<?php
require_once(DIR_FS_CATALOG.'admin/includes/classes/context_menu_group.php');
class context_menu {
	var $context_group;
	var $group_item_id;
	var $customers_id;
	var $access_array;
	var $cmg_class_name;
	var $entries;
	function __construct($context_group,$group_item_id,$customers_id,$admin_access=array()) {
		$this->setGroup_item_id($group_item_id);
		$this->setContext_group($context_group);
		$this->setCustomers_id($customers_id);
		if(sizeOf($admin_access)){
			$this->setAccess_array($admin_access);
		}else{
			$this->setAccess_array(main::get_admin_access());
		}
		require_once(DIR_WS_CLASSES.'context_menu.group.'.$this->getContext_group().'.php');
		$this->setCmg_class_name('cmg_'.$this->getContext_group());
	}
	public function getContext_group() {
		return $this->context_group;
	}

	public function setContext_group($context_group) {
		$this->context_group = $context_group;
	}

	public function getCustomers_id() {
		return $this->customers_id;
	}

	public function setCustomers_id($customers_id) {
		$this->customers_id = $customers_id;
	}

	public function getAccess_array() {
		return $this->access_array;
	}

	public function setAccess_array($access_array) {
		$this->access_array = $access_array;
	}

	public function getCmg_class_name() {
		return $this->cmg_class_name;
	}

	public function setCmg_class_name($cmg_class_name) {
		$this->cmg_class_name = $cmg_class_name;
	}

	public function getEntries( $group_item_id ) {
		return $this>entries;
	}

	public function setEntries($entries) {
		$this->entries = $entries;
	}
	
	public function getGroup_item_id() {
		return $this->group_item_id;
	}

	public function setGroup_item_id($group_item_id) {
		$this->group_item_id = $group_item_id;
	}

	public function get_default_element_html(){
		$entries = $this->getGroup_entries();
		if($this->check_permission($entries[0]['permission'])){
			$text = sprintf(
					'<a href="%s">%s</a>',
					$entries[0]['link'],
					$entries[0]['text']
			);
			$css_class = 'context_link_element_link';
		}else{
			$text = sprintf('<a style="text-decoration:strike-through;color:#999" href="javascript:alert(\'%s\');"><strike>%s</strike></a>',sprintf(JS_MISSING_PERMISSION,$entries[0]['text']),$entries[0]['text']);
			$css_class = 'context_link_element_perm';
		}
		return sprintf(
			'<div id="context_link_element" class="%s:%s">%s</div>',
			$this->getContext_group(),$this->getGroup_item_id(),$text
			
		);
	}
	private function getGroup_entries(){
		$cmg_name = $this->getCmg_class_name();
		$cmg = new $cmg_name($this->getGroup_item_id());
		return $cmg->getGroup_entries();
	}
	
	private function check_permission($perm){
		if(isset($this->access_array[$perm]) and $this->access_array[$perm] == 1)
				return true;
		return false;
	}

	public function get_menu_html(){
		$entries = $this->getGroup_entries();
		echo '<ul class="context_menu_ul">';
		foreach($entries as $nr=>$entry){
			if($nr == 0) continue; // erstes element ist im listing
			if($this->check_permission($entries[$nr]['permission'])){
				echo '<li class="cm_link">';
				switch($entries[$nr]['link_method']){
					case 'href':
						printf('<a href="%s">',$entries[$nr]['link']);
						break;
					case 'href_confirm':
						printf('<a href="javascript:;" onclick="yesConfirmLink( \'%s\', \'%s\' )">',$entries[$nr]['text'],$entries[$nr]['link']);
						break;
					case 'dialog':
						printf('<a title="%s" href="javascript:;" onclick="yesDialogLink(\'%s\',\'%s\');">',
                                                        $entries[$nr]['text'],
                                                        $entries[$nr]['text'],
                                                        $entries[$nr]['link']
                                                );
						break;
					case 'popup':
						printf('<a href="javascript:void(window.open(\'%s\',\'%s\',\'width:%spx,height:%spx,scrollbars:yes\'));">',$entries[$nr]['link'],$entries[$nr]['id'],EXT_POPUP_WIDTH,EXT_POPUP_HEIGHT);
						break;
					case '_blank':
						printf('<a href="javascript:void(window.open(\'%s\',\'_blank\'));">',$entries[$nr]['link']);
						break;
				}
			}else{
				printf('<li class="cm_perm"><a href="javascript:alert(\'%s\');">',sprintf(JS_MISSING_PERMISSION,$entries[$nr]['text']));
			}
			echo $entries[$nr]['text'];
			echo '</a></li>';
		}
		echo '</ul>';
	}
}
