<?php
/* includes/classes/class.paypal_ppp_admin.php
.---------------------------------------------------------------------------.
|    Software: PayPal-PPP                                                   |
|     Version: 0.3beta                                                      |
|        Date: 2016-02-09                                                   |
| Description: show/handle payment-Details in Admin                         |
|     Contact: info@andreas-guder.de                                        |
| ------------------------------------------------------------------------- |
|      Author: Andreas Guder                                                |
|     Contact: info@andreas-guder.de                                        |
| Copyright (c) 2015, Andreas Guder.                                        |
| ------------------------------------------------------------------------- |
|     License:  GNU Public License V2.0                                     |
|               http://www.gnu.org/licenses/gpl-2.0.html                    |
'--------------------------------------------------------------------------�'
*/
require_once DIR_FS_CATALOG.DIR_WS_CLASSES.'paypal_ppp_rest.class.php';
if (file_exists(DIR_FS_LANGUAGES . $_SESSION['language'] . '/admin/paypal_ppp.php'))
  require_once DIR_FS_LANGUAGES . $_SESSION['language'] . '/admin/paypal_ppp.php';

class PAYPAL_PPP_ADMIN extends PAYPAL_PPP_REST
{
  private $paypal_refund_task = 'show_form';
  private $paypal_refund_errors = array();
  
  /**
   * @var bool, call parent constructor to prepare paypal-request, or not
   */
  public function __construct($call_parent = false)
  {
    if (!defined('MODULE_PAYMENT_PAYPAL_PPP_STATUS') || !defined('TABLE_PAYPAL_PPP'))
      return false;
    $table_exists = false;
    $q = xtc_db_query("SHOW TABLES FROM `".DB_DATABASE."` LIKE '%paypal%'");
    while($row = xtc_db_fetch_row($q)) 
    {
      if($row[0] == TABLE_PAYPAL_PPP)
      {
        $table_exists = true;
        break;
      }
    }
    xtc_db_free_result($q);
    if (!$table_exists)
      return false;
      
    if ($call_parent)
      parent::__construct();
    return true;
  }
  
  /**
   * @var int, ppp-payment-id
   * @var string, currency-code
   * return string
   */
  public function get_status_history_table($payment_id, $currency = 'EUR')
  {
    if (empty($payment_id))
      return '';
    
    $result = '';
    $q = xtc_db_query("SELECT * FROM `".TABLE_PAYPAL_PPP_STATUS_HISTORY."` WHERE `paypal_ppp_id`=".$payment_id);
    if (xtc_db_num_rows($q))
    {
      $result .= '<table class="table" summary="Paypal Payment History"><thead>';
      $result .= '<tr class="dataTableHeadingRow">';
        $result .= '<th class="dataTableHeadingContent">'.PAYPAL_PPP_TXT_ORDER_DETAILS_TH_DATE.'</th>';
        $result .= '<th class="dataTableHeadingContent">'.PAYPAL_PPP_TXT_ORDER_DETAILS_TH_STATE.'</th>';
        $result .= '<th class="dataTableHeadingContent">'.PAYPAL_PPP_TXT_ORDER_DETAILS_TH_AMOUNT.'</th>';
        $result .= '<th class="dataTableHeadingContent">'.PAYPAL_PPP_TXT_ORDER_DETAILS_TH_TEXT_SUMMARY.'</th>';
        $result .= '<th class="dataTableHeadingContent">'.PAYPAL_PPP_TXT_ORDER_DETAILS_TH_CUSTOM_TEXT.'</th>';
      $result .= '</tr>';
      $result .= '</tr></thead><tbody>';
      while ($details = xtc_db_fetch_array($q))
      {
        $result .= '<tr class="dataTableRow">';
          $result .= '<td class="dataTableContent">'.date('d.m.Y H:i', strtotime($details['date'])).' Uhr</td>';
          $result .= '<td class="dataTableContent">'.$details['status'].'</td>';
          $result .= '<td class="dataTableContent">'.number_format($details['amount'],2,',','').' '.$currency.'</td>';
          $result .= '<td class="dataTableContent">'.htmlentities($details['summary'],ENT_COMPAT, $_SESSION['language_charset']).'</td>';
          $result .= '<td class="dataTableContent">'.htmlentities($details['pending_reason'],ENT_COMPAT, $_SESSION['language_charset']).'</td>';
        $result .= '</tr>';
      }
      $result .= '</tbody></table>';
    }
    xtc_db_free_result($q);
    
    return $result;
  }
  
  public function show_order_information($oID)
  {
    settype($oID, 'integer');
    
    // try to load data from TABLE_PAYPAL_PPP
    $q = xtc_db_query("SELECT * FROM `".TABLE_PAYPAL_PPP."` WHERE `orders_id`=".$oID);
    $payment = xtc_db_fetch_array($q);
    xtc_db_free_result($q);
    if (empty($payment))
      return;
    $payer = array();
    if (!empty($payment['payer_first_name']))
      $payer[] = $payment['payer_first_name'];
    if (!empty($payment['payer_last_name']))
      $payer[] = $payment['payer_last_name'];
    if (!empty($payment['payer_email']))
      $payer[] = '('.$payment['payer_email'].')';
    
    echo '<h2 id="paypal_ppp_order_details_title">',PAYPAL_PPP_TXT_ORDER_DETAILS_TITLE,'</h2>';
    echo '<div id="paypal_ppp_order_details_box">';
    echo '<label for="ppp_dt_sale_id">',PAYPAL_PPP_TXT_ORDER_DETAILS_DT_SALE_ID,'</label><span id="ppp_dt_sale_id">',htmlentities($payment['ppp_sale_id'],ENT_COMPAT, $_SESSION['language_charset']),'</span><br />';
    echo '<label for="ppp_dt_date">',PAYPAL_PPP_TXT_ORDER_DETAILS_DT_DATE,'</label>';
    echo '<span id="ppp_dt_date">',date('d.m.Y H:i', strtotime($payment['created_at'])),($payment['mode'] == 'sandbox' ? ' Uhr [in sandbox]' : ' Uhr'),'</span><br />';
    echo '<label for="ppp_dt_payer">',PAYPAL_PPP_TXT_ORDER_DETAILS_DT_PAYER,'</label><span id="ppp_dt_payer">',htmlentities(implode(' ', $payer),ENT_COMPAT, $_SESSION['language_charset']),'</span><br />';
    echo '<label for="ppp_dt_address">',PAYPAL_PPP_TXT_ORDER_DETAILS_DT_PAYER_ADDRESS,'</label><span id="ppp_dt_address">',htmlentities($payment['payer_shipping_address'],ENT_COMPAT, $_SESSION['language_charset']),'</span><br />';
    echo '<label for="ppp_dt_total">',PAYPAL_PPP_TXT_ORDER_DETAILS_DT_TOTAL,'</label><span id="ppp_dt_total">',number_format($payment['payment_total'],2,',',''),' ',$payment['payment_total_currency'],'</span><br />';
    echo '<label for="ppp_dt_fee">',PAYPAL_PPP_TXT_ORDER_DETAILS_DT_FEE,'</label><span id="ppp_dt_fee">',number_format($payment['payment_fee'],2,',',''),' ',$payment['payment_fee_currency'],'</span><br />';
    
    if ($payment['payment_type'] == 'PAY_UPON_INVOICE')
    {
      echo '<br /><strong>PayPal-Rechnung</strong><br />';
      if ($payment['payment_instruction'] != '')
      {
        $payment_instruction = unserialize($payment['payment_instruction']);
        echo '<label for="ppp_dt_invoice_paydate">',PAYPAL_PPP_TXT_ORDER_DETAILS_INVOICE_PAYDATE,'</label><span id="ppp_dt_invoice_paydate">',date('d.m.Y',strtotime($payment_instruction['payment_due_date'])),'</span><br />';
        echo '<label for="ppp_dt_invoice_payto">',PAYPAL_PPP_TXT_ORDER_DETAILS_INVOICE_PAYTO,'</label><span id="ppp_dt_invoice_payto">';
          echo htmlentities($payment_instruction['recipient_banking']['holder'],ENT_COMPAT, $_SESSION['language_charset']);
          echo ' | IBAN: ',htmlentities($payment_instruction['recipient_banking']['iban'],ENT_COMPAT, $_SESSION['language_charset']);
          echo ' | BANK: ',htmlentities($payment_instruction['recipient_banking']['bank'],ENT_COMPAT, $_SESSION['language_charset']);
        echo '</span><br />';
        echo '<label for="ppp_dt_invoice_paysubject">',PAYPAL_PPP_TXT_ORDER_DETAILS_DT_INVOICE_SUBJECT,'</label><span id="ppp_dt_invoice_paysubject">',htmlentities($payment_instruction['reference_number'],ENT_COMPAT, $_SESSION['language_charset']),'</span><br />';
      }
    }
    
    // load status history
    $status_history = $this->get_status_history_table($payment['id'], $payment['payment_total_currency']);
    if (!empty($status_history))
      echo '<br /><br />'.$status_history;
    
    // if payment not older than 60days, show refund-form
    if (strtotime($payment['created_at']) > time()-60*86400)
    {
      echo '<h3>',PAYPAL_PPP_TXT_ORDER_DETAILS_REFUND_TITLE,'</h3>';
      if(!empty($this->paypal_refund_errors))
          echo '<div class="messageStackWarning">',nl2br(htmlentities(implode(chr(10),$this->paypal_refund_errors),ENT_COMPAT, $_SESSION['language_charset'])),'</div>';
      
      if ($this->paypal_refund_task == 'show_success')
      {
        echo '<p class="messageStackSuccess">',PAYPAL_PPP_TXT_ORDER_DETAILS_REFUND_AQUIRED,'</p>';
      }
      elseif ($this->paypal_refund_task == 'show_confirm')
      {
        echo xtc_draw_form('paypal_ppp_refund', FILENAME_ORDERS, xtc_get_all_get_params(array('action','ppp_refund_aquired')) . 'action=edit&ppp_refund_aquired=confirmed');
        echo '<p style="font-weight: bold;">',PAYPAL_PPP_TXT_ORDER_DETAILS_REFUND_CONFIRM_HEADING,'</p>';
        echo '<dl>';
        echo '<dt>',PAYPAL_PPP_TXT_ORDER_DETAILS_REFUND_AMOUNT,'</dt><dd>',number_format($_SESSION['ppp_refund_amount'],2,',',''),' ',$payment['payment_total_currency'],'</dd>';
        //echo '<dt>',PAYPAL_PPP_TXT_ORDER_DETAILS_REFUND_TEXT,'</dt><dd>',htmlentities($_SESSION['ppp_refund_text'],ENT_COMPAT, $_SESSION['language_charset']),'</dd>';
        echo '</dl>';
        
        echo '<a class="button" href="',xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array ('action','ppp_refund_aquired')).'&action=edit'),'">',PAYPAL_PPP_TXT_ORDER_DETAILS_BUTTON_CANCEL,'</a>&nbsp;&nbsp;&nbsp;';
        echo '<input type="submit" name="ppp_confirm_refund" class="button" value="'.PAYPAL_PPP_TXT_ORDER_DETAILS_BUTTON_CONFIRM.'" />';
        echo '</form>';
      }
      else
      {
        echo xtc_draw_form('paypal_ppp_refund', FILENAME_ORDERS, xtc_get_all_get_params(array('action','ppp_refund_aquired')) . 'action=edit&ppp_refund_aquired=toconfirm');
        echo '<label for="ppp_payment_refund">',PAYPAL_PPP_TXT_ORDER_DETAILS_REFUND_AMOUNT,'</label>';
        echo xtc_draw_input_field('ppp_payment_refund', number_format($payment['payment_total'],2,',',''), 'id="ppp_payment_refund" size="10" maxlength="10"', false),' ',$payment['payment_total_currency'],
          sprintf('&nbsp;<span class="fieldRequired">%s</span>',TEXT_FIELD_REQUIRED);
        //echo '<br />';
        //echo '<label for="ppp_payment_refund_text">',PAYPAL_PPP_TXT_ORDER_DETAILS_REFUND_TEXT,'</label>';
        //echo xtc_draw_textarea_field('ppp_payment_refund_text', 'soft', '60', '5', '', 'id="ppp_payment_refund_text"');
        //echo '<br />';
        echo '<input type="submit" name="ppp_toconfirm" class="button" value="'.PAYPAL_PPP_TXT_ORDER_DETAILS_BUTTON_CONTINUE.'" />';
        echo '</form>';
      }
    }
    echo '</div>';
  }

  public function process_paypal_refund($oID)
  {
    $q = xtc_db_query("SELECT * FROM `".TABLE_PAYPAL_PPP."` WHERE `orders_id`=".$oID);
    $payment = xtc_db_fetch_array($q);
    xtc_db_free_result($q);
    if (empty($payment))
      return false;
    
    if (isset($_GET['ppp_refund_aquired']) && $_GET['ppp_refund_aquired'] == 'success')
    {
      $this->paypal_refund_task = 'show_success';
    }
    elseif (isset($_GET['ppp_refund_aquired']) && $_GET['ppp_refund_aquired'] == 'confirmed' && isset($_POST['ppp_confirm_refund']))
    {
      // execute refund
      if (empty($_SESSION['ppp_refund_amount']))
      {
        $this->add_message_stack(PAYPAL_PPP_TXT_ERROR_REFUND_DATA_NOT_SET, 'error');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array ('action','ppp_refund_aquired')).'action=edit'));
      }
      else
      {
        parent::__construct($payment['mode']);
        $data = array('amount'=>array('total'=>$_SESSION['ppp_refund_amount'], 'currency'=>$payment['payment_total_currency']));
        $this->prepare_request('v1/payments/sale/'.$payment['ppp_sale_id'].'/refund', 'POST', $data);
        $this->add_custom_header('Authorization: Bearer '.$this->get_api_access_token());
        $result = $this->execute();
        if (is_array($result) && ((int)$result['info']['http_code'] == 200 || (int)$result['info']['http_code'] == 201))
        {
          $body = json_decode($result['body']);
          $state = $body->state;
          $sql_data = array(
            'orders_id'     => $payment['orders_id'],
            'paypal_ppp_id' => $payment['id'],
            'amount'        => $_SESSION['ppp_refund_amount'],
            'summary'       => PAYPAL_PPP_TXT_REFUND_SUBMITED_TO_PAYPAL,
            'status'        => $body->state
          );
          unset($_SESSION['ppp_refund_amount']);
          xtc_db_perform(TABLE_PAYPAL_PPP_STATUS_HISTORY, $sql_data);
          switch($body->state)
          {
            case 'completed':
              if (MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REFUNDET_USE == 'True')
              {
                $set_order_status = MODULE_PAYMENT_PAYPAL_PPP_ORDER_STATUS_REFUNDET;
                $sql_order = array(
                  'orders_status' => $set_order_status,
                  'last_modified' => 'now()'
                );
                $sql_order_status = array(
                  'orders_id'         => $oID,
                  'orders_status_id'  => $set_order_status,
                  'date_added'        => 'now()',
                  'customer_notified' => 0
                );
                /* BOF FIX check if column exists */
                $query_result = xtc_db_query("SHOW COLUMNS FROM `" . TABLE_ORDERS_STATUS_HISTORY . "`");
                $db_table_rows = array();
                while ($row = xtc_db_fetch_array($query_result))
                  $db_table_rows[] = $row['Field']; 
                if (in_array('comments_sent', $db_table_rows))
                  $sql_order_status['comments_sent'] = 0;
                /* EOF FIX check if column exists */
                xtc_db_perform(TABLE_ORDERS, $sql_order, 'update', "`orders_id`=".$oID);
                xtc_db_perform(TABLE_ORDERS_STATUS_HISTORY, $sql_order_status);
              }
              xtc_redirect(xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array ('action','ppp_refund_aquired')).'action=edit&ppp_refund_aquired=success'));
              break;
            case 'pending':
              xtc_redirect(xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array ('action','ppp_refund_aquired')).'action=edit&ppp_refund_aquired=success'));
              break;
            case 'failed':
              $this->add_message_stack(PAYPAL_PPP_TXT_ERROR_REFUND_FAILED.': '.$result['body'], 'error');
              xtc_redirect(xtc_href_link(FILENAME_ORDERS, xtc_get_all_get_params(array ('action','ppp_refund_aquired')).'action=edit'));
              break;
          }
        }
        unset($_SESSION['ppp_refund_amount']);
      }
      // redirect to orders-page
    }
    elseif (isset($_GET['ppp_refund_aquired']) && $_GET['ppp_refund_aquired'] == 'toconfirm' && isset($_POST['ppp_toconfirm']))
    {
      if (!empty($_POST['ppp_payment_refund']) && preg_match('/^([0-9]+[\.\,]?[0-9]{0,2})?$/', $_POST['ppp_payment_refund']))
      {
        $ppp_to_refund = str_replace(',', '.', $_POST['ppp_payment_refund']);
        if ($ppp_to_refund > 0)
        {
          $_SESSION['ppp_refund_amount'] = $ppp_to_refund;
          //$_SESSION['ppp_refund_text'] = !empty($_POST['ppp_payment_refund_text']) ? xtc_prepare_input($_POST['ppp_payment_refund_text']) : '';
          $this->paypal_refund_task = 'show_confirm';
        }
        else
          $this->paypal_refund_errors[] = PAYPAL_PPP_TXT_ERROR_REFUND_AMOUNT_NEGATIVE;
      }
      else
        $this->paypal_refund_errors[] = PAYPAL_PPP_TXT_ERROR_REFUND_AMOUNT_EMPTY;
    }
    return true;
  }
  private function add_message_stack($text, $type)
  {
    if (!isset($_SESSION['messageToStack']))
      $_SESSION['messageToStack'] = array();
    $_SESSION['messageToStack'][count($_SESSION['messageToStack'])] = array(
      'text'  => $text,
      'type'  => $type
    );
  }
}
?>