<?php
class ebay_sammler extends ebay_item{
	var $copy = array();
	var $id;
	var $sammler_title;
	var $angelegt;
	var $aktiv;
	var $sammler_description;
	var $template;

	function __construct($sammler_id){
		if($sammler_id > 0){
			$this->setId($sammler_id);
			$sammler = $this->get_db_values();

			$this->setSammlerTitle($sammler['titel']);
			$this->setAngelegt($sammler['angelegt']);
			$this->setAktiv($sammler['aktiv']);
			$this->setSammlerDescription($sammler['description']);
			$this->setTemplate($sammler['template']);

			$this->setType($sammler['type']);
			$this->setDuration($sammler['duration']);
			$this->setQuantity($sammler['quantity']);
			$this->setGallery($sammler['gallery']);
			$this->setGalleryPlus($sammler['gallery_plus']);
			$this->setGalleryfeatured($sammler['galleryFeatured']);
			$this->setGalleryfeaturedDuration($sammler['galleryFeaturedDuration']);
			$this->setCategory($sammler['category']);
			$this->setCategory2($sammler['category2']);
			$this->setShopcat($sammler['shopcat']);
			$this->setShopcatName($sammler['shopcat_name']);
			$this->setShopcat2($sammler['shopcat2']);
			$this->setShopcat2Name($sammler['shopcat2_name']);
			$this->setCounter($sammler['counter']);
			$this->setVat($sammler['vat']);
			$this->setGeldzurueck($sammler['geldzurueck']);
			$this->setSofortneu($sammler['sofortneu']);
			$this->setNew($sammler['new']);
			$this->setSite($sammler['site']);
			$this->setPaymentinstructions($sammler['paymentinstructions']);
			$this->setSubtitletext($sammler['subtitletext']);
			$this->setBestoffer($sammler['bestoffer']);
			$this->setBestofferPrice($sammler['bestoffer_price']);
			$this->setLocation($sammler['location']);
			$this->setCountry($sammler['country']);
			$this->setBestOfferAutoAcceptPrice($sammler['bestofferautoacceptprice']);
			$this->setUser($sammler['user']);
			$this->setRevise($sammler['revise']);
			$this->setReviseOption($sammler['revise_option']);
			$this->setPostalcode($sammler['postalcode']);
			$this->setDispatchtimemax($sammler['dispatchtimemax']);
			$this->setItemcondition($sammler['itemcondition']);
			$this->get_copy_values();
			$this->get_characteristics_values($table='ebay_sammler_characteristics',$key='ebay_sammler_id',$id=$this->getId());
			$this->get_payments_values($table='ebay_sammler_payments',$key='ebay_sammler_id',$id=$this->getId());
			$this->get_shippings_values($table='ebay_sammler_shippings');
			$this->get_itemspecifics_values($table='ebay_sammler_itemspecifics',$key='ebay_sammler_id',$id=$this->getId());
			$this->get_itemspecifics_recommendations_values($table='ebay_sammler_itemspecifics_recommendations',$key='ebay_sammler_id',$id=$this->getId());
			$this->setShippingDiscountProfileID($sammler['ShippingDiscountProfileID']);
			$this->setInternationalShippingDiscountProfileID($sammler['InternationalShippingDiscountProfileID']);
			$this->setReserveprice($sammler['reserveprice']);
                        $this->setReturnswithincode($sammler['returnswithincode']);
                        $this->setShippingcostpaidby($sammler['shippingcostpaidby']);
			$this->setEBayPlus($sammler['ebay_plus']);
			$this->setSeller_profile_payment_id($sammler['seller_profile_payment_id']);
			$this->setSeller_profile_return_policy_id($sammler['seller_profile_return_policy_id']);
			$this->setSeller_profile_shipping_id($sammler['seller_profile_shipping_id']);
                        $this->setScheduleTime($sammler['scheduletime']);
			
		}else{
			$this->setSammlerTitle(EBAY_SAMMLER_DEFAULT_TITEL);
			$this->setId(0);
			$this->setAngelegt(date('Y-m-d H:i:s'));
			$this->setAktiv('j');
			$this->setSammlerDescription('');
			$this->setTemplate('');
			
			$this->setType(EBAY_AUCTIONTYPE);
			$this->setDuration(EBAY_DURATION);
			$this->setQuantity(EBAY_QUANTITY);
			$this->setGallery(EBAY_GALLERY);
			$this->setGalleryPlus(EBAY_GALLERYPLUS);
			$this->setGalleryfeatured(EBAY_GALLERYFEATURED);
			$this->setGalleryfeaturedDuration(EBAY_GALLERYFEATUREDDURATION);
			$this->setCategory(EBAY_CATEGORY);
			$this->setCategory2(EBAY_CATEGORY2);
			$this->setCounter(EBAY_COUNTER);
			$this->setVat(EBAY_SHOW_AUCTION_TAX);
			$this->setGeldzurueck(EBAY_GELDZURUECK);
			$this->setSofortneu(EBAY_SOFORTNEU);
			$this->setNew( (defined('EBAY_NEW')) ? intval(EBAY_NEW) : 0 );
			$this->setSite(EBAY_SITE_ID);
			$this->setPaymentinstructions(EBAY_CHECKOUT_INSTRUCTIONS);
			$this->setSubtitletext(EBAY_SUBTITLETEXT);
			$this->setBestoffer( (EBAY_BESTOFFER=='true') ? 1 : 0 );
			$this->setBestofferPrice(EBAY_BESTOFFER_PRICE);
			$this->setLocation(EBAY_LOCATION);
			$this->setCountry(strtoupper(EBAY_SELLER_COUNTRY));
			$this->setBestOfferAutoAcceptPrice(EBAY_BESTOFFERAUTOACCEPTPRICE );
			$this->setUser(EBAY_USER);
			$this->setRevise(EBAY_REVISE_AUTOMATIC);
			$this->setReviseOption(EBAY_REVISE_AUTOMATIC_OPTION);
			$this->setPostalcode(EBAY_POSTALCODE);
			$this->setDispatchtimemax(EBAY_DISPATCHTIMEMAX);
			$this->setItemcondition( intval(EBAY_ITEMCONDITION) );
			$copy_query = xtc_db_query("SHOW columns FROM ebay_sammler_copy");
			while($column = xtc_db_fetch_array($copy_query)){
				$this->copy[ $column['Field'] ] = 1;
			}
			$this->get_characteristics_values($table='ebay_default_characteristics',$key='ebay_sammler_id',$id=$this->getId());
			$this->get_payments_values($table='ebay_default_payments');
			$this->get_shippings_values($table='ebay_default_shippings');
			$this->get_itemspecifics_values($table='ebay_default_itemspecifics');
			$this->setShippingDiscountProfileID(EBAY_SHIPPINGDISCOUNTPROFILEID);
			$this->setInternationalShippingDiscountProfileID(EBAY_INTERNATIONALSHIPPINGDISCOUNTPROFILEID);
			$this->setReserveprice( (float)EBAY_RESERVEPRICE );
                        $this->setReturnswithincode(EBAY_RETURNSWITHINCODE);
                        $this->setShippingcostpaidby(EBAY_SHIPPINGCOSTPAIDBY);
			$this->setEBayPlus( ((EBAY_PLUS == 'True')?true:false)   );
			$this->setSeller_profile_payment_id(EBAY_SELLER_PROFILE_PAYMENT_ID);
			$this->setSeller_profile_return_policy_id(EBAY_SELLER_PROFILE_RETURN_POLICY_ID);
			$this->setSeller_profile_shipping_id(EBAY_SELLER_PROFILE_SHIPPING_ID);
		}
	}

	function setSammlerDescription($value){
		$this->sammler_description = $value;
	}

	function getSammlerDescription(){
		return $this->sammler_description;
	}

	function setTemplate($value){
		$this->template = $value;
	}

	function getTemplate(){
		return $this->template;
	}

	function setId($value){
		$this->id = $value;
	}

	function getId(){
		return $this->id;
	}

	function setSammlerTitle($value){
		$this->sammler_title = $value;
	}

	function getSammlerTitle(){
		return $this->sammler_title;
	}

	function setAngelegt($value){
		$this->angelegt = $value;
	}

	function getAngelegt(){
		return $this->angelegt;
	}

	function setAktiv($value){
		$this->aktiv = $value;
	}

	function getAktiv(){
		return $this->aktiv;
	}

	function get_new_ebay_product_sql_array(){
		$sql_array = array(
			'ebay_angebotsformat'=>$this->getType(),
			'ebay_auktionsdauer'=>$this->getDuration(),
			'ebay_untertitel'=>$this->getSubtitletext(),
			'ebay_menge'=>$this->getQuantity(),
			'ebay_ort'=>$this->getLocation(),
			'ebay_land'=>$this->getCountry(),
			'ebay_kategorie'=>$this->getCategory(),
			'ebay_kategorie2'=>$this->getCategory2(),
			'ebay_shopcat'=>$this->getShopcat(),
			'ebay_shopcat_name'=>$this->getShopcatName(),
			'ebay_shopcat2'=>$this->getShopcat2(),
			'ebay_shopcat2_name'=>$this->getShopcat2Name(),
			'ebay_gallery'=>$this->getGallery(),
			'ebay_gallery_plus'=>$this->getGalleryPlus(),
			'ebay_galleryfeatured'=>$this->getGalleryfeatured(),
			'ebay_galleryfeaturedduration'=>$this->getGalleryfeaturedDuration(),
			'ebay_counter'=>$this->getCounter(),
			'ebay_vat'=>(($this->getVat()=='true' or $this->getVat() == 1)?1:0),
			'ebay_geldzurueck'=>$this->getGeldzurueck(),
			'ebay_sofortneu'=>$this->getSofortneu(),
			'ebay_new'=>$this->getNew(),
			'ebay_site'=>$this->getSite(),
			'ebay_paymentinstructions'=>$this->getPaymentinstructions(),
			'ebay_bestoffer'=>$this->getBestoffer(),
			'ebay_bestoffer_price'=>$this->getBestofferPrice(),
			'ebay_user'=>$this->getUser(),
			'ebay_bestofferautoacceptprice' => $this->getBestOfferAutoAcceptPrice(),
			'ebay_template'=>$this->getTemplate(),
			'ebay_revise'=>$this->getRevise(),
			'ebay_revise_option'=>$this->getReviseOption(),
			'ebay_postalcode'=>$this->getPostalcode(),
			'ebay_dispatchtimemax'=>$this->getDispatchtimemax(),
			'itemcondition'=>$this->getItemcondition(),
			'ShippingDiscountProfileID'=>$this->getShippingDiscountProfileID(),
			'InternationalShippingDiscountProfileID'=>$this->getInternationalShippingDiscountProfileID(),
			'reserveprice'=>$this->getReserveprice(),
                        'returnswithincode' => $this->getReturnswithincode(),
                        'shippingcostpaidby' => $this->getShippingcostpaidby(),
			'ebay_plus'=>$this->getEBayPlus(),
			'seller_profile_payment_id'=>$this->getSeller_profile_payment_id(),
			'seller_profile_return_policy_id'=>$this->getSeller_profile_return_policy_id(),
			'seller_profile_shipping_id'=>$this->getSeller_profile_shipping_id(),
                    'scheduletime'=>$this->getScheduleTime()
		);
		return $sql_array;
	}

	function copy($new_title){
		$itemspecifics_recommendations = $this->getItemspecifics_recommendations();
		if($this->getId() == 0 || strlen($new_title) == 0){
			return false;
		}
		$sammler = $this->get_db_values();
		$sammler['angelegt'] = 'now()';
		$sammler['titel'] = $new_title;
		unset($sammler['id']);
		xtc_db_perform('ebay_sammler',$sammler,'insert');
		$new_sammler_id = xtc_db_insert_id();
		
		unset($this->copy['ebay_sammler_copy_id']);
		$this->copy['ebay_sammler_id'] = $new_sammler_id;
		xtc_db_perform('ebay_sammler_copy',$this->copy,'insert');

		$chars = $this->getCharacteristics();
		for($i=0;$i<sizeOf($chars);$i++){
			$insert_sql_array = $chars[$i];
			$insert_sql_array['ebay_sammler_id'] = $new_sammler_id;
			xtc_db_perform('ebay_sammler_characteristics',$insert_sql_array,'insert');
		}

		$payments = $this->getPayments();
		for($i=0;$i<sizeOf($payments);$i++){
			$insert_sql_array = $payments[$i];
			$insert_sql_array['ebay_sammler_id'] = $new_sammler_id;
			xtc_db_perform('ebay_sammler_payments',$insert_sql_array,'insert');
		}

		$shippings = $this->getShippings();
		for($i=0;$i<sizeOf($shippings);$i++){
			$locations = array();
			if($shippings[$i]['locations']){
				$locations = $shippings[$i]['locations'];
				unset($shippings[$i]['locations']);
			}
			unset($shippings[$i]['ebay_sammler_shippings_id']);
			$insert_sql_array = $shippings[$i];
			$insert_sql_array['ebay_sammler_id'] = $new_sammler_id;
			xtc_db_perform('ebay_sammler_shippings',$insert_sql_array,'insert');
			$new_shippings_id = xtc_db_insert_id();
			for($sl=0;$sl<sizeOf($locations);$sl++){
				$insert_sql_array = array(
					'ebay_sammler_shippings_id'=>$new_shippings_id,
					'location'=>$locations[$sl]
				);
				xtc_db_perform('ebay_sammler_shippings_locations',$insert_sql_array,'insert');
			}
		}
		$itemspecifics = $this->getItemSpecifics();
		for($i=0;$i<sizeOf($itemspecifics);$i++){
			$insert_sql_array = array(
				'is_name'=>$itemspecifics[$i]['name'],
				'is_value'=>$itemspecifics[$i]['value'],
				'ebay_sammler_id'=>$new_sammler_id
			);
			xtc_db_perform('ebay_sammler_itemspecifics',$insert_sql_array,'insert');
		}
		$itemspecifics_recommendations = $this->getItemspecifics_recommendations();
		for($i=0;$i<sizeOf($itemspecifics_recommendations);$i++){
			$insert_sql_array = array(
				'is_name'=>$itemspecifics_recommendations[$i]['name'],
				'is_value'=>$itemspecifics_recommendations[$i]['value'],
				'ebay_sammler_id'=>$new_sammler_id
			);
			xtc_db_perform('ebay_sammler_itemspecifics_recommendations',$insert_sql_array,'insert');
		}
		return $new_sammler_id;
	}

	function get_db_values(){
		$sammler_query = xtc_db_query("SELECT * FROM ebay_sammler WHERE id='".$this->getId()."'");
		$sammler = xtc_db_fetch_array($sammler_query);
		return $sammler;
	}

	function get_copy_values(){
		$copy_query = xtc_db_query("SELECT * FROM ebay_sammler_copy WHERE ebay_sammler_id='".$this->getId()."'");
		$this->copy = xtc_db_fetch_array($copy_query);
	}

	function get_shippings_values(){
		$shippings = array();
		if($this->getId() > 0){
			$query_raw = sprintf("SELECT * FROM ebay_sammler_shippings WHERE ebay_sammler_id='%s'",$this->getId());
			$location_table = 'ebay_sammler_shippings_locations';
			$location_key = 'ebay_sammler_shippings_id';
		}else{
			$query_raw = sprintf("SELECT * FROM ebay_default_shippings");
			$location_table = 'ebay_default_shippings_locations';
			$location_key = 'ebay_default_shippings_id';
		}

		$shippings_query = xtc_db_query($query_raw);
		while($shipping = xtc_db_fetch_array($shippings_query)){
			$locations = $this->get_shippings_locations_data($location_table,$location_key,$shipping[$location_key]);
			if(sizeOf($locations)>0)
				$shipping['locations'] = $locations;
			$shippings[] = $shipping;
		}
		$this->setShippings($shippings);
	}

	function get_shippings_locations_data($table,$key,$shippings_id){
		$query_raw = sprintf("SELECT location FROM %s WHERE %s='%s'",$table,$key,$shippings_id);
		$locations = array();
		$locations_query = xtc_db_query($query_raw);
		while($location = xtc_db_fetch_array($locations_query)){
			$locations[] = $location['location'];
		}
		return $locations;
	}

    function get_number_of_items(){
		$query_raw = sprintf("SELECT count(id) as anz FROM ebay_products WHERE ebay_sammler_id='%s'",$this->getId());
		$query = xtc_db_query($query_raw);
		$record = xtc_db_fetch_array($query);
		return (int) $record['anz'];
    }
        
    public function get_saved_itemspecifics_recommendations(){
        $query = yes_db_query(sprintf(
            "SELECT * FROM ebay_sammler_itemspecifics_recommendations WHERE ebay_sammler_id='%d'",
            $this->getId()
        ));
        $saved = array();
        foreach($query as $record){
                $saved[ $record['is_name'] ][] = $record['is_value'];
        }
        return $saved;
    }
    
    public function get_sdk_recommendations_input_fields( $res ){
        $saved = $this->get_saved_itemspecifics_recommendations();
        foreach($res as $rec){
            $values = array(0=>array('id'=>'','text'=>TEXT_SELECT));
            if( isset( $rec->aspectValues ) and is_countable( $rec->aspectValues ) ){
                foreach($rec->aspectValues as $av){
                    $values[] = array(
                        'id'=>$av->localizedValue,
                        'text'=>$av->localizedValue,
                    );
                }
            }
            $pflicht = '';
            if($rec->aspectConstraint->aspectRequired == 1){
                $pftxt = defined('TEXT_ITEMSPECIFIC_PFLICHTFELD') ? TEXT_ITEMSPECIFIC_PFLICHTFELD : ' Pflichtfeld';
                $pflicht = sprintf(' <span title="%s">*</span>',$pftxt);
            }
            if($rec->aspectConstraint->itemToAspectCardinality == 'SINGLE'){
                $value = '';
                if( isset( $saved[ $rec->localizedAspectName ] ) ){
                        $value = current($saved[ $rec->localizedAspectName ]);
                }
                $input_array[] = array(
                        'text'=>$rec->localizedAspectName,
                        'value'=>$value,
                        'input'=>xtc_draw_input_field( 'INPUT['.urlencode($rec->localizedAspectName).']',$value,'id="INPUT_'.urlencode($rec->localizedAspectName).'"' ),
                        'recommendations'=>$values,
                    'PFLICHT'=>$pflicht,
                    'SelectionMode'=>$rec->aspectConstraint->aspectMode,
                );
            }else{
                $rec_input_array = array();
                foreach($values as $valkey=>$val){
                    if($valkey == 0) continue;
                    $checked = (isset($saved[ $rec->localizedAspectName ]) and is_countable($saved[ $rec->localizedAspectName ]) and in_array($val['id'], $saved[ $rec->localizedAspectName ]))?true:false;
                    $rec_input_array[] = array(
                        'input'=>xtc_draw_checkbox_field( 'INPUT['.urlencode($rec->localizedAspectName).'][]',$val['id'], $checked),
                        'value'=>$val['id']
                    );
                }
                $input_array[] = array(
                        'text'=>$rec->localizedAspectName,
                        'input_array'=>$rec_input_array,
                        'recommendations'=>$values,
                    'max_values'=>(isset($rec->aspectConstraint->aspectMaxLength))?$rec->aspectConstraint->aspectMaxLength:1,
                    'PFLICHT'=>$pflicht,
                    'SelectionMode'=>$rec->aspectConstraint->aspectMode,
                );
            }
        }
        return $input_array;
    }
}
