<?php
class bwa {
    var $SatzID;
	var $Mode;
	var $ArtikelNummer;
	var $ArtikelNummerType;
	var $Preis;
	var $PreisType;
	var $Currency;
	var $MeldeNummer;
	var $Produktgruppe;
	var $Datum = array();
	var $DatumType = array();
	var $Seitenzahl;
	var $Rabatt;
	var $Sachtitel;
	var $MWST;
	
	function __construct($data_string){
		$data = split('\*',$data_string);
		$this->setSatzID($data[0]);
		$this->setMode($this->getSatzID());
		$this->process($data);
	}

	function getSatzID() {
		return $this->SatzID;
	}

	function setSatzID($SatzID) {
		$this->SatzID = $SatzID;
	}
	
	function getArtikelNummer() {
		return $this->ArtikelNummer;
	}

	function setArtikelNummer($ArtikelNummer) {
		$this->ArtikelNummer = $ArtikelNummer;
	}

	function getArtikelNummerType() {
		return $this->ArtikelNummerType;
	}

	function setArtikelNummerType($ArtikelNummerType) {
		$this->ArtikelNummerType = $ArtikelNummerType;
	}

	function getPreis() {
		return $this->Preis;
	}

	function setPreis($Preis) {
		$this->Preis = $Preis;
	}

	function getPreisType() {
		return $this->PreisType;
	}

	function setPreisType($PreisType) {
		$this->PreisType = $PreisType;
	}

	function getCurrency() {
		return $this->Currency;
	}

	function setCurrency($Currency) {
		$this->Currency = $Currency;
	}

	function getMeldeNummer() {
		return $this->MeldeNummer;
	}

	function setMeldeNummer($MeldeNummer) {
		$this->MeldeNummer = $MeldeNummer;
	}

	function getProduktgruppe() {
		return $this->Produktgruppe;
	}

	function setProduktgruppe($Produktgruppe) {
		$this->Produktgruppe = $Produktgruppe;
	}

	function getSeitenzahl() {
		return $this->Seitenzahl;
	}

	function setSeitenzahl($Seitenzahl) {
		$this->Seitenzahl = $Seitenzahl;
	}

	function getDatum($key = false) {
		if(!$key)
			return $this->Datum;
		else
			return $this->Datum[$key];
	}

	function setDatum($Datum,$key=false) {
		if(!$key)
			$this->Datum[] = $Datum;
		else
			$this->Datum[$key] = $Datum;
	}

	function getDatumType($key=false) {
		if(!$key)
			return $this->DatumType;
		else
			return $this->DatumType[$key];
	}

	function setDatumType($DatumType,$key = false) {
		if(!$key)
			$this->DatumType[] = $DatumType;
		else
			$this->DatumType[$key] = $DatumType;
	}

	function getRabatt() {
		return $this->Rabatt;
	}

	function setRabatt($Rabatt) {
		$this->Rabatt = $Rabatt;
	}

	function getSachtitel() {
		return $this->Sachtitel;
	}

	function setSachtitel($Sachtitel) {
		$this->Sachtitel = $Sachtitel;
	}

	function getMWST() {
		return $this->MWST;
	}

	function setMWST($MWST) {
		$this->MWST = $MWST;
	}



	function process($data){
		switch($this->getMode()){
			case 'update':
			case 'delete':
				$this->process_update($data);
				break;
		}
	}

	function process_update($data){
		foreach($data as $item){
			$id = substr($item,0,4);
			$value = substr($item,4,strlen($item));
			switch($id){
				case 'U201':
				case 'U301':
				case '9999':
					break;
				case '1102':
					$this->setArtikelNummerType($value);
					break;
				case '1101':
					$this->setArtikelNummer($value);
					break;
				case '1029':
					$value = $this->format_price($value);
					$this->setPreis( $value );
					break;
				case '1030':
					$this->setPreisType($value);
					break;
				case '1032':
					$this->setCurrency($value);
					break;
				case '1023':
					$this->setMeldeNummer($value);
					break;
				case '9002':
					$this->setProduktgruppe($value);
					break;
				case '9003':
					$this->setSeitenzahl($value);
					break;
				case '1201':
					$value = $this->format_date($value);
					$this->setDatum( $value);
					break;
				case '1202':
					$this->setDatumType($value);
					break;
				case '1025':
					$this->setRabatt($value);
					break;
				case '1019':
					$this->setMWST($value);
					break;
				case '1109':
					$this->setSachtitel($value);
					break;
				default:
					echo '<li>Unknown Key: '.$id;
					break;
			}
		}
	}

	function getMode() {
		return $this->Mode;
	}

	function setMode($Mode) {
		switch($Mode){
			default:
				$this->Mode = 'unknown';
				break;
			case 'T101':
			case 'U101':
				$this->Mode = 'new';
				break;
			case 'T201':
			case 'U201':
				$this->Mode = 'update';
				break;
			case 'T301':
			case 'U301':
				$this->Mode = 'delete';
				break;
		}
	}

	function format_price($price){
		if($price > 0){
			$price = $price / 10000;
		}
		return $price;
	}

	function format_date($date){
		if(xtc_not_null($date)){
			$Y = substr($date,4,8);
			$M = substr($date,2,2);
			$D = substr($date,0,2);
			$date = $Y.'-'.$M.'-'.$D;
		}
		return $date;
	}

}
