<?php
class amz_Feedshandler_Feed {
    var $amazon_feeds_id;
    var $feed_submission_id;
    var $feed_type;
    var $feed_processing_status;
    var $submitted_date;
    var $completed_processing_date;
    var $processed;
    var $merchant_id;
    var $items;
    
    function __construct($amazon_feeds_id = 0){
	if($amazon_feeds_id > 0){
	    $this->setAmazon_feeds_id($amazon_feeds_id);
            $af = \YES4Trade\Model\amazon_feeds::get_by_amazon_feeds_id($this->getAmazon_feeds_id());
	    if($af === null){
		$this->debug('__construct('.$amazon_feeds_id.') failed');
		return false;
            }
            $this->setFeed_submission_id($af->feed_submission_id);
            $this->setFeed_type($af->feed_type);
            $this->setFeed_processing_status($af->feed_processing_status);
            $this->setSubmitted_date($af->submitted_date);
            $this->setCompleted_processing_date($af->completed_processing_date);
            $this->setProcessed($af->processed);
            $this->setMerchant_id($af->merchant_id);
            $this->setItems($this->get_feed_items());
            $this->debug('__construct('.$amazon_feeds_id.')');
	    
	}
    }
    public function getAmazon_feeds_id() {
	return $this->amazon_feeds_id;
    }

    public function setAmazon_feeds_id($amazon_feeds_id) {
	$this->amazon_feeds_id = $amazon_feeds_id;
    }

    public function getFeed_submission_id() {
	return $this->feed_submission_id;
    }

    public function setFeed_submission_id($feed_submission_id) {
	$this->feed_submission_id = $feed_submission_id;
    }

    public function getFeed_type() {
	return $this->feed_type;
    }

    public function setFeed_type($feed_type) {
	$this->feed_type = $feed_type;
    }

    public function getFeed_processing_status() {
	return $this->feed_processing_status;
    }

    public function setFeed_processing_status($feed_processing_status) {
	$this->feed_processing_status = $feed_processing_status;
    }

    public function getSubmitted_date() {
	return $this->submitted_date;
    }

    public function setSubmitted_date($submitted_date) {
	$this->submitted_date = $submitted_date;
    }

    public function getCompleted_processing_date() {
	return $this->completed_processing_date;
    }

    public function setCompleted_processing_date($completed_processing_date) {
	$this->completed_processing_date = $completed_processing_date;
    }

    public function getProcessed() {
	return $this->processed;
    }

    public function setProcessed($processed) {
	$this->processed = $processed;
    }

    public function getMerchant_id() {
	return $this->merchant_id;
    }

    public function setMerchant_id($merchant_id) {
	$this->merchant_id = $merchant_id;
    }
    
    public function getItems() {
	return $this->items;
    }

    public function setItems($items) {
	$this->items = $items;
    }
    
    public function addItem($item) {
	$this->items[] = $item;
    }
    
    private function get_feed_items(){
	$items = array();
	switch($this->getFeed_type()){
	    case '_POST_PRODUCT_PRICING_DATA_': // veraltet
            case 'JSON_LISTINGS_FEED.price':
                $amazon_feeds_price_items = \YES4Trade\Model\amazon_feeds_price_items::get_by_amazon_feeds_id(
                    intval($this->getAmazon_feeds_id())
                );
		foreach($amazon_feeds_price_items as $record){
                    $pID = yes_get_products_id_from_amazon_sku($record->sku);
                    $items[] = array(
                        'sku'=>$record->sku,
                        'price'=>$record->price,
                        'processed'=>$record->processed,
                        'products_id'=>$pID
                    );
		}
		break;
            case 'JSON_LISTINGS_FEED.quantity':
	    case '_POST_INVENTORY_AVAILABILITY_DATA_': // veraltet
		    $query = xtc_db_query(sprintf(
			    "SELECT sku,qty,processed FROM amazon_feeds_quantity_items afqi WHERE afqi.amazon_feeds_id=%s",
			    $this->getAmazon_feeds_id()
		    ));
		    while($record = xtc_db_fetch_array($query)){
			    $pID = yes_get_products_id_from_amazon_sku($record['sku']);
			    $items[] = array(
				    'sku'=>$record['sku'],
				    'qty'=>$record['qty'],
				    'processed'=>$record['processed'],
				    'products_id'=>$pID
			    );
		    }
		    break;
		case '_POST_ORDER_FULFILLMENT_DATA_':
			$query = xtc_db_query(sprintf(
				"SELECT amazon_order_item_code,processed FROM amazon_feeds_order_fulfillments afof WHERE afof.amazon_feeds_id=%s",
				$this->getAmazon_feeds_id()
			));
			while($record = xtc_db_fetch_array($query)){
				$items[] = array(
					'amazon_order_item_code'=>$record['amazon_order_item_code'],
					'processed'=>$record['processed'],
					'shipper_tracking_number'=>$record['shipper_tracking_number']
				);
			}
			break;
	}
	$this->debug('get_feed_items()');
	return $items;
    }
    
    public function update_yes_qty(){
		$items = $this->getItems();
		$processed = 0;
		foreach($items as $item){
		    $pID = yes_get_products_id_from_amazon_sku($item['sku']);
		    if($pID < 1){
			    $this->setErrorMsg(sprintf(
				    MSG_ERROR_FEED_UNKNOWN_PRODUCTS_ID,
				    $this->getFeed_submission_id(), $item['sku']
			    ));
		    }else{
			    $this->update_qty_db($pID,$item['sku'],$item['qty']);
		    }
		    $processed++;
		}
		$this->debug('update_yes_qty()');
		if($processed == sizeOf($items)){
			$this->delete_feed_info_db();
			return true;
		}
		return false;
	}

	public function update_yes_price(){
		$items = $this->getItems();
		$processed = 0;
		foreach($items as $item){
		    $pID = yes_get_products_id_from_amazon_sku($item['sku']);
		    if($pID < 1){
			    $this->setErrorMsg(sprintf(
				    MSG_ERROR_FEED_UNKNOWN_PRODUCTS_ID,
				    $this->getFeed_submission_id(), $pID
			    ));
		    }else{
			    $this->update_price_db($pID,$item['sku'],$item['price']);
		    }
		    $processed++;
		}
		$this->debug('update_yes_price()');
		if($processed == sizeOf($items)){
			$this->delete_feed_info_db();
			return true;
		}
		return false;
	}

	public function update_order_fulfillment(){
		$items = $this->getItems();
		$processed = 0;
		foreach($items as $item){
		    if( $item['amazon_order_item_code'] != '' ){
			    $this->update_order_fulfillment_db(
				$item['amazon_order_item_code'],
				$item['shipper_tracking_number']
			    );
		    }
		    $processed++;
		}
		$this->debug('update_order_fulfillment()');
		if($processed == sizeOf($items)){
			$this->delete_feed_info_db();
			return true;
		}
		return false;
	}
	
	private function delete_feed_info_db(){
            \YES4Trade\Model\amazon_feeds::delete($this->getAmazon_feeds_id());
            $this->setProcessed(1);
            $this->items = array();
            $this->debug('delete_feed_info_db()');
	}

	private function get_yes_amazon_qty($sku){
		return yes_get_amazon_products_qty($sku);
	}
	
	private function update_qty_db($pID,$sku,$qty){
		$current_amazon_qty = $this->get_yes_amazon_qty($sku);
		$update_sql_array = array(
			'quantity'=>$qty,
			'last_quantity_feed'=>'now()'
		);
		xtc_db_perform('amazon_products',$update_sql_array,'update',"sku='".$sku."'");
		$submitted_qty = $qty;
		yes_add_products_history($pID, sprintf(MSG_AMAZON_UPDATE_QTY,
				$current_amazon_qty,
				$submitted_qty
			)
		);
		$update_sql_array = array(
			'processed'=>1
		);
		xtc_db_perform('amazon_feeds_quantity_items',$update_sql_array,'update',sprintf(
			"sku='%s' and amazon_feeds_id=%s",
			$sku,
			$this->getAmazon_feeds_id()
		));
		$this->debug('update_qty_db('.$pID.','.$sku.','.$qty.')');
	}
	
	function update_price_db($pID,$sku,$price){
		$update_sql_array = array(
			'price'=>$price,
			'last_price_feed'=>'now()'
		);
		$update_where = sprintf("sku='%s'",$sku);
		xtc_db_perform('amazon_products',$update_sql_array,'update',$update_where);
                
                $amazon_feeds_price_items = \YES4Trade\Model\amazon_feeds_price_items::get_by_amazon_feeds_id_and_sku(
                    intval($this->getAmazon_feeds_id()), $sku
                );
                // eigentlich sollte es nur einen Eintrag zur Beziehung
                // amazon_feeds_id / sku existieren, aber wer weiss
                foreach($amazon_feeds_price_items as $afpi){
                    $upd = new \YES4Trade\Model\amazon_feeds_price_items([
                        'amazon_feeds_price_items_id'=>$afpi->amazon_feeds_price_items_id,
                        'processed'=>1
                    ]);
                    $upd->update();
                }
		$this->debug('update_price_db('.$pID.','.$sku.','.$price.')');
	}
	
	private function update_order_fulfillment_db($amazon_order_item_code,$shipper_tracking_number){
		$update_sql_array = array(
			'order_fulfillment_send'=>1,
			'order_fulfillment_send_date'=>'now()',
			'shipper_tracking_number'=>$shipper_tracking_number
		);
		$update_where = sprintf("amazon_order_item_code='%s'",$amazon_order_item_code);
		xtc_db_perform('amazon_orders_products',$update_sql_array,'update',$update_where);
		$update_sql_array = array(
			'processed'=>1
		);
		xtc_db_perform('amazon_feeds_order_fulfillments',$update_sql_array,'update',sprintf(
			"amazon_order_item_code='%s' and amazon_feeds_id=%s",
			$amazon_order_item_code,
			$this->getAmazon_feeds_id()
		));
		$this->debug('update_order_fulfillment_db('.$amazon_order_item_code.','.$shipper_tracking_number.')');
	}
	
	private function debug($str){
	    if(CRON_AMAZON_FEEDS_DEBUG == 1){
		printf("\r\n\tDEBUG %s: %s",get_class($this),$str);
	    }
	}
	public function getErrorMsg() {
		return $this->ErrorMsg;
	}

	public function setErrorMsg($ErrorMsg,$id = -1) {
            if($id > 0){
                $this->ErrorMsg[$id] = $ErrorMsg;
            }else{
                $this->ErrorMsg[] = $ErrorMsg;
            }
	}
}