<?php
class amazon_sp
{
    const AMAZON_SP_awsAccessKeyId = "AKIATQM37HTULRQE77HD";
    const AMAZON_SP_awsSecretAccessKey = "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";
    const AMAZON_SP_roleArn = "arn:aws:iam::241382145256:role/ExecuteAPIRole";
    const AMAZON_SP_APPLICATION_ID = 'amzn1.sp.solution.59b8d3bd-5f8c-4e32-9e37-4c0fc4785931';
    const AMAZON_SP_LWACLIENTID = "amzn1.application-oa2-client.26ee5febe1884f7a9c5f39e5aea366bb";
    const AMAZON_SP_LWACLIENTID_FILE = 'AMAZON_SP_LWACLIENT.SECRET';
    const AMAZON_SP_FEED_STATES = [
        ['id'=>'CANCELLED','text'=>'The feed was cancelled before it started processing.'],
        ['id'=>'DONE','text'=>'The feed has completed processing. Examine the contents of the result document to determine if there were any errors during processing.'],
        ['id'=>'FATAL','text'=>'The feed was aborted due to a fatal error. Some, none, or all of the operations within the feed may have completed successfully.'],
        ['id'=>'IN_PROGRESS','text'=>'The feed is being processed.'],
        ['id'=>'IN_QUEUE','text'=>'The feed has not yet started processing. It may be waiting for another IN_PROGRESS feed.'],
    ];
                                      
    const AMAZON_SP_DEVELOPER_ID = '241382145256';

    const AMAZON_SP_MARKETPLACES = [
        ['country'=>'Canada', 'id'=>'A2EUQ1WTGCTBG2','code'=>'CA',
            'url'=>'https://sellercentral.amazon.ca'
        ],
        ['country'=>'United States of America', 'id'=>'ATVPDKIKX0DER','code'=>'US',
            'url'=>'https://sellercentral.amazon.com'
        ],
        ['country'=>'Mexico', 'id'=>'A1AM78C64UM0Y8','code'=>'MX',
            'url'=>'https://sellercentral.amazon.com.mx'
        ],
        ['country'=>'Brazil', 'id'=>'A2Q3Y263D00KWC','code'=>'BR',
            'url'=>'https://sellercentral.amazon.com.br'
        ],
        ['country'=>'Spain', 'id'=>'A1RKKUPIHCS9HS','code'=>'ES',
            'url'=>'https://sellercentral-europe.amazon.com'
        ],
        ['country'=>'United Kingdom', 'id'=>'A1F83G8C2ARO7P','code'=>'UK',
            'url'=>'https://sellercentral-europe.amazon.com'
        ],
        ['country'=>'France', 'id'=>'A13V1IB3VIYZZH','code'=>'FR',
            'url'=>'https://sellercentral-europe.amazon.com'
        ],
        ['country'=>'Belgium', 'id'=>'AMEN7PMS3EDWL','code'=>'BE',
            'url'=>'https://sellercentral.amazon.com.be'
        ],
        ['country'=>'Netherlands', 'id'=>'A1805IZSGTT6HS','code'=>'NL',
            'url'=>'https://sellercentral.amazon.nl'
        ],
        ['country'=>'Germany', 'id'=>'A1PA6795UKMFR9','code'=>'DE',
            'url'=>'https://sellercentral-europe.amazon.com'
        ],
        ['country'=>'Italy', 'id'=>'APJ6JRA9NG5V4','code'=>'IT',
            'url'=>'https://sellercentral-europe.amazon.com'
        ],
        ['country'=>'Sweden', 'id'=>'A2NODRKZP88ZB9','code'=>'SE',
            'url'=>'https://sellercentral.amazon.se'
        ],
        ['country'=>'South Africa', 'id'=>'AE08WJ6YKNBMC','code'=>'ZA',
            'url'=>'https://sellercentral.amazon.ca'
        ],
        ['country'=>'Poland', 'id'=>'A1C3SOZRARQ6R3','code'=>'PL',
            'url'=>'https://sellercentral.amazon.pl'
        ],
        ['country'=>'Egypt', 'id'=>'ARBP9OOSHTCHU','code'=>'EG',
            'url'=>'https://sellercentral.amazon.eg'
        ],
        ['country'=>'Turkey', 'id'=>'A33AVAJ2PDY3EV','code'=>'TR',
            'url'=>'https://sellercentral.amazon.com.tr'
        ],
        ['country'=>'Saudi Arabia', 'id'=>'A17E79C6D8DWNP','code'=>'SA',
            'url'=>'https://sellercentral.amazon.sa'
        ],
        ['country'=>'United Arab Emirates', 'id'=>'A2VIGQ35RCS4UG','code'=>'AE',
            'url'=>'https://sellercentral.amazon.ae'
        ],
        ['country'=>'India', 'id'=>'A21TJRUUN4KGV','code'=>'IN',
            'url'=>'https://sellercentral.amazon.in'
        ],
        ['country'=>'Singapore', 'id'=>'A19VAU5U5O7RUS','code'=>'SG',
            'url'=>'https://sellercentral.amazon.sg'
        ],
        ['country'=>'Australia', 'id'=>'A39IBJ37TRP1C6','code'=>'AU',
            'url'=>'https://sellercentral.amazon.com.au'
        ],
        ['country'=>'Japan', 'id'=>'A1VC38T7YXB528','code'=>'JP',
            'url'=>'https://sellercentral.amazon.co.jp'
        ],
    ];
    
    
    var $auth_params, $configObj;

    function __construct( $seller = null, $createConfigObj = true ){
        $this->readAuth_params();
        if($createConfigObj){
            $this->configObj = $this->getSPAPI_config( $seller );
        }
    }
    
    public static function set_lwaclientsecret( $secret ){
        $file = main::get_secure_path().self::AMAZON_SP_LWACLIENTID_FILE;
        if(!is_file($file)){
            throw new Exception('Amazon LWA secret file not exists');
        }
        if(!is_writable($file)){
            throw new Exception('Amazon LWA secret file is not writeable');
        }
        try{
            basics::create_file2($file, $secret);
            return true;
        }catch( Exception $e ){
            throw new Exception( $e->getMessage() );
        }
    }
    
    public static function get_lwaclientsecret(){
        $file = main::get_secure_path().self::AMAZON_SP_LWACLIENTID_FILE;
        if(!is_file($file)){
            throw new Exception('Amazon LWA secret file not exists');
        }
        $content = file_get_contents($file);
        if(empty(trim($content))){
            throw new Exception('Amazon LWA secret file is empty');
        }
        return trim($content);
    }
    
    public function getSPAPI_config( $seller ){
        $found = false;
        foreach($this->getAuth_params()->users as $user=>$data){
            if($user === $seller){
                $found = true;
                $auth = $data;
            }
        }
        if(gettype($auth) == 'NULL'){
            return false;
        }
        return new SellingPartnerApi\Configuration([
            "lwaClientId" => self::AMAZON_SP_LWACLIENTID,
            "lwaClientSecret" => self::get_lwaclientsecret(),
            "lwaRefreshToken" => $auth->auth->refresh_token,
            "awsAccessKeyId" => self::AMAZON_SP_awsAccessKeyId,
            "awsSecretAccessKey" => self::AMAZON_SP_awsSecretAccessKey,
            // If you're not working in the North American marketplace, change
            // this to another endpoint from lib/Endpoint.php
            "endpoint" => SellingPartnerApi\Endpoint::EU,
            //"roleArn" => self::AMAZON_SP_roleArn,
        ]);
    }
    
    public static function write_file( $string,$filename ){
        // Let's make sure the file exists and is writable first.
        if(is_file($filename)){
            unlink($filename);
        }
        touch($filename);
        if (is_writable($filename)) {

            // In our example we're opening $filename in append mode.
            // The file pointer is at the bottom of the file hence
            // that's where $somecontent will go when we fwrite() it.
            if (!$fp = fopen($filename, 'w')) {
                 echo "Error: Cannot open file ($filename)";
                 return false;
            }

            // Write $somecontent to our opened file.
            if (fwrite($fp, $string) === FALSE) {
                echo "Error: Cannot write to file ($filename)";
                return false;
            }
            fclose($fp);
            return true;
        }
        echo "Error: The file $filename is not writable";
        return false;
    }
    
    private function readAuth_params(){
        $auth_file = main::get_secure_path().'AMAZON_SP_AUTH.json';
        if(!is_file($auth_file)){
            $write = $this->write_file(json_encode([
                'users'=>[]
            ],JSON_PRETTY_PRINT),$auth_file);
            if(!$write){
                return false;
            }
        }
        return $this->setAuth_params( json_decode(file_get_contents($auth_file)) );
    }
    public function getAuth_params() {
        return $this->auth_params;
    }

    public function setAuth_params($auth_params): void {
        $this->auth_params = $auth_params;
    }
    
    public function createFeedFile( $xml ){
        $dir = main::get_secure_path().'AMAZON-SP-FEEDS_TO_CREATE';
        if(!is_dir($dir)){
            mkdir($dir);
        }
        $filename_prefix = time();
        while(file_exists($dir.DIRECTORY_SEPARATOR.$filename_prefix.'.xml')){
            $filename_prefix = time().'-1';
        }
        $this->write_file($xml, $dir.DIRECTORY_SEPARATOR.$filename_prefix.'.xml');
    }

    public function getFeedFiles(){
        $dir = main::get_secure_path().'AMAZON-SP-FEEDS_TO_CREATE';
        $saved_files = scandir($dir);
        $xml_files = [];
        foreach($saved_files as $file){
            if(strpos($file, '.xml') < 0){
                continue;
            }
            $xml_files[] = $dir.DIRECTORY_SEPARATOR.$file;
        }
        return $xml_files;
    }
    
    public function uploadFeedFile( $target_url, $content ){
        $options = [
            'headers' => ['Content-Type' => 'text/xml; charset=UTF-8'],
            'body' => $content
        ];

        $client = new Client();
        $client->request('PUT', $target_url, $options);

    }

    public function get_update_qty_feed( $user,$data ){
            $xml = $this->get_base_xml( $user );
            $feed = new SimpleXMLElement($xml);
            $feed->addChild('MessageType','Inventory');
            foreach($data as $nr => $product){
                $Message = $feed->addChild('Message');
                $Message->addChild('MessageID',$nr+1);
                $Message->addChild('OperationType','Update');
                $Inventory = $Message->addChild('Inventory');
                $Inventory->addChild('SKU',$product['sku']);
                $Inventory->addChild('Quantity',$product['qty']);
                $Inventory->addChild('FulfillmentLatency',(int)$product['fulfillment_latency']);
            }
            return $feed;
    }

    /**
     * Liefert den XML Feed um den Preis eines Artikels bei Amazon zu aendern
     *
     * @param String $sku
     * @param String $price
     * @return String
     */
    public function get_update_price_feed($user,$data){
        $xml = $this->get_base_xml( $user );
        $feed = new SimpleXMLElement($xml);
        $feed->addChild('MessageType','Price');
        foreach($data as $nr => $product){
            $Message = $feed->addChild('Message');
            $Message->addChild('MessageID',$nr+1);
            
            $Price = $Message->addChild('Price');
            $Price->addChild('SKU',$product['sku']);
            $StandardPrice = $Price->addChild('StandardPrice',$product['price']);
            $StandardPrice->addAttribute('currency','EUR');
        }
        return $feed;
    }


    /**
     * Liefert das XML fuer einen OrderFulfilment Feed bezogen auf mehrere
     * Bestellungen/Artikel
     *
     * @param Array $orders
     * @return string
     */
    public function get_order_fulfillment_feed($orders){
            if(!sizeOf($orders))
                    return '';
            $xml = $this->get_base_xml();
            $feed = new SimpleXMLElement($xml);
            $feed->addChild('MessageType', 'OrderFulfillment');
            $message_id = 1;
            foreach($orders as $counter=>$order){
                    if(strstr($order['shipper_tracking_number'],'+')){
                            $tracking_numbers_array = explode('+',$order['shipper_tracking_number']);
                            $tracking_numbers = array(current($tracking_numbers_array));
                    }else{
                            $tracking_numbers = array($order['shipper_tracking_number']);
                    }

                    $items_per_tn = array();
                    foreach($tracking_numbers as $lfd => $tn){
                            $Message = $feed->addChild('Message');
                            $Message->addChild('MessageID', $message_id);
                            $OrderFulfillment = $Message->addChild('OrderFulfillment');
                            //$OrderFulfillment->addChild('MerchantOrderID',$order['merchant_orders_id']);
                            $OrderFulfillment->addChild('AmazonOrderID',$order['amazon_orders_id']);
                            $date = new DateTime('now');
                            $OrderFulfillment->addChild('FulfillmentDate',$date->format(DATE_ATOM));
                            $FulfillmentData = $OrderFulfillment->addChild('FulfillmentData');
                            if($order['carrier_code'] != '')
                                    $FulfillmentData->addChild('CarrierCode',$order['carrier_code']);
                            if($order['carrier_name'] != '')
                                    $FulfillmentData->addChild('CarrierName',$order['carrier_name']);
                            $FulfillmentData->addChild('ShippingMethod',$order['shipping_method_service_level']);
                            if($tn != '')
                                    $FulfillmentData->addChild('ShipperTrackingNumber',trim($tn));
                            foreach($order['items'] as $item){
                                    $Item = $OrderFulfillment->addChild('Item');
                                    $Item->addChild('AmazonOrderItemCode',$item['amazon_order_item_code']);
                                    $Item->addChild('Quantity',$item['quantity']);
                                    // BOF - Teillieferungen
                                    if(sizeOf($tracking_numbers) > 1){
                                        /* ENTFERNT - SOLLTE DAS QUANTITY
                                         * FELD MIT UEBERGEBEN BEI MEHREREN
                                         * SHIPPING TRACKING NUMMERN
                                         * KLAPPTE ABER AUCH NICHT


                                            if(!isset($items_per_tn[$item['amazon_order_item_code']])){
                                                    $items_per_tn_mod = $item['order_quantity'] % sizeOf($tracking_numbers);
                                                    $items_per_tn[ $item['amazon_order_item_code'] ] = ($item['order_quantity'] - $items_per_tn_mod) / sizeOf($tracking_numbers);
                                                    $send_qty = $items_per_tn[$item['amazon_order_item_code']]+$items_per_tn_mod;
                                            }else{
                                                    $send_qty = $items_per_tn[$item['amazon_order_item_code']];
                                            }
                                            $Item->addChild('Quantity',$send_qty);
                                         * 
                                         */
                                    }
                                    // EOF - Teillieferungen

//					$Item->addChild('MerchantFulfillmentItemID',$item['merchant_fulfillment_item_id']);
                            }
                            $message_id++;
                    }
                    unset($items_per_tn);
            } // eof foreach orders
            return $feed;
    }

    /**
     * Liefert einen Feed zu einem bestimmten OperationType fuer ein Array von
     * Artikeln
     *
     * @param Array $products_id_array
     * @param String $OperationType
     * @return String
     */
    public function get_product_feed($products_id_array,$OperationType){
            $feed = $this->get_base_xml();
            $feed = new SimpleXMLElement($feed);

            foreach($products_id_array as $counter =>  $pID){
                    $product = new product( xtc_db_input($pID));
                    $amazon_values = $product->get_amazon_values();
                    $feed->addChild('MessageType','Product');
                    $Message = $feed->addChild('Message');
                    $Message->addChild('MessageID', $counter);
                    $Message->addChild('OperationType', $OperationType);
                    $Product = $Message->addChild('Product');
                    $Product->addChild('SKU', $amazon_values['sku']);
                    if(!empty($product->info['products_ean'])){
                            $StandardProductID = $Product->addChild('StandardProductID');
                            $StandardProductID->addChild('Type', 'EAN');
                            $StandardProductID->addChild('Value', $product->info['products_ean']);
                    }
            }
            return $feed;
    }

    /**
     * Submitted den Feed an Amazon und liefert das Resultat.
     * Bei einem Fehler wird die Meldung ausgegeben.
     *
     * @param MarketplaceWebService_Interface $service
     * @param Object $request
     * @return Resultinfo
     */
    public static function invokeSubmitFeed(MarketplaceWebService_Interface $service, $request){
            try {
                    $response = $service->submitFeed($request);
                    if ($response->isSetSubmitFeedResult()) {
                            $submitFeedResult = $response->getSubmitFeedResult();
                            return $submitFeedResult->getFeedSubmissionInfo();
                    }
            } catch (MarketplaceWebService_Exception $ex) {
                    echo amazon_get_request_error_msg($ex);
            }
    }

    public function getOrderAcknowledgementFeed($orders_array){
            $xml = '';
            if(!sizeOf($orders_array))
                    return $xml;
            $xml = $this->get_base_xml();
            $feed = new SimpleXMLElement($xml);
            $feed->addChild('MessageType', 'OrderAcknowledgement');

            foreach($orders_array as $counter=>$order){
                    $Message = $feed->addChild('Message');
                    $Message->addChild('MessageID', ($counter+1));
                    $OrderAcknowledgement = $Message->addChild('OrderAcknowledgement');
                    $OrderAcknowledgement->addChild('AmazonOrderID',$order['amazon_orders_id']);
                    $OrderAcknowledgement->addChild('MerchantOrderID',$order['merchant_orders_id']);
                    $OrderAcknowledgement->addChild('StatusCode','Success');
                    $Item = $OrderAcknowledgement->addChild('Item');
                    foreach($order['items'] as $item){
                            $Item->addChild('AmazonOrderItemCode',$item['amazon_order_item_code']);
                            $Item->addChild('MerchantOrderItemID',$item['merchant_order_item_id']);
                    }
            }
            return $feed;
    }
    /**
     * Diese Funktion gibt den XML Header fuer alle Feeds als String zurueck.
     * Diesen XML String laden wir dann als SimpleXMLElement und k�nnen diesen
     * erweitern
     *
     * @return String
     */
    public static function get_base_xml( $user ){
		$xml =	<<<EOD
<?xml version="1.0"?>
<AmazonEnvelope xsi:noNamespaceSchemaLocation="amzn-envelope.xsd" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance">
	<Header>
		<DocumentVersion>1.0</DocumentVersion>
		<MerchantIdentifier>%s</MerchantIdentifier>
	</Header>
</AmazonEnvelope>
EOD;
		return sprintf($xml,$user);
    }
    
    public static function get_marketplaces_for_selectbox(){
        $return = [];
        foreach( self::AMAZON_SP_MARKETPLACES as $m ){
            $return[] = [
                'id'=>$m['id'],
                'text'=>$m['country'].' ('.$m['code'].')',
            ];
        }
        return $return;
    }
    
    public function insert_feed_info_to_db(string $selling_partner_id, array $products, string $feed_id, string $feed_type){
        $new = new \YES4Trade\Model\amazon_feeds([
            'feed_submission_id'=>$feed_id,// 	varchar(16)
            'feed_type'=>$feed_type,
            'feed_processing_status'=>'IN_QUEUE',
            'submitted_date'=>date('Y-m-d H:i:s'),
            'completed_processing_date'=>'',
            'processed'=>0,
            'selling_partner_id'=>$selling_partner_id,
        ]);
        $afID = $new->create();
        foreach($products as $p){
            switch($feed_type){
                case 'JSON_LISTINGS_FEED.quantity':
                    $insert_sql_array = [
                        'amazon_feeds_id'=>$afID,
                        'qty'=>$p['qty'],
                        'sku'=>$p['sku'],
                        'processed'=>0,
                        'fulfillment_latency'=>$p['fulfillment_latency'],
                    ];
                    xtc_db_perform('amazon_feeds_quantity_items',$insert_sql_array);
                    break;
                case 'JSON_LISTINGS_FEED.price':
                    $insert_sql_array = [
                        'amazon_feeds_id'=>intval($afID),
                        'price'=>(float)$p['price'],
                        'sku'=>$p['sku'],
                        'processed'=>0,
                    ];
                    $ins = new \YES4Trade\Model\amazon_feeds_price_items($insert_sql_array);
                    $ins->create();
                    break;
            }
        }
    }
    
    public function get_active_marketplaces(){
        $marketplaces = explode(',',MODULE_OTHER_AMAZON_MARKETPLACE_IDS);
        foreach($marketplaces as $k=>$v){
            $marketplaces[$k] = trim($v);
        }
        return $marketplaces;
    }
    
    public function count_amazon_products_allocations(string $selling_partner_id){
        $query = xtc_db_query(sprintf(
                "SELECT COUNT(amazon_products_id) AS anz FROM amazon_products WHERE selling_partner_id='%s'",
                $selling_partner_id
        ));
        $record = xtc_db_fetch_array($query);
        return $record['anz'];
    }

    /**
     * Pruefen ob eine oID existiert und ob die oID noch nicht zu einem Amazon
     * Auftrag zugewiesen wurde. Wenn true zurueck gegeben wird ist alles OK
     * 
     * @param int $oID
     * @return boolean
     */
    public static function check_yes_order_exists_and_not_allocated_to_amazon_order(int $oID){
        $q = xtc_db_query(sprintf(
                "SELECT orders_id FROM %s WHERE orders_id='%d'",
                TABLE_ORDERS, $oID
        ));
        if(!xtc_db_num_rows($q)){
            return false;
        }
        $q = xtc_db_query(sprintf(
                "SELECT orders_id FROM %s WHERE orders_id='%d'",
                'amazon_orders', $oID
        ));
        if(xtc_db_num_rows($q)){
            return false;
        }
        return true;
    }
}
