<?php
/**
 * FeePreview
 *
 * PHP version 7.3
 *
 * @category Class
 * @package  SellingPartnerApi
 */

/**
 * Selling Partner API for FBA Small And Light
 *
 * The Selling Partner API for FBA Small and Light lets you help sellers manage their listings in the Small and Light program. The program reduces the cost of fulfilling orders for small and lightweight FBA inventory. You can enroll or remove items from the program and check item eligibility and enrollment status. You can also preview the estimated program fees charged to a seller for items sold while enrolled in the program.
 *
 * The version of the OpenAPI document: v1
 * 
 * Generated by: https://openapi-generator.tech
 * OpenAPI Generator version: 5.0.1
 */

/**
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

namespace SellingPartnerApi\Model\SmallAndLightV1;
use ArrayAccess;
use SellingPartnerApi\Model\BaseModel;
use SellingPartnerApi\Model\ModelInterface;

/**
 * FeePreview Class Doc Comment
 *
 * @category Class
 * @description The fee estimate for a specific item.
 * @package  SellingPartnerApi
 * @group 
 * @implements \ArrayAccess<TKey, TValue>
 * @template TKey int|null
 * @template TValue mixed|null  
 */
class FeePreview extends BaseModel implements ModelInterface, ArrayAccess, \JsonSerializable, \IteratorAggregate
{
    public const DISCRIMINATOR = null;

    /**
      * The original name of the model.
      *
      * @var string
      */
    protected static $openAPIModelName = 'FeePreview';

    /**
      * Array of property to type mappings. Used for (de)serialization
      *
      * @var string[]
      */
    protected static $openAPITypes = [
        'asin' => 'string',
        'price' => '\SellingPartnerApi\Model\SmallAndLightV1\MoneyType',
        'fee_breakdown' => '\SellingPartnerApi\Model\SmallAndLightV1\FeeLineItem[]',
        'total_fees' => '\SellingPartnerApi\Model\SmallAndLightV1\MoneyType',
        'errors' => '\SellingPartnerApi\Model\SmallAndLightV1\Error[]'
    ];

    /**
      * Array of property to format mappings. Used for (de)serialization
      *
      * @var string[]
      * @phpstan-var array<string, string|null>
      * @psalm-var array<string, string|null>
      */
    protected static $openAPIFormats = [
        'asin' => null,
        'price' => null,
        'fee_breakdown' => null,
        'total_fees' => null,
        'errors' => null
    ];



    /**
     * Array of attributes where the key is the local name,
     * and the value is the original name
     *
     * @var string[]
     */
    protected static $attributeMap = [
        'asin' => 'asin',
        'price' => 'price',
        'fee_breakdown' => 'feeBreakdown',
        'total_fees' => 'totalFees',
        'errors' => 'errors'
    ];

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     *
     * @var string[]
     */
    protected static $setters = [
        'asin' => 'setAsin',
        'price' => 'setPrice',
        'fee_breakdown' => 'setFeeBreakdown',
        'total_fees' => 'setTotalFees',
        'errors' => 'setErrors'
    ];

    /**
     * Array of attributes to getter functions (for serialization of requests)
     *
     * @var string[]
     */
    protected static $getters = [
        'asin' => 'getAsin',
        'price' => 'getPrice',
        'fee_breakdown' => 'getFeeBreakdown',
        'total_fees' => 'getTotalFees',
        'errors' => 'getErrors'
    ];


    
    /**
     * Associative array for storing property values
     *
     * @var mixed[]
     */
    protected $container = [];

    /**
     * Constructor
     *
     * @param mixed[] $data Associated array of property values
     *                      initializing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['asin'] = $data['asin'] ?? null;
        $this->container['price'] = $data['price'] ?? null;
        $this->container['fee_breakdown'] = $data['fee_breakdown'] ?? null;
        $this->container['total_fees'] = $data['total_fees'] ?? null;
        $this->container['errors'] = $data['errors'] ?? null;
    }

    /**
     * Show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalidProperties = [];
        return $invalidProperties;
    }


    /**
     * Gets asin
     *
     * @return string|null
     */
    public function getAsin()
    {
        return $this->container['asin'];
    }

    /**
     * Sets asin
     *
     * @param string|null $asin The Amazon Standard Identification Number (ASIN) value used to identify the item.
     *
     * @return self
     */
    public function setAsin($asin)
    {
        $this->container['asin'] = $asin;

        return $this;
    }
    /**
     * Gets price
     *
     * @return \SellingPartnerApi\Model\SmallAndLightV1\MoneyType|null
     */
    public function getPrice()
    {
        return $this->container['price'];
    }

    /**
     * Sets price
     *
     * @param \SellingPartnerApi\Model\SmallAndLightV1\MoneyType|null $price price
     *
     * @return self
     */
    public function setPrice($price)
    {
        $this->container['price'] = $price;

        return $this;
    }
    /**
     * Gets fee_breakdown
     *
     * @return \SellingPartnerApi\Model\SmallAndLightV1\FeeLineItem[]|null
     */
    public function getFeeBreakdown()
    {
        return $this->container['fee_breakdown'];
    }

    /**
     * Sets fee_breakdown
     *
     * @param \SellingPartnerApi\Model\SmallAndLightV1\FeeLineItem[]|null $fee_breakdown A list of the Small and Light fees for the item.
     *
     * @return self
     */
    public function setFeeBreakdown($fee_breakdown)
    {
        $this->container['fee_breakdown'] = $fee_breakdown;

        return $this;
    }
    /**
     * Gets total_fees
     *
     * @return \SellingPartnerApi\Model\SmallAndLightV1\MoneyType|null
     */
    public function getTotalFees()
    {
        return $this->container['total_fees'];
    }

    /**
     * Sets total_fees
     *
     * @param \SellingPartnerApi\Model\SmallAndLightV1\MoneyType|null $total_fees total_fees
     *
     * @return self
     */
    public function setTotalFees($total_fees)
    {
        $this->container['total_fees'] = $total_fees;

        return $this;
    }
    /**
     * Gets errors
     *
     * @return \SellingPartnerApi\Model\SmallAndLightV1\Error[]|null
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     *
     * @param \SellingPartnerApi\Model\SmallAndLightV1\Error[]|null $errors One or more unexpected errors occurred during the getSmallAndLightFeePreview operation.
     *
     * @return self
     */
    public function setErrors($errors)
    {
        $this->container['errors'] = $errors;

        return $this;
    }
}


