<?php
/**
 * In der Versandabschluss Lagerliste (lagerliste raw) sind nun keine Preise 
 * mehr verfuegbar. Vorher haben wir im template bereitgestellt
 * Artikel.FINAL_PRICE
 * Das ist zum einen fürs Lager irrelevant und zum anderen bei Teillieferungen
 * eher wieder fehleranfällig da rauszurechnen wieviel zb 3 der 5 Artikel nun
 * gekostet haben
 * 
 * 
 */
if(!function_exists('yes_write_notice')){
    require_once(DIR_FS_INC.'yes_write_notice.inc.php');
}
function get_source_title_string($source, bool $singular = false){
    if(!$source){
        return TEXT_ACTION_SHIPPING;
    }
    switch($source){
        case 'reclamations':
            return ($singular) ? TEXT_RECLAMATION : TABLE_HEADING_RECLAMATIONS;
        case 'block_reclamations':
            return ($singular) ? TEXT_RECLAMATION : TABLE_HEADING_BLOCKED_RECLAMATIONS;
        case 'orders':
            return ($singular) ? TEXT_ORDER : TABLE_HEADING_ORDERS;
        case 'block_orders':
            return ($singular) ? TEXT_ORDER : TABLE_HEADING_BLOCKED_ORDERS;
        case 'rueckstand':
            return ($singular) ? TEXT_ORDER : TABLE_HEADING_ORDERS_ARREAR;
        case 'otc':
            return ($singular) ? TEXT_OTC.' '.TEXT_ORDER : TEXT_OTC;
    }
}


class YESSavedShippingItems{
    var $items;
    function getItems() {
        return $this->items;
    }

    function setItems($items): void {
        $this->items = $items;
    }

    function __construct(array $params = []){
        $items = array();
        foreach($params['id_array'] as $id){
            $items[] = new YESSavedShippingItem($id);
        }
        $this->setItems($items);
    }
}

class YESShippingItem_base{
    var $class_obj;
    var $source;
    var $id;
    var $telephone;
    var $email;
    var $mobile;
    var $source_status_name;
    var $totals;
    var $default_versender;
    var $errors;
    var $allow_shipping;
    var $set_versandsperre_link;
    var $unset_versandsperre_link;
    var $set_rueckstand_link;
    var $unset_rueckstand_link;
    var $branches_id; // fuer otc
    var $is_shipping_before_payment;
    var $paydate;
    var $total_amount;
    var $has_part_delivery; // sind bereits shipping_products Eintraege vorhanden?
    
    function getIs_shipping_before_payment() {
        return $this->is_shipping_before_payment;
    }

    function setIs_shipping_before_payment($is_shipping_before_payment): void {
        $this->is_shipping_before_payment = $is_shipping_before_payment;
    }

    function getBranches_id() {
        return $this->branches_id;
    }

    function setBranches_id($branches_id): void {
        $this->branches_id = $branches_id;
    }
    
    function getClass_obj() {
        return $this->class_obj;
    }

    function getId() {
        return $this->id;
    }

    function setClass_obj($class_obj): void {
        $this->class_obj = $class_obj;
    }

    function setId($id): void {
        $this->id = $id;
    }

    function getSource() {
        return $this->source;
    }

    function setSource($source): void {
        $this->source = $source;
    }
    function getTelephone() {
        return $this->telephone;
    }

    function getEmail() {
        return $this->email;
    }

    function setTelephone($telephone): void {
        $this->telephone = $telephone;
    }

    function setEmail($email): void {
        $this->email = $email;
    }
    
    public function get_products(){
        return $this->class_obj->products;
    }
    function getMobile() {
        return $this->mobile;
    }

    function setMobile($mobile): void {
        $this->mobile = $mobile;
    }
    function getSource_status_name() {
        return $this->source_status_name;
    }

    function setSource_status_name($source_status_name): void {
        $this->source_status_name = $source_status_name;
    }

    function getTotals() {
        return $this->totals;
    }

    function setTotals($totals): void {
        $this->totals = $totals;
    }
    function getDefault_versender() {
        return $this->default_versender;
    }

    function setDefault_versender($default_versender): void {
        $this->default_versender = $default_versender;
    }
    function getErrors() {
        return $this->errors;
    }

    function setErrors($errors): void {
        $this->errors = $errors;
    }
    
    function getAllow_shipping() {
        return $this->allow_shipping;
    }

    function setAllow_shipping($allow_shipping): void {
        $this->allow_shipping = $allow_shipping;
    }
    
    function getSet_versandsperre_link() {
        return $this->set_versandsperre_link;
    }

    function getUnset_versandsperre_link() {
        return $this->unset_versandsperre_link;
    }

    function getSet_rueckstand_link() {
        return $this->set_rueckstand_link;
    }

    function getUnset_rueckstand_link() {
        return $this->unset_rueckstand_link;
    }

    function setSet_versandsperre_link($set_versandsperre_link): void {
        $this->set_versandsperre_link = $set_versandsperre_link;
    }

    function setUnset_versandsperre_link($unset_versandsperre_link): void {
        $this->unset_versandsperre_link = $unset_versandsperre_link;
    }

    function setSet_rueckstand_link($set_rueckstand_link): void {
        $this->set_rueckstand_link = $set_rueckstand_link;
    }

    function setUnset_rueckstand_link($unset_rueckstand_link): void {
        $this->unset_rueckstand_link = $unset_rueckstand_link;
    }
    function getPaydate() {
        return $this->paydate;
    }

    function setPaydate($paydate): void {
        $this->paydate = $paydate;
    }
    
    function getTotal_amount() {
        return $this->total_amount;
    }

    function setTotal_amount($total_amount): void {
        $this->total_amount = $total_amount;
    }
    
    function getHas_part_delivery() {
        return $this->has_part_delivery;
    }

    function setHas_part_delivery($has_part_delivery): void {
        $this->has_part_delivery = $has_part_delivery;
    }
    
    public function get_has_part_delivery(){
        $sql_id_key = ($this->getSource() == 'orders') ? 'orders_id' : 'reclamations_id';
        $query = xtc_db_query(sprintf(
                "SELECT id FROM shippings WHERE %s='%d'",
                $sql_id_key,$this->getId()
        ));
        return (bool)xtc_db_num_rows($query);
    }

    public function get_address_errors(){
        $address_warnings = array();
        if(!preg_match('/[0-9]+/',$this->getClass_obj()->delivery['street_address'])){
            $_street = $this->getClass_obj()->delivery['street_address'];
            if( empty($_street)){
                $_street = '<i style="font-size:inherit;">leer</i>';
            }
            $address_warnings[] = sprintf(TEXT_ADDRESS_WARNING_STREET_NO_NUMBER,$_street);
        }
        if(strlen($this->getClass_obj()->delivery['street_address']) > 30){
            $address_warnings[] = sprintf(TEXT_ADDRESS_WARNING_STREET_LENGTH,$this->getClass_obj()->delivery['street_address']);
        }
        if(!empty($this->getClass_obj()->delivery['suburb'])){
            $address_warnings[] = sprintf(TEXT_ADDRESS_WARNING_SUBURB_EXISTS,$this->getClass_obj()->delivery['suburb']);
        }
        $insel_plz_array = explode(',',SHIPPING_POSTCODES_GERMANY_SPECIAL);
        if($this->getClass_obj()->delivery['country'] == 'Germany' and in_array($this->getClass_obj()->delivery['postcode'],$insel_plz_array)){
            $address_warnings[] = TEXT_INTRO_ISLAND_SHIPPING;
        }
        if( $this->getClass_obj()->delivery['country'] != 'Germany' or strlen($this->getClass_obj()->delivery['postcode']) <> 5 or strlen($this->getClass_obj()->delivery['street_address']) < 3){
            $address_warnings[] = TEXT_ORDER_OUTSIDE_GERMANY;
        }
	if(stristr($this->getClass_obj()->delivery['suburb'],'packstation') or stristr($this->getClass_obj()->delivery['street_address'],'packstation')){
            $address_warnings[] = 'Adresse mit Packstation';
	}
        
        return $address_warnings;
    }
    
    /** 
     * Hermes Artikelpruefung
     * 
     * wenn es bereits einen versanddatensatz gibt, wird geprueft ob beim
     * gewaehltem Versender Hermes der Artikel auch ein zugewiesener Hermes
     * Artikel ist
     * 
     * @return bool
     */
    public function check_hermes_products(){
        $errors = array();
        if( $this->getVersender() == 'Hermes' ){
            foreach($this->getClass_obj()->products as $k=>$product){
                $storage_check_query = xtc_db_query(sprintf(
                    "SELECT nummer FROM storage_numbers WHERE products_id='%d' && storage_id='%d'",
                    $product['id'],
                    HERMES_LAGER_ID
                ));
                if( xtc_db_num_rows($storage_check_query) < 1 ){
                    return true;
                }
            }
        }
        return false;
    }
    
    public function check_products(){
        $errors = array();
        // BOF TICKET 1566 - Erscheinungsdatum
        // erweitert um comments - Ticket 2435
        foreach($this->getClass_obj()->products as $k=>$product){
            $pda_query = xtc_db_query(sprintf(
                    "SELECT products_date_available,comments,storage_comments,default_storage FROM %s WHERE products_id='%s'",
                TABLE_PRODUCTS,$product['id']
            ));
            if(!xtc_db_num_rows($pda_query)){
                continue;
            }
            $pda = xtc_db_fetch_array($pda_query);
            if($pda['comments'] != ''){
                // SOLL RAUS - ticket 3338
                //$errors[] = $pda['comments'];
            }
            if($pda['storage_comments'] != ''){
                $errors[] = PRODUCTS_STORAGE_COMMENTS.": ".xtc_db_prepare_input($pda['storage_comments']);
            }
            if($pda['products_date_available'] > date('Y-m-d H:i:s')){
                $errors[] = sprintf(TEXT_SPECIAL_WARNING_DATE_AVAILABLE,
                    $product['id'],
                    xtc_date_short($pda['products_date_available'])
                );
            }
        }
        // EOF TICKET 1566 - Erscheinungsdatum
        return $errors;
    }
}

class YESShippingItem_orders extends YESShippingItem_base{

    function __construct(array $values = []){
        $this->setId($values['id']);
        $this->setSource($values['source']);
        $this->setClass_obj(new order($this->getId()));
        $this->setEmail( $this->getClass_obj()->customer['email_address']);
        $this->setTelephone( $this->getClass_obj()->customer['telephone']);
        $this->setMobile( $this->getClass_obj()->customer['mobile']);
        $this->setSource_status_name($this->getClass_obj()->info['orders_status_name']);
        $this->setTotals( self::get_totals_string( $this->getClass_obj()->totals ) );
        $default_versender = $this->get_default_versender();
        $this->setDefault_versender($default_versender);
        $this->setDefault_versender($default_versender);
        
        
        // fuer otc
        $this->setBranches_id( $this->get_wrapping_counter_branches_id() );
        $this->check_errors();
        $this->setSet_rueckstand_link(xtc_href_link('shipping.php',xtc_get_all_get_params(array('action','oID')).'action=set_rueckstand&oID='.$this->getId()));
        $this->setSet_versandsperre_link(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','oID')).'action=set_block_shipping_confirm&oID='.$this->getId()));
        $this->setUnset_rueckstand_link(xtc_href_link('shipping.php',xtc_get_all_get_params(array('action','oID')).'action=unset_rueckstand&oID='.$this->getId()));
        $this->setUnset_versandsperre_link(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','oID','referrer')).'action=set_unblock_shipping&oID='.$this->getId()));
        $this->setIs_shipping_before_payment(xtc_is_shipping_before_payment($this->getClass_obj()->info['payment_method']));
        $this->setPaydate($this->get_paydate());
        $this->setTotal_amount($this->get_total_amount());
        $this->setHas_part_delivery($this->get_has_part_delivery());
    }
    
    
    private function get_total_amount(){
        foreach($this->getClass_obj()->totals as $total){
            switch($total['class']){
                case 'ot_total':
                    return number_format($total['value'],2,',','');
            }
        }
        return 0;
    }
    private function get_paydate(){
        if($this->getClass_obj()->info['date_payment'] > 0) {
                $paydate = ' Gebucht: '.yes_strftime('%d.%m.%y',strtotime($this->getClass_obj()->info['date_payment']));
        }else{
                if( xtc_is_shipping_before_payment($this->getClass_obj()->info['payment_method']) ){
                        $paydate = 'Bezahlart: '.$this->getClass_obj()->info['payment_method'];
                }else{
                        $paydate_query = xtc_db_query("SELECT date_added FROM orders_status_history WHERE orders_id='".$this->getId()."' && orders_status_id='".ORDERS_STATUS_BEZAHLT."'");
                        $paydate_res = xtc_db_fetch_array($paydate_query);
                        if(xtc_not_null($paydate_res['date_added'])) {
                                $paydate = ' Gebucht: '.yes_strftime('%d.%m.%y',strtotime($paydate_res['date_added']));
                        }else{
                                $paydate = '';
                        }
                }
        }
        $payment_query = xtc_db_query("SELECT ip.buchungstag,ip.betrag FROM incoming_payments ip, payment_orders po WHERE ip.id=po.payment_id and po.orders_id='".$this->getId()."'");
        if(xtc_db_num_rows($payment_query) > 0){
                while($payment = xtc_db_fetch_array($payment_query)) {
                        $paydate .= ' Z.-Eing vom '.$payment['buchungstag'].': '.number_format($payment['betrag'],2,',','').' und ';
                }
                $paydate = substr($paydate,0,(strlen($paydate)-5));
        }
        return $paydate;
    }
    
    private function get_wrapping_counter_branches_id(){
        $query = xtc_db_query(sprintf(
                "SELECT branches_id FROM wrapping_counter WHERE orders_id='%d'",
                $this->getId()
        ));
        if(!xtc_db_num_rows($query)){
            return -1;
        }
        $record = xtc_db_fetch_array($query);
        return $record['branches_id'];
    }
    
    public function get_default_versender(){
        $default_shipping_profile = '';
        $selected_versender = '';
        if(defined('SHIPPING_DEFAULT_VERSENDER') and SHIPPING_DEFAULT_VERSENDER == '1'){
            if(defined('SHIPPING_DEFAULT_VERSENDER_VALUE') and !empty(SHIPPING_DEFAULT_VERSENDER_VALUE)){
                $default_shipping_profile = SHIPPING_DEFAULT_VERSENDER_VALUE;
            }
        }
        // AUFTRAG IST WICHTIGER
        if($this->getClass_obj()->info['versender'] != ''){
            $default_shipping_profile = $this->getClass_obj()->info['versender'];
        }
        if(sizeOf($this->getClass_obj()->products) == 1){
            $pID = $this->getClass_obj()->products[0]['id'];
            $profile = \YES4Trade\Model\shipper_profiles::get_products_id_value($pID);
            if(!empty($profile)){
	            $default_shipping_profile = $profile;
	    }
        }
        if(!empty($default_shipping_profile)){
            $shipper_profile = \YES4Trade\Model\shipper_profiles::get_profile($default_shipping_profile);
            $selected_versender = $shipper_profile->versender;
        }
        return $selected_versender;
    }
    
    public static function get_totals_string( array $totals = []){
        $lines = array();
        foreach($totals as $ot){
            $lines[] = sprintf(
                    '<b>%s</b>&nbsp;%s',
                    $ot['title'],
                    $ot['text']
            );
        }
        return implode('<br />',$lines);
    }
    
    function check_errors(){
        $errors = array();
        $this->setAllow_shipping(true);
        
        if($this->getClass_obj()->info['ebay_id'] != ''){
            // BOF - PRUEFUNG AUF DOPPELT ANGELEGTE TRANSAKTIONEN
            $check_result = $this->getClass_obj()->check_auction_transaction_exists( $this->getId(), $this->getClass_obj()->info['ebay_id'] );
            if(sizeOf($check_result)){
                yes_write_notice('Doppelte eBay Transaktion', $check_result['message'], 0, main::get_notice_recipients('orders'));
                $errors[] = sprintf('<span style="color:#666;">%s</span>',$check_result['message']);
            }
            // EOF - PRUEFUNG AUF DOPPELTE TRANSAKTIONEN
            if( $this->getClass_obj()->getAllow_shipping_ebay_1_hour() == 0 && (strtotime($this->getClass_obj()->info['date_purchased'])+(60*60)) > time()  ){
                $errors[] = sprintf(TEXT_SHIPPING_EBAY_SPERRE,
                        date('H:i:s',strtotime($this->getClass_obj()->info['date_purchased']))
                );
                $this->setAllow_shipping(false);
            }
        }
        
        // BOF - AMAZON ALLOCATION
        if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
                $amz_query = xtc_db_query(sprintf(
                        "SELECT amazon_orders_id FROM amazon_orders WHERE orders_id=%s",
                        $this->getId()
                ));
                if(xtc_db_num_rows($amz_query)){
                        $amzp_query = xtc_db_query(sprintf(
                                "SELECT products_id FROM orders_products WHERE orders_id=%s AND products_id<1",
                                $this->getId()
                        ));
                        if(xtc_db_num_rows($amzp_query)){
                                $errors[] = TEXT_ORDER_HAS_UNALLOCATED_AMAZON_ITEMS;
                                $this->setAllow_shipping(false);
                        }
                }
        }
        // EOF - AMAZON ALLOCATION
        if($this->getClass_obj()->info['block_shipping'] == 1){
            $errors[] = sprintf('<b>%s:</b> %s',
                    TEXT_VERSANDSPERRE,
                    $this->getClass_obj()->info['block_shipping_comment']
            );
            $this->setAllow_shipping(false);
        }
        foreach($this->get_address_errors() as $err){
            $errors[] = $err;
        }
        if($this->getClass_obj()->info['rueckstand'] == 1){
            $errors[] = TEXT_INTRO_LIST_ARREAR;
            $this->setAllow_shipping(false);
        }
        foreach($this->check_products() as $err){
            $errors[] = $err;
        }
        if(stristr($this->getClass_obj()->info['shipping_class'],'pickup') and $this->getSource() != 'otc'){
            $errors[] = TEXT_ERROR_ABHOLUNG;
            $this->setAllow_shipping(false);
        }
        $this->setErrors($errors);
    }
}

class YESShippingItem_reclamations extends YESShippingItem_base{
    function __construct(array $values = []){
        $this->setId($values['id']);
        $this->setSource($values['source']);
        $this->setClass_obj(new reclamation($this->getId()));
        $this->setEmail( $this->getClass_obj()->customer['email_address']);
        $this->setTelephone( $this->getClass_obj()->customer['telephone']);
        $this->setSource_status_name( xtc_get_reclamations_status_name($this->getClass_obj()->info['reclamations_status']));
        $this->setTotals( self::get_totals_string( $this->getClass_obj()->totals ) );
        $this->setDefault_versender($this->get_default_versender());
        $this->check_errors();
        $this->setSet_versandsperre_link(xtc_href_link('reclamations.php',xtc_get_all_get_params(array('action','rID')).'action=set_block_shipping_confirm&rID='.$this->getId()));
        $this->setUnset_versandsperre_link(xtc_href_link('reclamations.php',xtc_get_all_get_params(array('action','rID','referrer')).'action=set_unblock_shipping&rID='.$this->getId()));
        $this->setPaydate('');
        $this->setTotal_amount(0);
    }
    
    public function check_errors(){
        $this->setAllow_shipping(true);
        $errors = array();
        if($this->getClass_obj()->info['block_shipping'] == 1){
            $status_query = xtc_db_query(sprintf(
                    "SELECT comments FROM reclamations_status_history WHERE reclamations_id='%d' and comments LIKE 'Vom Versand ausgeschlossen:%%' ORDER BY date_added DESC",
                    $this->getId()
            ));
            $block_comment = xtc_db_fetch_array($status_query);
            $errors[] = $block_comment['comments'];
        }
        foreach($this->get_address_errors() as $err){
            $errors[] = $err;
        }
        $this->check_products();
        $this->setErrors($errors);
    }
    public static function get_totals_string( array $totals = []){
        $lines = array();
        foreach($totals as $ot){
            $lines[] = sprintf(
                    '<b>%s</b>&nbsp;%s',
                    $ot['title'],
                    $ot['text']
            );
        }
        return implode('<br />',$lines);
    }
    
    public function get_default_versender(){
        if(sizeOf($this->getClass_obj()->products) == 1){
            $default_shipping = yes_get_products_default_shipper($this->getClass_obj()->products[0]['id']);
        }else{
            $default_shipping = '';
        }
        $selected_versender = (empty($default_shipping)) ? '' : $default_shipping;
        if(SHIPPING_DEFAULT_VERSENDER == '1' && empty($selected_versender)){
                $selected_versender = SHIPPING_DEFAULT_VERSENDER_VALUE;
        }
        $list = \YES4Trade\Model\shipper_profiles::get_list();
        foreach($list as $shipper_profile){
            if($this->getClass_obj()->info['versender_proposal'] == $shipper_profile){
                    $selected_versender = $shipper_profile['profile_name'];
            }
        }
        if(!empty($selected_versender)){
            $shipper_profile = \YES4Trade\Model\shipper_profiles::get_profile($selected_versender);
            $selected_versender = $shipper_profile->versender;
        }
        return $selected_versender;
    }   
}

/**
 * shippings products object
 * 
 * Wenn ein shippings Eintrag vorhanden ist, gehoert dazu nun immer ein oder
 * mehrere shippings_products Eintraege. Diese shipping_products Eintraege
 * entsprechen YESShippingItemSavedProduct
 * 
 */
class YESShippingItemSavedProduct{
    var $masse, $weight, $shippings_products_id,$shippings_id,$products_id,
            $quantity,$source_products_id,$source_product, $ean, $model;
    function getMasse() {
        return $this->masse;
    }

    function getWeight() {
        return $this->weight;
    }

    function setMasse($masse): void {
        $this->masse = $masse;
    }

    function setWeight($weight): void {
        $this->weight = $weight;
    }

    function getShippings_products_id() {
        return $this->shippings_products_id;
    }

    function getShippings_id() {
        return $this->shippings_id;
    }

    function getProducts_id() {
        return $this->products_id;
    }

    function getQuantity() {
        return $this->quantity;
    }

    function getSource_products_id() {
        return $this->source_products_id;
    }

    function setShippings_products_id($shippings_products_id): void {
        $this->shippings_products_id = $shippings_products_id;
    }

    function setShippings_id($shippings_id): void {
        $this->shippings_id = $shippings_id;
    }

    function setProducts_id($products_id): void {
        $this->products_id = $products_id;
    }

    function setQuantity($quantity): void {
        $this->quantity = $quantity;
    }

    function setSource_products_id($source_products_id): void {
        $this->source_products_id = $source_products_id;
    }
    function getSource_product() {
        return $this->source_product;
    }

    function setSource_product($source_product): void {
        $this->source_product = $source_product;
    }

    function getEan() {
        return $this->ean;
    }

    function getModel() {
        return $this->model;
    }

    function setEan($ean): void {
        $this->ean = $ean;
    }

    function setModel($model): void {
        $this->model = $model;
    }

    function __construct( array $params = [] ){
        $this->setShippings_products_id($params['shipping_data']['shippings_products_id']);
        $this->setShippings_id($params['shipping_data']['shippings_id']);
        $this->setProducts_id($params['shipping_data']['products_id']);
        $this->setSource_products_id($params['shipping_data']['source_products_id']);
        $this->setQuantity($params['shipping_data']['quantity']);
        $this->setSource_product($params['source_product']);
        $this->setMasse($this->get_masse()); // BHT 
        $this->setWeight($this->get_weight());
        $this->setModel($params['source_product']['model']);
        $this->setEan(YESShippingItems::get_products_ean($this->getProducts_id()));
    }
    public function get_masse(){
        // MASSE
        $products_masse = xtc_get_products_size($this->getProducts_id());
        if($products_masse['width'] != 0 and $products_masse['height'] != 0 and $products_masse['depth'] != 0){
            return ($this->getQuantity()*$products_masse['width']).'x'.($this->getQuantity()*$products_masse['height']).'x'.($this->getQuantity()*$products_masse['depth']);
        }
        return 0;
    }
    
    public function get_weight(){
        return xtc_get_ext_products_weight($this->getProducts_id())*$this->getQuantity();
    }
    
    
    public static function get_storages( int $products_id ){
        $storages = array();
        $storage_query = xtc_db_query(sprintf(
            "SELECT s.name,sp.storage_places_id,sn.nummer,sp.quantity FROM storage_products sp LEFT JOIN storage_numbers sn USING(storage_id,products_id),storages s WHERE sp.products_id='%d' and sp.storage_id=s.id",
            $products_id
        ));
        while($storage = xtc_db_fetch_array($storage_query)){
            $storages[] = xtc_db_prepare_input($storage);
        }
        foreach($storages as $strk=>$strg){
            if($strg['storage_places_id']>0){
                $storages[$strk]['storage_place'] = yes_get_storage_place_title($strg['storage_places_id']);
            }
        }
        return $storages;
    }
    
    public function get_collies(){
        $pcollies = array();
        $collies = xtc_get_product_collies($this->getProducts_id());
        foreach($collies as $collie){
            $storages = self::get_storages( $collie['collie_products_id'] );
            $pcollies[] = array(
                'ID'=>$collie['collie_products_id'],
                'SLAVE_TITLE'=>  xtc_get_products_slave_title($collie['collie_products_id'],$_SESSION['languages_id']),
                'STORAGES'=>$storages,
                'QTY'=>$collie['quantity'],
                'QTY_PURCHASED'=>$collie['quantity']*$this->getQuantity(),
                'NAME'=>xtc_get_products_name($collie['collie_products_id']),
                'DISTRIBUTOR_NUMBER'=>yes_get_products_distributor_number($collie['collie_products_id'])
            );
        }
        return $pcollies;
    }
    
    public static function get_image( int $products_id, string $dir = 'thumbnail_images'){
        $picture_query = yes_db_query(sprintf(
            "SELECT products_image FROM products WHERE products_id='%d'",
            $products_id
        ),true);
        if(!$picture_query){
            return '';
        }
        $picture = current($picture_query);
        if(!is_file(DIR_FS_CATALOG.'images/product_images/'.$dir.'/'.$picture['products_image'])){
            return '';
        }
        return HTTP_SERVER.'images/product_images/thumbnail_images/'.$picture['products_image'];
    }
}

class YESShippingItems{
    const ITEM_SOURCES = array(
        array('id'=>'','text'=>TEXT_ACTION_ORDERS),
        array('id'=>'reclamations','text'=>TEXT_ACTION_RECLAMATIONS),
        array('id'=>'block_reclamations','text'=>TEXT_ACTION_RECLAMATIONS_BLOCK_SHIPPING),
        array('id'=>'rueckstand','text'=>TEXT_ACTION_RUECKSTAND),
        array('id'=>'block_orders','text'=>TEXT_ACTION_ORDERS_BLOCK_SHIPPING),
        array('id'=>'otc','text'=>TEXT_ACTION_OTC)
    );

    var $source;
    var $items;
    var $id_array;
    var $source_title;
    var $table_definitions;
    var $is_versandabschluss;
    
    function getIs_versandabschluss() {
        return $this->is_versandabschluss;
    }

    private static function get_dompdf_ship_parts_path():string{
        return \main::get_exportdata_path().'DOMPDF_SHIP_PARTS/';
    }

    function setIs_versandabschluss($is_versandabschluss): void {
        $this->is_versandabschluss = $is_versandabschluss;
    }

    function getSource() {
        return $this->source;
    }

    function getItems() {
        return $this->items;
    }

    function getId_array() {
        return $this->id_array;
    }

    function setSource($source): void {
        $this->source = $source;
    }

    function setItems($items): void {
        $this->items = $items;
    }

    function setId_array($id_array): void {
        $this->id_array = $id_array;
    }

    function __construct(array $values = []){
        // versandabschluss modus hat kein source
        if(isset($values['source'])){
            $this->setSource($values['source']);
        }
        $this->setIs_versandabschluss($values['is_versandabschluss']);
        $this->setId_array($values['id_array']);
    }
    
    private static function get_shipping_products(int $id){
        $records = array();
        $query = xtc_db_query(sprintf(
            "SELECT * FROM shippings_products WHERE shippings_id='%d'",
            $id
        ));
        while ($record = xtc_db_fetch_array($query)) {
            $records[] = $record;
        }
        return $records;
    }
    
    public function get_different_shippers_from_items(array $items = []){
        $diff = array();
        foreach($this->get_items() as $item){
            if(!in_array($item->shipping_configuration['versender'], $diff)){
                $diff[] = $item->shipping_configuration['versender'];
            }
        }
        return $diff;
    }
    public static function get_shipping_configuration(int $id){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM shippings WHERE id='%d'",
            $id
        ));
        if(!xtc_db_num_rows($query)){
            throw new Exception('Invalid shippings_id '.$id);
        }
        return xtc_db_fetch_array($query);
    }
    
    public function addItem( $obj, int $id ){
        if($this->getIs_versandabschluss()){
            $products = array();
            $shipping_products = $this->get_shipping_products($id);
            // BEIM VERSANDABSCHLUSS WERDEN NUR DIE ARTIKEL UEBERNOMMEN DIE
            // IN DER TABELLE shippings_products VORHANDEN SIND
            foreach($shipping_products as $shp){
                foreach($obj->get_products() as $p){
                    switch(get_class($obj->class_obj)){
                        case 'order':
                            $key = 'opID';
                            break;
                        case 'reclamation':
                            $key = 'rpID';
                            break;
                    }
                    if($p[$key] == $shp['source_products_id']){
                        $products[] = new YESShippingItemSavedProduct(array_merge([
                            'shipping_data' => $shp,
                            'source_product'=>$p,
                        ],$p));
                    }
                }
            }
            $this->items[] = new YESShippingItem([
                'shipping_products'=>$products,
                'source_obj'=>$obj,
                'shipping_configuration'=>self::get_shipping_configuration($id),
//                'source_product'=>$p,
            ]);
        }else{
            $products = $obj->get_products();
            $this->items[] = new YESShippingItem([
                'product_data'=>$products,
                'source_obj'=>$obj,
                'shipping_configuration'=>array()
            ]);
            /** DER ANSATZ WAR FALSCH. EIN YESSHIPPINGITEM ENTSPRICHT EINER
             * ORDER ODER EINER REKLA
             * 
            foreach($products as $p){
                $this->items[] = new YESShippingItem([
                    'product_data'=>$p,
                    'source_obj'=>$obj,
                    'shipping_configuration'=>array()
                ]);
            }*/
        }
    }
    
    public static function getYESShippingItemInstanceFromShippings_id(int $id){
        $query = xtc_db_query(sprintf(
            "SELECT orders_id, reclamations_id FROM shippings WHERE id='%d'",
            $id
        ));
        if(!xtc_db_num_rows($query)){
            throw new Exception('Unknown shippings_id '.$id);
        }
        $record = xtc_db_fetch_array($query);
        if($record['reclamations_id']>0){
                return new YESShippingItem_reclamations([
                    'id'=>$record['reclamations_id'],
                    'source'=>'reclamations'
                ]);
        }
        return new YESShippingItem_orders([
            'id'=>$record['orders_id'],
            'source'=>'orders',
        ]);
    }
    
    public static function getYESShippingItemInstanceNameFromSource($source){
        switch($source){
            case 'orders':
            case 'orders_arreal':
            case 'block_orders':
            case 'rueckstand';
            case 'otc':
                return "YESShippingItem_orders";
            case 'reclamations':
            case 'block_reclamations':
                return "YESShippingItem_reclamations";
        }
    }
    
    /**
     * Array aller orders/reclas
     * 
     * Im Gegensatz zu get_items() wird hier ein Array zurueckgegeben, dass nicht
     * nach Artikeln gruppiert ist
     * 
     * @return array
     */
    public function get_source_objects(){
        $array = array();
        foreach($this->getId_array() as $id){
            $array[] = array(
                'YESShippingItem'=>self::getYESShippingItemInstanceFromShippings_id($id),
                'id'=>$id,
                'products'=>$this->get_shipping_products($id)
            );
        }
        return $array;
    }
    
    public function get_items(){
        $this->items = array();
        foreach($this->getId_array() as $id){
            if($this->getIs_versandabschluss()){
                $obj = self::getYESShippingItemInstanceFromShippings_id($id);
            }else{
                $objName = self::getYESShippingItemInstanceNameFromSource($this->getSource());
                $obj = new $objName([
                    'id'=>$id,
                    'source'=>$this->getSource(),
                ]);
            }
            $this->addItem($obj,$id);
        }
        return $this->getItems();
    }
    
    public function count_source_objects(array $items = []){
        $diff_objects = [];
        foreach($items as $i){
            $diff_objects[ $i->source_obj->class_obj->info['id'] ] = true;
        }
        return sizeOf($diff_objects);
    }
    
    public function get_heading_title( $anzahl_im_versand = [] ){
        if(isset($_POST['scanner_mode']) and isset($_POST['barcode'])){
            switch($_POST['scanner_mode']){
                case 'ean':
                    $mode = SCANNER_MODE_HEADING_TITLE;
                    break;
                case 'model':
                    $mode = SCANNER_MODE_PRODUCTS_MODEL_HEADING_TITLE;
                    break;
                case 'orders':
                    $mode = SCANNER_MODE_ORDERS_HEADING_TITLE;
                    break;
                case 'items':
                    $mode = SCANNER_MODE_SHIPPING_ITEMS_HEADING_TITLE;
                    break;
            }
            return sprintf('%s %s: %s&nbsp;<a title="Scanner Mode beenden" href="shipping.php"><img src="images/icons/cross.gif" /></a>',
                    BUTTON_SCANNER_MODE,
                    $mode,
                    $_POST['barcode']
            );
        }
        if(!$this->getIs_versandabschluss()){
            if(isset($_POST['scanner_mode']) and isset($_POST['barcode'])){
                switch($_POST['scanner_mode']){
                    case 'ean':
                        $mode = SCANNER_MODE_HEADING_TITLE;
                        break;
                    case 'model':
                        $mode = SCANNER_MODE_PRODUCTS_MODEL_HEADING_TITLE;
                        break;
                    case 'orders':
                        $mode = SCANNER_MODE_ORDERS_HEADING_TITLE;
                        break;
                }
                return sprintf('%s %s: %s&nbsp;<a title="Scanner Mode beenden" href="shipping.php"><img src="images/icons/cross.gif" /></a>',
                        BUTTON_SCANNER_MODE,
                        $mode,
                        $_POST['barcode']
                );
            }
            return sprintf('%s / <a style="color: blue;" href="%s">%s (%d)</a>',
                get_source_title_string($this->getSource(),false),
                xtc_href_link('shipping.php','versandabschluss=1'),
                HEADING_TITLE_WRITE, sizeOf($anzahl_im_versand)
            );
        }
        return sprintf('<a style="color: blue;" href="%s">%s</a> / %s',
                    xtc_href_link('shipping.php'),
                    TEXT_PRE_SHIPPING,
                    HEADING_TITLE_WRITE
        );
    }
    
    
    /**
     * Artikel im Versandabschluss
     * 
     * Gibt ein Array aller verschiedenen enthaltenen Artikel wieder.
     * array(
     *  [products_id]=>quantity,
     *  ...
     * )
     * 
     * @param string $shipper gespeicherter Versender zb "DHL"
     * @return array
     */
    public function versandabschluss_get_different_products( $display_mode = '' ){
        $products = array();
        foreach($this->get_items() as $item){
            if(is_array($item->products_to_ship) and sizeOf($item->products_to_ship)){
                // BEREITS IM VERSANDABSCHLUSS
                foreach($item->products_to_ship as $pts){
                    $pID = $pts->getProducts_id();
                    $collies = xtc_get_product_collies($pID);
                    $is_stklistenartikel = (sizeOf($collies)) ? true : false;
                    if($is_stklistenartikel){
                        foreach($collies as $colli){
                            $cpID = $colli['collie_products_id'];
                            if(!isset($products[ $cpID ])){
                                $products[$cpID] = new paketliste_pdf_product($cpID);
                            }
                            $products[ $cpID ]->add_quantity( $pts->getQuantity()*$colli['quantity'] );
                            $storage_data = $products[$cpID]->get_default_storage_data();
                            $products[ $cpID ]->setStorages_array($storage_data);
                        }
                    }
                    if(!isset($products[ $pID ])){
                        $products[$pID] = new paketliste_pdf_product($pID, $is_stklistenartikel);
                        $storage_data = $products[$pID]->get_default_storage_data();
                        $products[ $pID ]->setStorages_array($storage_data);
                    }
                    $products[ $pID ]->add_quantity( $pts->getQuantity() );
                }
            }else{
                // VOR VERSANDABSCHLUSS IST item EIN EINTRAG AUS orders_products
                $pID = $item->product_data['id'];
                $collies = xtc_get_product_collies($pID);
                $is_stklistenartikel = (sizeOf($collies)) ? true : false;
                if($is_stklistenartikel){
                    foreach($collies as $colli){
                        $cpID = $colli['collie_products_id'];
                        if(!isset($products[ $cpID ])){
                            $products[$cpID] = new paketliste_pdf_product($cpID);
                        }
                        $products[ $cpID ]->add_quantity( $item->product_data['qty']*$colli['quantity'] );
                        $storage_data = $products[$cpID]->get_default_storage_data();
                        $products[ $cpID ]->setStorages_array($storage_data);
                    }
                }
                if(!isset($products[ $pID ])){
                    $products[$pID] = new paketliste_pdf_product($pID, $is_stklistenartikel);
                    $storage_data = $products[$pID]->get_default_storage_data();
                    $products[ $pID ]->setStorages_array($storage_data);
                }
                $products[ $pID ]->add_quantity( $item->product_data['qty']*$colli['quantity'] );
            }
        }
        return self::group_products($products,$display_mode);
    }
    
    private static function get_paketliste_csv_file_name(string $versender='', bool $pre_write_mode=true) {
	$crypt_name = yes_get_sha1_from_string( 'vom_'.date('d_m_Y')."-".date('H_i_s') );
        if($pre_write_mode){
            return 'VORAB_PRODUKTLISTE.csv';
        }
	if($versender != '') {
		return 'PAKETLISTE-'.$versender.'_'.$crypt_name.".csv";
	}
	return 'KOMPLETTPAKETLISTE_'.$crypt_name.".csv";
}


    /**
     * Im Versandabschluss wird einmal eine Komplettpaketliste erzeugt und an-
     * schliessend noch jeweils eine fuer jeden Versender. Mit schreiben des
     * jeweiligen Versenders wird das Flag csv_status auf 1 gesetzt.
     * 
     * @param bool $pre_write_mode
     * @param string $versender
     * @return string CSV Filename
     */
    public function versandabschluss_paketliste_csv(bool $pre_write_mode = false, string $versender = ''){
	    $crypt_dir = yes_get_sha1_from_string( date('Y-m-d') );
	    $path = \main::get_exportdata_path().$crypt_dir;
	    if(!is_dir($path)){
		    mkdir($path);
		    //chmod($path,0777);
	    }
	    $filename = $path.'/'.self::get_paketliste_csv_file_name($versender, $pre_write_mode);
	
	    $fh = fopen($filename,'a+') or die("Kann ".$filename." nicht anlegen.");
	    fclose($fh);
	    $csv = new CSVfile($filename);
	    $csv->open("w");
	
	    $csv->addRow([
            CSV_EXPORT_COL_VERSENDER,
            CSV_EXPORT_COL_NUM_PACKAGES,
            CSV_EXPORT_COL_DATE,
            CSV_EXPORT_COL_RECIPIENT_COMPANY,
            CSV_EXPORT_COL_RECIPIENT_NAME,
            CSV_EXPORT_COL_RECIPIENT_STREET,
            CSV_EXPORT_COL_RECIPIENT_SUBURB,
            CSV_EXPORT_COL_RECIPIENT_POSTCODE_CITY,
            CSV_EXPORT_COL_RECIPIENT_COUNTRY,
            // CSV_EXPORT_COL_AMOUNT, // KEINE AHNUNG
            CSV_EXPORT_COL_PRODUCTS,
            CSV_EXPORT_COL_ORDER_TOTAL,
            CSV_EXPORT_COL_WEIGHT
        ]);
        foreach($this->get_source_objects() as $sh){
            $shconf = $this->get_shipping_configuration($sh['id']);
            if($versender != '' and $shconf['versender'] != $versender){
                continue;
            }
            $products = array();
            foreach($sh['products'] as $product){
                $name = 'unknown';
                foreach($sh['YESShippingItem']->class_obj->products as $op){
                    $idkey = ($sh['YESShippingItem']->source == 'orders')?'opID':'rpID';
                    if($op[$idkey] == $product['source_products_id']){
                        $name = $op['name'];
                    }
                }
                $products[] = $product['quantity'] . ' x ' . $name;
            }
            $csv->addRow([
                $shconf['versender'],
                $shconf['packages'],
                $sh['YESShippingItem']->paydate,
                $shconf['company'],
                $shconf['name1'],
                $shconf['street1'],
                $shconf['street2'],
                $shconf['postcode'].' '.$shconf['city'],
                $shconf['country_name'],
                implode(', ',$products),
                $sh['YESShippingItem']->total_amount,
                ($shconf['weight']/10)
            ]);
            if(!$pre_write_mode and $versender != ''){ // csv geschrieben status setzen
                xtc_db_query(sprintf(
                    "UPDATE shippings SET csv_status='1' WHERE id='%d'",
                    $shconf['id']
                ));
            }
	} // end foreach shippings
	$csv->close();
    $click_path_parts = explode('/exportdata/',$filename);
	return $click_path_parts[1];
    }
    
    /** WIE WIRD VERFAHREN BEI MEHREREN LAGERPLAETZEN DES GLEICHEN ARTIKELS
     *  PRO LAGER ... UND WAS IST WENN 3 STK BENOETIGT WERDEN UND ES MEHRERE
     *  LAGERPLAETZE MIT AUSREICHEND BESTAND GIBT?
     */
    private static function group_products_by_storage($products){
        $storages = array(
            'no_storage'=>array(
                'products'=>array(),
                'name'=>TEXT_NO_STORAGE_ALLOCATED
            )
        );
        foreach($products as $product){
            $needed_qty_for_pID = $product->qty;
            
            $product_has_storage_places = false;
            foreach($product->storages_array as $storage){
                if(isset($storage['places']) and sizeOf($storage['places'])){
                    $product_has_storage_places = true;
                }
            }
            $products_meta_query = xtc_db_query(sprintf(
                "SELECT products_ean, products_model FROM %s WHERE products_id='%d'",
                TABLE_PRODUCTS,$product->products_id
            ));
            $products_meta = xtc_db_fetch_array($products_meta_query);
            if(!$product_has_storage_places){
                unset($product->storages_array);
                $storages['no_storage']['products'][] = array(
                    'products_id'=>$product->products_id,
                    'ean'=>$products_meta['products_ean'],
                    'model'=>$products_meta['products_model'],
                    'qty'=>$product->qty,
                    'image'=>$product->image,
                );
                continue;
            }
            
            $storage_place_quantity_collected = 0;
            foreach($product->storages_array as $storage){
                if(!isset($storages[ $storage ['storage_id'] ] )){
                    $storages[ $storage['storage_id'] ] = array(
                        'name'=> xtc_get_storage_name($storage['storage_id']),
                        'products'=>array()
                    );
                }
                $places = array();
                foreach($storage['places'] as $stplace){
                    if($needed_qty_for_pID > $storage_place_quantity_collected){
                        $places[] = $stplace;
                        $storage_place_quantity_collected += $stplace['product_place_quantity'];
                    }
                }
                $storages[ $storage['storage_id'] ]['products'][] = array(
                    'products_id'=>$product->products_id,
                    'ean'=>$products_meta['products_ean'],
                    'model'=>$products_meta['products_model'],
                    'qty'=>$product->qty,
                    'image'=>$product->image,
                    'places'=>$places,
                    'is_colli'=>$storage['is_colli']
                );
                // ABBRUCH WENN LAGERPLATZBESTAND KLEINER IST ALS DIE GEFORDERTE
                // MENGE - DA LAGERPLAETZE ABER EINE PRIORISIERUNG HABEN, WERDEN
                // DIE HALT NACHEINANDER WEGGEBUCHT
                if($needed_qty_for_pID <= $storage_place_quantity_collected){
                    break;
                }
                
            }
            // ALLE ZUGEWIESENEN LAGER DURCHLAUFEN, ES KANN ABER VORKOMMEN
            // DASS BESTAND FEHLT, DER NICHT ZUGEWIESEN IST, ALSO OHNE
            // LAGERPLATZ
            // WENN $product_has_storage_places DEN WERT false HAT, WURDE WEITER
            // OBEN BEREITS EIN DUMMY EINTRAG IN no_storage VORGENOMMEN
            if($product_has_storage_places and $needed_qty_for_pID > $storage_place_quantity_collected){
                $storages['no_storage']['products'][] = array(
                    'products_id'=>$product->products_id,
                    'ean'=>$products_meta['products_ean'],
                    'model'=>$products_meta['products_model'],
                    'qty'=>$product->qty,
                    'image'=>$product->image,
                );
            }
        }
        return $storages;
    }
    
    private static function group_products( $products, $display_mode=''){
        switch($display_mode){
            case 'storages':
                return self::group_products_by_storage($products);
            default:
                return $products;
        }
    }

    /**
     * Informationen zu PDF SHIP PARTS
     * 
     * Liest das dompdf ship parts Verzeichnis aus und ermittelt
     * das Alter der neuesten Datei in Sekunden sowie die Information ob Files
     * vorhanden sind
     * 
     * @param basics $basics
     * @return array('youngest_file_seconds'=>int,'pdf_files_in_queue'=>bool)
     *
     */
    private static function get_shipping_parts_file_info( basics $basics ){
        $files = $basics->get_directory_content(self::get_dompdf_ship_parts_path() );
        $youngest_file_seconds = 0;
        $pdf_files_in_queue = false;
        foreach($files as $file){
            if( substr($file,strlen($file)-3, strlen($file)) != 'pdf'){
                continue;
            }
            $pdf_files_in_queue = true;
            $file_date = filemtime(self::get_dompdf_ship_parts_path().$file);
            $diff = time()-$file_date;
            if($youngest_file_seconds == 0){
                $youngest_file_seconds = $diff;
            }else{
                $youngest_file_seconds = ($diff < $youngest_file_seconds) ? $diff : $youngest_file_seconds;
            }
        }
        return array(
            'youngest_file_seconds'=>$youngest_file_seconds,
            'pdf_files_in_queue'=>$pdf_files_in_queue
        );
    }
    
    /**
     * Beim Versandabschluss zuerst pruefen ob noch unverarbeitete PDFs im 
     * queue sind
     * 
     * @param type $step
     * @return type
     */
    public function check_step($step){
        switch($step){
            case 1:
                $basics = new basics;
                if(!is_object($basics)){
                    die('error: basics not initialized');
                }
                $info = self::get_shipping_parts_file_info($basics);
                return array(
                    'youngest_file_seconds'=>$info['youngest_file_seconds'],
                    'success'=>!$info['pdf_files_in_queue']
                );
        }
    }
    
    public function check_for_storno($item){
        $message = '';
        $success = true;
        $delete = false;
        // REKLAMATIONEN EGAL
        if($item->source_obj->source != 'orders'){
            return array(
                'success'=>$success,
                'message'=>$message,
                'delete'=>$delete
            );
        }
        if($item->source_obj->class_obj->info['orders_status'] == ORDERS_STATUS_STORNIERT){
            $success = false;
            $delete = true;
            $message = sprintf(MSG_AUTOREMOVE_STORNO_ORDER_FROM_SHIPPING,$item->source_obj->getId());
        }
        return array(
            'success'=>$success,
            'message'=>$message,
            'delete'=>$delete
        );
    }
    
    public function get_packagelist(&$messages, bool $group_by_shipper = false){
        $packagelist = array();
        foreach($this->get_items() as $item){
            $storno_check = $this->check_for_storno($item);
            if($storno_check['success']){
                if($group_by_shipper){
                    if(!isset($packagelist[ $item->shipping_configuration['versender'] ])){
                        $packagelist[ $item->shipping_configuration['versender'] ] = array();
                    }
                    $packagelist[ $item->shipping_configuration['versender'] ][] = $item;
                }else{
                    $packagelist[] = $item;
                }
            }
            if($storno_check['delete']){
                $yes_shipping = new yes_shipping($item->getId());
                $yes_shipping->delete();
            }
            if($storno_check['message'] != ''){
                $messages[] = $storno_check['message'];
            }
        }
        return $packagelist;
    }
    
    
    
    public function get_pager_html( int $total, int $page = 1){
        $max_items_per_page = MAX_DISPLAY_SEARCH_RESULTS_ADMIN;
        $text = '';
        if($page > 0){
            $text .= sprintf('<a class="pager" href="%s">&laquo;</a> &nbsp;',
                    xtc_href_link('shipping.php',xtc_get_all_get_params(array('page')).'page='.($page-1))
            );
        }
        $to = ($page * $max_items_per_page) + $max_items_per_page;
        if($to > $total){
            $to = $total;
        }
        $text .= sprintf('<span class="pager">%d - %d von insgesamt %d</span>',
                $page * $max_items_per_page,
                $to,
                $total
        );
        if($page < ($total / $max_items_per_page)){
            $text .= sprintf(' &nbsp;<a class="pager" href="%s">&raquo;</a>',
                    xtc_href_link('shipping.php',xtc_get_all_get_params(array('page')).'page='.($page+1))
            );
        }
        return $text;
    }
    
    public static function get_products_ean( int $products_id ){
        if($products_id < 1){
            return '';
        }
        $query = xtc_db_query(sprintf(
            "SELECT products_ean FROM %s WHERE products_id='%d'",
            TABLE_PRODUCTS,$products_id
        ));
        if(!xtc_db_num_rows($query)){
            throw new Exception('get_products_ean() with invalid pID: '.$products_id);
        }
        $record = xtc_db_fetch_array($query);
        return $record['products_ean'];
    }
    
    private static function get_barcode( int $orders_id ){
        if(BARCODE_PACKINGSLIP_ACTIVE != 'True'){
            return '';
        }
        if(!is_file(\main::get_exportdata_path().'BARCODE_'.$orders_id.'.png')){
            return \main::get_exportdata_path().'BARCODE_'.xtc_generate_packingslip_barcode($orders_id,\main::get_exportdata_path());
        }
        return \main::get_exportdata_path().'BARCODE_'.$orders_id.'.png';
    }
    
    // BUGFIX Mario 01/2024 - vorher ohne $shipping
    public function get_paydate( YESShippingItem $shipping ){
        $paydate = '';
        if(get_class($shipping->source_obj->class_obj) != 'order'){
            return $paydate;
        }
        if($shipping->source_obj->class_obj->info['date_payment'] > 0) {
            $paydate = '<b>'.TEXT_DATE_EXPENSED.':</b>&nbsp;';
            if(isset($_GET['action']) and $_GET['action'] == 'lagerliste_raw'){ // NUR BEI DRUCKANSICHT, NICHT BEI PDF
                $paydate = sprintf('<font size=1>%s</font>',xtc_date_short($shipping->source_obj->class_obj->info['date_payment']));
            }else{
                $paydate = xtc_date_short($shipping->source_obj->class_obj->info['date_payment']);
            }
            return $paydate;
        }
   
        if(xtc_is_shipping_before_payment($shipping->source_obj->class_obj->info['payment_method'])){
            if($shipping->source_obj->class_obj->info['payment_method'] == 'invoice'){
                $paydate = '&nbsp;<b>'.TEXT_PAYMENT_METHOD.':</b> '.$shipping->source_obj->class_obj->info['payment_method'];
                if(isset($_GET['action']) and $_GET['action'] == 'lagerliste_raw'){ // NUR BEI DRUCKANSICHT, NICHT BEI PDF
                    return sprintf('<font color="red">%s</font>',$paydate);
                }
            }
            return '&nbsp;'.TEXT_PAYMENT_METHOD.': '.$shipping->source_obj->class_obj->info['payment_method'];
        }
        $paydate_query = xtc_db_query("SELECT date_added FROM orders_status_history WHERE orders_id='".$shipping->source_obj->class_obj->info['id']."' && orders_status_id='".ORDERS_STATUS_BEZAHLT."'");
        $paydate_res = xtc_db_fetch_array($paydate_query);
        if(isset($_GET['action']) and $_GET['action'] == 'lagerliste_raw'){ // NUR BEI DRUCKANSICHT, NICHT BEI PDF
            return '<b>'.TEXT_DATE_EXPENSED.':</b> <font size=1>'.xtc_date_short($paydate_res['date_added'])."</font>";
        }
        return '<b>'.TEXT_DATE_EXPENSED.':</b> '.xtc_date_short($paydate_res['date_added']);
    }
    
    // BUGFIX Mario 01/2024 - vorher ohne $shipping
    public function get_payment_orders( YESShippingItem $shipping ){
        $payment_orders = array();
        if(get_class($shipping->source_obj->class_obj) != 'order'){
            return $payment_orders;
        }
        $payment_query = xtc_db_query(sprintf(
            "SELECT ip.buchungstag,ip.betrag FROM incoming_payments ip, payment_orders po WHERE ip.id=po.payment_id and po.orders_id='%d'",
            $shipping->source_obj->getId()
        ));
        while($payment = xtc_db_fetch_array($payment_query)) {
            $payment_orders[] = $payment;
        }
        return $payment_orders;
    }
    
    public function yes_get_shipping_lagerliste_html( string $action, yesSmarty $smarty ){
        $SQ_ARRAY = array(); // STORAGEQUANTITY ALS ARRAY UM PERFORMANCE ZU SPAREN
        $smarty->assign('DATE',date('d.m.Y H:i:s'));
        foreach($this->get_items() as $shipping){
            $barcode = '';
            $products = array();
            if(get_class($shipping->source_obj->class_obj) == 'order'){
                $barcode = self::get_barcode( $shipping->source_obj->getId() );
            }
            // BUGFIX Mario 01/2024 - vorher ohne $shipping
            $payment_orders = $this->get_payment_orders( $shipping );
            
            $real_weight = 0;
            foreach($shipping->getProducts_to_ship() as $YESShippingItemSavedProduct){
                $collies = $YESShippingItemSavedProduct->get_collies();
                if(sizeOf($collies)>0){
                    $name = sprintf('<b>[C]</b>&nbsp;%s',$YESShippingItemSavedProduct->source_product['name']);
                }else{
                    $name = $YESShippingItemSavedProduct->source_product['name'];
                }
                $storages = YESShippingItemSavedProduct::get_storages( $YESShippingItemSavedProduct->getProducts_id() );
                $thumbnail_image = YESShippingItemSavedProduct::get_image($YESShippingItemSavedProduct->getProducts_id(), 'thumbnail_images');
                $pweight = xtc_get_ext_products_weight($YESShippingItemSavedProduct->getProducts_id());
                $real_weight += $pweight * $YESShippingItemSavedProduct->getQuantity();
                if(!isset($SQ_ARRAY[$YESShippingItemSavedProduct->getProducts_id()])){
                    $SQ_ARRAY[$YESShippingItemSavedProduct->getProducts_id()] = new products_quantity($YESShippingItemSavedProduct->getProducts_id());
                }
                $products[] = array(
                        'PRODUCTS_ID'=>$YESShippingItemSavedProduct->getProducts_id(),
                        'PHYSICAL_QTY'=>$SQ_ARRAY[$YESShippingItemSavedProduct->getProducts_id()]->get_gesamtbestand_qty(),
                        'SLAVE_TITLE'=> xtc_get_products_slave_title($YESShippingItemSavedProduct->getProducts_id(),$_SESSION['languages_id']),
                        'WEIGHT'=>  $pweight,
                        'TOTAL_WEIGHT'=>  $pweight*$YESShippingItemSavedProduct->getQuantity(),
                        'STORAGES'=>$storages,
                        'MODEL'=>$YESShippingItemSavedProduct->getModel(),
                        'EAN'=>$YESShippingItemSavedProduct->getEan(),
                        'QTY'=>$YESShippingItemSavedProduct->getQuantity(),
                        'NAME'=>$name,
                        'collis'=>$collies,
                        'COLLINUM'=>sizeOf($collies),
                        //'FINAL_PRICE'=>$product['final_price'],
                        'THUMBNAIL_IMAGE'=>$thumbnail_image,
                        'DISTRIBUTOR_NUMBER'=>yes_get_products_distributor_number($YESShippingItemSavedProduct->getProducts_id()),
                        'DISTRIBUTOR_NUMBER_COMMENTS'=>yes_get_products_distributor_comment($YESShippingItemSavedProduct->getProducts_id()),
                );
            }
            // BUGFIX Mario 01/2024 - vorher ohne $shipping
            $paydate = $this->get_paydate($shipping);
            if(get_class($shipping->source_obj->class_obj)=='order'){
                $orders_id = '<b>'.$shipping->source_obj->class_obj->info['id']. '</b><br />';
                $class_obj_id_key = 'OID';
            }else{
                $orders_id = '<b>R'.$shipping->source_obj->class_obj->info['id']. '</b><br />';
                $class_obj_id_key = 'RID';
            }
            if(isset($shipping->source_obj->class_obj->info['ebay_id']) and $shipping->source_obj->class_obj->info['ebay_id'] != ''){
                $orders_id = sprintf('%s (<b>%s</b>)<br />',
                    $orders_id, 
                    $shipping->source_obj->class_obj->info['ebay_id']
                );
            }
            $ebay_plus = (isset($shipping->source_obj->class_obj->info['ebay_plus'])) ? $shipping->source_obj->class_obj->info['ebay_plus'] : 0;
            if($action == 'lagerliste_raw'){ // NUR BEI DRUCKANSICHT, NICHT BEI PDF
                $orders_id = sprintf('<font size="2">%s</font>',$orders_id);
            }
            $order_totals = $shipping->source_obj->class_obj->totals;
            $shipping_comments = $shipping->source_obj->class_obj->info['shipping_comments'];
            $packages = $shipping->shipping_configuration['packages'];
            if(WEIGHT_ACTIVE){
                $packages .= '<br />('.($shipping->shipping_configuration['weight']/10).' kg)';
            }
            $name = $shipping->shipping_configuration['name1'].( ($shipping->shipping_configuration['name2'] != '') ? '<br />'.$shipping->shipping_configuration['name2'] : '');
            if($shipping->shipping_configuration['company'] != ''){
                    $name = $shipping->shipping_configuration['company'].'<br />'.$name;
            }
            $shipping_array[] = array(
                'VERSENDER'=>$shipping->shipping_configuration['versender'],
                'PACKAGES'=>$packages,
                $class_obj_id_key=>$orders_id.$paydate,
                'PAYMENTS'=>$payment_orders,
                'COMMENTS'=>$shipping->shipping_configuration['comments'],
                'COMPANY'=>$shipping->shipping_configuration['company'],
                'NAME'=>$name,
                'STREET'=>$shipping->shipping_configuration['street1'],
                'SUBURB'=>$shipping->shipping_configuration['street2'],
                'CITY'=>$shipping->shipping_configuration['postcode'].' '.$shipping->shipping_configuration['city'],
                'COUNTRY'=>$shipping->shipping_configuration['country_name'],
                'BETRAG'=>((isset($shipping->shipping_configuration['betrag']))?number_format(($shipping->shipping_configuration['betrag']/100),2,',',''):''),
                'products'=>$products,
                'TOTAL'=>$order_totals,
                'WEIGHT'=>($shipping->shipping_configuration['weight']/10),
                'REAL_WEIGHT'=>$real_weight,
                'UNITS'=>$products,
                'BARCODE_SRC'=>$barcode,
                'SHIPPING_COMMENTS'=>$shipping_comments,
                'EBAY_PLUS'=>$ebay_plus
            );
        } // end foreach this->get_items()
        $smarty->assign('shippings',$shipping_array);
        if($action == 'lagerliste_raw'){ // NUR BEI DRUCKANSICHT, NICHT BEI PDF
                $main_content= $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/shippings_raw.html');
        }else{
                $main_content= $smarty->fetch(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/shippings_raw_pdf.html');
        }
        return $main_content;
    }        
}


class YESShippingItem {
    var $product_data;
    var $source_obj;
    var $source;
    var $id; //opID oder rpID
    //var $in_shipping_quantity; // in product
    var $source_title;
    //var $masse; // BHT in product
    //var $weight; // in product
    //var $ean; // in product
    var $table_definitions;
    var $shipping_configuration;
    var $products_to_ship;
    var $calculated_shipping_weight;
    
    function getShipping_configuration() {
        return $this->shipping_configuration;
    }

    function setShipping_configuration($shipping_configuration): void {
        $this->shipping_configuration = $shipping_configuration;
    }

    function getTable_definitions() {
        return $this->table_definitions;
    }

    function setTable_definitions($table_definitions): void {
        $this->table_definitions = $table_definitions;
    }
    
    function getSource_obj() {
        return $this->source_obj;
    }

    function setSource_obj($source_obj): void {
        $this->source_obj = $source_obj;
    }

    function getProduct_data() {
        return $this->product_data;
    }

    function setProduct_data($product_data): void {
        $this->product_data = $product_data;
    }
    
    function getId() {
        return $this->id;
    }

    function setId($id): void {
        $this->id = $id;
    }
    

    function getSource_title() {
        return $this->source_title;
    }

    function setSource_title($source_title): void {
        $this->source_title = $source_title;
    }

    function getSource() {
        return $this->source;
    }

    function setSource($source): void {
        $this->source = $source;
    }

    function getCalculated_shipping_weight() {
        return $this->calculated_shipping_weight;
    }

    function setCalculated_shipping_weight($calculated_shipping_weight): void {
        $this->calculated_shipping_weight = $calculated_shipping_weight;
    }

    /*
    function getIn_shipping_quantity() {
        return $this->in_shipping_quantity;
    }

    function setIn_shipping_quantity($in_shipping_quantity): void {
        $this->in_shipping_quantity = $in_shipping_quantity;
    }
    function getMasse() {
        return $this->masse;
    }

    function setMasse($masse): void {
        $this->masse = $masse;
    }
    
    function getWeight() {
        return $this->weight;
    }

    function setWeight($weight): void {
        $this->weight = $weight;
    }
    function getEan() {
        return $this->ean;
    }

    function setEan($ean): void {
        $this->ean = $ean;
    }
     * 
     */
    
    function getProducts_to_ship() {
        return $this->products_to_ship;
    }

    function setProducts_to_ship($products_to_ship): void {
        $this->products_to_ship = $products_to_ship;
    }
    
    public function get_calculated_shipping_weight( bool $is_versandabschluss = false ){
        $total_weight = 0;
        if($is_versandabschluss){
            foreach($this->getProducts_to_ship() as $product){
                $total_weight += ($product->quantity*xtc_get_ext_products_weight($product->products_id));
            }
        }else{
            $source_products_id_key = get_class($this->source_obj->class_obj) == 'order' ? 'opID':'rpID';
            foreach($this->source_obj->class_obj->products as $product){
                $weight_qty = $product['qty']-$product['quantity_shipped']-$this->get_in_shipping_from_db($product[$source_products_id_key]);
                if($weight_qty < 1){
                    continue;
                }
                $total_weight += ($weight_qty*xtc_get_ext_products_weight($product['id']));
            }
        }
        return number_format($total_weight,4,'.','');
    }

    function __construct( array $data = []){
        $this->setSource_obj($data['source_obj']);
        $this->setSource($data['source_obj']->source);
        $this->setTable_definitions( yes_shipping::get_source_sql_table_definitions($this->getSource()));
        $this->setShipping_configuration($data['shipping_configuration']);
        $this->setSource_title(get_source_title_string($this->getSource(),true));
        
        if(isset($data['shipping_products'])){
            // wenn versandabschluss werden die enthaltenen Artikel als array
            // gespeichert
            $this->setProducts_to_ship($data['shipping_products']);
            $this->setCalculated_shipping_weight($this->get_calculated_shipping_weight( (isset($data['shipping_products']) ) ));
            $this->setId($data['shipping_configuration']['id']);
        }else{
            $this->setCalculated_shipping_weight($this->get_calculated_shipping_weight( (isset($data['shipping_products']) ) ));
            // wenn kein versandabschluss wird jeder eintrag aus order_products
            // bzw reclamations_products als neues item gezaehlt
            foreach($data['product_data'] as $k=>$pd){
                $data['product_data'][$k]['ean'] = YESShippingItems::get_products_ean($pd['id']);
                $source_products_id = (in_array($data['source_obj']->source,['orders','block_orders','rueckstand','otc'])) ? $pd['opID'] : $pd['rpID'];
                $data['product_data'][$k]['in_shipping_quantity'] = $this->get_in_shipping_from_db((int)$source_products_id);
                $data['product_data'][$k]['masse'] = $this->get_masse($pd['id'], $pd['qty']);
                $data['product_data'][$k]['weight'] = $this->get_weight($pd['id'], $pd['qty']);
                
                // V1 EINFUEGEN
                $SQ = new products_quantity( $pd['id'] );
                $data['product_data'][$k]['V1'] = $SQ->get_available1_qty();
                
                // BOF - branches Ticket 1747
                $query = xtc_db_query(sprintf(
                        "SELECT SUM(products_quantity) as anz FROM branches_products WHERE products_id='%d'",
                        $pd['id']
                ));
                $record = xtc_db_fetch_array($query);
                $branches_total_qty = (int)$record['anz'];
                // EOF - branches Ticket 1747
                
                $data['product_data'][$k]['branches_total_qty'] = $branches_total_qty;
            }

            $this->setProduct_data($data['product_data']);
            $this->setId( sprintf('%s_%d', 
                $data['source_obj']->source,
                $data['source_obj']->id
            ));
        }

    }
    public function get_masse( int $products_id, int $quantity = 1){
        // MASSE
        $products_masse = xtc_get_products_size($products_id);
        if($products_masse['width'] != 0 and $products_masse['height'] != 0 and $products_masse['depth'] != 0){
            return ($quantity*$products_masse['width']).'x'.($quantity*$products_masse['height']).'x'.($quantity*$products_masse['depth']);
        }
    }
    
    public function get_weight(int $products_id, int $qty = 1){
        return xtc_get_ext_products_weight($products_id)*$qty;
    }

    
    public function get_in_shipping_from_db( int $source_products_id ){
        $query = xtc_db_query(sprintf(
                "SELECT SUM(sp.quantity) as anz FROM shippings s LEFT JOIN shippings_products sp ON s.id=sp.shippings_id WHERE sp.source_products_id='%d' AND s.status=0",
                $source_products_id
        ));
        if(!xtc_db_num_rows($query)){
            return 0;
        }
        $record = xtc_db_fetch_array($query);
        return $record['anz'];
    }
    
    /*
     * BESTELLUNG ALS VERSENDET MARKIEREN, BESTAENDE BUCHEN
     * 
     * ES WIRD products_to_ship DURCHLAUFEN UND ZU DEN EINZELNEN ORDER PRODUCT 
     * EINTRAEGEN WERDEN BESTAENDE GEBUCHT
     */
    public function versandabschluss_update_class_obj(string $versender,&$messages){
        global $AmazonHelper; // in der shipping_action_ajax.php
        $op_shipped_status = true;
        // BOF - TEILLIEFERUNG HANDLING
        if(get_class($this->source_obj->class_obj) == 'order'){
            $source_products_table_index_field = 'orders_id';
            $source_products_table = 'orders_products';
            $source_products_field = 'orders_products_id';
        }else{
            $source_products_table_index_field = 'reclamations_id';
            $source_products_table = 'reclamations_products';
            $source_products_field = 'reclamations_products_id';
        }
        foreach ($this->products_to_ship as $pts) {
            $SQ = new products_quantity($pts->products_id);
            $qty_total = $SQ->get_products_total_qty();
            $new_qty = $pts->quantity;
            if(get_class($this->source_obj->class_obj) == 'order'){
                $comment = sprintf(HISTORY_ORDER_SEND,$this->source_obj->class_obj->info['id'],$new_qty);
            }else{
                if($this->source_obj->class_obj->info['reclamations_type'] == 3){
                    $comment = sprintf(HISTORY_RECLAMATION_SEND,$this->source_obj->class_obj->info['id'],$new_qty);
                }else{
                    $comment = sprintf(HISTORY_SEND_NO_QTY_CHANGE_RECLAMATION,
                        $new_qty,
                        $this->source_obj->class_obj->info['id'],
                    );
                }
            }
            $part_delivery = false;
            if($pts->quantity <> $pts->source_product['qty']){
                $comment .= ' '.TEXT_PART_DELIVERY;
                $part_delivery = true;
            }
            
            // IM ALTEN SHIPPING WURDEN NOCH COLLIES ERMITTELT UND DURCHLAUFEN, 
            // ABER DAS IST JA SCHON LANGE IN DER BESTANDSKLASSE INTEGRIERT
            if(isset($this->source_obj->class_obj->info['reclamations_type']) and $this->source_obj->class_obj->info['reclamations_type'] != 3){
                $pd_str = ($part_delivery) ? ' '.TEXT_PART_DELIVERY: '';
                yes_add_products_history($pts->products_id, 
                    sprintf(HISTORY_SEND_NO_QTY_CHANGE_RECLAMATION,
                        $new_qty,
                        $this->source_obj->class_obj->info['id']
                    ).$pd_str
                );
                
                // BOF - HISTORIENEINTRAG IN REKLA 2022/04
                $rec_status = $this->source_obj->class_obj->info['reclamations_status'];
                $current_product = '';
                foreach( $this->source_obj->class_obj->products as $rp){
                    if($rp['rpID'] == $pts->source_products_id){
                        $current_product = $rp['name'];
                    }
                }
                $rec_products_name = ' [pID '.$pts->products_id.'] '.$current_product;
                $this->source_obj->class_obj->add_history(
                    $rec_status,
                    false,
                    $comment.$rec_products_name
                );
                // EOF - HISTORIENEINTRAG IN REKLA 2022/04
            }else{
                $SQ->update_qty(-$new_qty, $SQ->get_default_storage_id(), $qty_total,$comment,
                    get_class($this->source_obj->class_obj), // order/reclamation
                    $this->source_obj->class_obj->info['id'],'Versand',
                    $pts->shippings_products_id
                );
                // BOF - HISTORIENEINTRAG IN SOURCE OBJ 2022/04
                if(isset($this->source_obj->class_obj->info['reclamations_status'])){
                    $src_obj_status = $this->source_obj->class_obj->info['reclamations_status'];
                    $prod_key = 'rpID';
                }else{
                    $src_obj_status = $this->source_obj->class_obj->info['orders_status'];
                    $prod_key = 'opID';
                }
                $current_product = '';
                foreach( $this->source_obj->class_obj->products as $rp){
                    if($rp[$prod_key] == $pts->source_products_id){
                        $current_product = $rp['name'];
                    }
                }
                $src_products_name = ' [pID '.$pts->products_id.'] '.$current_product;
                $this->source_obj->class_obj->add_history(
                    $src_obj_status,
                    false,
                    $comment.$src_products_name
                );
                // EOF - HISTORIENEINTRAG IN SOURCE OBJ 2022/04
            }
            
            // BOF - TEILLIEFERUNG HANDLING
            if(get_class($this->source_obj->class_obj) == 'order'){
                xtc_db_query(sprintf(
                        "UPDATE %s SET not_ship=0 WHERE %s='%d'",
                        $source_products_table,$source_products_field,
                        $pts->source_products_id
                ));
            }
            
            // orders_products quantity_shipped=quantity_shipped+%d
            $this->source_obj->class_obj->add_quantity_shipped(
                $pts->source_products_id,
                $new_qty
            );
            // DAS HIER IST FALSCH. ES MUESSEN ALLE ARTIKEL DES AUFTRAGS
            // DURCHLAUFEN WERDEN. DAS PASSIERT JETZT NACH DIESER FOREACH SCHLEIFE
            //if( $pts->source_product['qty'] <> ($pts->source_product['quantity_shipped'] + $new_qty) ){
            //    $op_shipped_status = false;
            //}
            
            // EOF - TEILLIEFERUNG HANDLING
            
            // LIBRI HANDLING AUS order->process_shipping_orders_product
            // NICHT UEBERNOMMEN

        }
        if( NO_SHIPPING_EMAIL == 0){
        // EOF - AMAZON WIEDER VOLLSTAENDIG INTEGRIEREN - TICKET 2173 - 07/2016
            $email_send_status = 1;
        }
        
        
        // ERMITTELN OB TEILLIEFERUNG VORLIEGT BZW OB ALLE ARTIKEL DES AUFTRAGS
        // VERSENDET WURDEN
        $query = xtc_db_query(sprintf(
                "SELECT products_quantity-quantity_shipped AS restmenge FROM %s WHERE %s='%d'",
                $source_products_table, $source_products_table_index_field,
                $this->source_obj->class_obj->info['id']
        ));
        while($record = xtc_db_fetch_array($query)){
            if($record['restmenge']>0){
                $op_shipped_status = false;
            }
        }
        
        
        if(get_class($this->source_obj->class_obj) == 'order'){
            if($op_shipped_status){
                // ZUSAETZLICH SCHAUEN WIR OB ES MEHRERE shippings EINTRAEGE GIBT
                // FUER DEN AUFTRAG
                
                // 2023/03 also das fuehrt dazu, das Teillieferungen nie den Status
                // abgeschlossen erhalten. Also raus.
                //$op_shipped_status = !$this->source_obj->class_obj->has_part_delivery();
            }

            // BOF - EBAY ADDON - COMPLETE SALE SENDEN
            // WIR SETZEN EIN FLAG UM DIE COMPLETE-SALE MELDUNGEN
            // ABARBEITEN ZU KOENNEN
            // DIE COMPLETSALE-MELDUNGEN WERDEN JA VOM SELLER MANUELL INITIIERT
            // IN DER shipping.php MUSS DAS NOCH ENTSPRECHEND ANGEPASST WERDEN
            $auctions = $this->source_obj->class_obj->get_auction_array(true); // incl orders_id
            for($ai=0;$ai<sizeOf($auctions);$ai++){
                $update_sql_array = array(
                        'shipped'=>1
                );
                xtc_db_perform('ebay_transactions',$update_sql_array,'update',sprintf(
                        "orders_id='%d' and ebayid='%s'",
                        $auctions[$ai]['orders_id'],
                        $auctions[$ai]['ebay_id']
                ));
            }
            // EOF - EBAY ADDON - COMPLETE SALE SENDEN
            // 
            // AUFTRAG AUF NEUEN STATUS SETZEN, ABHAENGIG DAVON OB ALLE ARTIKEL
            // VERSENDET SIND UND WELCHE BEZAHLART
            $sconf = $this->getShipping_configuration();
            $this->source_obj->class_obj->set_shipping_orders_status($op_shipped_status,array(
                'versender'=>$versender,
                'shipping_id'=>$sconf['id']
            ));
            
            $order = new order($this->source_obj->getId());
            $xtPrice = new xtcPrice($order->info['currency'],$order->info['status']);
            if(defined('MODULE_OTHER_FIBUNUMBERS_STATUS') && MODULE_OTHER_FIBUNUMBERS_STATUS == 'True' && MODULE_OTHER_FIBUNUMBERS_AUTOMATIC == 'True'){
                $number = $order->get_fibunumber();
                if(empty($number) or strlen($number)==1){
                    $number = $order->add_fibunumber();
                    $comments = sprintf(HISTORY_ORDER_FIBUNUMBER,$number);
                    $order->add_history($order->info['orders_status'], false, $comments);
                }
            }
            // MARGE BERECHNEN
            if($op_shipped_status){
                if(defined('PAY_MODULE_MARGE') and PAY_MODULE_MARGE == 'True'){
                    $order->save_marge();
                }
            }
            //
            // AMAZON ADDON - AMAZON MELDEN, DASS DIE ARTIKEL VERSENDET WURDEN
            //
            if($order->has_amazon_items()){
                $order->process_shipping_amazon($versender,$AmazonHelper,$sconf['id']);
            }
            
            $customer = new customer( $order->customer['ID'] );
            $customer->update_current_account_value();

            // BOF - AMAZON WIEDER VOLLSTAENDIG INTEGRIEREN - TICKET 2173 - 07/2016
            //if( NO_SHIPPING_EMAIL == 0 && !$order->has_amazon_items() and !stristr($row['email'],'marketplace.amazon')){
        }else{
            $comments = sprintf(HISTORY_RECLAMATION_SHIPPED_SENDER,$versender);
            $recla_abgeschlossen = true;
            switch($this->source_obj->class_obj->info['reclamations_type']){
                case 3:
                case 4:
                    foreach($this->source_obj->class_obj->rueckerstattungen as $rueck){
                        if( in_array($rueck['status'],array(1,4))){
                            $recla_abgeschlossen = false;
                        }
                    }
                    if($recla_abgeschlossen){
                        $ret_query = xtc_db_query(sprintf(
                                "SELECT retoure_id FROM retouren WHERE reclamations_id='%s' AND retoure_status IN(%s)",
                                $this->source_obj->class_obj->info['id'],implode(',',array(1,2))
                        ));
                        if(xtc_db_num_rows($ret_query)){
                            $recla_abgeschlossen = false;
                        }
                    }
                    break;
            }
            if($recla_abgeschlossen && $op_shipped_status){
                $recla_status = 3;
                xtc_db_query(sprintf(
                        "UPDATE reclamations SET send_status='2', last_modified=now() WHERE reclamations_id='%d'",
                        $this->source_obj->class_obj->info['id']
                ));
                xtc_db_query(sprintf(
                    "UPDATE reclamations SET reclamations_status='%s' WHERE reclamations_id='%s'",
                    $recla_status,$this->source_obj->class_obj->info['id']
                ));
            }else{
                xtc_db_query(sprintf(
                        "UPDATE reclamations SET last_modified=now() WHERE reclamations_id='%d'",
                        $this->source_obj->class_obj->info['id']
                ));
                $recla_status = $this->source_obj->class_obj->info['reclamations_status'];
            }
            $this->source_obj->class_obj->add_history($recla_status, false, $comments);
        }
    }
    
    /**
     * Es ist moeglich Shipping-Tracking-Nummern schon vor Versandabschluss zu
     * Auftrag oder Reklamation zu hinterlegen. Dazu speichere ich -wenn kein
     * shippings Datensatz existiert- die Daten in der Tabelle 
     * shippings_tracking_numbers_temp
     * 
     * Mit dieser Funktion, werden die temporaeren Trackingnummern in die 
     * Tabelle shippings_tracking_numbers uebertragen und anschliessend aus der
     * _temp Tabelle geloescht
     * 
     * @throws exception when called without a saved instance
     */
    public function convert_temp_tracking_number_to_shipment(){
        if(get_class($this->source_obj->class_obj) == 'reclamation'){
                $type = 'reclamation';
		$field = 'reclamations_id';
		$table = 'reclamations';
		$class_status_id = 'reclamations_status';
        }else{
                $type = 'order';
		$field = 'orders_id';
		$table = 'orders';
		$class_status_id = 'orders_status';
	}
        
        $query = xtc_db_query(sprintf(
                "SELECT * FROM shippings_tracking_numbers_temp WHERE target_type='%s' and target_type_id='%d'",
                $type,
                $this->source_obj->class_obj->info['id']
        ));
        if(xtc_db_num_rows($query)){
            while($record = xtc_db_fetch_array($query)){
                $insert_sql_array = array(
                    'tracking_number'=>$record['transaction_id'],
                    'shippings_id'=>$this->shipping_configuration['id'],
                    'date_added'=>'now()'
                );
                xtc_db_perform('shippings_tracking_numbers',$insert_sql_array);
                xtc_db_query(sprintf(
                        "DELETE FROM shippings_tracking_numbers_temp WHERE shippings_tracking_numbers_temp_id='%d'",
                        $record['shippings_tracking_numbers_temp_id']
                ));
            }
        }
    }
}
