<?php
namespace YES4Trade\Model;

class groups_characteristic_set extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'products_characteristic_set';
    const TABLE_INDEX = 'products_characteristic_set_id';
    var $description;
    private static $propertyTypes = [
        'products_characteristic_set_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_characteristic_set_id'
        ],
        'products_characteristic_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_characteristic_id'
        ],
        'sort_order' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sort_order'
        ],
        'description' => [
            'type' => 'YES4Trade\Model\groups_characteristic_set_description',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'description'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }

    public function create(){
        $data = $this->toArray();
        unset($data['description']);
        yes_db_perform(self::TABLE_NAME, $data);
        \YES4Trade\Model\group_handler::clear_cache();
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        unset($data['description']);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
        \YES4Trade\Model\group_handler::clear_cache();
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
        $desc = \YES4Trade\Model\groups_characteristic_set_description::get_by_characteristic_set_id( $index );
        foreach($desc as $c){
            \YES4Trade\Model\groups_characteristic_set_description::delete( $c->products_characteristic_set_description_id );
        }
        
        $products_allocation = \YES4Trade\Model\groups_characteristic_set_products_allocation::get_by_characteristic_set_id( $index );
        foreach($products_allocation as $c){
            \YES4Trade\Model\groups_characteristic_set_products_allocation::delete( $c->products_to_characteristics_id );
        }
        \YES4Trade\Model\group_handler::clear_cache();
    }
    
    public static function get_by_characteristic_id( int $characteristic_id, int $language_id = -1 ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE products_characteristic_id=:id ORDER BY sort_order",
                self::TABLE_NAME
            ),['id'=>$characteristic_id]
        );
        foreach($query as $record){
            foreach($record as $k=>$v){
                $record[$k] = (int)$v;
            }
            $item = new \YES4Trade\Model\groups_characteristic_set($record);
            if($language_id > -1){
                $item->description = \YES4Trade\Model\groups_characteristic_set_description::get_by_characteristic_set_id($item->products_characteristic_set_id, $language_id);
            }
            $items[] = $item;
        }
        return $items;
    }
    
    public static function get_by_characteristic_set_id( int $index ){
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE %s=:id ORDER BY sort_order",
                self::TABLE_NAME, 
                self::TABLE_INDEX
            ),['id'=>$index]
        );
        if(!sizeOf($query)){
            return false;
        }
        $record = current($query);
        foreach($record as $k=>$v){
            $record[$k] = (int)$v;
        }
        return new \YES4Trade\Model\groups_characteristic_set($record);
    }
    
    public function get_descriptionData( int $language_id ){
        return \YES4Trade\Model\groups_characteristic_set_description::get_by_characteristic_set_id( $this->products_characteristic_set_id, $language_id );
    }
    
}