<?php
namespace YES4Trade\Model;
class ebay_products_regulatory_hazmats extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'ebay_products_regulatory_hazmats';
    const TABLE_INDEX = 'ebay_products_regulatory_hazmats_id';
    private static $propertyTypes = [
        'ebay_products_regulatory_hazmats_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_regulatory_hazmats_id'
        ],
        'ebay_products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_id'
        ],
        'signalword' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'signalword'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
        'statements' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'statements'
        ],
        'pictograms' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'pictograms'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
	public static function convertInt( array $data ){
		foreach(get_class_vars(__CLASS__) as $pk=>$pv){
		   if($pk == 'propertyTypes'){
		   	foreach($pv as $kpart => $part){
			   if($part['type'] == 'integer' and isset($data[$kpart])){
			       $data[$kpart] = (int)$data[$kpart];
			   }
		   	}
		   }
		}
		return $data;
	}
    
    public function create(){
        $data = $this->toArray();
        $data = self::convertInt($data);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $data = self::convertInt($data);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_ebay_products_id( int $ebay_products_id ){
        $items = [];
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE ebay_products_id='%d' ORDER BY date_added",
            self::TABLE_NAME, $ebay_products_id
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
            $record = self::convertInt($record);
            return new \YES4Trade\Model\ebay_products_regulatory_hazmats($record);
        }
        return null;
    }
    
    public static function delete_by_ebay_products_id(int $ebay_products_id ){
        xtc_db_query(sprintf(
            "DELETE FROM %s WHERE ebay_products_id='%d'",
            self::TABLE_NAME, $ebay_products_id
        ));
    }
}