<?php
namespace YES4Trade\Model;
class ebay_order_reservation{
    var $reservationId, $ebay_seller, $customers_id;
    public function __construct( string $ebay_seller, string $reservationId ){
        if(!defined('EBAY_ORDER_RESERVATION_ORDERS_ID') or intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')) < 1){
            return false;
        }
        $this->reservationId = $reservationId;
        $this->customers_id = self::get_customers_id();
        $this->ebay_seller = $ebay_seller;
        return true;
    }

    public function getReservationId():string{
        return $this->reservationId;
    }

    public function getCustomers_id():int{
        return $this->customers_id;
    }

    public function getEbay_seller():string{
        return $this->ebay_seller;
    }

    public function exists( int $products_id ):bool{
        if(!defined('EBAY_ORDER_RESERVATION_ORDERS_ID') or intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')) < 1){
            return false;
        }
        $query = yes_query(sprintf(
            "SELECT orders_products_id FROM %s WHERE orders_id=:id AND products_name=:pname AND products_id=:pid",
                TABLE_ORDERS_PRODUCTS
            ),[
                'id'=>intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')),
                'pid'=>$products_id,
                'pname'=>$this->getProductsName()
            ],true
        );
        return ($query === false) ? false : true;
    }

    private function getProductsName():string{
        return sprintf('%s:%s',
            $this->getEbay_seller(),
            $this->getReservationId()
        );
    }
    private static function get_customers_id():int{
        $query = yes_query(sprintf(
            "SELECT customers_id FROM %s WHERE orders_id=:id",
                TABLE_ORDERS
            ),['id'=>intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID'))],
            true
        );
        if($query === false){
            throw new \Exception(sprintf(
                'yes order EBAY_ORDER_RESERVATION_ORDERS_ID (%d) doesnt exists.',
                intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID'))
            ));
        }
        return intval($query['customers_id']);
    }

    private static function getProductsModel(int $products_id):string{
        $query = yes_query(sprintf(
            "SELECT products_model FROM %s WHERE products_id=:id",
                TABLE_PRODUCTS
            ),[
                'id'=>$products_id,
            ],true
        );
        return ($query === false) ? '' : $query['products_model'];
    }

    public function get(int $products_id ):array{
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE orders_id=:id AND products_id=:pid AND products_name=:pname",
                TABLE_ORDERS_PRODUCTS
            ),[
                'id'=>intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')),
                'pid'=>$products_id,
                'pname'=>$this->getProductsName(),
            ],
            true
        );
        if($query === false or $query === null){
            throw new \Exception('failed to get ebay_order_reservation pID '.$products_id.' item '.$this->getProductsName());
        }
        return $query;
    }

    public function update(int $orders_products_id, int $quantity):void{
        yes_db_perform(TABLE_ORDERS_PRODUCTS,[
            'products_quantity'=>$quantity
        ],'update',['orders_products_id'=>$orders_products_id]);
    }

    public function add(int $products_id, int $quantity ):void{
        if(!defined('EBAY_ORDER_RESERVATION_ORDERS_ID') or intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')) < 1){
            
        }else{
            $insert_sql_array = [
                'products_id'=>$products_id,
                'orders_id'=>intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')),
                'products_model'=>self::getProductsModel($products_id),
                'products_name'=>$this->getProductsName(),
                'products_price'=>0,
                'final_price'=>0,
                'products_quantity'=>$quantity,
                'date_added'=>date('Y-m-d H:i:s'),
            ];
            try{
                yes_db_perform(TABLE_ORDERS_PRODUCTS, $insert_sql_array);
            }catch(Exception $e){
                throw new \Exception('Cant add product to ebay_order_reservation');
            }
        }
    }

    public function delete():void{
        if(!defined('EBAY_ORDER_RESERVATION_ORDERS_ID') or intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')) < 1){
            
        }else{
            yes_query(sprintf(
                "DELETE FROM %s WHERE orders_id=:id AND products_name=:pname",
                    TABLE_ORDERS_PRODUCTS,
                ),[
                    'pname'=>$this->getProductsName(),
                    'id'=>intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID'))
                ]
            );
        }
    }

    public static function count():int{
        if(!self::isInstalled()){
            return 0;
        }
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE orders_id=:id",
                TABLE_ORDERS_PRODUCTS
            ),[
                'id'=>intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')),
            ]
        );
        if($query === false or $query === null or !is_countable($query)){
            return 0;
        }
        return sizeOf($query);
    }

    public static function isInstalled():bool{
        return defined('EBAY_ORDER_RESERVATION_ORDERS_ID');
    }

    public static function install(int $configuration_value):void{
        global $InstanceCache;
        if(self::isInstalled()){
            throw new \Exception(self::class.': The module is installed already.');
        }
        $query = yes_query(sprintf(
            "SELECT configuration_value FROM %s WHERE configuration_key='EBAY_ORDER_RESERVATION_ORDERS_ID'",
                TABLE_CONFIGURATION
            )
        );
        if(!sizeOf($query)){
            yes_db_perform(TABLE_CONFIGURATION,[
                'configuration_key'=>'EBAY_ORDER_RESERVATION_ORDERS_ID',
	            'configuration_value'=>$configuration_value,
                'configuration_group_id'=>101,
                'sort_order'=>100,
                'date_added'=>date('Y-m-d H:i:s')
            ]);
            $InstanceCache->deleteItem('configuration');
        }else{
            throw new \Exception(self::class.': The module is installed already.');
        }
    }

    public static function get_items(string $seller = ''):array{
        if(!defined('EBAY_ORDER_RESERVATION_ORDERS_ID') or intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')) < 1){
            return [];
        }
        $parameters = [
            'id'=>intval(constant('EBAY_ORDER_RESERVATION_ORDERS_ID')),
        ];
        $add = '';
        if(!empty($seller)){
            $parameters['seller'] = $seller.':%';
            $add .= 'AND products_name LIKE :seller';
        }
        $query = yes_query(sprintf(
            "SELECT * FROM %s WHERE orders_id=:id %s",
                TABLE_ORDERS_PRODUCTS, $add
            ),$parameters
        );
        return (is_countable($query))?$query:[];
    }
}

