<?php
namespace YES4Trade\Model;
class ebay_media_documents extends \YES4Trade\Model\BaseType{
    const TABLE_NAME = 'ebay_media_documents';
    const TABLE_INDEX = 'ebay_media_documents_id';
    private static $propertyTypes = [
        'ebay_media_documents_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_media_documents_id'
        ],
        'documents_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'documents_id'
        ],
        'documentStatus' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'documentStatus'
        ],
        'documentType' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'documentType'
        ],
        'documentType_title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'documentType_title'
        ],
        'seller' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'seller'
        ],
        'fileName' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'fileName'
        ],
        'fileSize' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'fileSize'
        ],
        'fileType' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'fileType'
        ],
    ];
    
    public function __construct( array $values = [] ){
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);

        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }

        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }

        $this->setValues(__CLASS__, $childValues);
    }
    
	private static function convertInt( array $data ){
		foreach(get_class_vars(__CLASS__) as $pk=>$pv){
		   if($pk == 'propertyTypes'){
		   	foreach($pv as $kpart => $part){
			   if($part['type'] == 'integer' and isset($data[$kpart])){
			       $data[$kpart] = (int)$data[$kpart];
			   }
		   	}
		   }
		}
		return $data;
	}
	
    public function create(){
        $data = $this->toArray();
        unset($data['documentType_title']);
        $data = self::convertInt($data);
        xtc_db_perform(self::TABLE_NAME, $data);
        return xtc_db_insert_id();
    }
    
    public function update(){
        $data = $this->toArray();
        unset($data['documentType_title']);
        unset($data[self::TABLE_INDEX]);
        $data = self::convertInt($data);
        $index = self::TABLE_INDEX;
        xtc_db_perform(self::TABLE_NAME, $data,'update',self::TABLE_INDEX."='".$this->$index."'");
    }
    
    public static function delete( int $index ){
        xtc_db_query(sprintf(
                "DELETE FROM %s WHERE %s='%d'",
                self::TABLE_NAME,self::TABLE_INDEX, $index
        ));
    }
    
    public static function get_by_documents_id( string $documents_id, string $seller ){
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE documents_id='%s' AND seller='%s'",
            self::TABLE_NAME, $documents_id, $seller
        ));
        if(xtc_db_num_rows($query)){
            $record = xtc_db_fetch_array($query);
	    $record = self::convertInt($record);
            $record['documentType_title'] = \eBayMediaApi::get_documentType_name($record['documentType']);
            return new \YES4Trade\Model\ebay_media_documents($record);
        }
        return null;
    }
    
    public static function get_by_seller( string $seller ){
        $items = [];
        $query = xtc_db_query(sprintf(
            "SELECT * FROM %s WHERE seller='%s'",
            self::TABLE_NAME, $seller
        ));
        while($record = xtc_db_fetch_array($query)){
 	    $record = self::convertInt($record);
            $record['documentType_title'] = \eBayMediaApi::get_documentType_name($record['documentType']);
            $items[] = new \YES4Trade\Model\ebay_media_documents($record);
        }
        return $items;
    }
    
}
