<?php

namespace YES4Trade\Model;

class ebay_auctions_price_revise_auctions extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_auctions_price_revise_auctions';
    const TABLE_INDEX = 'ebay_auctions_price_revise_auctions_id';

    private static $propertyTypes = [
        'ebay_auctions_price_revise_auctions_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_auctions_price_revise_auctions_id'
        ],
        'ebay_auctions_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_auctions_id'
        ],
        'date_added' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'date_added'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'is_special' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'is_special'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}

	public function update_by_products_id() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
        $pID = $data['products_id'];
        unset($data['products_id']);
		yes_db_perform(self::TABLE_NAME, $data,'update',['products_id'=>$pID]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_ebay_auctions_price_revise_auctions_id(int $ebay_auctions_price_revise_auctions_id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$ebay_auctions_price_revise_auctions_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

    public static function get_by_products_id(int $products_id, array $select_fields = []){
        $items = [];
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE products_id=:id",
				$select_field_string,self::TABLE_NAME
			),['id'=>$products_id]
		);
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    
    /**
     * delete all entries with specific ebay_auctions_id
     * no return
     * @param int $ebay_auctions_id
     * 
     * @return none
     */
    public static function delete_by_ebay_auctions_id( int $ebay_auctions_id ){
        yes_query(sprintf(
            "DELETE FROM %s WHERE ebay_auctions_id=:id",
            self::TABLE_NAME
        ),['id'=>$ebay_auctions_id]);
    }

    public static function delete_by_products_id(int $products_id ){
        yes_query(sprintf(
            "DELETE FROM %s WHERE products_id=:id",
            self::TABLE_NAME
        ),['id'=>$products_id]);
    }

    /**
     * wrapper funktion zum einfuegen
     * gibt die insert_id zurueck
     * @param array $data
     * 
     * @return [type]
     */
    public static function create_ebay_auctions_price_revise_auctions(array $data){
        $new = new self($data);
        return $new->create();
    }
}
