<?php

namespace YES4Trade\Model;

class ebay_auctions extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'ebay_auctions';
    const TABLE_INDEX = 'id';

    private static $propertyTypes = [
        'id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'id'
        ],
        'ebay_products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_products_id'
        ],
        'ebay_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_id'
        ],
        'products_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'products_id'
        ],
        'start_time' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'start_time'
        ],
        'end_time' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'end_time'
        ],
        'type' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'type'
        ],
        'auctionprice' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'auctionprice'
        ],
        'buyitnowprice' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'buyitnowprice'
        ],
        'gallery' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'gallery'
        ],
        'galleryfeatured' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'galleryfeatured'
        ],
        'galleryfeaturedduration' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'galleryfeaturedduration'
        ],
        'featured' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'featured'
        ],
        'highlight' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'highlight'
        ],
        'boldtitle' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'boldtitle'
        ],
        'border' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'border'
        ],
        'auction_fees' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'auction_fees'
        ],
        'title' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'title'
        ],
        'counter' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'counter'
        ],
        'subtitletext' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'subtitletext'
        ],
        'description' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'description'
        ],
        'picture' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'picture'
        ],
        'category' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'category'
        ],
        'category2' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'category2'
        ],
        'duration' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'duration'
        ],
        'quantity' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'quantity'
        ],
        'current_auctionprice' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'current_auctionprice'
        ],
        'quantity_sold' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'quantity_sold'
        ],
        'relist_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'relist_id'
        ],
        'cronstart' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'cronstart'
        ],
        'status' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'status'
        ],
        'shopcat' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'shopcat'
        ],
        'vat' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'vat'
        ],
        'geldzurueck' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'geldzurueck'
        ],
        'sofortneu' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sofortneu'
        ],
        'new' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'new'
        ],
        'relist' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'relist'
        ],
        'not_valid' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'not_valid'
        ],
        'is_automatic' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'is_automatic'
        ],
        'homepagefeatured' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'homepagefeatured'
        ],
        'bestoffer' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'bestoffer'
        ],
        'bestoffer_price' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'bestoffer_price'
        ],
        'is_personal_offer' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'is_personal_offer'
        ],
        'select_set' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'select_set'
        ],
        'site' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'site'
        ],
        'shopcat2' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'shopcat2'
        ],
        'paymentinstructions' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'paymentinstructions'
        ],
        'gallery_plus' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'gallery_plus'
        ],
        'country' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'country'
        ],
        'location' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'location'
        ],
        'user' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'user'
        ],
        'BidCount' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'BidCount'
        ],
        'UUID' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'UUID'
        ],
        'select_set_multiple' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'select_set_multiple'
        ],
        'skype_enabled' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'skype_enabled'
        ],
        'skype_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'skype_id'
        ],
        'skype_contact_option' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'skype_contact_option'
        ],
        'bestofferautoacceptprice' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'bestofferautoacceptprice'
        ],
        'revise' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'revise'
        ],
        'revise_option' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'revise_option'
        ],
        'revise_counter' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'revise_counter'
        ],
        'external_product_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'external_product_id'
        ],
        'external_product_id_type' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'external_product_id_type'
        ],
        'postalcode' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'postalcode'
        ],
        'locked' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'locked'
        ],
        'dispatchtimemax' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'dispatchtimemax'
        ],
        'automatic_list_no_sell' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'automatic_list_no_sell'
        ],
        'itemcondition' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'itemcondition'
        ],
        'sku' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'sku'
        ],
        'ShippingDiscountProfileID' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ShippingDiscountProfileID'
        ],
        'InternationalShippingDiscountProfileID' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'InternationalShippingDiscountProfileID'
        ],
        'reserveprice' => [
            'type' => 'double',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'reserveprice'
        ],
        'returnswithincode' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'returnswithincode'
        ],
        'shippingcostpaidby' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'shippingcostpaidby'
        ],
        'ean' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ean'
        ],
        'isbn' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'isbn'
        ],
        'ebay_plus' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ebay_plus'
        ],
        'seller_profile_payment_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'seller_profile_payment_id'
        ],
        'seller_profile_return_policy_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'seller_profile_return_policy_id'
        ],
        'seller_profile_shipping_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'seller_profile_shipping_id'
        ],
        'ProductReferenceID' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'ProductReferenceID'
        ],
        'scheduletime' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'scheduletime'
        ],
    ];


	public function __construct(array $values = []) {
		list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
		parent::__construct($parentValues);
		if (!array_key_exists(__CLASS__, self::$properties)) {
			self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
		}
		if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
			self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
		}
		$this->setValues(__CLASS__, $childValues);
	}


	public function create() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		yes_db_perform(self::TABLE_NAME, $data);
		return xtc_db_insert_id();
	}


	public function update() {
		$data = self::convert_values( $this->toArray(),self::$propertyTypes );
		unset($data[self::TABLE_INDEX]);
		$index = self::TABLE_INDEX;
		yes_db_perform(self::TABLE_NAME, $data,'update',[$index=>$this->$index]);
	}


	public static function delete(int $index) {
		yes_query(sprintf(
			"DELETE FROM %s WHERE %s=:id",
				self::TABLE_NAME,self::TABLE_INDEX
			),['id'=>$index]
		);
	}


	public static function get_by_id(int $id, array $select_fields = []) {
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE %s=:id",
				$select_field_string,self::TABLE_NAME, self::TABLE_INDEX
			),['id'=>$id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
	}

    public static function get_by_ebay_id( string $ebay_id, array $select_fields = [] ){
		$select_field_string = '*';
		if(sizeOf($select_fields)){
			$select_field_string = implode(',',$select_fields);
		}
		$query = yes_query(sprintf(
			"SELECT %s FROM %s WHERE ebay_id=:ebay_id",
				$select_field_string,self::TABLE_NAME
			),['ebay_id'=>$ebay_id]
		);
		if(!sizeOf($query)){
			return null;
		}
		$record = current($query);
		return new self(self::convert_values($record,self::$propertyTypes));
    }

    /**
     * wrapper funktion zum einfuegen
     * @param array $data
     * 
     * @return int insert_id
     */
    public static function create_ebay_auction(array $data){
        $new = new self($data);
        return $new->create();
    }

    /**
     * wrapper funktion zum aktualisieren
     * @param array $data
     * 
     * @return none
     */
    public static function update_ebay_auction(array $data){
        $upd = new self($data);
        $upd->update();
    }


    /**
     * zaehlt in wieviel laufenden ebay_auctions eine ebay_products_id vorhanden ist
     * 
     * @param int $ebay_products_id
     * 
     * @return int anzahl laufender auktionen
     */
    public static function count_running_auctions_for_ebay_products_id( int $ebay_products_id ){
        $query = yes_query(sprintf(
            "SELECT COUNT(ea.id) as anz FROM %s ea WHERE ea.ebay_products_id=:id AND ea.status IN(0,1)",
                self::TABLE_NAME
            ),['id'=>$ebay_products_id],
            true
        );
        return intval($query['anz']);
    }

    /**
     * ist eine ebay id in YES als laufende Auktion (status 0) gefuehrt?
     * 
     * @param string $ebay_id
     * 
     * @return bool
     */
    public static function is_ebay_id_active(string $ebay_id){
        $query = yes_query(sprintf(
            "SELECT count(ea.id) as total FROM %s ea WHERE ebay_id=:ebay_id AND ea.status=0",
                self::TABLE_NAME
            ),['ebay_id'=>$ebay_id],
            true
        );
        return ($query['total'] > 0) ? true : false;
    }

    /**
     * liefert ein type=>qty Array aller laufenden Auktionen eines Artikels
     * beruecksichtigt keine varianten
     * 
     * @param int $products_id
     * 
     * @return [type]
     */
    public static function get_auction_types_and_quantity_by_products_id(int $products_id ){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT ea.type,ea.quantity FROM %s ea WHERE ea.products_id=:products_id and ea.status=0",
                self::TABLE_NAME
            ),['products_id'=>$products_id]
        );
        $results = [];
        foreach($query as $record){
            if(!isset($results[ $record['type'] ])){
                $results[ $record['type'] ] = 0;
            }
            $results[ $record['type'] ] += $record['quantity'];
        }
        foreach($results as $t => $qty){
            $items[] = array(
                'type'=>$t,
                'qty'=>$qty
            );
        }
        return $items;
    }

    /**
     * SELECT SUM(quantity) AS anz [...] where ea.products_id=:id AND ea.status=0
     * @param int $products_id
     * 
     * @return int
     */
    public static function calc_running_auctions_quantity_for_products_id( int $products_id ){
        $query = yes_query(sprintf(
            "SELECT SUM(quantity) AS anz FROM %s ea WHERE ea.products_id=:id AND ea.status=0",
                self::TABLE_NAME
            ),['id'=>$products_id],
            true
        );
        return intval($query['anz']);
    }

    public static function get_runnings_by_products_id(int $products_id, array $select_fields = [], array $order_by = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $order_by_string = '';
        if(sizeOf($order_by)){
            $order_by_string = " ORDER BY ".implode(',',$order_by);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s ea WHERE ea.products_id=:id AND ea.status=0 %s",
                $select_field_string,self::TABLE_NAME,
                $order_by_string
            ),['id'=>$products_id]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    /**
     * get all items with status=2 and end_time < -days
     * days wird negiert beim verarbeiten, also 100 bedeutet minus 100 Tage
     * 
     * @param int $days
     * @param array $select_fields
     * 
     * @return array
     */
    public static function get_abondened(int $days, array $select_fields = [], int $limit = 50000){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }

        $auctions_abonded_date_obj = new \DateTime(-$days.' Days');
        $auctions_abonded_date = $auctions_abonded_date_obj->format('Y-m-d 00:00:00');
        $query = yes_query(sprintf(
            "SELECT %s FROM %s ea WHERE ea.status=2 AND end_time<:end_time LIMIT %d",
                $select_field_string,self::TABLE_NAME,$limit
            ),['end_time'=>$auctions_abonded_date]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    /**
     * liefert alle ebay_auctions.ebay_id eintraege die nicht leer sind
     * bisher nur in cron_mailfilter
     * 
     * @return array (objects)
     */
    public static function get_all_ebay_id(){
        $items = [];
        $query = yes_query(sprintf(
            "SELECT ebay_id FROM %s WHERE ebay_id!=''",
            self::TABLE_NAME,
        ));
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;


    }

    /**
     * @param string $ebay_id
     * @param string $user
     * @param array $select_fields
     * 
     * @return object or null
     */
    public static function get_by_ebay_id_and_user(string $ebay_id, string $user,array $select_fields = []){
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }

        $query = yes_query(sprintf(
            "SELECT %s FROM %s ea WHERE ebay_id=:ebay_id AND ea.user=:user",
                $select_field_string,self::TABLE_NAME,
            ),['ebay_id'=>$ebay_id,'user'=>$user],
        );
		if(!sizeOf($query)){
			return null;
		}
        $record = current($query);
        return new self(self::convert_values($record,self::$propertyTypes));
    }

    public static function get_by_ebay_products_id(int $ebay_products_id,array $select_fields = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }

        $query = yes_query(sprintf(
            "SELECT %s FROM %s ea WHERE ebay_products_id=:id",
                $select_field_string,self::TABLE_NAME,
            ),['id'=>$ebay_products_id],
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

    public static function count_runnings_by_ebay_products_id(int $ebay_products_id){
        $query = yes_query(sprintf(
            "SELECT COUNT(id) as anz FROM %s ea WHERE ebay_products_id=:id AND ea.status=0",
                self::TABLE_NAME
            ),['id'=>$ebay_products_id],
            true
        );
        return intval($query['anz']);
    }

    /**
     * WHERE UNIX_TIMESTAMP(end_time) > :start_date && UNIX_TIMESTAMP(end_time) < :end_date",
     * @param int $startDate timestamp
     * @param int $endDate timestamp
     * 
     * @param array $select_fields
     * 
     * @return [type]
     */
    public static function get_by_enddate_span(int $startDate, int $endDate,array $select_fields = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }

        $query = yes_query(sprintf(
            "SELECT %s FROM %s ea WHERE UNIX_TIMESTAMP(end_time) > :start_date && UNIX_TIMESTAMP(end_time) < :end_date",
                $select_field_string,self::TABLE_NAME,
            ),[
                'start_date'=>$startDate,
                'end_date'=>$endDate
            ],
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;

    }

    /**
     * WHERE status=0
     * 
     * @param array $select_fields
     * 
     * @return array of object
     */
    public static function get_runnings(array $select_fields = [], string $limit = ''){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $limit_sql = (!empty($limit)) ? ' LIMIT '.$limit : '';

        $query = yes_query(sprintf(
            "SELECT %s FROM %s ea WHERE status=0 %s",
                $select_field_string,self::TABLE_NAME,
                $limit_sql
            )
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }

	/**
     * Holt sich die zuletzt zugewiesene pID zu einer SKU
     * gibt -1 zurueck wenn nichts gefunden wird.
     * 
	 * @param string $sku
	 * 
	 * @return int
	 */
	public static function get_products_id_from_last_used_ebay_sku( string $sku ){
        $query = yes_query(sprintf(
            "SELECT products_id FROM %s WHERE sku=:sku AND ea.products_id > 0 ORDER BY ea.start_time DESC LIMIT 1",
                self::TABLE_NAME
            ),['sku'=>$sku],
            true
        );
        if(!is_countable($query) or !sizeOf($query)){
            return -1;
        }
        return intval($query['products_id']);
    }
}
