<?php

namespace YES4Trade\Model;

class amazon_feeds extends \YES4Trade\Model\BaseType {

    const TABLE_NAME = 'amazon_feeds';
    const TABLE_INDEX = 'amazon_feeds_id';

    private static $propertyTypes = [
        'amazon_feeds_id' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'amazon_feeds_id'
        ],
        'feed_submission_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'feed_submission_id'
        ],
        'feed_type' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'feed_type'
        ],
        'feed_processing_status' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'feed_processing_status'
        ],
        'submitted_date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'submitted_date'
        ],
        'completed_processing_date' => [
            'type' => 'DateTime',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'completed_processing_date'
        ],
        'processed' => [
            'type' => 'integer',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'processed'
        ],
        'merchant_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'merchant_id'
        ],
        'selling_partner_id' => [
            'type' => 'string',
            'repeatable' => false,
            'attribute' => false,
            'elementName' => 'selling_partner_id'
        ],
    ];


    public function __construct(array $values = []) {
        list($parentValues, $childValues) = self::getParentValues(self::$propertyTypes, $values);
        parent::__construct($parentValues);
        if (!array_key_exists(__CLASS__, self::$properties)) {
            self::$properties[__CLASS__] = array_merge(self::$properties[get_parent_class(__CLASS__)], self::$propertyTypes);
        }
        if (!array_key_exists(__CLASS__, self::$xmlNamespaces)) {
            self::$xmlNamespaces[__CLASS__] = 'xmlns="urn:ebay:apis:eBLBaseComponents"';
        }
        $this->setValues(__CLASS__, $childValues);
    }


    public function create() {
        $data = $this->toArray();
        yes_db_perform(self::TABLE_NAME, self::convert_values($data,self::$propertyTypes));
        return xtc_db_insert_id();
    }


    public function update() {
        $data = $this->toArray();
        unset($data[self::TABLE_INDEX]);
        $index = self::TABLE_INDEX;
        yes_db_perform(self::TABLE_NAME, self::convert_values($data,self::$propertyTypes),'update',[$index=>$this->$index]);
    }


    public static function delete(int $index) {
        $amazon_feeds_quantity_items = \YES4Trade\Model\amazon_feeds_quantity_items::get_by_amazon_feeds_id($index);
        foreach($amazon_feeds_quantity_items as $amazon_feeds_quantity_item){
            \YES4Trade\Model\amazon_feeds_quantity_items::delete(
                intval($amazon_feeds_quantity_item->amazon_feeds_quantity_items_id)
            );
        }
        $amazon_feeds_price_items = \YES4Trade\Model\amazon_feeds_price_items::get_by_amazon_feeds_id($index);
        foreach($amazon_feeds_price_items as $amazon_feeds_price_item){
            \YES4Trade\Model\amazon_feeds_price_items::delete(
                intval($amazon_feeds_price_item->amazon_feeds_price_items_id)
            );
        }
        
        $amazon_feeds_order_fulfillments = \YES4Trade\Model\amazon_feeds_order_fulfillments::get_by_amazon_feeds_id($index);
        foreach($amazon_feeds_order_fulfillments as $amazon_feeds_order_fulfillment){
            \YES4Trade\Model\amazon_feeds_order_fulfillments::delete(
                intval($amazon_feeds_order_fulfillment->amazon_feeds_order_fulfillments_id)
            );
        }
        $amazon_feeds_product_listings = \YES4Trade\Model\amazon_feeds_product_listing::get_by_amazon_feeds_id($index);
        foreach($amazon_feeds_product_listings as $amazon_feeds_product_listing){
            \YES4Trade\Model\amazon_feeds_product_listing::delete(
                intval($amazon_feeds_product_listing->amazon_feeds_product_listing_id)
            );
        }
        $amazon_feeds_upload_vat_invoices = \YES4Trade\Model\amazon_feeds_upload_vat_invoice::get_by_amazon_feeds_id($index);
        foreach($amazon_feeds_upload_vat_invoices as $amazon_feeds_upload_vat_invoice){
            \YES4Trade\Model\amazon_feeds_upload_vat_invoice::delete(
                intval($amazon_feeds_upload_vat_invoice->amazon_feeds_upload_vat_invoice_id)
            );
        }
        
        yes_query(sprintf(
                "DELETE FROM %s WHERE %s=:id",
                self::TABLE_NAME,self::TABLE_INDEX
           ),['id'=>$index]
        );
    }


    public static function get_by_amazon_feeds_id(int $amazon_feeds_id, array $select_fields = []) {
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE %s=:id",
                   $select_field_string, self::TABLE_NAME, self::TABLE_INDEX
                ),['id'=>$amazon_feeds_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        return new self(self::convert_values($record,self::$propertyTypes));
    }

    public static function get_by_feed_submission_id(string $feed_submission_id, array $select_fields = []){
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE feed_submission_id=:id",
                   $select_field_string, self::TABLE_NAME
                ),['id'=>$feed_submission_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        return new self(self::convert_values($record,self::$propertyTypes));
    }
    
    public static function get_by_amazon_feeds_id_and_seller(int $amazon_feeds_id, string $selling_partner_id, array $select_fields = []){
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE %s=:id AND selling_partner_id=:selling_partner_id",
                   $select_field_string, self::TABLE_NAME, self::TABLE_INDEX
                ),['id'=>$amazon_feeds_id,'selling_partner_id'=>$selling_partner_id]
        );
        if(!sizeOf($query)){
            return null;
        }
        $record = current($query);
        return new self(self::convert_values($record,self::$propertyTypes));
    }
    
    public static function get_by_selling_partner_id(string $selling_partner_id, array $select_fields = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
                "SELECT %s FROM %s WHERE selling_partner_id=:selling_partner_id",
                   $select_field_string, self::TABLE_NAME, self::TABLE_INDEX
                ),['selling_partner_id'=>$selling_partner_id]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
    
    public static function get_by_feed_submission_id_array(array $feed_submissions_id_array, array $select_fields = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE feed_submission_id IN(:ids)",
               $select_field_string, self::TABLE_NAME
            ),['ids'=>implode(',',$feed_submissions_id_array)]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
    
    public static function get_by_processed(int $processed, array $select_fields = []){
        $items = [];
        $select_field_string = '*';
        if(sizeOf($select_fields)){
            $select_field_string = implode(',',$select_fields);
        }
        $query = yes_query(sprintf(
            "SELECT %s FROM %s WHERE processed=:processed",
               $select_field_string, self::TABLE_NAME
            ),['processed'=>$processed]
        );
        foreach($query as $record){
            $items[] = new self(self::convert_values($record,self::$propertyTypes));
        }
        return $items;
    }
    
    public static function getRequestFileNameFromFeedsId( string $feeds_id ){
        if(!defined('AMAZON_SAVE_PATH') or !is_dir(DIR_FS_ADMIN.AMAZON_SAVE_PATH)){
            throw new Exception('Invalid or undefined AMAZON_SAVE_PATH');
        }
        return AMAZON_SAVE_PATH.sprintf(
                AMAZON_JSON_LISTINGS_FEED_FILENAME_BASE,
                $feeds_id
        );
    }
    
    public static function saveFeedRequestFile(string $feeds_id, string $json){
        \basics::create_file2(self::getRequestFileNameFromFeedsId($feeds_id), $json);
    }
    
    public static function loadFeedRequestFile(string $feeds_id){
        $fn = self::getRequestFileNameFromFeedsId($feeds_id);
        if(!self::existsRequestFile($feeds_id)){
            throw new Exception('Request file for feed #'.$feeds_id.' not exists');
        }
        return file_get_contents($fn);
    }
    
    public static function deleteFeedRequestFile(string $feeds_id){
        unlink(self::getRequestFileNameFromFeedsId($feeds_id));
    }
    
    public static function existsRequestFile(string $feeds_id){
        return is_file(self::getRequestFileNameFromFeedsId($feeds_id));
    }
}
