<?php
namespace YES4Trade\Enums;

enum Bk: string
{

    case Bk_1 = '1';
    case Bk_2 = '2';
    case Bk_3 = '3';
    case Bk_4 = '4';

    public function multiplikator(): int{
        return match($this) {
            self::Bk_1 => 50,
            self::Bk_2 => 3,
            self::Bk_3 => 1,
            self::Bk_4 => 0,
        };
    }

    public function label(): string{
        return match($this) {
            self::Bk_1 => constant('Bk_1'),
            self::Bk_2 => constant('Bk_2'),
            self::Bk_3 => constant('Bk_3'),
            self::Bk_4 => constant('Bk_4'),
        };
    }
    
    public static function fromName(string $name): ?self
    {
        foreach (self::cases() as $case) {
            if ($case->name === $name) {
                return $case;
            }
        }
        return null;
    }

}
