<?php
/* --------------------------------------------------------------
   $Id: geo_zones.php,v 1.3 2017/01/09 10:48:05 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   --------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(geo_zones.php,v 1.27 2003/05/07); www.oscommerce.com 
   (c) 2003	 nextcommerce (geo_zones.php,v 1.9 2003/08/18); www.nextcommerce.org

   Released under the GNU General Public License 
   --------------------------------------------------------------*/

require('includes/application_top.php');
foreach($InstanceCache->getItemsByTags(['admin','shop']) as $cn=>$cd){
    if(strpos($cd->getKey(),'tax_description_')>-1 or strpos($cd->getKey(),'tax_rates_')>-1){
        $InstanceCache->deleteItem($cd->getKey()); // tax_description_*, tax_rates_*
    }
}
if(isset($_GET['term'])){
    $gzID = (int)xtc_db_input($_GET['gzID']);
    $z2gz = \YES4Trade\Model\zones_to_geo_zones::get_by_geo_zone_id_and_zone_id(
            $gzID, 0,['zone_country_id']
    );
    foreach($z2gz as $zc){
        $countries_exclude[] = $zc->zone_country_id;
    }
    $term = xtc_db_prepare_input($_GET['term']);
    $query = xtc_db_query(sprintf(
            "SELECT countries_id, countries_name FROM %s WHERE %s (countries_name LIKE '%%%s%%' or countries_iso_code_2='%s') ",
            TABLE_COUNTRIES, 
            ((sizeOf($countries_exclude))?"countries_id NOT IN(".implode(',',$countries_exclude).") AND " : ''),
            $term, $term
    ));
    $results = [];
    while($record = xtc_db_fetch_array($query)){
        $results[] = [
            'id'=>$record['countries_id'],
            'value'=>$record['countries_name'],
        ];
    }
    die(json_encode($results));
}
$smarty = new yesSmarty;
$smarty->assign('tpl_path','templates/'.CURRENT_TEMPLATE.'/');
$smarty->assign('logo_path',HTTP_SERVER  . DIR_WS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/img/');
$smarty->assign('language_path',DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
$action = isset($_GET['action']) ? $_GET['action'] : '';
switch ($action) {
    case 'ajax_insert':
        $new = new \YES4Trade\Model\geo_zones([
            'geo_zone_name'=>$_POST['geo_zone_name'],
            'geo_zone_description'=>$_POST['geo_zone_description'],
            'date_added'=>date('Y-m-d H:i:s'),
        ]);
        die(json_encode(array(
            'MSG'=>'',
            'insert_id'=>$new->create()
        )));
        break;
    case 'ajax_delete':
        $id = (int)xtc_db_input($_GET['id']);
        \YES4Trade\Model\geo_zones::delete(intval($id)); // zones_to_geo_zones werden mitgeloescht
        yes_add_history('geo zone #'.$id.' and country allocations deleted');
        die(json_encode(array(
            'MSG'=>''
        )));
        break;
    case 'update_country_allocation_process':
        $id = (int)xtc_db_input($_GET['id']);
        $upd = new \YES4Trade\Model\zones_to_geo_zones([
            'association_id'=>$id,
            'zone_id'=>$_GET['zone_id'],
            'last_modified'=>date('Y-m-d H:i:s'),
        ]);
        $upd->update();
        die(json_encode(array(
            'MSG'=>'',
        )));
        break;
    case 'update_country_allocation':
        $id = (int)xtc_db_input($_GET['id']);
        $z2gz = \YES4Trade\Model\zones_to_geo_zones::get_by_association_id($id,[
            'zone_country_id','zone_id'
        ]);
        printf('%s<br />%s<br /><button style="padding: 3px;" class="ui-button ui-corner-all ui-state-default" onClick="update_country_allocation( '.$id.' )">%s</button>',
                TEXT_INFO_COUNTRY_ZONE,
                xtc_draw_pull_down_menu('zone_id', xtc_prepare_country_zones_pull_down(
                        intval($z2gz->zone_country_id)
                    ),
                    intval($z2gz->zone_id)
                ),
                IMAGE_SAVE
        );
        exit;
        break;
    case 'ajax_add_country_allocation':
        $gzID = (int)xtc_db_input($_GET['gzID']);
        $id = (int)xtc_db_input($_GET['id']);
        $new = new \YES4Trade\Model\zones_to_geo_zones([
            'zone_country_id'=>$id,
            'zone_id'=>0,
            'geo_zone_id'=>$gzID,
            'date_added'=>date('Y-m-d H:i:s')
        ]);
        $insert_id = $new->create();
        die(json_encode(array(
            'MSG'=>'',
            'insert_id'=>$insert_id,
        )));
        break;
    case 'ajax_delete_country_allocation':
        $id = (int)xtc_db_input($_GET['id']);
        \YES4Trade\Model\zones_to_geo_zones::delete($id);
        die(json_encode(array(
            'MSG'=>''
        )));
        break;
    case 'ajax_list':
        $rows = 0;
        $zones_query_raw = sprintf(
                "select a.association_id, a.zone_country_id, c.countries_name, a.zone_id, a.geo_zone_id, a.last_modified, a.date_added, z.zone_name from %s a left join %s c on a.zone_country_id = c.countries_id left join %s z on a.zone_id = z.zone_id where a.geo_zone_id ='%d' order by association_id",
                TABLE_ZONES_TO_GEO_ZONES,TABLE_COUNTRIES,TABLE_ZONES,
                (int)xtc_db_input($_GET['zID'])
        );
        $zones_query = xtc_db_query($zones_query_raw);
        $zones_array = [];
        while ($zones = xtc_db_fetch_array($zones_query)) {
            $rows++;
            $zones_array[] = [
                'country_name'=>(($zones['countries_name']) ? $zones['countries_name'] : TEXT_ALL_COUNTRIES),
                'zone'=>(($zones['zone_id']) ? $zones['zone_name'] : PLEASE_SELECT),
                'association_id'=>$zones['association_id'],
            ];
        }
        $geo_zone = \YES4Trade\Model\geo_zones::get_by_geo_zone_id(intval($_GET['zID']),[
            'geo_zone_name'
        ]);
        $smarty->assign([
            'ZONES_MODE'=>true,
            'TABLE_HEADING_COUNTRY'=>TABLE_HEADING_COUNTRY,
            'TABLE_HEADING_COUNTRY_ZONE'=>TABLE_HEADING_COUNTRY_ZONE,
            'PLEASE_SELECT'=>PLEASE_SELECT,
            'TEXT_ALL'=>TEXT_ALL_ZONES,
            'zones'=>$zones_array,
            'GEO_ZONE_NAME'=>$geo_zone->geo_zone_name,
            'TEXT_INFO_HEADING_NEW_SUB_ZONE'=>TEXT_INFO_HEADING_NEW_SUB_ZONE,
            'GEO_ZONES_ID'=>$_GET['zID'],
            'JS_CONFIRM_ADD_COUNTRY_TO_GEO_ZONE'=>JS_CONFIRM_ADD_COUNTRY_TO_GEO_ZONE,
            'JS_CONFIRM_REALLY_DELETE_COUNTRY_ALLOCATION'=>JS_CONFIRM_REALLY_DELETE_COUNTRY_ALLOCATION,
            'TEXT_INFO_HEADING_EDIT_SUB_ZONE'=>TEXT_INFO_HEADING_EDIT_SUB_ZONE,
        ]);
        $smarty->display('geo_zones.html');
        exit;
        break;
    case 'ajax_update':
        $upd = new \YES4Trade\Model\geo_zones([
            'geo_zone_id'=>intval($_GET['id']),
            'geo_zone_name'=>$_GET['geo_zone_name'],
            'last_modified'=>date('Y-m-d H:i:s'),
        ]);
        $upd->update();
        die(json_encode(array(
            'MSG'=>'',
            'now'=> xtc_date_short(date('Y-m-d H:i:s'))
        )));
        break;
    case 'ajax_new':
        printf('<div class="main add_geo_zone">%s<br />%s<br />',
                TEXT_INFO_ZONE_NAME,
                xtc_draw_input_field('geo_zone_name','Neue Steuerzone')
        );
        printf('%s<br />%s<br />%s</div>',
                TEXT_INFO_ZONE_DESCRIPTION,
                xtc_draw_input_field('geo_zone_description','Beschreibung der neuen Steuerzone (nur intern)','size="64"'),
                xtc_draw_input_field('subm', IMAGE_SAVE, 'onClick="add_new_geo_zone()" class="ui-button ui-corner-all ui-state-default"', false, 'button')
        );
        exit;
        break;
    case 'insert_zone':
      $geo_zone_name = xtc_db_prepare_input($_POST['geo_zone_name']);
      $geo_zone_description = xtc_db_prepare_input($_POST['geo_zone_description']);
      $new = new \YES4Trade\Model\geo_zones([
          'geo_zone_name'=>$geo_zone_name, 
          'geo_zone_description'=>$geo_zone_description, 
          'date_added'=>date('Y-m-d H:i:s')
      ]);
      $new_zone_id = $new->create();

      xtc_redirect(xtc_href_link(FILENAME_GEO_ZONES, 'zpage=' . $_GET['zpage'] . '&zID=' . $new_zone_id));
      break;

}
yes_draw_pre_header();
yes_draw_header(TITLE);
$buttons = [];
$buttons[] = array('text'=>TEXT_TAX_RATES,
    'link'=>xtc_href_link(FILENAME_TAX_RATES),
    'lbOn'=>false,
    'auth'=>true
);
$buttons[] = array('text'=>TEXT_INFO_HEADING_NEW_ZONE,
    'link'=>xtc_href_link(FILENAME_GEO_ZONES, 'action=ajax_new'),
    'lbOn'=>true,
    'auth'=>true
);
$geo_zones = [];
$search_country_allocation = (isset($_GET['search_country_allocation'])) ? $_GET['search_country_allocation'] : '';
$order_by = 'order by gz.geo_zone_name';
$where = '';
if($search_country_allocation != ''){
    $where .= sprintf(" WHERE gz.geo_zone_id IN ( SELECT zgz.geo_zone_id FROM %s zgz LEFT JOIN %s c ON zgz.zone_country_id=c.countries_id WHERE ",
            TABLE_ZONES_TO_GEO_ZONES,TABLE_COUNTRIES,
    );
    if(strlen($search_country_allocation) == 2){
        $where .= " c.countries_iso_code_2 LIKE '".$search_country_allocation."'";
    }else{
        $where .= "c.countries_name LIKE '%".$search_country_allocation."%'";
    }
    $where .= ') ';
}
$zones_query_raw = sprintf("select gz.geo_zone_id, gz.geo_zone_name, gz.geo_zone_description, gz.last_modified, gz.date_added from %s gz %s %s",
    TABLE_GEO_ZONES,$where,$order_by
);

$zones_split = new splitPageResults($_GET['zpage'], MAX_DISPLAY_SEARCH_RESULTS, $zones_query_raw, $zones_query_numrows);
$zones_query = xtc_db_query($zones_query_raw);
while ($zones = xtc_db_fetch_array($zones_query)) {
    $zones['num_zones'] = \YES4Trade\Model\zones_to_geo_zones::count_by_geo_zone_id(intval($zones['geo_zone_id']));
    $zones['list_link'] = xtc_href_link(FILENAME_GEO_ZONES, 'zpage=' . $_GET['zpage'] . '&zID=' . $zones['geo_zone_id'] . '&action=list');
    $geo_zones[] = $zones;
}
$pager = $zones_split->display_count($zones_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['zpage'], TEXT_DISPLAY_NUMBER_OF_TAX_ZONES).
    '<br />'.
    $zones_split->display_links($zones_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['zpage'], '', 'zpage');

$smarty->assign([
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
    'TABLE_HEADING_ACTION'=>TABLE_HEADING_ACTION,
    'TABLE_HEADING_TAX_ZONES'=>TABLE_HEADING_TAX_ZONES,
    'PAGER'=>$pager,
    'geo_zones'=>$geo_zones,
    'TEXT_INFO_NUMBER_ZONES'=>TEXT_INFO_NUMBER_ZONES,
    'TEXT_INFO_DATE_ADDED'=>TEXT_INFO_DATE_ADDED,
    'TEXT_INFO_LAST_MODIFIED'=>TEXT_INFO_LAST_MODIFIED,
    'HEADING_TITLE_LIST'=>HEADING_TITLE_LIST,
    'LIST_ZONE_ALLOCATIONS'=>LIST_ZONE_ALLOCATIONS,
    'TEXT_SEARCH_COUNTRY_ALLOCATION'=>TEXT_SEARCH_COUNTRY_ALLOCATION,
    'INPUT_SEARCH_COUNTRY_ALLOCATION'=>xtc_draw_input_field("search_country_allocation", $search_country_allocation,'id="search_country_allocation" placeholder="DE, Deutschland ..."'),
    'TEXT_INFO_HEADING_EDIT_ZONE'=>TEXT_INFO_HEADING_EDIT_ZONE,
    'JS_REALLY_DELETE_GEO_ZONE'=>JS_REALLY_DELETE_GEO_ZONE,
]);
$smarty->display('geo_zones.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');