<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

include( 'includes/application_top.php');
require_once(DIR_FS_ADMIN.DIR_WS_CLASSES.'class.ebay.php');
$error_reporting = yes_getErrorReporting();
yes_setErrorReporting(0);
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_ServiceProxy.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/EbatNs_Logger.php';
require_once ABS_PATH_TO_PHPAPI.'ebat/RelistItemRequestType.php';
yes_setErrorReporting($error_reporting);

$EBAYAPI = new EbayAPI;
require(DIR_FS_INC.'xtc_is_language_installed.inc.php');
require(DIR_FS_INC.'xtc_get_products_stock.inc.php');
require(DIR_FS_INC.'xtc_get_product_path.inc.php');
require(DIR_FS_INC.'xtc_get_parent_categories.inc.php');
require(DIR_FS_INC.'xtc_get_tax_class_id.inc.php');
require(DIR_FS_INC.'xtc_get_ebay_link.inc.php');
require(DIR_FS_INC.'xtc_get_auction_site.inc.php');
require(DIR_FS_INC.'xtc_get_site_country_id.inc.php');
$smarty = new yesSmarty;

// dont allow cache
$smarty->caching = false;
		
$smarty->template_dir='templates';
$smarty->compile_dir=DIR_FS_CATALOG.'templates_c';
$smarty->config_dir=DIR_FS_CATALOG.'lang';
$smarty->plugins_dir[] = DIR_FS_CATALOG.'includes/smarty_plugins';
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');


$action = isset($_REQUEST["action"]) ? $_REQUEST["action"] : '';
$page_type = isset($_REQUEST['page_type']) ? $_REQUEST['page_type'] : '';
  
$ebayID = array();

$VARS = (is_array($_POST)) ? $_POST : $_GET;
switch($action) {
	case 'itemaction':
		$smarty->assign('ITEMACTION',true);
		switch($_REQUEST['itemaction_mode']){
			default:
				$actions = array(
					0=>array('id'=>'toebay','text'=>TEXT_FORM_INPUT_RELIST),
					1=>array('id'=>'del','text'=>TEXT_FORM_INPUT_DELETE_FROM_RELIST)
				);
				break;
			case 'runnings':
				$actions = array(
	            	0=>array('text'=>TEXT_FORM_INPUT_CANCEL,'id'=>'delebay')
           		);
				break;
			case 'timeset':
			case 'timeset_process':
				$actions = array(
					0=>array('id'=>'del','text'=>TEXT_FORM_INPUT_DELETE_FROM_TIMING)
				);
				break;
		}
		$smarty->assign('ITEMACTIONS',$actions);
		$smarty->assign('ITEM_ID',$_REQUEST['id']);
		$smarty->assign(array(
			'JS_MESSAGE_REALLY_DELETE_PRODUCT'=>JS_MESSAGE_REALLY_DELETE_PRODUCT,
			'JS_MESSAGE_REALLY_TO_EBAY'=>JS_MESSAGE_REALLY_TO_EBAY
		));
		header('Content-Type: text/html; charset='.CHARSET);
		$smarty->display('auctions.html');
		exit;
		break;
	case 'del':
		if(isset($_REQUEST['id']) and $_REQUEST['id'] > 0){
			$id = xtc_db_input($_REQUEST['id']);
			xtc_db_query("update ebay_auctions set relist_id=1 where id='".$id."' LIMIT 1");
			$messageStack->add_session(sprintf(MSG_SUCCESS_DELETE,1),'success');
		}
		xtc_redirect(xtc_href_link('ebayapi_relist.php', xtc_get_all_get_params(array('page_type','action','id'))));
		break;
	case 'delete':
		if(is_array($_GET['id'])){
			foreach($_GET['id'] as $k=>$ebayid){
				$ebay_id = xtc_db_input($ebayid);
				if($ebayid and $ebayid!=''){
					xtc_db_query("update ebay_auctions set relist_id=1 where ebay_id='".$ebayid."' LIMIT 1");
				}
			}
			$messageStack->add_session(sprintf(MSG_SUCCESS_DELETE,sizeOf($_GET['id'])),'success');
		}else{
			$messageStack->add_session(MSG_ERROR_DELETE,'error');
		}
		xtc_redirect(xtc_href_link('ebayapi_relist.php', xtc_get_all_get_params(array('page_type','action','id'))));
		break;
	case 'deleteids':
		if(is_array($_GET['id'])){
			foreach($_GET['id'] as $k=>$id){
				$id = xtc_db_input($id);
				if($id and $id!=''){
					xtc_db_query("update ebay_auctions set relist_id=1 where id='".$id."' LIMIT 1");
				}
			}
            		$messageStack->add_session(sprintf(MSG_SUCCESS_DELETE,sizeOf($_GET['id'])),'success');
		}else{
            		$messageStack->add_session(MSG_ERROR_DELETE,'error');
		}
		xtc_redirect(xtc_href_link('ebayapi_relist.php', xtc_get_all_get_params(array('page_type','action','id'))));
		break;
	case "toebay":
		$okay = true;
		$ids = ($_GET["id"]) ? $_GET["id"] : $_POST["id"];
		$gesamtfee = 0;
		for($i=0;$i<count($ids);$i++){
			$ea = new ebay_auction($ids[$i]);
			$data = $ea->getSQLArray();

			if(EBAY_LIST_ONLY_ACTIVE_PRODUCTS == 'true'){
				$is_active_query = xtc_db_query(sprintf(
					"SELECT products_status FROM products WHERE products_id='%s'",
					$data['products_id']
				));
				$is_active = xtc_db_fetch_array($is_active_query);
				if($is_active['products_status'] == 0){
					$messageStack->add_session(sprintf(TEXT_MESSAGE_LIST_ONLY_ACTIVE,$data['products_id']),'error');
					continue;
				}
			}

			$session = new EbatNs_Session(ABS_PATH_TO_PHPAPI.'config/ebay.config.php');
			$session->setRequestToken( $EBAYAPI->getToken($ea->getUser() ) );	
			$site_id = $EBAYAPI->get_site_id_from_name($data['site']);
			$session->setSiteID($site_id);
			
			$cs = new EbatNs_ServiceProxy($session);
			$req = new RelistItemRequestType();

			$einstellmenge = $data['quantity'];
			if($data['select_set_multiple']>0)
				$einstellmenge = $einstellmenge*$data['select_set_multiple'];
		    	
			if(STOCK_CHECK == 'true'){
				$SQ = new products_quantity($data['products_id']);
				$products_stock = $SQ->get_available2_qty();
				
				if( $products_stock <  $einstellmenge){
					$messageStack->add_session(MSG_ERROR_TO_EBAY_QTY,'error');
					$okay = false;
				}
			}
			if(defined('EBAY_LIST_ONLY_UNIQUE_PRODUCTS') and EBAY_LIST_ONLY_UNIQUE_PRODUCTS == 'True'){
				$unique_check_query = xtc_db_query(sprintf(
					"SELECT ebay_id FROM ebay_auctions WHERE products_id='%s' and status=0",
					$data['products_id']
				));
				if(xtc_db_num_rows($unique_check_query)){
					$messageStack->add_session(MSG_ERROR_TO_EBAY_UNIQUE,'error');
					$okay = false;
				}
			}
			
			if($okay){
				
				$item = new ItemType();
				$item->setItemID($data['ebay_id']);
				$req->setItem($item);
				$res = $cs->RelistItem($req);
				
				if($cs->isGood($res)){
					$fees_type = $res->getFees();
					$fees = $fees_type->getFee();
					$fee_val = 0;
					foreach($fees as $k=>$fee ){
						if(is_object($fee)){
							$amount = $fee->getFee();
							if($fee->getName() == 'ListingFee')
								$fee_val = $amount->value;
						}
					}
					$insert_sql_array = $data;
					unset($insert_sql_array['id']);
					$insert_sql_array['start_time'] = $res->getStartTime();
					$insert_sql_array['end_time'] = $res->getEndTime();
					$insert_sql_array['ebay_id'] = $res->getItemID();
					$insert_sql_array['auction_fees'] = $fee_val;
					$insert_sql_array['description'] = '';
					$insert_sql_array['relist'] = '0';
					$insert_sql_array['relist_id'] = '1';

					$insert_sql_array['quantity'] = $data['quantity']+$data['quantity_sold']+(-$data['revise_counter']);
					$insert_sql_array['quantity_sold'] = 0;
					$insert_sql_array['revise_counter'] = 0;
					
					xtc_db_perform('ebay_auctions',$insert_sql_array);
					$insert_id = xtc_db_insert_id();
					
					$payments = $EBAYAPI->get_payments('ebay_auctions_payments','ebay_auctions_id',$data['id']);
					// payments kopieren
					if(is_array($payments) and sizeOf($payments)>0){
						foreach($payments as $k=>$v){
							xtc_db_query("INSERT INTO ebay_auctions_payments SET ebay_auctions_id='".$insert_id."',payment='".$v."'");
						}
					}

					$item_shippingcosts = array(); // array muss genullt werden
					$EBAYAPI->get_shippingcosts_value('auction',$item_shippingcosts,$data['id']);
					if(sizeOf($item_shippingcosts)>0)
						$EBAYAPI->save_ebayshipping_values($item_shippingcosts,'auction',$insert_id);

					
					xtc_db_query("update ebay_auctions set relist=1,relist_id='".$res->getItemID()."' where id='".$ids[$i]."'");
					yes_update_products_in_auction_quantity($data['products_id'],
							$data['quantity'],
							'Relist '.$res->getItemID().': per Hand eingestellt, '.$data['quantity'].' Stk.'
					);

					$messageStack->add_session(sprintf(MSG_SUCCESS_TO_EBAY,
							xtc_get_ebay_link(xtc_get_auction_site($res->getItemID())).$res->getItemID(),
							$res->getItemID(),
							$einstellmenge),
						'success');
				} else {
					$messageStack->add_session($cs->getErrorsToString($res),'error');
				}
			} // end if okay			
		}
		xtc_redirect(xtc_href_link('ebayapi_relist.php', xtc_get_all_get_params(array('page_type','action'))));
		break;
	case "timeset_sort":
		$page_type='timeset_sort';
		break;
	case "timeset_sort_shuffle":
		shuffle($_POST['id']);
		$page_type='timeset_sort';
		break;
	case "timeset":
	case "timeset_process":
		$page_type = "timeset_process";
		if(!empty($_POST["save"])) {
		    $ids = $_POST["id"];
			for($i=0;$i<count($ids);$i++){
				$sql_array = array(
					'cronstart'=>$_POST["timestamp"][$i],
					'status'=>'1',
					'relist'=>'1'
				);
				xtc_db_perform('ebay_auctions',$sql_array, 'update','id='.xtc_db_input($ids[$i]));

				if(PRODUCTS_QUANTITY_LOG_MODE == 1){
					$ea = new ebay_auction(xtc_db_input($ids[$i]));
					$log_qty = $ea->getQuantity();
					if($ea->getSelectSetMultiple() > 0){
						$log_qty = $log_qty * $ea->getSelectSetMultiple();
					}
					$SQ = new products_quantity($ea->getProductsId());
					$SQ->update_log('in_timing', $log_qty);
				}

			}
            $messageStack->add_session(MSG_SUCCESS_TIMESET_PROCESS,'success');
            xtc_redirect(xtc_href_link('ebayapi_cart.php','page_type=timings&menugroup=interfaces'));
		}
		break;
}

$smarty->assign('TEXT_SEARCH_PRODUCT',TEXT_SEARCH_PRODUCT);
$smarty->assign('TEXT_SEARCH_PID',TEXT_SEARCH_PID);
$smarty->assign('TEXT_SEARCH_CARTID',TEXT_SEARCH_CARTID);
$smarty->assign('TEXT_SEARCH_TIMING',TEXT_SEARCH_TIMING);
$smarty->assign('TEXT_INFO_ADD_NEW_CARTITEM',TEXT_INFO_ADD_NEW_CARTITEM);
$smarty->assign('TEXT_ADD_NEW_CARTITEM',TEXT_ADD_NEW_CARTITEM);
$smarty->assign('TABLE_HEADING_TYPE',TABLE_HEADING_TYPE);
$smarty->assign('TABLE_HEADING_IMAGE',TABLE_HEADING_IMAGE);
$smarty->assign('TABLE_HEADING_TYPE',TABLE_HEADING_TYPE);
$smarty->assign('TABLE_HEADING_FORMAT','Formatierungen');
$smarty->assign('TABLE_HEADING_STARTPRICE',TABLE_HEADING_STARTPRICE);
$smarty->assign('TABLE_HEADING_PREFERENCES',TABLE_HEADING_PREFERENCES);
$smarty->assign('TABLE_HEADING_DURATION',TABLE_HEADING_DURATION);
$smarty->assign('TABLE_HEADING_QTY',TABLE_HEADING_QTY);
$smarty->assign('TABLE_HEADING_STARTTIME',TABLE_HEADING_STARTTIME);
$smarty->assign('TABLE_HEADING_ENDTTIME',TABLE_HEADING_ENDTIME);
$smarty->assign('TABLE_HEADING_EBAYID',TABLE_HEADING_EBAYID);
$smarty->assign('TABLE_HEADING_ACTION',TABLE_HEADING_ACTION);
$smarty->assign('TEXT_PERSONAL_OFFER',TEXT_PERSONAL_OFFER);
$smarty->assign('JS_MESSAGE_SET',JS_MESSAGE_SET);
$smarty->assign('TEXT_PRODUCTS_MODEL',TEXT_PRODUCTS_MODEL);
$smarty->assign('JS_MESSAGE_CART_TITLE',JS_MESSAGE_CART_TITLE);
$smarty->assign('TEXT_CART_INFO',TEXT_CART_INFO);
$smarty->assign('TEXT_CARTID',TEXT_CARTID);
$smarty->assign('TEXT_AVAILABLE_QTY',TEXT_AVAILABLE_QTY);
$smarty->assign('TEXT_SELLER',TEXT_SELLER);
$smarty->assign('TEXT_BUYITNOWPRICE',TEXT_BUYITNOWPRICE);
$smarty->assign('TEXT_EBAY_SITE',TEXT_EBAY_SITE);
$smarty->assign('TEXT_PERSONAL_OFFERS',TEXT_PERSONAL_OFFERS);
$smarty->assign('TEXT_COPY_MOVE_PRODUCTS',TEXT_COPY_MOVE_PRODUCTS);
$smarty->assign('TEXT_SOURCE_FROM',TEXT_SOURCE_FROM);
$smarty->assign('TEXT_DAY',TEXT_DAY);
$smarty->assign('TEXT_MONTH',TEXT_MONTH);
$smarty->assign('TEXT_YEAR',TEXT_YEAR);
$smarty->assign('TEXT_HOUR',TEXT_HOUR);
$smarty->assign('TEXT_MINUTE',TEXT_MINUTE);
$smarty->assign('TEXT_INTERVALL',TEXT_INTERVALL);
$smarty->assign('TEXT_INFO_SAVE_TIMING',TEXT_INFO_SAVE_TIMING);
$smarty->assign('TEXT_BUTTON_DELETE_FROM_TIMING',TEXT_BUTTON_DELETE_FROM_TIMING);

$smarty->assign('TEXT_ADD_BESTOFFER_MATRIX',TEXT_ADD_BESTOFFER_MATRIX);
$smarty->assign('TEXT_ADD_BESTOFFER_MATRIX_INTRO1',TEXT_ADD_BESTOFFER_MATRIX_INTRO1);
$smarty->assign('TEXT_ADD_BESTOFFER_MATRIX_INTRO2',TEXT_ADD_BESTOFFER_MATRIX_INTRO2);
$smarty->assign('TEXT_BUTTON_SAVE_BESTOFFER_MATRIX',TEXT_BUTTON_SAVE_BESTOFFER_MATRIX);
$smarty->assign('TEXT_BUTTON_CANCEL',TEXT_BUTTON_CANCEL);
$smarty->assign('TEXT_PRODUCTS_LINK',TEXT_PRODUCTS_LINK);
$smarty->assign('JS_MESSAGE_CHANGE_SELLER',JS_MESSAGE_CHANGE_SELLER);
$smarty->assign('TEXT_USER',TEXT_USER);
$smarty->assign('TEXT_INFO',TEXT_INFO);
$smarty->assign('TEXT_EBAY_CONFIG',TEXT_EBAY_CONFIG);
$smarty->assign('TEXT_COUNTER',TEXT_COUNTER);
$smarty->assign('TEXT_EBAY_QUANTITY',TEXT_EBAY_QUANTITY);
$smarty->assign('TEXT_EBAY_TAX',TEXT_EBAY_TAX);
$smarty->assign('TEXT_SELLER_LOCATION',TEXT_SELLER_LOCATION);
$smarty->assign('TEXT_ZUSTAND',TEXT_ZUSTAND);
$smarty->assign('TEXT_ZUSTAND_NONE',TEXT_ZUSTAND_NONE);
$smarty->assign('TEXT_ZUSTAND_NEW',TEXT_ZUSTAND_NEW);
$smarty->assign('TEXT_ZUSTAND_NOWNEW',TEXT_ZUSTAND_NOWNEW);
$smarty->assign('TEXT_SELLER_COUNTRY',TEXT_SELLER_COUNTRY);
$smarty->assign('TEXT_GELDZURUECK',TEXT_GELDZURUECK);
$smarty->assign('TEXT_CONFIGURE_SET',TEXT_CONFIGURE_SET);
$smarty->assign('TEXT_INTRO_SET',TEXT_INTRO_SET);
$smarty->assign('TEXT_SET_SELECT',TEXT_SET_SELECT);
$smarty->assign('TEXT_EBAY_DESCRIPTION',TEXT_EBAY_DESCRIPTION);
$smarty->assign('TEXT_UPDATE_TITLE',TEXT_UPDATE_TITLE);
$smarty->assign('TEXT_AUCTION_TITLE',TEXT_AUCTION_TITLE);
$smarty->assign('TEXT_EBAY_TEMPLATE',TEXT_EBAY_TEMPLATE);
$smarty->assign('TEXT_AUCTION_SUBTITLE',TEXT_AUCTION_SUBTITLE);
$smarty->assign('TEXT_AUCTION_PAYMENTINFO',TEXT_AUCTION_PAYMENTINFO);
$smarty->assign('TEXT_AUCTION_TEXT',TEXT_AUCTION_TEXT);
$smarty->assign('TEXT_UPDATE_EXTRATEXT',TEXT_UPDATE_EXTRATEXT);
$smarty->assign('TEXT_UPDATE_DESCRIPTION',TEXT_UPDATE_DESCRIPTION);
$smarty->assign('TEXT_UPDATE_INTRO',TEXT_UPDATE_INTRO);
$smarty->assign('TEXT_AUCTION_COMMENTS',TEXT_AUCTION_COMMENTS);
$smarty->assign('TEXT_PRICE',TEXT_PRICE);
$smarty->assign('TEXT_AUCTION_STARTPRICE',TEXT_AUCTION_STARTPRICE);
$smarty->assign('TEXT_AUCTION_ALLOW_BESTOFFER',TEXT_AUCTION_ALLOW_BESTOFFER);
$smarty->assign('TEXT_BUYITNOWPRICE',TEXT_BUYITNOWPRICE);
$smarty->assign('TEXT_BUYITNOWPRICE_INFO',TEXT_BUYITNOWPRICE_INFO);
$smarty->assign('TEXT_AUCTION_ALLOW_BESTOFFER_FROM',TEXT_AUCTION_ALLOW_BESTOFFER_FROM);
$smarty->assign('TEXT_AUCTION_BESTOFFER_MATRIX_VALUES',TEXT_AUCTION_BESTOFFER_MATRIX_VALUES);
$smarty->assign('TEXT_AUCTION_BESTOFFER_UNIT',TEXT_AUCTION_BESTOFFER_UNIT);
$smarty->assign('TEXT_AUCTION_BESTOFFER_DELETE_VALUE',TEXT_AUCTION_BESTOFFER_DELETE_VALUE);
$smarty->assign('TEXT_LINK_ADD_BESTOFFER',TEXT_LINK_ADD_BESTOFFER);
$smarty->assign('TEXT_EBAY_CATEGORYS',TEXT_EBAY_CATEGORYS);
$smarty->assign('TEXT_AUCTION_CATEGORY',TEXT_AUCTION_CATEGORY);
$smarty->assign('TEXT_AUCTION_CATEGORY2',TEXT_AUCTION_CATEGORY2);
$smarty->assign('TEXT_AUCTION_SHOPCATEGORY',TEXT_AUCTION_SHOPCATEGORY);
$smarty->assign('TEXT_AUCTION_SHOPCATEGORY2',TEXT_AUCTION_SHOPCATEGORY2);
$smarty->assign('TEXT_EBAY_PAYMENT',TEXT_EBAY_PAYMENT);
$smarty->assign('TEXT_AUCTION_PAYMENTMETHODS',TEXT_AUCTION_PAYMENTMETHODS);
$smarty->assign('TEXT_EBAY_IMAGES',TEXT_EBAY_IMAGES);
$smarty->assign('TEXT_AUCTION_IMAGE_STYLE_GALLERY',TEXT_AUCTION_IMAGE_STYLE_GALLERY);
$smarty->assign('TEXT_AUCTION_IMAGE_STYLE_GALLERYPLUS',TEXT_AUCTION_IMAGE_STYLE_GALLERYPLUS);
$smarty->assign('TEXT_AUCTION_IMAGE_STYLE_GALLERYFEATURED',TEXT_AUCTION_IMAGE_STYLE_GALLERYFEATURED);
$smarty->assign('TEXT_AUCTION_IMAGE_STYLE_GALLERYFEATURED_DURATION',TEXT_AUCTION_IMAGE_STYLE_GALLERYFEATURED_DURATION);
$smarty->assign('TEXT_AUCTION_IMAGE_SELECT',TEXT_AUCTION_IMAGE_SELECT);
$smarty->assign('TEXT_AUCTION_IMAGE_NOT_SELECT',TEXT_AUCTION_IMAGE_NOT_SELECT);
$smarty->assign('TEXT_UPDATE_IMAGE',TEXT_UPDATE_IMAGE);
$smarty->assign('TEXT_UPDATE_IMAGE_INFO',TEXT_UPDATE_IMAGE_INFO);
$smarty->assign('TEXT_BUTTON_SAVE_CARTITEM',TEXT_BUTTON_SAVE_CARTITEM);
$smarty->assign('TEXT_SET_MULTIPLE_CHOICE_INFO',TEXT_SET_MULTIPLE_CHOICE_INFO);
$smarty->assign('TEXT_SET_MULTIPLE_CHOICE',TEXT_SET_MULTIPLE_CHOICE);
$smarty->assign(array(
	'TEXT_EBAY_DISPATCHTIMEMAX'=>TEXT_EBAY_DISPATCHTIMEMAX,
	'JS_MESSAGE_REALLY_DELETE_PRODUCT'=>JS_MESSAGE_REALLY_DELETE_PRODUCT
));

if($page_type == 'timeset_sort'){
	include('ebayapi_relist.timesort.inc.php');
	exit;
}
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php if($page_type != 'timeset_sort'){ ?>
	<?php include('includes/ebayapi.js.php'); ?>
<?php } ?>
<script type="text/javascript">
<!--
function delete_relist(product,id){
	confirm_text = sprintf('<?php echo JS_CONFIRM_REALLY_DELETE_FROM_TIMING; ?>',id);
	yes = confirm(confirm_text);
	if(yes){
		window.location.href='<?php echo xtc_href_link('ebayapi_relist.php',xtc_get_all_get_params(array('id','action'))); ?>&action=delete&id[]='+id;
	}
}

function ebay_item_set_action(action,element_id){
	document.forms['ebayapi'].elements['itemaction_'+element_id].value = action;
	itemAction(element_id);
}


<?php 
if($action=="verify") { 
	echo "var ONLOADFUNC = 'prev';";
} 
if($page_type=="edit") { 
	echo "var ONLOADFUNC = '';";
}else{
	echo "var ONLOADFUNC = '';";
}
?>
//-->
</script>

<?php
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE
));
?>
<!-- header_eof //-->

<table border="0" width="100%" cellspacing="0" cellpadding="0">
<tr>
	<td class="main">
<?php
function _getSort($field){
	$sortmode = 'ASC';
	if(isset($_GET['order_by']) and $_GET['order_by'] == $field.' ASC'){
		$sortmode = 'DESC';
	}else if(isset($_GET['order_by']) and $_GET['order_by'] == $field.' DESC'){
		$sortmode = 'ASC';
	}
	return xtc_href_link('ebayapi_relist.php',xtc_get_all_get_params(array('order_by')).'order_by='.$field.'%20'.$sortmode);
}

$smarty->assign('ITEMACTION_BASE_LINK',xtc_href_link('ebayapi_relist.php','action=itemaction&itemaction_mode='.$page_type));
$smarty->assign('TABLE_CAPTION',HEADING_TITLE);
$smarty->assign('LISTING_MODE','relist');

switch($page_type){
	default:
		$days90 = strftime('%Y-%m-%d',time()-(60*60*24*85)); // 85 statt 90 haben wir um nen sicherheitspuffer bei datumsberechnungen zu haben
		$where = " (relist_id='0' or relist_id='') and relist=0 and quantity=1 and (type='FixedPriceItem' or type='Chinese') and end_time > '".$days90." 00:00:00' and ea.status='2' and quantity_sold='0'"; // mit relist_id=0 wissen wir das sie nich per hand "ausgeschlossen" wurde -> siehe funktion delete
		$order_by = (isset($_GET['order_by'])) ? $_GET['order_by'] : 'end_time DESC';
		
		$search_title = isset($_GET['search_title']) ? xtc_db_prepare_input($_GET['search_title']) : '';
		if(xtc_not_null($search_title))
			$where .= " and title like '%".$search_title."%' ";
		
		$search_pid = isset($_GET['search_pid']) ? xtc_db_prepare_input($_GET['search_pid']) : '';
		if(xtc_not_null($search_pid))
			$where .= " and ep.products_id = '".$search_pid."' ";
		
		$search_sammlerid = isset($_GET['search_sammlerid']) ? xtc_db_prepare_input($_GET['search_sammlerid']) : '';
		if(xtc_not_null($search_sammlerid))
			$where .= " and ebay_products_id = '".$search_sammlerid."' ";
		
		$search_sammler = isset($_GET['search_sammler']) ? xtc_db_prepare_input($_GET['search_sammler']) : '';
		if(xtc_not_null($search_sammler))
			$where .= " and ep.ebay_sammler_id = '".$search_sammler."' ";
		
		$products_query_raw = "select ea.id from ebay_auctions ea,ebay_products ep where ep.id=ea.ebay_products_id and  ".$where.' order by '.$order_by;

		$products_split = new splitPageResults( $_GET['page'], MAX_DISPLAY_SEARCH_RESULTS, $products_query_raw, $products_query_numrows);
		$products_query = xtc_db_query($products_query_raw);

		$smarty->assign('RELIST_SEARCH_TITLE_FORM',xtc_draw_form('search_title','ebayapi_relist.php','','get'));
		$smarty->assign('RELIST_SEARCH_TITLE_INPUT',xtc_draw_input_field('search_title',@$_GET['search_title'],'maxlength="40" size="10"'));
		
		$smarty->assign('RELIST_SEARCH_PID_FORM',xtc_draw_form('search_pid','ebayapi_relist.php','','get'));
		$smarty->assign('RELIST_SEARCH_PID_INPUT',xtc_draw_input_field('search_pid',@$_GET['search_pid'],'size="5" maxlength="10"'));
				
		$smarty->assign('RELIST_SEARCH_SAMMLERID_FORM',xtc_draw_form('search_sammlerid','ebayapi_relist.php','','get'));
		$smarty->assign('RELIST_SEARCH_SAMMLERID_INPUT',xtc_draw_input_field('search_sammlerid',@$_GET['search_sammlerid'],'size="5" maxlength="10"'));
				
		$smarty->assign('RELIST_SEARCH_SAMMLER_FORM',xtc_draw_form('search_sammler','ebayapi_relist.php','','get'));
		$smarty->assign('RELIST_SEARCH_SAMMLER_INPUT',xtc_draw_pull_down_menu('search_sammler',$EBAYAPI->getSammlerValues(),@$_GET['search_sammler']));
			
		$smarty->assign('SORT_TYPE',array('href'=>_getSort('type'),'title'=>TABLE_HEADING_TYPE));
		$smarty->assign('SORT_TITLE',array('href'=>_getSort('title'),'title'=>TABLE_HEADING_TITLE));
		$smarty->assign('SORT_STARTPRICE',array('href'=>_getSort('startprice'),'title'=>TABLE_HEADING_STARTPRICE));
		$smarty->assign('SORT_ENDTIME',array('href'=>_getSort('endtime'),'title'=>TABLE_HEADING_ENDTIME));
		$smarty->assign('SORT_PID',array('title'=>TEXT_PRODUCTS_ID,'href'=>_getSort('ea.products_id')));
			
		$actions = array(
			0=>array('id'=>'','text'=>TEXT_SELECT),
			1=>array('id'=>'toebay','text'=>TEXT_FORM_INPUT_RELIST),
			2=>array('id'=>'del','text'=>TEXT_FORM_INPUT_DELETE_FROM_RELIST)
		);
	
		$auction = array();
		while($products = xtc_db_fetch_array($products_query)){
			$ea = new ebay_auction($products['id']);
			$SQ = new products_quantity( $ea->getProductsId() );
			$auction = $ea->getSmartyListArray($SQ,$actions,$checked=true);
			$is_relist = 1;
			if($is_relist == 1)
				$auction['checkbox'] = xtc_draw_checkbox_field("id[]", $products['id'], false);
			else
				$auction['checkbox'] = $no_relist;
			
			if($is_relist == 1){
				$select = '<select name="itemaction_'.$products['id'].'" onChange="itemAction(\''.$products['id'].'\')">';
				foreach($actions as $ak=>$av){
					$select .= '<option value="'.$av['id'].'">'.$av['text'].'</option>';
				}
				$select .= '</select>';
				$auction['actions'] = $select;
			}else{
				$auction['actions'] = '&nbsp;';
			}
			
			$auctions[] = $auction;
			
		} // end for
		$smarty->assign('FORM',xtc_draw_form("ebayapi", 'ebayapi_relist.php', '', 'post'));
		
		$arr = array( 	0=>array('text'=>TEXT_SELECT,'id'=>'0'),
						1=>array('text'=>TEXT_FORM_INPUT_TIMINGS,'id'=>'timeset_sort'),
						2=>array('text'=>TEXT_FORM_INPUT_TIMINGS_RANDOM,'id'=>'timeset_sort_shuffle'),
						3=>array('text'=>TEXT_FORM_INPUT_DELETE_FROM_RELIST,'id'=>'delete_relist'),
						4=>array('text'=>'----------------------------------','id'=>''),
						5=>array('text'=>TEXT_FORM_INPUT_TOEBAY,'id'=>'toebay')
		);
		$smarty->assign('LISTACTIONS',xtc_draw_pull_down_menu("action",$arr,'0',"onChange='confirmaction();'"));
		if(isset($auctions) and sizeOf($auctions)>0)
			$smarty->assign('auctions',$auctions);
		
		$smarty->assign('PRODUCTS_IMAGES',((EBAYCART_LISTING_IMAGE=='1') ? true : false));
		$smarty->assign('PRODUCTS_ACTION','1');
		$smarty->assign('PRODUCTS_STARTTIME','0'); // zeige ich aus platzmangel nicht
		$smarty->assign('PRODUCTS_ENDTIME','1');
		$smarty->assign('PRODUCTS_EBAYID','1');
			
		$optionstr = '';
		if(!isset($pages)) $pages = 0;
		for($i=1;$i<=$pages;$i++){
			$optionstr .= '<option value="'.$i.'"';
			if($i == $_GET['page']) 
				$optionstr .= ' SELECTED';
			$optionstr .= '>';
			$optionstr .= $i;
			$optionstr .= '</option>';
		}
		
		$smarty->assign('split_text',$products_split->display_count($products_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, $_GET['page'], TEXT_DISPLAY_NUMBER_OF_ITEMS,xtc_get_all_get_params(array('page', 'action'))));
		$smarty->assign('split_navi',$products_split->display_links($products_query_numrows, MAX_DISPLAY_SEARCH_RESULTS, MAX_DISPLAY_PAGE_LINKS, $_GET['page'], xtc_get_all_get_params(array('page'))));
		
		$smarty->assign('select_all','<a href="javascript:selectall(\'ebayapi\',\'id[]\',true);">'.TEXT_SELECT_ALL.'</a><br><a href="javascript:selectall(\'ebayapi\',\'id[]\');">'.TEXT_UNSELECT_ALL.'</a>');
		
		$smarty->assign('EBAY_SITE_ID',EBAY_SITE_ID);
		$html=$smarty->fetch('auctions.html');
?>
			<script type='text/javascript'>
			<!--
			function itemAction(pID){
				eval("iAction = document.forms['ebayapi'].itemaction_"+pID+".value;");
				switch(iAction){
					case 'del':
						ok = confirm('<?php echo JS_CONFIRM_REALLY_DELETE_RELISTITEM; ?>');
						if(ok)
							delete_relist(pID);
						break;
					case 'toebay':
						ok = confirm('<?php echo JS_CONFIRM_REALLY_RELISTITEM; ?>');
						if(ok)
							window.location.href='<?php echo xtc_href_link('ebayapi_relist.php',xtc_get_all_get_params(array('action','id')).'action=toebay');?>&id[]='+pID;
						break;
				}
			}
			//-->
			</script>
<?php
			echo $html;
		break;
	case "timeset":
	case "timeset_process":
		$intervall = array();
		$year = array();
		$month = array();
		$day = array();
		$hour = array();
		$minute = array();

		$default_year = ($_POST["START_YEAR"]>0) ? $_POST["START_YEAR"] : date("Y");
		$default_month = ($_POST["START_MONTH"]>0) ? $_POST["START_MONTH"] : date("m");
		$default_day = ($_POST["START_DAY"]>0) ? $_POST["START_DAY"] : date("d");
		$default_hour = ($_POST["START_HOUR"]>0) ? $_POST["START_HOUR"] :date("H");
		$default_minute = ($_POST["START_MINUTE"]>0) ? $_POST["START_MINUTE"] : date("i");
		$default_intervall = ($_POST["START_INTERVALL"]>0) ? $_POST["START_INTERVALL"] : "5";

		$intervall_query = xtc_db_query("SELECT timing_delay_value FROM ebay_timingdelays order by timing_delay_value");
		while($intervalls = xtc_db_fetch_array($intervall_query)){
			$intervall[] = array("id"=>$intervalls['timing_delay_value'],"text"=>$intervalls['timing_delay_value'] );
		}

		$year = array( 0 => array('id'=>date("Y"),'text'=>date("Y")),
					   1 => array('id'=>(date("Y")+1),'text'=>(date("Y")+1))
					   );
		for($i=0;$i<12;$i++){
			$num = ($i+1);
			$month[] = array("id"=>$num,"text"=>$num);
		}
		for($i=0;$i<31;$i++){
			$num = ($i+1);
			$day[] = array("id"=>$num,"text"=>$num);
		}
		for($i=0;$i<24;$i++){
			$num = ($i+1);
			$hour[] = array("id"=>$num,"text"=>$num);
		}

		for($i=0;$i<60;$i+=1){
			$num = $i;
			$minute[] = array("id"=>$num,"text"=>$num);
		}
		$form_action = "ebayapi";
?>
		
		<table border="0" cellpadding="0" cellspacing="4" width="100%" class="formArea">
		<tr>
			<td class="main"><?php echo TEXT_INTRO_TIMER; ?></td>
		</tr>
		</table>
		<br>
<?php		
		echo xtc_draw_form($form_action, 'ebayapi_relist.php','', 'post');
?>
			<table border="0" cellpadding="1" cellspacing="0" width="100%">
			<tr class="dataTableHeadingRow">
				<td valign="top" class="dataTableHeadingContent">&nbsp;</td>
				<td valign="top" class="dataTableHeadingContent" width="100"><?php echo TABLE_HEADING_TITLE; ?></td>
				<td valign="top" class="dataTableHeadingContent"><?php echo TABLE_HEADING_CATEGORY; ?></td>
				<td valign="top" align="center" class="dataTableHeadingContent"><?php echo TABLE_HEADING_QTY; ?></td>
				<td valign="top" align="center" class="dataTableHeadingContent"><?php echo TABLE_HEADING_AUCTION; ?></td>
				<td valign="top" align="center" class="dataTableHeadingContent" width="120"><?php echo TABLE_HEADING_BIN; ?></td>
				<td valign="top" align="center" class="dataTableHeadingContent"><?php echo TABLE_HEADING_DURATION; ?></td>
				<td valign="top" align="center" class="dataTableHeadingContent"><?php echo TABLE_HEADING_STARTTIME; ?></td>
			</tr>

<?php
		if($_POST["START_YEAR"]){
			$timestring = $_POST["START_YEAR"]."-".$_POST["START_MONTH"]."-".$_POST["START_DAY"]." ".$_POST["START_HOUR"].":".$_POST["START_MINUTE"].":00";
			$timestamp = strtotime($timestring);
		}
		$add_time_delay = 0;
		if(is_array($_GET['id'])){
			$VARID = $_GET['id'];
			$get = true;
		}else{
			$VARID = $_POST['id'];
			$get = false;
		}
		for($i=0;$i<count($VARID);$i++){
			$timestamp += $add_time_delay;
			$time_europe = date("d.m.Y H:i",$timestamp);
			$time_db = date("Y-m-d H:i:s",$timestamp);
			$add_time_delay = $_POST["START_INTERVALL"]*60;

			$products_query = xtc_db_query("SELECT * FROM ebay_auctions WHERE id='".$VARID[$i]."'");
			$products = xtc_db_fetch_array($products_query);
                        
			$products = xtc_db_prepare_input($products);

			$site = $EBAYAPI->get_site_id_from_name($products['site']);
			$favorite_query = xtc_db_query("SELECT favorite_title FROM ebayapi_favorites WHERE favorite_ebayid='".$products['category']."' and site='".$site."'");
			if(xtc_db_num_rows($favorite_query)){
				$favorite = xtc_db_fetch_array($favorite_query);
				$fav = xtc_db_prepare_input($favorite);
				$cat = '<b>'.$products['site'].':</b> '.substr($fav['favorite_title'],0,50);
			}else
				$cat = '<font color="red">'.TEXT_ERROR_CATEGORY_INVALID.'</font>';

			$class = (is_int($i/2)) ? '<tr class="dataTableRowSelected">' : '<tr class="dataTableRow">';
			$tr = (!empty($bgcolor)) ? $bgcolor : $class;

			switch($products["ebay_angebotsformat"]){
				case '1':
					$auction_icon = xtc_image(DIR_WS_IMAGES."ebay_icon_auction.gif",TEXT_AUCTION);
					break;
				case '9':
					$auction_icon = xtc_image(DIR_WS_IMAGES."ebay_icon_fixprice.gif",TEXT_FIXEDPRICE);
					break;
			}
			echo "\n\t<td valign=\"top\" class=\"dataTableContent\">" . $auction_icon.xtc_draw_checkbox_field("id[]", $products["id"], $checked = ($VARID[$i] == $products["id"]) ? true : false) . "</td>";
			echo "\n\t<td valign=\"top\" class=\"dataTableContent\">".$products["title"]."</td>";
			echo "\n\t<td valign=\"top\" class=\"dataTableContent\">".$cat."</td>";
			echo "\n\t<td valign=\"top\" class=\"dataTableContent\" align=\"center\">".$products["quantity"]."</td>";
			echo "\n\t<td valign=\"top\" class=dataTableContent align=right>" . number_format($products["auctionprice"],2,',','') . "</td>";
			echo "\n\t<td valign=\"top\" class=dataTableContent align=right>" . number_format($products["buyitnowprice"],2,',','') . "</td>";
			echo "\n\t<td valign=\"top\" class=dataTableContent align=\"right\">" . $products["duration"] . "&nbsp;</td>";

			$start = "";
			if($_POST["action"] == "timeset_process") {
				$start  = $time_europe;
				$start .= xtc_draw_hidden_field("timestamp[]", $time_db);
			}
			$start .= "";
			echo "\n\t<td valign=\"top\" class=\"dataTableContent\" align=\"right\">" . $start . "&nbsp;</td>";
			echo "</tr>\n";
		}
?>
		<tr>
			<td colspan="8"><?php echo xtc_image('images/pixel_trans.gif'); ?></td>
		</tr>
		<tr class="dataTableHeadingRow">
			<td colspan="8" class="main"><a href="javascript:selectall('ebayapi','id[]',true);"><?php echo TEXT_SELECT_ALL; ?></a><br><a href="javascript:selectall('ebayapi','id[]');"><?php echo TEXT_UNSELECT_ALL; ?></a></td>
		</tr>
		<tr class="dataTableRowSelected">
			<td colspan="8">
		<?php
		echo "<table border='0'><tr>";
		echo "<td class='messageBox'>".TEXT_DAY."</td><td>".xtc_draw_pull_down_menu("START_DAY",$day,$default_day,"size='1'")."</td>";
		echo "<td class='messageBox'>".TEXT_MONTH."</td><td>".xtc_draw_pull_down_menu("START_MONTH",$month,$default_month,"size='1'")."</td>";
		echo "<td class='messageBox'>".TEXT_YEAR."</td><td>".xtc_draw_pull_down_menu("START_YEAR",$year,$default_year,"size='1'")."</td>";
		echo "<td class='messageBox'>".TEXT_HOUR."</td><td>".xtc_draw_pull_down_menu("START_HOUR",$hour,$default_hour,"size='1'")."</td>";
		echo "<td class='messageBox'>".TEXT_MINUTE."</td><td>".xtc_draw_pull_down_menu("START_MINUTE",$minute,$default_minute,"size='1'")."</td>";
		echo "</tr><tr>";
		echo "<td class='messageBox' colspan='2'>* ".TEXT_INTERVALL."</td><td colspan='2' class='messageBox'>".xtc_draw_pull_down_menu("START_INTERVALL",$intervall,$default_intervall,"size='1'")."</td>";
		echo "<td colspan='6' class='messageBox' align='right'>";
		if($_POST["action"] == "timeset_process") {
			echo "<input type='checkbox' name='save' value='1' /> ".TEXT_INFO_SAVE_TIMING."&nbsp; &nbsp;";
			echo "<input type='button' value='".TEXT_BUTTON_ALLOCATE."' onClick='confirmaction();' />";
		}else{
			echo "<input type='button' value='".TEXT_BUTTON_ALLOCATE_PREVIEW."' onClick='confirmaction();'>";
		}
		echo "</td></tr></table>";
		echo xtc_draw_hidden_field("action", "timeset_process");
		?>
			</td>
		</tr>
		</form>
		</table>
		<br /><span class="smallText">* <?php echo sprintf(TEXT_INFO_EDIT_TIMEDELAYS,xtc_href_link('ebayapi_timerdelays.php')); ?></span>
<?php
		break;
}
?>

</td>
 </tr>
</table>
<?php require(DIR_WS_INCLUDES . 'footer.php'); ?>					
<?php require(DIR_WS_INCLUDES . 'application_bottom.php'); ?>					
