<?php
/*------------------------------------------------------------------------------

   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *

                                              Author M. ASPELEITER <dazze@gmx.de
                                             Copyright (c) 2004 mario aspeleiter

   ---------------------------------------------------------------------------*/
require('includes/application_top.php');
require_once(DIR_FS_ADMIN.DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_FS_ADMIN.DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_FS_INC.'yes_extract_buyandnow_char.inc.php');
include(DIR_WS_CLASSES.'class.yes_lister.php');

function _xtc_get_ebay_site_id_name($site){
	global $EBAYAPI;
	return $EBAYAPI->get_site_name_from_id($site);
}
function _get_title($title){
	return '<a href="javascript:;" onclick="scroll(0,0);">'.$title.'</a>';
}
$EBAYAPI = new EbayAPI;
$basics = new basics;

// WELCHE ATTRIBUTE PARSEN?
$attribute_id_array = array('10244','3803','3804','1905','2136','3805');


$smarty = new yesSmarty;

$ebay_sites = array();
$ebay_sites_query = xtc_db_query("SELECT * FROM ebay_sites ORDER BY site_name");
while($ebay_sites_res = xtc_db_fetch_array($ebay_sites_query)){
	$ebay_sites[] = array('id'=>$ebay_sites_res['id'],'text'=>$ebay_sites_res['site_name']);
}
$update_specifics_limit = 10; //10
$repair_limit = 50; // 50
if(isset($_GET['action']) ){
	switch($_GET['action']){
	    case 'update_specifics_confirm':
		$query = xtc_db_query(
			"SELECT favorite_id FROM ebayapi_favorites"
		);
		$mod = xtc_db_num_rows($query) % $update_specifics_limit;
		if($mod > 0){
		    $steps = ((xtc_db_num_rows($query)-$mod) / $update_specifics_limit)+1;
		}else{
		    $steps = xtc_db_num_rows($query) / $update_specifics_limit;
		}
		$smarty->assign(array(
		    'TEXT_UPDATE_HEADER'=>sprintf(TEXT_UPDATE_BRANDMPN_HEADER,xtc_db_num_rows($query),$steps),
		    'STEPS'=>$steps,
		    'LIMIT'=>$update_specifics_limit,
		    'TEXT_UPDATE_SUCCESS'=>TEXT_UPDATE_BRANDMPN_SUCCESS,
		    'UPDATE_URL'=>xtc_href_link('ebayapi_favorite_category.php','action=update_specifics')
		));
		$smarty->display('ebayapi_favorite_category_update.html');
		exit;
		break;
	case 'update_specifics':
		$start = (isset($_REQUEST['start'])) ? (int)xtc_db_input($_REQUEST['start']) : 0;
		$limit = $update_specifics_limit;
		$query = xtc_db_query(sprintf(
			"SELECT favorite_id,favorite_title,favorite_ebayid,site FROM ebayapi_favorites ORDER BY favorite_id LIMIT %s,%s",
			$start, $limit
		));
		$num = xtc_db_num_rows($query);
		while($record = xtc_db_fetch_array($query)){
			$token = json_decode($EBAYAPI->sdk_getOAuthToken());
			$site = $EBAYAPI->get_site_name_from_id($record['site']);
			$sdk_site_id = ebayApi::get_sdk_sitecode_from_site($site);
			$res = $EBAYAPI->sdk_taxonomy_caller( $token->TOKEN, 'GetADefaultCategoryTreeId', array(
			    'SITE_ID'=>$sdk_site_id
			));
			$CATEGORY_TREE_ID = $res->categoryTreeId;
			$res = $EBAYAPI->sdk_taxonomy_caller( $token->TOKEN, 'GetItemAspectsForCategory', array(
			    'CATEGORY_TREE_ID'=>$CATEGORY_TREE_ID,
			    'CATEGORY_ID'=>$record['favorite_ebayid']
			));
			$update_sql_array = array(
			    'mpn_alias'=>'',
			    'brand_alias'=>''
			);
			foreach($res->aspects as $AS){
			    if($AS->aspectConstraint->aspectRequired == 1){
			    
				if($EBAYAPI->is_ebay_brand_alias($AS->localizedAspectName, $record['site'])){
				    $update_sql_array[ 'brand_alias' ] = $AS->localizedAspectName;
				}
				if($EBAYAPI->is_ebay_mpn_alias($AS->localizedAspectName, $record['site'])){
				    $update_sql_array[ 'mpn_alias' ] = $AS->localizedAspectName;
				}
			    }
			}
			xtc_db_perform('ebayapi_favorites',$update_sql_array,'update',"favorite_id='".$record['favorite_id']."'");
		}
		if($num < 1){
		    $msg = 'eBay Kategorie MPN/Brand Felder aktualisiert';
		}else{
		    $msg = '';
		    //xtc_redirect(xtc_href_link(basename(__FILE__),'action=update_specifics&start='.($start+$limit)));
		}
		die(json_encode(array(
		    'MSG'=>$msg,
		    'OUTDATED'=>array() // spielt bei repair eine rolle
		)));
		break;
	    case 'delete_multiple':

		    if(!is_array($_REQUEST['fID']))
			    $_REQUEST['fID'] = array($_REQUEST['fID']);
		    $cart_items = array();
		    for($i=0;$i<sizeOf($_REQUEST['fID']);$i++){
			    $fID = (int)xtc_db_input($_REQUEST['fID'][$i]);
			    $query = xtc_db_query(sprintf("SELECT COUNT(ep.id) as anz,ef.favorite_title FROM ebay_products ep LEFT JOIN ebayapi_favorites ef ON ep.ebay_kategorie=ef.favorite_ebayid WHERE ef.favorite_id='%s'",$fID));
			    $record = xtc_db_fetch_array($query);
			    $cart_items[ $fID ] = array(
				'COUNT'=>$record['anz'],
				'CATEGORY'=>$record['favorite_title']
			    );
		    }
		    printf('<div class="smallText"><form action="%s" method="post"><table class="yesListTable_minimal" width="100%%">',
			    xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('fID','action')).'action=delete_multiple_process')
		    );
		    echo '<thead>';
		    echo '<tr>';
		    echo '  <th>&nbsp;</th>';
		    echo '  <th>'.TEXT_CART_ITEMS.'</th>';
		    echo '  <th>'.TEXT_EBAYCATEGORY.'</th>';
		    echo '</tr>';
		    echo '</thead>';
		    echo '<tfoot>';
		    printf('	<th colspan="3"><input type="submit" value="%s" class="ui-button ui-corner-all ui-state-default" /></th>',IMAGE_SAVE);
		    echo '</tfoot>';
		    echo '<tbody>';
		    foreach($cart_items as $fID=>$ci){
			$checked = ($ci['COUNT'] > 0) ? false : true;
			if($checked){
			    echo '<tr>';
			}else{
			    echo '<tr class="highlight">';
			}
			printf('<td>%s</td><td>%s</td><td>%s</td>',xtc_draw_checkbox_field('fID[]',$fID,$checked),$ci['COUNT'],$ci['CATEGORY']);
			echo '</tr>';
		    }
		    echo '</tbody>';
		    echo '</table></form></div>';
		    header('Content-Type: text/html; charset='.CHARSET);
		    exit;
		    break;
		case 'delete_multiple_process':
		    if(!is_array($_REQUEST['fID']))
			    $_REQUEST['fID'] = array($_REQUEST['fID']);
		    for($i=0;$i<sizeOf($_REQUEST['fID']);$i++){
			    $fID = (int)xtc_db_input($_REQUEST['fID'][$i]);
			    $feID_query = xtc_db_query(sprintf("SELECT favorite_ebayid FROM ebayapi_favorites WHERE favorite_id='%s'",$fID));
			    $feID_res = xtc_db_fetch_array($feID_query);
			    $feID = $feID_res['favorite_ebayid'];
			    xtc_db_query("DELETE FROM ebayapi_favorites_characteristics WHERE ebayapi_favorites_id='".$fID."'");
			    xtc_db_query("DELETE FROM ebayapi_favorites_itemconditions WHERE favorite_ebayid='".$feID."'");
			    xtc_db_query("DELETE FROM ebayapi_favorites WHERE favorite_id='".$fID."'");
		    }
		    $messageStack->add_session(MSG_SUCCESS_DELETE_MULTIPLE,'success');
		    xtc_redirect(xtc_href_link('ebayapi_favorite_category.php','menugroup=interfaces'));
		    break;
		case 'repair_confirm':
		    $query = xtc_db_query("SELECT favorite_id FROM ebayapi_favorites");
		    $mod = xtc_db_num_rows($query) % $repair_limit;
		    if($mod > 0){
			$steps = ((xtc_db_num_rows($query)-$mod) / $repair_limit)+1;
		    }else{
			$steps = xtc_db_num_rows($query) / $repair_limit;
		    }
		    $smarty->assign(array(
			'TEXT_UPDATE_HEADER'=>sprintf(TEXT_REPAIR_HEADER,xtc_db_num_rows($query),$steps),
			'STEPS'=>$steps,
			'LIMIT'=>$repair_limit,
			'TEXT_UPDATE_SUCCESS'=>TEXT_REPAIR_SUCCESS,
			'UPDATE_URL'=>xtc_href_link('ebayapi_favorite_category.php','action=repair')
		    ));
		    $smarty->display('ebayapi_favorite_category_update.html');
		    exit;
		    break;
		case 'repair':
			$start = (isset($_REQUEST['start']))?$_REQUEST['start']:0;
			$max = $repair_limit;
			$query = xtc_db_query("SELECT count(favorite_id) as anz FROM ebayapi_favorites");
			$res = xtc_db_fetch_array($query);
			$anz = $res['anz'];
			$diff = $anz % $max;
			$pages = ($anz - $diff)/$max;
			if($diff > 0){
				$pages++;
                        }
			$query = xtc_db_query("SELECT * FROM ebayapi_favorites LIMIT $start, $max");
			$num = xtc_db_num_rows($query);
			$favorites_array = array();
			while($row = xtc_db_fetch_array($query)){
			    $favorites_array[] = $row;
			}
			$outdated = array();
			foreach($favorites_array as $row){
				$site = $row['site'];
				$site_name = $EBAYAPI->get_site_name_from_id($site);
				xtc_db_query("DELETE FROM ebayapi_favorites_itemconditions WHERE favorite_ebayid='".$row['favorite_ebayid']."' and site='".$site."'");
                                
				$features = yes_get_ebay_category_features($site_name, $row['favorite_ebayid']);
				if(isset($features->ConditionValues) and is_countable($features->ConditionValues->Condition) and sizeOf( $features->ConditionValues->Condition )){
					foreach($features->ConditionValues->Condition as $condition){
						$insert_sql_array = array(
								'favorite_ebayid'=>$row['favorite_ebayid'],
								'condition_id'=>$condition->ID,
								'condition_name'=>$condition->DisplayName,
								'site'=>$site
						);
						xtc_db_perform('ebayapi_favorites_itemconditions',$insert_sql_array);
					}
				}else{
					$outdated[] = sprintf(
								'Kategorie %s (ID: %s) scheint veraltet oder deaktiviert.',
								yes_encode_string($row['favorite_title']),$row['favorite_ebayid']
					);
				}
			}
			die(json_encode(array(
			    'MSG'=>'',
			    'OUTDATED'=>$outdated
			)));
			break;
		case 'save':
		    if(!isset($_POST['favorite_ebayid']) or (int)$_POST['favorite_ebayid'] == 0){
				$messageStack->add_session(MSG_ERROR_NO_CATEGORY_SELECTED,'error');
				xtc_redirect(xtc_href_link('ebayapi_favorite_category.php'));
		    }
			$check_query = xtc_db_query("SELECT favorite_id FROM ebayapi_favorites WHERE favorite_ebayid='".(int)xtc_db_input($_POST['favorite_ebayid'])."' and site='".(int)xtc_db_input($_POST['site'])."'");
			if( xtc_db_num_rows($check_query) > 0 ){
				$messageStack->add_session(MSG_ERROR_ALREADY_SAVED,'error');
				xtc_redirect(xtc_href_link('ebayapi_favorite_category.php'));
			}else{
				if(isset($_POST['site']) and xtc_not_null($_POST['site'])){
					$site = xtc_db_input($_POST['site']);
				}else{
					if((int) EBAY_SITE_ID > 0)
						$site = EBAY_SITE_ID;
					else
						$site = $EBAYAPI->get_site_id_from_name(EBAY_SITE_ID);
				}
				$catID = (isset($_REQUEST['favorite_ebayid'])) ? xtc_db_input($_POST['favorite_ebayid']) : 0;
                                
				$site_name = $EBAYAPI->get_site_name_from_id($site);
				// Check
				$res = $EBAYAPI->get_ebay_category('',$catID,$site);
				$path = $res->Category->CategoryParentID;
				$level = $res->Category->CategoryLevel;
				$cname = $res->Category->CategoryName;
				$path_string = $EBAYAPI->get_ebay_category_path( $path,$level,$site ).$cname;


				xtc_db_query("INSERT INTO ebayapi_favorites SET favorite_ebayid='".$catID."',favorite_title='".xtc_db_input($path_string)."',site='".$site."',date_saved=now()");
				$favorites_id = xtc_db_insert_id();
				xtc_db_query("DELETE FROM ebayapi_favorites_itemconditions WHERE favorite_ebayid='".$catID."' AND site='".$site."'");
				$features = yes_get_ebay_category_features($site_name, $catID);
				if(!empty($features->ConditionEnabled)){
					$conditions = $features->ConditionValues;
					foreach($conditions->Condition as $condition){
						$insert_sql_array = array(
								'favorite_ebayid'=>$catID,
								'condition_id'=>$condition->ID,
								'condition_name'=>$condition->DisplayName,
								'site'=>$site
						);
						xtc_db_perform('ebayapi_favorites_itemconditions',$insert_sql_array);
					}
				}
				$messageStack->add_session(MSG_SUCCESS_SAVED,'success');
				xtc_redirect(xtc_href_link('ebayapi_favorite_category.php'));
			}
			break;
		case 'choose':
			if(isset($_GET['view']) and $_GET['view'] == 'off'){
				exit;
            }
			if(isset($_GET['view']) and $_GET['view']>0){
				$act = 0;
				if(isset($_GET['site'])){
					$site = $_GET['site'];
				}else{
					$site = $EBAYAPI->get_site_id_from_name(EBAY_SITE_ID);
				}
				switch($_GET['view']){

					case '1':
						$cats = $EBAYAPI->get_ebay_category($level = $_GET['view'],$parent = '0',$site);
						break;
					case '2':
						$cats = $EBAYAPI->get_ebay_category($level = $_GET['view'],$parent = $_GET['step1'],$site);
						$act = $_GET['step1'];
						break;
					case '3':
						$cats = $EBAYAPI->get_ebay_category($level = $_GET['view'],$parent = $_GET['step2'],$site);
						$act = $_GET['step2'];
						break;
					case '4':
						$cats = $EBAYAPI->get_ebay_category($level = $_GET['view'],$parent = $_GET['step3'],$site);
						$act = $_GET['step3'];
						break;
					case '5':
						$cats = $EBAYAPI->get_ebay_category($level = $_GET['view'],$parent = $_GET['step4'],$site);
						$act = $_GET['step4'];
						break;
					case '6':
						$cats = $EBAYAPI->get_ebay_category($level = $_GET['view'],$parent = $_GET['step5'],$site);
						$act = $_GET['step5'];
						break;
				}
				if(strpos(get_class($cats),'CategoryArrayType')<0){
					if( strpos(get_class($cats[0]),'ErrorType') > -1){
						die(sprintf(
								'<span style="font-size: 10px;font-family: system, fixed, sans-serif;"><b>eBay API Fehler</b><br /><i>Seller: %s/Site: %s</i><br />%s</b><br /><span style="color: #555;">%s</span></span>',
								EBAY_USER,
								$site,
								$cats[0]->ShortMessage,
								$cats[0]->LongMessage
						));
					}
				}
				$cat_select = array();
				$js_array = array();
				if(is_countable($cats->Category)){
					foreach($cats->Category as $k=>$cat){
						if($cat->CategoryID != $act){
							$leaf = $cat->LeafCategory==true;
							$cat_select[] = array(
								'id'=>$cat->CategoryID,
								'text'=>$cat->CategoryName.(($leaf)?'':'->')
							);
							$js_array[] = array(
								'category_id'=>$cat->CategoryID,
								'is_leaf'=>($leaf)?1:0
							);
						}
					}
				}
				$smarty->assign('js_data',$js_array);
				switch($_GET['view']){
					case '1':
						$form = xtc_draw_form('cat0','#','','GET');
						$input = xtc_draw_pull_down_menu('ebay_cat0',$cat_select,'','size="12" onChange="sel(\'0\');" style="width:100%;height:100%;"');
						break;
					case '2':
						$form = xtc_draw_form('cat1','#','','GET');
						$input = xtc_draw_pull_down_menu('ebay_cat1',$cat_select,'','size="12" onChange="sel(\'1\');" style="width:100%;height:100%;"');
						break;
					case '3':
						$form = xtc_draw_form('cat2','#','','GET');
						$input = xtc_draw_pull_down_menu('ebay_cat2',$cat_select,'','size="12" onChange="sel(\'2\');" style="width:100%;height:100%;"');
						break;
					case '4':
						$form = xtc_draw_form('cat3','#','','GET');
						$input = xtc_draw_pull_down_menu('ebay_cat3',$cat_select,'','size="12" onChange="sel(\'3\');" style="width:100%;height:100%;"');
						break;
					case '5':
						$form = xtc_draw_form('cat4','#','','GET');
						$input = xtc_draw_pull_down_menu('ebay_cat4',$cat_select,'','size="12" onChange="sel(\'4\');" style="width:100%;height:100%;"');
						break;
					case '6':
						$form = xtc_draw_form('cat5','#','','GET');
						$input = xtc_draw_pull_down_menu('ebay_cat5',$cat_select,'','size="12" onChange="sel(\'5\');" style="width:100%;height:100%;"');
						break;
				}
				$smarty->assign('FORM',$form);
				$smarty->assign('INPUT_CATEGORIES',$input);
				$smarty->assign('link1',xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('step1','view')).'view=2'));
				$smarty->assign('link2',xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('step1','view')).'view=3'));
				$smarty->assign('link3',xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('step1','view')).'view=4'));
				$smarty->assign('link4',xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('step1','view')).'view=5'));
				$smarty->assign('link5',xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('step1','view')).'view=6'));
				$smarty->assign('linkclean',xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('view')).'view=off'));
				$smarty->assign('IFRAME','1');
				$html=$smarty->fetch('favorite_category.html');
				echo $html;
				exit;
			}
			if($_POST['site'] != '') {
				$site = $_POST['site'];
			}else{
				$site = $EBAYAPI->get_site_id_from_name(EBAY_SITE_ID);
			}
			$smarty->assign('FORM',"<form name='sites' action='".xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('site')))."' method='post'>");
			$smarty->assign('INPUT_SITE',xtc_draw_pull_down_menu('site',$ebay_sites,(($_POST['site']!='') ? $_POST['site'] : EBAY_SITE_ID),'onChange="document.forms[\'sites\'].submit();"'));
            $iframe_src = xtc_href_link('ebayapi_favorite_category.php',xtc_get_all_get_params(array('view')).'view=1&site='.$site);
			$smarty->assign('IFRAME_SRC',$iframe_src);
			$smarty->assign('CATEGORY_POPUP','1');
			$html=$smarty->fetch('favorite_category.html');
			echo $html;
			exit;
			break;
	}
}
if(isset($_REQUEST['fID'])){
	$box_action = (isset($_GET['action'])) ? $_GET['action'] : '';
	$fID = (int)xtc_db_input($_GET['fID']);
	if($fID){
		$query = xtc_db_query(sprintf("SELECT * FROM ebayapi_favorites WHERE favorite_id='%s'",$fID));
		$res = xtc_db_fetch_array($query);
		$fInfo = new objectInfo($res);
	}
	switch ($box_action) {
		case 'new':
			$heading[] = array('text' => '<b>'.TEXT_ADD_FAVORITE.'</b>');
			$contents = array('form' => xtc_draw_form('favo', 'ebayapi_favorite_category.php','action=save'));
			$contents[] = array('text' => TEXT_EBAYCATEGORY);
			$contents[] = array('text' => xtc_draw_input_field('favorite_ebayid','') . '<br /><a href="#" onClick="javascript:window.open(\'ebayapi_favorite_category.php?action=choose\',\'popup\',\'width=800,height='.EXT_POPUP_HEIGHT.',resizable=yes,scrollbars=yes\');">['.TEXT_SELECT_CATEGORY.']</a>' );
			$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
					IMAGE_SAVE,
					"javascript:this.form.submit();",
					'width:120px;').'&nbsp;'.yes_draw_href_button(
					IMAGE_CANCEL,
					xtc_href_link('ebayapi_favorite_category.php'),
					'width:120px;').xtc_draw_hidden_field('site','')
			);
			break;
		case 'replace_process':
			if(!isset($_REQUEST['fID']) or !isset($_REQUEST['replace_category']) or $_REQUEST['replace_category'] == ''){
				$messageStack->add_session(MSG_ERROR_NO_REPLACE_CATEGORY,'error');
				xtc_redirect(xtc_href_link('ebayapi_favorite_category.php'));
			}
			$fID = (int)xtc_db_input($_REQUEST['fID']);
			$rcatID = (int)xtc_db_input($_REQUEST['replace_category']);
			$catID = (int)xtc_db_input($_REQUEST['category']);
			xtc_db_query(sprintf(
				"UPDATE ebay_products SET ebay_kategorie=%s WHERE ebay_kategorie=%s",
				$rcatID,$catID
			));
			xtc_db_query(sprintf(
				"UPDATE ebay_products SET ebay_kategorie2=%s WHERE ebay_kategorie2=%s",
				$rcatID,$catID
			));
			xtc_db_query(sprintf(
				"UPDATE ebay_sammler SET category=%s WHERE category=%s",
				$rcatID,$catID
			));
			xtc_db_query(sprintf(
					"UPDATE ebay_sammler SET category2=%s WHERE category2=%s",
				$rcatID,$catID
			));
			if(isset($_REQUEST['delete']) and $_REQUEST['delete'] == 1){
				xtc_db_query(sprintf("DELETE FROM ebayapi_favorites WHERE favorite_id=%s",
					$fID
				));
			}
			$messageStack->add_session(MSG_SUCCESS_REPLACE_CATEGORY,'success');
			xtc_redirect(xtc_href_link('ebayapi_favorite_category.php'));
			break;
		case 'delete_process':
			xtc_db_query("DELETE FROM ebayapi_favorites WHERE favorite_id='".$fID."'");
			xtc_db_query("DELETE FROM ebayapi_favorites_characteristics WHERE ebayapi_favorites_id='".$fID."'");
			xtc_db_query("DELETE FROM ebayapi_favorites_itemconditions WHERE favorite_ebayid='".$fInfo->favorite_ebayid."'");
			$messageStack->add_session(MSG_SUCCESS_DELETE,'success');
			xtc_redirect(xtc_href_link('ebayapi_favorite_category.php'));
			break;
		case 'replace':
			$heading[] = array('text' => '<b>'.TEXT_CONFIRM_REPLACE.'</b>');
			$contents = array('form' => xtc_draw_form('favo_replc', 'ebayapi_favorite_category.php','action=replace_process&fID='.$fInfo->favorite_id.'&category='.$fInfo->favorite_ebayid));
			$contents[] = array('text' => TEXT_CONFIRM_REPLACE_INTRO);
			$contents[] = array('text' => '<b>'.TEXT_REPLACE_EBAYCATEGORY.':</b>');
			$query = xtc_db_query(sprintf(
				"SELECT favorite_ebayid,favorite_title FROM ebayapi_favorites WHERE favorite_id!=%s ORDER BY favorite_ebayid",
				$fInfo->favorite_id
			));
			$replace_array = array(0=>array('id'=>'','text'=>TEXT_SELECT));
			while($row = xtc_db_fetch_array($query)){
				$replace_array[] = array('id'=>$row['favorite_ebayid'],'text'=>$row['favorite_ebayid'].' '.$row['favorite_title']);
			}
			$contents[] = array('text' => xtc_draw_pull_down_menu('replace_category',$replace_array));
			$contents[] = array('text' => TEXT_DELETE_AT_REPLACE.' &nbsp; '.xtc_draw_checkbox_field('delete','1',true));
			$query = xtc_db_query(sprintf(
					"SELECT COUNT(id) as anz FROM ebay_products WHERE ebay_kategorie=%s OR ebay_kategorie2=%s",
					$fInfo->favorite_ebayid,$fInfo->favorite_ebayid
			));
			$record = xtc_db_fetch_array($query);
			$contents[] = array('text' => TEXT_NUMBER_OF_CARTITEMS.': '.$record['anz']);
			
			$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
					BUTTON_REPLACE_CATEGORY,
					"javascript:this.form.submit();",
					'width:120px;').'&nbsp;'.yes_draw_href_button(
					IMAGE_CANCEL,
					"javascript:ajax_box_action('".$fInfo->favorite_id."','');",
					'width:120px;')
			);
			break;
		case 'delete':
			$heading[] = array('text' => '<b>'.TEXT_CONFIRM_DELETE.'</b>');
			$contents = array('form' => xtc_draw_form('favo', 'ebayapi_favorite_category.php','action=delete_process&fID='.$fInfo->favorite_id));
			$contents[] = array('text' => '<b>'.TABLE_HEADING_EBAY_CATEGORY_ID.':</b> '.$fInfo->favorite_ebayid);
			$contents[] = array('text' => '<b>'.TABLE_HEADING_TITLE.':</b> '.$fInfo->favorite_title);
			$contents[] = array('text' => '<b>'.TABLE_HEADING_SITE.':</b> '.$EBAYAPI->get_site_name_from_id($fInfo->site));
			
			$query = xtc_db_query(sprintf("SELECT COUNT(ep.id) as anz,ef.favorite_title FROM ebay_products ep LEFT JOIN ebayapi_favorites ef ON ep.ebay_kategorie=ef.favorite_ebayid WHERE ef.favorite_id='%s'",$fInfo->favorite_id));
			$record = xtc_db_fetch_array($query);
			if($record['anz'] > 0){
			    $contents[] = array('class'=>'errorText','text' => '<br />'.xtc_image('images/icons/warning.gif').'&nbsp;'.sprintf(TEXT_WARNING_CART_ITEM_EXISTS,$record['anz']));
			}
			
			$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
					IMAGE_DELETE,
					"javascript:this.form.submit();",
					'width:120px;').'&nbsp;'.yes_draw_href_button(
					IMAGE_CANCEL,
					"javascript:ajax_box_action('".$fInfo->favorite_id."','');",
					'width:120px;')
			);
			break;
		default:
			if (isset($fInfo) and is_object($fInfo)) {
				$heading[] = array('text' => '<b>'.TEXT_EBAYCATEGORY.'</b>');
				$contents[] = array('text' => '<b>'.TABLE_HEADING_EBAY_CATEGORY_ID.':</b> '.$fInfo->favorite_ebayid);
				$contents[] = array('text' => '<b>'.TABLE_HEADING_TITLE.':</b> '.$fInfo->favorite_title);
				$contents[] = array('text' => '<b>'.TABLE_HEADING_SITE.':</b> '.$EBAYAPI->get_site_name_from_id($fInfo->site));
				$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
						BUTTON_REPLACE_CATEGORY,
						"javascript:ajax_box_action('".$fInfo->favorite_id."','replace');",
						'width:120px;')
				);
				$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
						IMAGE_DELETE,
						"javascript:ajax_box_action('".$fInfo->favorite_id."','delete');",
						'width:120px;')
				);
			}
			break;
	}
	$box = new box;
	header('Content-Type: text/html; charset='.CHARSET);
	echo $box->infoBox($heading, $contents);
	exit;
}
$action = (isset($_REQUEST['action'])) ? $_REQUEST['action'] : '';

$order_by = (isset($_GET['order_by'])) ? xtc_db_input($_GET['order_by']) : 'favorite_title DESC';
$query_raw = "select favorite_id,favorite_id as favorite_id2,favorite_ebayid,favorite_title,site,date_saved from ebayapi_favorites order by ".$order_by;
$page = (isset($_GET['page'])) ? $_GET['page'] : 1;
$sammler_split = new splitPageResults($page, $view_limit = MAX_DISPLAY_SEARCH_RESULTS, $query_raw, $query_numrows);
function _get_favorite_checkbox($id){
	return xtc_draw_checkbox_field('id[]', $id, false);
}
$select_field_array = array(
		0=>array(
			'field'=>'favorite_id',
			'heading'=>TABLE_HEADING_ID,
			'format'=>'string',
			'function'=>'_get_favorite_checkbox',
			'get_param'=>'fID',
			'sortable'=>1,
			'index'=>true,
			'column'=>0
		),
		1=>array(
			'field'=>'favorite_ebayid',
			'heading'=>TABLE_HEADING_EBAY_CATEGORY_ID,
			'format'=>'string',
			'get_param'=>'feb',
			'sortable'=>0,
			'column'=>1
		),
		2=>array(
			'field'=>'favorite_title',
			'heading'=>TABLE_HEADING_TITLE,
			'format'=>'string',
			'function'=>'_get_title',
			'get_param'=>'fttl',
			'sortable'=>1,
			'column'=>2
		),
		3=>array(
			'field'=>'site',
			'heading'=>TABLE_HEADING_SITE,
			'format'=>'string',
			'get_param'=>'fst',
			'sortable'=>1,
			'function'=>'_xtc_get_ebay_site_id_name',
			'column'=>3
		),
		4=>array(
			'field'=>'date_saved',
			'heading'=>TABLE_HEADING_DATE_ADDED,
			'format'=>'date',
			'get_param'=>'dt',
			'sortable'=>1,
			'column'=>4
		)
);
$listing_smarty = $smarty;
$list_actions = array(
	0=>array('title'=>TEXT_SELECT,'function'=>''),
	1=>array('title'=>IMAGE_DELETE,'function'=>'delete_favorites')
);
$YL = new yes_lister($query_raw,'ebayapi_favorites','ebayapi_favorite_category.php',$select_field_array,$where_array = array(),$ajax_box = 1,$ajax_get_param_key = 'fID',$ajax_link = 'ebayapi_favorite_category.php','yes_lister_item_table_new.html',$list_actions);
$YL->setSmarty($listing_smarty);
$YL->setFormID('favorite_form');
//$YL->setTableCaption(HEADING_TITLE);
$sInfo = $YL->active_row;
$buttons = array(
    array('text'=>TEXT_ADD_FAVORITE,
	'link'=>"javascript:scroll(0,0);ajax_box_action('','new');",
	'lbOn'=>false,
	'auth'=>true
    ),
    array('text'=>BUTTON_REPAIR,
	'link'=>xtc_href_link('ebayapi_favorite_category.php','action=repair_confirm'),
	'lbOn'=>true,
	'auth'=>true
    ),
    array('text'=>BUTTON_UPDATE_BRANDMPN,
	'link'=>xtc_href_link('ebayapi_favorite_category.php','action=update_specifics_confirm'),
	'lbOn'=>true,
	'auth'=>true
    )
);

$smarty->assign(array(
    'LISTING'=>$YL->display($sammler_split,$query_numrows,MAX_DISPLAY_SEARCH_RESULTS),
    'FORM'=>xtc_draw_form('favorite_form', 'ebayapi_favorite_category.php', xtc_get_all_get_params(array('action','a')).'a=1', 'POST','id="favorite_form_id"'),
    'FORM_END'=>'</form>',
    'HEADING_TITLE'=>HEADING_TITLE,
    'CONFIRM_DELETE_TITLE'=>CONFIRM_DELETE_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
));
$smarty->assign('start_row_input',$YL->start_row_input);
$smarty->assign('SPLIT',$YL->split_string);
$box_html = '';
$heading = array();
$contents = array();
switch($action){
	default:
		$box_html .= '<div id="orderdetails" style="z-index:0;position:absolute;width:250px;margin: 0;padding: 0;" class="ui-widget-content"></div>';
		break;
}

if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    $box_html .= '            <td width="25%" valign="top">' . "\n";

    $box = new box;
    $box_html .= $box->infoBox($heading, $contents);
    $box_html .= '            </td>' . "\n";
}
$smarty->assign('BOX',$box_html);
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<?php
echo $smarty->fetch(DIR_FS_ADMIN.'templates/ebayapi_favorite_category.html');
?>

<?php
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
exit;
