<?php
/**
 * XTC - EBAY API
 * ADD EBAYTRANSACTION AS CHECKOUT PROCESS
 *
 * @version $Id: ebayapi_crontimer.php,v 1.3 2010/10/22 06:55:01 cvs Exp $
 * @copyright 2004
 * @author: mario aspeleiter <dazze@gmx.de>
 **/
require('includes/cron_application_top.php');
require(DIR_FS_INC.'yes_write_notice.inc.php');

/**
 * ALLE AUFTRAEGE IM STATUS UPSELLING UND AELTER ALS X AUF STATUS OFFEN SETZEN
 * AUSSER SOFORTUEBERWEISUNG - HIER MUSS SEPARAT GESCHAUT WERDEN OB
 * DER ZAHLUNGSEINGANG AUCH ERFOLGTE
 */
xtc_db_query("UPDATE ".TABLE_ORDERS." SET orders_status='1' WHERE orders_status='".ORDERS_STATUS_UPSELLING."' && ( UNIX_TIMESTAMP( date_purchased )+".(EBAY_XSELL_DAYSPAN*60*60*24)." ) < UNIX_TIMESTAMP( NOW() ) && (payment_method != 'sofortueberweisung' and payment_method != 'sofortueberweisungredirect')");


/**
 * NUN DIE AUFTRAEGE IM STATUS UPSELLING UND AELTER ALS X MIT BEZAHLART
 * SOFORTUEBERWEISUNG ERMITTELN UND ALS NOTIZ AN ADMIN SENDEN
 */
$query = yes_db_query(sprintf(
	"SELECT orders_id FROM %s WHERE orders_status='%s' && ( UNIX_TIMESTAMP( date_purchased )+%s ) < UNIX_TIMESTAMP( NOW() ) && (payment_method = 'sofortueberweisung' or payment_method = 'sofortueberweisungredirect')",
		TABLE_ORDERS,ORDERS_STATUS_UPSELLING,(EBAY_XSELL_DAYSPAN*60*60*24)
));
$matched_orders = array();
if(yes_db_num_rows($query)){
	$notice_users = main::get_notice_recipients('incoming_payments');
	foreach($query as $record){
		$matched_orders[] = $record['orders_id'];
	}
	$subject = sprintf('%s Sofortueberweisung Auftr&auml;ge in Upselling',
		sizeOf($matched_orders)
	);
	$message = sprintf(
		'Es befinden sich %s Auftr&auml;ge im Status Upselling. Diese Auftr&auml;ge wurden vom Kunden in die Bezahlart "Sofortueberweisung" gesetzt - daher bitte pr&uuml;fen ob die Zahlung auch tats&auml;chlich ausgef&uuml;hrt wurde.<br />Folgende Auftr&auml;ge sind davon betroffen: %s',
		sizeOf($matched_orders),
		implode(', ',$matched_orders)
	);
	yes_write_notice($subject, $message, 0, $notice_users);
}

