<?php
/*------------------------------------------------------------------------------
   
   * * * ----------------------------------------------------------------- * * *
   * * * DIESES SCRIPT IST PRIVAT UND DARF NICHT OHNE DIE AUSDRUECKLICHE   * * *
   * * * GENEHMIGUNG DES AUTORS, WEDER FUER PRIVATE NOCH FUER KOMMERZIELLE * * *
   * * * ZWECKE, VERWENDET WERDEN.                                         * * *
   * * * ----------------------------------------------------------------- * * *
   
                                             Author M. ASPELEITER <dazze@gmx.de>
                                             Copyright (c) 2004 mario aspeleiter
					     
   ---------------------------------------------------------------------------*/

  require('includes/application_top.php');
  require('includes/classes/class.ebay.php');
  require_once('includes/classes/class.ebay_sammler.php');
  define('EBAY_SAMMLER_ADMIN','ebayapi_cart_admin.php');
  if(isset($_GET['action']) and $_GET['action'] == 'view_defaults'){
	$id = xtc_db_input($_GET['id']);
	$cart_query_raw = sprintf("SELECT * FROM ebay_sammler WHERE id='%s'",$id);
	$cart_query = xtc_db_query($cart_query_raw);
	$cart = xtc_db_fetch_array($cart_query);
	print_r($cart);
	exit;
  }
  $EBAYAPI = new ebayApi;
  $action = '';
  if(isset($_GET['action'])){
	  $action = $_GET['action'];
  }
  switch($action){
		case 'update_recommendations':
			if(!isset($_REQUEST['INPUT']) or !is_array($_REQUEST['INPUT'])){
				die('Missing parameters INPUT');
			}
			$id = (int)xtc_db_input($_REQUEST['id']);
			$query = xtc_db_query(sprintf(
				"DELETE FROM ebay_sammler_itemspecifics_recommendations WHERE ebay_sammler_id='%s'",
				$id
			));
			foreach($_REQUEST['INPUT'] as $is_name=>$is_value){
			    if(is_array($is_value)){
				foreach($is_value as $isv){
				    switch($isv){
					case 'A+':
					case 'A++':
					case 'A+++':
					    break;
					default:
					    $isv = urldecode($isv);
					    break;
				    }
				    $insert_sql_array = array(
					    'ebay_sammler_id'=>$id,
					    'is_name'=>urldecode($is_name),
					    'is_value'=>$isv
				    );
				    xtc_db_perform('ebay_sammler_itemspecifics_recommendations',$insert_sql_array);
				}
			    }else{
				// ENERGIEKLASSE BUGFIX
				switch($is_value){
				    case 'A+':
				    case 'A++':
				    case 'A+++':
					break;
				    default:
					$is_value = urldecode($is_value);
					break;
				}
				$insert_sql_array = array(
					'ebay_sammler_id'=>$id,
					'is_name'=>urldecode($is_name),
					'is_value'=>$is_value
				);
				xtc_db_perform('ebay_sammler_itemspecifics_recommendations',$insert_sql_array);
			    }
			}
			$messageStack->add_session(MSG_SUCCESS_RECOMMENDATIONS_UPDATE,'success');
			xtc_redirect(xtc_href_link('ebayapi_cart_admin.php'));
			exit;
			break;
		case 'itemspecifics':
			$smarty = new yesSmarty;

			$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
			$id = (int)xtc_db_input($_REQUEST['id']);
			$es = new ebay_sammler( $id );
			$query = yes_db_query(sprintf(
				"SELECT * FROM ebay_sammler_itemspecifics_recommendations WHERE ebay_sammler_id='%s'",
				$id
			));
			$saved = array();
			foreach($query as $record){
				$saved[ $record['is_name'] ][] = $record['is_value'];
			}
			if($es->getCategory() < 1){
				die(TEXT_MESSAGE_FIRST_CATEGORY_NOT_SAVED);
			}
                        
                        
			$site_id = $EBAYAPI->get_sdk_sitecode_from_site($es->getSite());
			$token = json_decode($EBAYAPI->sdk_getOAuthToken());
			if($token->ERROR != ''){
				die($token->ERROR);
			}
			$res = $EBAYAPI->sdk_taxonomy_caller( $token->TOKEN, 'GetADefaultCategoryTreeId', array(
				'SITE_ID'=>$site_id
			));
			$CATEGORY_TREE_ID = $res->categoryTreeId;
			$res = $EBAYAPI->sdk_taxonomy_caller( $token->TOKEN, 'GetItemAspectsForCategory', array(
				'CATEGORY_TREE_ID'=>$CATEGORY_TREE_ID,
				'CATEGORY_ID'=>$es->getCategory()
			));
			$input_array = $es->get_sdk_recommendations_input_fields($res->aspects);
                        
			$smarty->assign('FORM',xtc_draw_form('recommendations','ebayapi_cart_admin.php','action=update_recommendations&id='.$id));
			$smarty->assign('RECOMMENDATIONS',$input_array);
			$smarty->assign('SAVED',$saved);
			$smarty->assign('FORM_END','</form>');
			$smarty->display('recommendations_select.html');
			exit;
			break;
		case 'quick_edit_category':
			if(!isset($_REQUEST['id']))
				die('Missing Input');
			$sammler = new ebay_sammler((int)xtc_db_input($_REQUEST['id']));
			$db_field = ($_REQUEST['nr'] == '1') ? 'category' : 'category2';
			$title_field = ($_REQUEST['nr'] == 1) ? TEXT_AUCTION_CATEGORY : TEXT_AUCTION_CATEGORY2;
			$saved = ($_REQUEST['nr'] == 1)?$sammler->getCategory():$sammler->getCategory2();
			header('Content-Type: text/html; charset='.CHARSET);
			echo xtc_draw_form('quick_edit_form','ebayapi_cart_admin.php',xtc_get_all_get_params(array('action','field','id')).'action=quick_update','post','id="quick_edit_form"');
			printf('<fieldset style="font-size:small;"><legend>%s</legend>',$title_field);
			$favorites_query_raw = sprintf("SELECT favorite_ebayid,favorite_title FROM ebayapi_favorites WHERE site='%s' ORDER BY favorite_title,date_saved",$EBAYAPI->get_site_id_from_name($sammler->getSite()));
			$favorites_query = xtc_db_query($favorites_query_raw);
			$favorites = array( 0=>array('id'=>'','text'=>TEXT_SELECT) );
			while($favorite = xtc_db_fetch_array($favorites_query)){
				$favorites[] = array('id'=>$favorite['favorite_ebayid'],'text'=>$favorite['favorite_ebayid'].': '.$favorite['favorite_title']);
			}
			echo xtc_draw_pull_down_menu($db_field,$favorites,$saved);
			echo xtc_draw_hidden_field('field',$db_field);
			echo xtc_draw_hidden_field('id',$_REQUEST['id']);
			echo '</fieldset>';
			if(isset($_REQUEST['nolisting']))
				echo '<input type="button" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" onclick="quick_update(\''.$db_field.'_name\');" /></form>';
			else
				echo '<input type="button" value="'.IMAGE_SAVE.'" class="ui-button ui-corner-all ui-state-default" onclick="quick_update();" /></form>';
			exit;
			break;
		case 'quick_update':
			if(!isset($_REQUEST['id']))
				die('Missing Input');
			$id = intval(xtc_db_input($_REQUEST['id']));
			switch($_REQUEST['field']){
				case 'itemcondition':
					$update_key = $_REQUEST['field'];
					$value = xtc_db_prepare_input(yes_decode_string($_REQUEST[$update_key]));
					$id_key = 'id';
					$table = 'ebay_products';
					switch($update_key){
						case 'ebay_kategorie':
							xtc_db_query(sprintf(
								"DELETE FROM ebay_products_characteristics WHERE ebay_products_id='%s' and category_number='1'",
								$id
							));
							break;
						case 'ebay_kategorie2':
							xtc_db_query(sprintf(
								"DELETE FROM ebay_products_characteristics WHERE ebay_products_id='%s' and category_number='2'",
								$id
							));
							break;
					}

					$comments = sprintf(HISTORY_QUICKSAVE_ITEMCONDITION,$value);
					xtc_db_query(sprintf(
						"UPDATE %s SET %s='%s', ebay_shopcat_name='%s' WHERE %s='%s'",
						$table,$update_key,$value,$category_name,$id_key,$id
					));
					$EBAYAPI->save_history($id, $comments, $_SESSION['customer_id']);
					if( (isset($_REQUEST['response_msg']) and $_REQUEST['response_msg'] == 'name') or isset($_REQUEST['reinsert'])){
						$ebay_product = new ebay_product($id);
						$query = xtc_db_query(sprintf(
							"SELECT condition_name FROM ebayapi_favorites_itemconditions WHERE favorite_ebayid='%s' and condition_id='%s'",
							$ebay_product->getCategory(),$value
						));
						$condition = xtc_db_fetch_array($query);
						header('Content-Type: text/html; charset='.CHARSET);
						die( substr($condition['condition_name'],0,20) );
					}
					die($comments);
					break;
				case 'ebay_shopcat':
					$update_key = $_REQUEST['field'];
					$value = xtc_db_prepare_input(yes_decode_string($_REQUEST[$update_key]));
					$id_key = 'id';
					$table = 'ebay_products';
					$category_name = xtc_get_ebayshop_category_name($value);
					$comments = sprintf(HISTORY_QUICKSAVE_SHOPCATEGORY,$category_name);
					xtc_db_query(sprintf(
						"UPDATE %s SET %s='%s', ebay_shopcat_name='%s' WHERE %s='%s'",
						$table,$update_key,$value,$category_name,$id_key,$id
					));
					$EBAYAPI->save_history($id, $comments, $_SESSION['customer_id']);
					if(isset($_REQUEST['response_msg']) and $_REQUEST['response_msg'] == 'name'){
						header('Content-Type: text/html; charset='.CHARSET);
						die($category_name);
					}
					die($comments);
					break;
				case 'ebay_shopcat2':
					$update_key = $_REQUEST['field'];
					$value = xtc_db_prepare_input(yes_decode_string($_REQUEST[$update_key]));
					$id_key = 'id';
					$table = 'ebay_products';
					$category_name = xtc_get_ebayshop_category_name($value);
					$comments = sprintf(HISTORY_QUICKSAVE_SHOPCATEGORY2,$category_name);
					xtc_db_query(sprintf(
						"UPDATE %s SET %s='%s',ebay_shopcat2_name='%s' WHERE %s='%s'",
						$table,$update_key,$value,$category_name,$id_key,$id
					));
					$EBAYAPI->save_history($id, $comments, $_SESSION['customer_id']);
					if(isset($_REQUEST['response_msg']) and $_REQUEST['response_msg'] == 'name'){
						header('Content-Type: text/html; charset='.CHARSET);
						die($category_name);
					}
					die($comments);
					break;
				case 'ebay_kategorie':
					$product = new ebay_product($id);
					$update_key = 'ebay_kategorie';
					$value = xtc_db_prepare_input(yes_decode_string($_REQUEST[$update_key]));
					$id_key = 'id';
					$table = 'ebay_products';
					$comments = sprintf(HISTORY_QUICKSAVE_CATEGORY,$value);
					xtc_db_query(sprintf(
						"UPDATE %s SET %s='%s' WHERE %s='%s'",
						$table,$update_key,$value,$id_key,$id
					));
					$EBAYAPI->save_history($id, $comments, $_SESSION['customer_id']);
					if(isset($_REQUEST['response_msg']) and $_REQUEST['response_msg'] == 'name'){
						header('Content-Type: text/html; charset='.CHARSET);
						die($EBAYAPI->get_ebay_category_name_from_favorites($value,$EBAYAPI->get_site_id_from_name($product->getSite())));
					}
					die($comments);
					break;
				case 'ebay_kategorie2':
					$product = new ebay_product($id);
					$update_key = 'ebay_kategorie2';
					$value = xtc_db_prepare_input(yes_decode_string($_REQUEST[$update_key]));
					$id_key = 'id';
					$table = 'ebay_products';
					$comments = sprintf(HISTORY_QUICKSAVE_CATEGORY2,$value);
					xtc_db_query(sprintf(
						"UPDATE %s SET %s='%s' WHERE %s='%s'",
						$table,$update_key,$value,$id_key,$id
					));
					$EBAYAPI->save_history($id, $comments, $_SESSION['customer_id']);
					if(isset($_REQUEST['response_msg']) and $_REQUEST['response_msg'] == 'name'){
						header('Content-Type: text/html; charset='.CHARSET);
						die($EBAYAPI->get_ebay_category_name_from_favorites($value,$EBAYAPI->get_site_id_from_name($product->getSite())));
					}
					die($comments);
					break;
				case 'description':
					$update_key = 'ebay_beschreibung';
					$value = xtc_db_prepare_input(yes_decode_string($_REQUEST[$update_key]));
					$id_key = 'id';
					$table = 'ebay_products';
					$comments = HISTORY_QUICKSAVE_DESCRIPTION;
					xtc_db_query(sprintf(
						"UPDATE %s SET %s='%s' WHERE %s='%s'",
						$table,$update_key,$value,$id_key,$id
					));
					$EBAYAPI->save_history($id, $comments, $_SESSION['customer_id']);
					break;
				default:
					die('Missing Quick-Update Handler in admin/ebayapi_cart.php');
			}
			die('1');
			break;
  }

  $basics = new basics;

  
  // EBAY-TEMPLATES
  $auction_templates = $basics->get_template_values(DIR_FS_CATALOG.'templates/'.CURRENT_TEMPLATE.'/admin/ebay_templates/');
  

  $auction_types = array();
  if(sizeOf($_YES_auction_types)>0){
  	foreach($_YES_auction_types as $k=>$v){
		$auction_types[] = array('id'=>$k,'text'=>$v);
	}
  }

  $auction_counter = array();
  if(sizeOf($_YES_auction_counter)>0){
  	foreach($_YES_auction_counter as $k=>$v){
		$auction_counter[] = array('id'=>$k,'text'=>$v);
	}
  }
  
  $ebay_sites = array();
  $ebay_sites_query = xtc_db_query("SELECT * FROM ebay_sites ORDER BY site_name");
  while($ebay_sites_res = xtc_db_fetch_array($ebay_sites_query)){
  	$ebay_sites[] = array('id'=>$ebay_sites_res['site_name'],'text'=>$ebay_sites_res['site_name']);
  }

  function get_copy_box($field){
  	global $copy;
	if($copy[$field] == 1)
		return xtc_draw_checkbox_field('copy_'.$field,'1',true);
	else
		return xtc_draw_checkbox_field('copy_'.$field,'1',false);
  }
	    
  $input_fields = array(
		'user','site','country','location','postalcode','dispatchtimemax','type','subtitletext','duration','counter','quantity','revise','revise_option',
		'category','itemspecifics_recommendations','category2','shopcat','shopcat2','payments','gallery','gallery_plus','galleryFeatured','galleryFeaturedDuration','vat',
		'seller_profile_payment_id','seller_profile_return_policy_id','seller_profile_shipping_id',
		'geldzurueck','bestoffer','bestoffer_price','bestofferautoacceptprice','reserveprice','template','paymentinstructions','itemcondition',
		'itemspecifics','ShippingDiscountProfileID','InternationalShippingDiscountProfileID',
      'returnswithincode','shippingcostpaidby','ebay_plus','scheduletime'
  );

  function get_input_field($field,$mode = 'edit'){
	global $sInfo,$ebay_sites,$auction_counter,$auction_types,$shop_categories_array,$EBAYAPI,$payment_codes,$auction_templates,$pi_select;
	switch($field){
		case 'user':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_USER;
			return xtc_draw_pull_down_menu('user',xtc_get_ebay_users(),$default,'class=""');
			break;
		case 'site':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_SITE;
			return xtc_draw_pull_down_menu('site',$ebay_sites,$default);
			break;
		case 'postalcode':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_POSTALCODE;
			return xtc_draw_input_field('postalcode',$default,'size="8" maxlength="8"');
			break;
		case 'dispatchtimemax':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_DISPATCHTIMEMAX;
			$dispatch_values = array(array('id'=>'','text'=>TEXT_SELECT));
			$ebay_dispatch_details = $EBAYAPI->get_ebay_details('DispatchTimeMaxDetails');
			foreach($ebay_dispatch_details->DispatchTimeMaxDetails as $dtm){
			    $dispatch_values[] = array(
				'id'=>$dtm->DispatchTimeMax,
				'text'=>str_replace(array('Days','Day'), array('Tage','Tag'),$dtm->Description)
			    );
			}
			return xtc_draw_pull_down_menu('dispatchtimemax', $dispatch_values, $default);
			break;
		case 'country':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_SELLER_COUNTRY;
			return xtc_draw_input_field('country',strtoupper($default),'size="4" maxlength="2"');
			break;
		case 'type':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_AUCTIONTYPE;
			return xtc_draw_pull_down_menu('type',$auction_types,$default);
			break;
		case 'subtitletext':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_SUBTITLETEXT;
			return xtc_draw_input_field('subtitletext',$default,'size="25" maxlength="'.MAX_SIZE_EBAY_TITLE.'"');
			break;
		case 'galleryFeaturedDuration':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_GALLERYFEATUREDDURATION;
			return xtc_draw_ebay_duration_pull_down('galleryFeaturedDuration',false,false,$default);
			break;
		case 'duration':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_DURATION;
			return xtc_draw_ebay_duration_pull_down('duration',false,false,$default);
			break;
		case 'revise':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_REVISE_AUTOMATIC;
			return xtc_draw_pull_down_menu('revise',xtc_get_ebay_revise_automatics(),$default);
			break;
		case 'revise_option':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_REVISE_AUTOMATIC_OPTION;
			return xtc_draw_input_field('revise_option',$default,'size="4" maxlength="5"');
			break;
		case 'counter':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_COUNTER;
			return xtc_draw_pull_down_menu('counter',$auction_counter, $default);
			break;
		case 'category':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_CATEGORY;
			$css_class = ( $sInfo->getCategory() == 0 ) ? 'container' : 'container_active';
			return xtc_draw_input_field('category',$default,'size=8').'<br /><a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart_admin.php','action=quick_edit_category&nr=1&id='.$sInfo->getId()).'" href="javascript:;" class="lbOn" title="'.TEXT_CHOOSE_CATEGORY1.'">'.TEXT_CHOOSE_CATEGORY1.'</a>';
			break;
		case 'category2':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_CATEGORY2;
			return xtc_draw_input_field('category2',$default,'size=8').'<br /><a style="padding:0px;" id="'.xtc_href_link('ebayapi_cart_admin.php','action=quick_edit_category&nr=2&id='.$sInfo->getId()).'" href="javascript:;" class="lbOn" title="'.TEXT_CHOOSE_CATEGORY2.'">'.TEXT_CHOOSE_CATEGORY2.'</a>';
			break;
		case 'shopcat':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_SHOPCATEGORY;
			return xtc_draw_pull_down_menu('shopcat',$shop_categories_array,$default);
			break;
		case 'shopcat2':
			$default = ($mode == 'edit') ? $sInfo->$field : '';
			return xtc_draw_pull_down_menu('shopcat2',$shop_categories_array,$default);
			break;
		case 'itemcondition':
			$default = ($mode == 'edit') ? $sInfo->$field : '';
			$ebay_itemcondition_array = array();
			if($sInfo->category > 0){
				$ebay_user = $sInfo->getUser();
				$category = yes_get_ebay_category_features( $sInfo->getSite(),$sInfo->getCategory(),$ebay_user);
				if($category->ConditionEnabled){
					$conditions_num = sizeOf($category->ConditionValues->Condition);
					$conditions = $category->ConditionValues;
					foreach($conditions->Condition as $condition){
						$ebay_itemcondition_array[] = array(
							'id'=>$condition->ID,
							'text'=>$condition->DisplayName
						);
					}
				}
				return xtc_draw_pull_down_menu('itemcondition',$ebay_itemcondition_array,$default);
			}else{
				return MSG_ERROR_NO_EBAY_DEFAULT_CATEGORY;
			}
			break;
		case 'payments':
			$default = ($mode == 'edit') ? $sInfo->id : 0;

                        if((int)$sInfo->category < 1){
                            return 'Es muss zuerst eine eBay Kategorie gespeichert sein';
                        }
                        $payment_codes = xtc_get_available_ebay_payments($sInfo->category);
			return $EBAYAPI->draw_payments_select('sammler',$default,$payment_codes);
			break;
		case 'itemspecifics':
			if($mode == 'edit')
				return $EBAYAPI->draw_itemspecifics_select('sammler',$sInfo->id);
			else
				return $EBAYAPI->draw_itemspecifics_select('default');
			break;
		case 'itemspecifics_recommendations':
			if($mode == 'edit' and $sInfo->category > 0){
				$default = $sInfo->id;
				return '<a href="javascript:;" class="lbOn bigWidth" id="ebayapi_cart_admin.php?action=itemspecifics&id='.$default.'" title="'.TEXT_EBAY_ITEMSPECIFICS_RECOMMENDATIONS.'">'.TEXT_EBAY_ITEMSPECIFICS_RECOMMENDATIONS.'</a>';
			}
			return MSG_ERROR_NO_EBAY_DEFAULT_CATEGORY;
			break;

		case 'gallery':
		case 'gallery_plus':
		case 'galleryFeatured':
		case 'geldzurueck':
		case 'sofortneu':
		case 'bestoffer':
                        $cnst = defined('EBAY_'.strtoupper($field)) ? constant('EBAY_'.strtoupper($field)) : 1;
			$default = ($mode == 'edit') ? $sInfo->$field : $cnst;
			return TEXT_YES.'&nbsp;'.xtc_draw_radio_field($field, '1', (($default==1)?true:false)).'&nbsp;'.TEXT_NO.'&nbsp;'.xtc_draw_radio_field($field, $value = '0', (($default==0)?true:false));
			break;
		case 'vat':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_SHOW_AUCTION_TAX;
			return TEXT_YES.'&nbsp;'.xtc_draw_radio_field($field, '1', (($default==1)?true:false)).'&nbsp;'.TEXT_NO.'&nbsp;'.xtc_draw_radio_field($field, $value = '0', (($default==0)?true:false));
			break;
		case 'bestoffer_price':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_BESTOFFER_PRICE;
			return xtc_draw_input_field($field, $default,'maxlength="8"');
			break;
		case 'bestofferautoacceptprice':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_BESTOFFERAUTOACCEPTPRICE;
			return xtc_draw_input_field($field, $default,'maxlength="8"');
			break;
		case 'template':
                    $cnst = (defined('EBAY_TEMPLATE')) ? EBAY_TEMPLATE : '';
			$default = ($mode == 'edit') ? $sInfo->$field : $cnst;
			return xtc_draw_pull_down_menu('template',$auction_templates,$default);
			break;
		case 'paymentinstructions':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_CHECKOUT_INSTRUCTIONS;
			$text = '<b>'.TEXT_TEXTITEMS_PAYMENTINSTRUCTIONS.':</b><br />'.TEXT_PAYMENTINSTRUCTIONS_INTRO.'<br />'.$pi_select;
			return $text.xtc_draw_input_field($field,$default,'size="20" maxlength="500"');
			break;
                case 'returnswithincode':
			$default = ($mode == 'edit') ? $sInfo->$field : EBAY_RETURNSWITHINCODE;
			return yes_cfg_pull_down_ebay_returnswithincodes($default, $field);
                    break;
                case 'shippingcostpaidby':
                    $cnst = (defined('EBAY_SHIPPINGCOSTSPAIDBY')) ? EBAY_SHIPPINGCOSTSPAIDBY : '';
			$default = ($mode == 'edit') ? $sInfo->$field : $cnst;
                        return yes_cfg_pull_down_ebay_shippingcostpaidbycodes($default, $field);
                        break;
                case 'ebay_plus':
			$default = ($mode == 'edit') ? $sInfo->eBayPlus : EBAY_PLUS;
			return TEXT_YES.'&nbsp;'.xtc_draw_radio_field($field, '1', (($default==1)?true:false)).'&nbsp;'.TEXT_NO.'&nbsp;'.xtc_draw_radio_field($field, $value = '0', (($default==0)?true:false));
                        break;
                case 'seller_profile_shipping_id':
			$default = ($mode == 'edit') ? $sInfo->seller_profile_shipping_id : EBAY_SELLER_PROFILE_SHIPPING_ID;
			return $EBAYAPI->draw_seller_profile_select('shipping', $field, $default);
                        break;
                case 'seller_profile_payment_id':
			$default = ($mode == 'edit') ? $sInfo->seller_profile_payment_id : EBAY_SELLER_PROFILE_PAYMENT_ID;
			return $EBAYAPI->draw_seller_profile_select('payment', $field, $default);
                        break;
                case 'seller_profile_return_policy_id':
			$default = ($mode == 'edit') ? $sInfo->seller_profile_return_policy_id : EBAY_SELLER_PROFILE_RETURN_POLICY_ID;
			return $EBAYAPI->draw_seller_profile_select('return_policy', $field, $default);
                        break;
                case 'scheduletime':
                    $default_date = ($mode == 'edit' and $sInfo->getScheduleTime() != '' and $sInfo->getScheduleTime() != '0000-00-00 00:00:00') ? date('Y-m-d',strtotime($sInfo->getScheduleTime())) : '';
                    $default_time = ($mode == 'edit' and $sInfo->getScheduleTime() != '' and $sInfo->getScheduleTime() != '0000-00-00 00:00:00') ? date('H:i:s',strtotime($sInfo->getScheduleTime())) : '00:00:00';
                    return xtc_draw_input_field('scheduletime', $default_date, 'size="19" maxlength="19"',false,'date').'&nbsp;<font size="4">&#128337</font>&nbsp;'.xtc_draw_input_field('scheduletime_time',$default_time,'maxlength="8" size="8"');
                    break;
		default:
			$default = ($mode == 'edit') ? $sInfo->$field : constant('EBAY_'.strtoupper($field));
			return xtc_draw_input_field($field,$default);
			break;
	}
  }

  if (isset($_GET['action'])) {
    $date_added = date("Y-m-d H:i:s");;
    switch ($_GET['action']) {
      case 'copy_confirm':
		if(xtc_not_null($_POST['new_title'])){
			$new_title = substr(xtc_db_input($_POST['new_title']),0,MAX_SIZE_EBAY_TITLE);
		}else{
			$messageStack->add_session(MESSAGE_COPY_ERROR_TITLE,'error');
		        xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_CART_ADMIN,xtc_get_all_get_params(array('action')).'action=copy'));
		}
		$sammler = new ebay_sammler($_GET['sID']);
		$new_id = $sammler->copy($new_title);

		if($new_id){
			$messageStack->add_session(MESSAGE_COPY_SUCCESS,'success');
		    xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_CART_ADMIN,xtc_get_all_get_params(array('sID','action'))));
		}else{
			$messageStack->add_session(MESSAGE_COPY_ERROR,'error');
		    xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_CART_ADMIN,xtc_get_all_get_params(array('action','sID'))));
		}
		break;
      case 'insert':
		// SHOPKATEGORIENAME
		$shop_categories_array = xtc_get_ebayshop_categorys($_POST['user']);
		if($_POST['shopcat'] and $_POST['shopcat'] > 0){
			foreach($shop_categories_array as $k=>$v){
				if($v['id'] == $_POST['shopcat']){
					$cat_name = $v['text'];
				}
			}
		}

		if($_POST['shopcat2'] and $_POST['shopcat2'] > 0){
			if(sizeOf($shop_categories_array)>0){
				foreach($shop_categories_array as $k=>$v){
					if($v['id'] == $_POST['shopcat2']){
						$cat2_name = $v['text'];
					}
				}
			}
		}

		$insert_sql_array = array(
                    'angelegt'=>'now()',
                    'titel'=>$_POST['titel'],
                    'description'=>$_POST['description'],
                    'shopcat_name'=>$cat_name,
                    'shopcat2_name'=>$cat2_name,
                    'aktiv'=>'j'
		);
                
                if(isset($_REQUEST['configuration']['returnswithincode'])){
                    $insert_sql_array[ 'returnswithincode' ] = $_REQUEST['configuration']['returnswithincode'];
                }
                if(isset($_REQUEST['configuration']['shippingcostpaidby'])){
                    $insert_sql_array[ 'shippingcostpaidby' ] = $_REQUEST['configuration']['shippingcostpaidby'];
                }                
                
		foreach($input_fields as $k=>$v){
                    if($v != 'payments' and $v != 'itemspecifics' and $v != 'itemspecifics_recommendations'  and $v != 'shippingcostpaidby' and $v != 'returnswithincode'){
                        $vp = $_POST[$v];
                        if($v == 'scheduletime'){
                            $vp .= ' '.$_POST['scheduletime_time'];
                        }
                        $insert_sql_array[$v] = $vp;
                    }
		}
		xtc_db_perform(TABLE_EBAY_SAMMLER,$insert_sql_array,'insert');
		$sammler_id = xtc_db_insert_id();
	
		$copy = array();
		foreach($_POST as $k=>$v){
                    if(strstr($k,'copy_')){
                        $key = explode('copy_',$k);
                        $copy[ $key[1] ] = 1;
                    }
		}
		if(sizeOf($copy)>0){
                    $copy['ebay_sammler_id'] = $sammler_id;
                    xtc_db_perform('ebay_sammler_copy',$copy);
		}
	
		if(is_array($_POST['payment']) and sizeOf($_POST['payment'])>0){
			foreach($_POST['payment'] as $k=>$v){
				xtc_db_query("INSERT INTO ebay_sammler_payments SET ebay_sammler_id='".$sammler_id."',payment='".$v."'");
			}
		}

		xtc_db_query(sprintf("DELETE FROM ebay_sammler_itemspecifics WHERE ebay_sammler_id='%s'",$sammler_id));
		for($i=0;$i<sizeOf($_POST);$i++){
                    if(xtc_not_null($_POST['is_name_'.$i]) and xtc_not_null($_POST['is_value_'.$i])){
                        $is_value = $_POST['is_value_'.$i];
                        $insert_sql_array = array(
                                'is_name'=>$_POST['is_name_'.$i],
                                'is_value'=>$is_value,
                                'ebay_sammler_id'=>$sammler_id
                        );
                        xtc_db_perform('ebay_sammler_itemspecifics',$insert_sql_array);
                    }
		}

		$messageStack->add_session(MESSAGE_CART_ADDED,'success');
		xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_CART_ADMIN));
		break;
      case 'save':
		$id = xtc_db_input($_GET['sID']);
		$es = new ebay_sammler($id);
		// TABLE EBAY_SAMMLER_COPY AKTUALISIEREN
		$shop_categories_array = xtc_get_ebayshop_categorys($_POST['user']);
		xtc_db_query("DELETE FROM ebay_sammler_copy WHERE ebay_sammler_id='".$id."'");
		$copy = array();
		foreach($_POST as $k=>$v){
                    if(strstr($k,'copy_')){
                        $key = explode('copy_',$k);
                        $copy[ $key[1] ] = 1;
                    }
		}
		if(sizeOf($copy)>0){
                    $copy['ebay_sammler_id'] = $id;
                    xtc_db_perform('ebay_sammler_copy',$copy);
		}

		// SHOPKATEGORIENAMEN ERMITTELN
		if($_POST['shopcat'] and $_POST['shopcat'] > 0){
                    if(is_array($shop_categories_array) and sizeOf($shop_categories_array)>0){
                        foreach($shop_categories_array as $k=>$v){
                            if($v['id'] == $_POST['shopcat']){
                                $cat_name = $v['text'];
                            }
                        }
                    }
		}

		if($_POST['shopcat2'] and $_POST['shopcat2'] > 0){
                    if(is_array($shop_categories_array) and sizeOf($shop_categories_array)>0){
                        foreach($shop_categories_array as $k=>$v){
                            if($v['id'] == $_POST['shopcat2']){
                                $cat2_name = $v['text'];
                            }
                        }
                    }
		}

		$update_sql_array = array(
                    'titel'=>$_POST['titel'],
                    'description'=>$_POST['description'],
                    'shopcat_name'=>$cat_name,
                    'shopcat2_name'=>$cat2_name,
                    'aktiv'=>'j'
		);
                
                if(isset($_REQUEST['configuration']['returnswithincode'])){
                    $update_sql_array[ 'returnswithincode' ] = $_REQUEST['configuration']['returnswithincode'];
                }
                if(isset($_REQUEST['configuration']['shippingcostpaidby'])){
                    $update_sql_array[ 'shippingcostpaidby' ] = $_REQUEST['configuration']['shippingcostpaidby'];
                }                
		foreach($input_fields as $k=>$v){
                    if($v != 'payments' and $v != 'itemspecifics' and $v != 'itemspecifics_recommendations' and $v != 'shippingcostpaidby' and $v != 'returnswithincode' and $v != 'scheduletime_time'){
                        if($v == 'scheduletime'){
                            $update_sql_array[$v] = $_POST[$v].' '.$_POST['scheduletime_time'];
                        }else{
                            $update_sql_array[$v] = $_POST[$v];
                        }
                    }
		}
               
                
		xtc_db_perform(TABLE_EBAY_SAMMLER,$update_sql_array,'update',"id='".$id."'");

		xtc_db_query("DELETE FROM ebay_sammler_payments WHERE ebay_sammler_id='".$id."'");
		if(is_array($_POST['payment']) and sizeOf($_POST['payment'])>0){
			foreach($_POST['payment'] as $k=>$v){
				xtc_db_query("INSERT INTO ebay_sammler_payments SET ebay_sammler_id='".$id."',payment='".$v."'");
			}
		}

		xtc_db_query(sprintf("DELETE FROM ebay_sammler_itemspecifics WHERE ebay_sammler_id='%s'",$id));
		for($i=0;$i<sizeOf($_POST);$i++){
			if(isset($_POST['is_name_'.$i]) and xtc_not_null($_POST['is_name_'.$i]) and xtc_not_null($_POST['is_value_'.$i])){
				$insert_sql_array = array(
					'is_name'=>$_POST['is_name_'.$i],
					'is_value'=>$_POST['is_value_'.$i],
					'ebay_sammler_id'=>$id
				);
				xtc_db_perform('ebay_sammler_itemspecifics',$insert_sql_array);
			}
		}

		// falls andere ebay-kategorie -> merkmale loeschen
		if($es->getCategory() != $_POST['category']){
			xtc_db_query("DELETE FROM ebay_sammler_characteristics WHERE ebay_sammler_id='".$id."' and category_number='1'");
		}

		if($es->getCategory2() != $_POST['category2']){
                    xtc_db_query("DELETE FROM ebay_sammler_characteristics WHERE ebay_sammler_id='".$id."' and category_number='2'");
		}
		$messageStack->add_session(MESSAGE_CART_UPDATED,'success');	
		xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_CART_ADMIN));
		break;
    case 'deleteconfirm':
		$id = xtc_db_input($_GET['sID']);
		// sammlerprodukt-zuordnungen loeschen
		$ebay_products = array();
		$products_query = xtc_db_query("SELECT id FROM ". TABLE_EBAY_PRODUCTS ." WHERE ebay_sammler_id = '" . $id . "'");
		while($products = xtc_db_fetch_array($products_query)){
			$ebay_products[] = $products['id'];
		}
                foreach($ebay_products as $epID){
                    $ep = new ebay_product($epID);
                    $ep->delete();
                }

		xtc_db_query("delete from " . TABLE_EBAY_SAMMLER . " where id = '" . $id . "'");
		xtc_db_query("DELETE FROM ebay_sammler_payments WHERE ebay_sammler_id='".$id."'");
		xtc_db_query("DELETE FROM ebay_sammler_characteristics WHERE ebay_sammler_id='".$id."'");
		xtc_db_query("DELETE FROM ebay_sammler_copy WHERE ebay_sammler_id='".$id."'");
		xtc_db_query("DELETE FROM ebay_sammler_itemspecifics WHERE ebay_sammler_id='".$id."'");
		xtc_db_query("DELETE FROM ebay_sammler_itemspecifics_recommendations WHERE ebay_sammler_id='".$id."'");

		$shippingmethods_query = xtc_db_query("SELECT ebay_sammler_shippings_id FROM ebay_sammler_shippings WHERE ebay_sammler_id='".$id."'");
		while($shippingmethods = xtc_db_fetch_array($shippingmethods_query)){
			xtc_db_query("DELETE FROM ebay_sammler_shippings_locations WHERE ebay_sammler_shippings_id='".$shippingmethods['ebay_sammler_shippings_id']."'");
		}
		xtc_db_query("DELETE FROM ebay_sammler_shippings WHERE ebay_sammler_id='".$id."'");

		$messageStack->add_session(MESSAGE_CART_DELETED,'success');
		xtc_redirect(xtc_href_link(FILENAME_EBAYAPI_CART_ADMIN));
		break;
    case 'edit':
		$copy_query = xtc_db_query("SELECT * FROM ebay_sammler_copy WHERE ebay_sammler_id='".(int)$_GET['sID']."'");
		$copy = xtc_db_fetch_array($copy_query);
		break;
   }
  }
$smarty = new yesSmarty;	
//$smarty->plugins_dir[]=DIR_FS_CATALOG.'includes/smarty_plugins/';
$smarty->assign([
    'SAMMLER_FORM'=>'',
    'TABLE_CAPTION'=>'',
    'LIST_ACTIONS'=>'',
]);
if(isset($_GET['sID'])){
	$box_action = (isset($_GET['action'])) ? $_GET['action'] : '';
	$sID = (int)xtc_db_input($_GET['sID']);
	$sInfo = new ebay_sammler($sID);
	switch ($box_action) {
			case 'new':
				$shop_categories_array = xtc_get_ebayshop_categorys(EBAY_USER);
				if(!is_array($shop_categories_array))
					$shop_categories_array = array();

				$heading[] = array('text' => '<b>'.TEXT_ADD_CONFIG.'</b>');
				$contents = array('form' => xtc_draw_form('cart', FILENAME_EBAYAPI_CART_ADMIN, xtc_get_all_get_params(array('action','sID')).'action=insert'));
				$contents[] = array('text' => '<br /><b>'.TEXT_CART_TITLE.'</b><br />' . xtc_draw_input_field('titel',NEW_CART_TITLE));
				$contents[] = array('text' => '<br /><b>'.TEXT_CART_DESC.'</b><br />' . xtc_draw_textarea_field('description', "virtual", 40, 3, $text = NEW_CART_DESC));
				$contents[] = array('text' => '<br />');

				$output = array();
				foreach($input_fields as $k=>$field){
					$output[] = array(
						'id'=>$field,
						'copy_box'=>get_copy_box($field),
						'input'=>get_input_field($field,'add')
					);
				}
				$smarty->assign('configs',$output);
				$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
				$smarty->assign('SEPARATOR',xtc_draw_separator('pixel_black.gif'));

				$contents[] = array('text' => $smarty->fetch('ebay_sammler_config.html'));


				$contents[] = array('text' => '<br>'.xtc_draw_checkbox_field('copy_shippingmethods','1',false).' Kopieren der hinterlegten Versandmethoden?');
				$contents[] = array('text' => '<br>'.xtc_draw_checkbox_field('copy_characteristics','1',false).' Kopieren der Artikelmerkmale?');
				$contents[] = array('align' => 'center', 'text' => '<br />'.yes_draw_href_button(IMAGE_SAVE,"javascript:document.forms['add'],submit();",'width:120px;').'&nbsp;'.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(EBAY_SAMMLER_ADMIN, xtc_get_all_get_params(array('action'))),'width:120px;'));
				break;
			case 'edit':
				$shop_categories_array = xtc_get_ebayshop_categorys($sInfo->user);
				if(!is_array($shop_categories_array))
						$shop_categories_array = array();

				$heading[] = array('text' => '<b>'.TEXT_EDIT_CONFIG.'</b>');
				$contents = array('form' => xtc_draw_form('cart', FILENAME_EBAYAPI_CART_ADMIN, 'page=' . $_GET['page'] . '&sID=' . $sInfo->id  . '&action=save'));
				$contents[] = array('text' => '<br /><b>'.TEXT_CART_TITLE.'</b><br />' . xtc_draw_input_field('titel',$sInfo->getSammlerTitle()));
				$contents[] = array('text' => '<br /><b>'.TEXT_CART_DESC.'</b><br />' . xtc_draw_textarea_field('description', "virtual", 40, 3, $text = $sInfo->getSammlerDescription()));

				$contents[] = array('text' => '<br />');

				$output = array();
				foreach($input_fields as $k=>$field){
					$output[] = array(
						'id'=>$field,
						'copy_box'=>get_copy_box($field),
						'input'=>get_input_field($field,'edit')
					);
				}
				$smarty->assign('configs',$output);
				$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');
				$smarty->assign('SEPARATOR',xtc_draw_separator('pixel_black.gif'));

				$contents[] = array('text' => $smarty->fetch('ebay_sammler_config.html'));


				$contents[] = array('text' => '<br>'.xtc_draw_checkbox_field('copy_shippingmethods','1',(($copy['shippingmethods']==1)?true:false)).' Kopieren der hinterlegten Versandmethoden?');
				$contents[] = array('text' => '<br>'.xtc_draw_checkbox_field('copy_characteristics','1',(($copy['characteristics']==1)?true:false)).' Kopieren der Artikelmerkmale?');
				$contents[] = array('align' => 'center', 'text' => '<br />'.yes_draw_href_button(IMAGE_UPDATE,"javascript:document.forms['edit'],submit();",'width:120px;').'&nbsp;'.yes_draw_href_button(IMAGE_CANCEL,xtc_href_link(EBAY_SAMMLER_ADMIN, xtc_get_all_get_params(array('action'))),'width:120px;'));
				break;
			case 'delete':
				$heading[] = array('text' => '<b>'.TEXT_DELETE_CART.'</b>');
				$contents = array('form' => xtc_draw_form('delete', FILENAME_EBAYAPI_CART_ADMIN, 'page=' . $_GET['page'] . '&sID=' . $sInfo->id  . '&action=deleteconfirm'));
				$contents[] = array('text' => TEXT_DELETE_CART_INTRO);
					$contents[] = array('text' => '<br /><b>' . TEXT_DATE_ADDED . ':</b> ' . xtc_date_short($sInfo->angelegt));
				$contents[] = array('text' => '<br /><b>' . TEXT_CART_TITLE . ':</b><br />'.$sInfo->getSammlerTitle());
				$contents[] = array('text' => '<br /><b>' . TEXT_CART_DESC . ':</b><br />'.$sInfo->getSammlerDescription());
				$contents[] = array('text' => '<br /><b>' . TEXT_CART_ITEMS . ':</b> '.$sInfo->get_number_of_items());
				$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_DELETE,"javascript:document.forms['delete'],submit();",'width:120px;').'&nbsp;'.
					yes_draw_href_button(
						IMAGE_CANCEL,
						"javascript:ajax_box_action('".$sInfo->id."','');",
						'width:120px;')
				);
				break;
			case 'copy':
				$heading[] = array('text' => '<b>' . TEXT_COPY_CART . '</b>');

				$contents = array('form' => xtc_draw_form('copy', FILENAME_EBAYAPI_CART_ADMIN, 'page=' . $_GET['page'] . '&sID=' . $sInfo->id  . '&action=copy_confirm'));
				$contents[] = array('text' => TEXT_COPY_CART_INTRO);
				$contents[] = array('text' => '<br />'.xtc_draw_input_field('new_title','COPY OF '.$sInfo->getSammlerTitle(),'size="30" maxlength="64"'));
				$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(IMAGE_COPY,"javascript:document.forms['copy'],submit();",'width:120px;').'&nbsp;'.
					yes_draw_href_button(
						IMAGE_CANCEL,
						"javascript:ajax_box_action('".$sInfo->id."','');",
						'width:120px;')
				);
				break;
			default:
				if (is_object($sInfo)) {
					$heading[] = array('text' => '<b>' . TEXT_EDIT_CART . '</b>');
					$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
						IMAGE_EDIT,
						"javascript:ajax_box_action('".$sInfo->id."','edit');",
						'width:140px;')
					);
					$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
						IMAGE_COPY,
						"javascript:ajax_box_action('".$sInfo->id."','copy');",
						'width:140px;')
					);
					$contents[] = array('align' => 'center', 'text' => yes_draw_href_button(
						IMAGE_DELETE,
						"javascript:ajax_box_action('".$sInfo->id."','delete');",
						'width:140px;')
					);

					$contents[] = array('text' => '<br /><b>' . TEXT_DATE_ADDED . ':</b> ' . xtc_date_short($sInfo->angelegt));
					$contents[] = array('text' => '<br /><b>' . TEXT_CART_TITLE . ':</b><br />'.$sInfo->getSammlerTitle() );
					$contents[] = array('text' => '<br /><b>' . TEXT_CART_DESC . ':</b><br />'.$sInfo->getSammlerDescription());
					$contents[] = array('text' => '<br /><b>' . TEXT_CART_ITEMS . ':</b> '.$sInfo->get_number_of_items());
					$EBAYAPI->get_shippingcosts_value('sammler',$item_shippingcosts,$sInfo->id);
					$anzahl_shippingmethods = $EBAYAPI->get_shippingcosts_count($item_shippingcosts);

					$contents[] = array('text' => '<br /><a class="lbOn" href="javascript:;" id="'.xtc_href_link('ebayapi_shippingcosts.php',xtc_get_all_get_params(array('source','id','action')).'source=sammler&id='.$sInfo->id).'" title="'.TEXT_SHIPPINGMETHODS.'"><u>'.$anzahl_shippingmethods.' '.TEXT_SHIPPINGMETHODS.'</u></a><br />');
			  }
			  break;
	}
	$box = new box;
	header('Content-Type: text/html; charset='.CHARSET);
	if(isset($_GET['sID'])){
		echo <<<EOF
<script type="text/javascript">
$().ready(function(){
	$('.lbOn').click(function(){
		var url = this.id;
		var title = this.title;
		var width = YES_MODAL_WIDTH;
		if($(this).hasClass('bigWidth'))
			width = YES_MODAL_BIGWIDTH;
		showPreloader();
		$('#modal_window').dialog({title: title,width:width,modal:true,maxHeight:YES_MODAL_HEIGHT}).load(url,function(){
			if($('#modal_window').height() >= YES_MODAL_HEIGHT )
				$('#modal_window').dialog('option','height',YES_MODAL_HEIGHT);
			hidePreloader();
		});
	});
});
</script>
EOF;
	}
	echo $box->infoBox($heading, $contents);
	exit;
}




include(DIR_WS_CLASSES.'class.yes_lister.php');
$order_by = (isset($_GET['order_by'])) ? xtc_db_input($_GET['order_by']) : 'titel DESC';
$query_raw = "select id,titel,description,user,angelegt from ebay_sammler order by ".$order_by;
$page = (isset($_GET['page'])) ? $_GET['page'] : 0;
$sammler_split = new splitPageResults($page, $view_limit = MAX_DISPLAY_SEARCH_RESULTS, $query_raw, $query_numrows);

$select_field_array = array(
		0=>array(
			'field'=>'id',
			'heading'=>TABLE_HEADING_ID,
			'format'=>'int',
			'get_param'=>'sID',
			'sortable'=>1,
			'index'=>true,
			'column'=>0
		),
		1=>array(
			'field'=>'titel',
			'heading'=>TABLE_HEADING_TITLE,
			'format'=>'string',
			'get_param'=>'ttl',
			'sortable'=>1,
			'column'=>1
		),
		2=>array(
			'field'=>'description',
			'heading'=>TABLE_HEADING_DESCRIPTION,
			'format'=>'string',
			'get_param'=>'dsc',
			'sortable'=>0,
			'column'=>2
		),
		3=>array(
			'field'=>'user',
			'heading'=>TABLE_HEADING_EBAYUSER,
			'format'=>'string',
			'get_param'=>'slr',
			'sortable'=>1,
			'column'=>3
		),
		4=>array(
			'field'=>'angelegt',
			'heading'=>TABLE_HEADING_DATE_ADDED,
			'format'=>'date',
			'get_param'=>'dt',
			'sortable'=>1,
			'column'=>4
		)
);
$listing_smarty = $smarty;
$YL = new yes_lister($query_raw,'ebay_sammler','ebayapi_cart_admin.php',$select_field_array,$where_array = array(),$ajax_box = 1,$ajax_get_param_key = 'sID',$ajax_link = 'ebayapi_cart_admin.php','yes_lister_item_table_new.html');
$YL->setSmarty($listing_smarty);
//$YL->setTableCaption(HEADING_TITLE);
$sInfo = $YL->active_row;
$smarty->assign('LISTING',$YL->display($sammler_split,$query_numrows,MAX_DISPLAY_SEARCH_RESULTS));
$buttons = array(
    array('text'=>NEW_CART_TITLE,
	'link'=>"javascript:ajax_box_action('0','new');",
	'lbOn'=>false,
	'auth'=>true
    )
);
$smarty->assign(array(
    'HEADING_TITLE'=>HEADING_TITLE,
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons,
));
$smarty->assign('start_row_input',$YL->start_row_input);
$smarty->assign('SPLIT',$YL->split_string);

$box_html = '';
$heading = array();
$contents = array();
switch ($action) {
	default:
		$box_html .= '<div id="orderdetails" style="z-index:0;width:100%; margin:0;padding:0;" class="ui-widget-content"></div>';
		break;
}

if ( (xtc_not_null($heading)) && (xtc_not_null($contents)) ) {
    $box_html .= '            <td width="25%" valign="top">' . "\n";

    $box = new box;
    $box_html .= $box->infoBox($heading, $contents);
    $box_html .= '            </td>' . "\n";
}
$smarty->assign('BOX',$box_html);
yes_draw_pre_header();
yes_draw_header(TITLE);
?>
<script type="text/javascript" src="minify_js.php?file=includes/general.js"></script>
<script type="text/javascript">
<!--

function pi_select(){
	var arr = new Array();
<?php
$paymentinstr_query = xtc_db_query("SELECT * FROM ebay_textitems WHERE module='ebayshipping'");
while($paymentinstr = xtc_db_fetch_array($paymentinstr_query)){
	$string = str_replace('"',"'",xtc_db_prepare_input($paymentinstr['text']));
	echo 'arr['.$paymentinstr['id'].'] = "'.$string.'";'."\r\n";
}
?>
	newval = arr[document.forms['rates'].piselect.value];
	document.forms['rates'].paymentinstructions.value = newval;
}
//-->
</script>
<?php
echo $smarty->fetch(DIR_FS_ADMIN.'templates/ebayapi_cart_admin.html');
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
