<?php
set_time_limit(0);
include('includes/cron_application_top.php');

if(constant('FEEDBACK_REMINDER_ACTIVE') != 'True'){
	die('Feedback Reminder nicht aktiv');
}
require('includes/classes/class.ebay.php');
$EBAYAPI = new ebayApi;
define('EBAY_FEEDBACK_ALLOWED_TIMESTAMP',time()-60*60*24*60);

function getQueryResults($page,$parameters, &$transactions){
    global $EBAYAPI;
    $ebaycalls = new \YES4Trade\Model\ebaycalls();
    $res = $ebaycalls->tradingQuery($parameters['seller'],
        'GetItemsAwaitingFeedback',
        $parameters['site_id'],
        [
            'Pagination'=>[
                'EntriesPerPage' => 200,
                'PageNumber' => $page
            ]
        ]
    );
	if($EBAYAPI->isGood($res)) {
		$call_result = $res->ItemsAwaitingFeedback;
        printf("Page %d/%d (Total Items: %d)\n",
            $page,
            intval($call_result->PaginationResult->TotalNumberOfPages)+1,
            $call_result->PaginationResult->TotalNumberOfEntries
        );
		$pagRes = $call_result->PaginationResult;
		$total_pages = $pagRes->TotalNumberOfPages;
		$total_entries = $pagRes->TotalNumberOfEntries;
		if($total_entries > 0){
			$items = $call_result->TransactionArray;
			foreach($items->Transaction as $k=>$item){
				// PRUEFUNG OB KLEINER ALS 60 TAGE
				$I = $item->Item;
				$ILD = $I->ListingDetails;
                $endt_obj = new \DateTime($ILD->EndTime);
				if( $endt_obj->getTimestamp() > EBAY_FEEDBACK_ALLOWED_TIMESTAMP){
					$transactions[] = $item;
				}
			}
		}
		if($total_pages > $page and $page < MAX_EBAY_PAGE_RESULTS)
			getQueryResults($page+1,$parameters,$transactions);
	}else{
        print_r($res);
    }
}


if( !defined('FEEDBACK_REMINDER_DAYS_AFTER_SHIPPING' ) or (int)FEEDBACK_REMINDER_DAYS_AFTER_SHIPPING < 1){
	yes_mail_debug('Die Konstante FEEDBACK_REMINDER_DAYS_AFTER_SHIPPING ist nicht gesetzt oder hat einen ungueltigen Wert. ('.FEEDBACK_REMINDER_DAYS_AFTER_SHIPPING.')'."\r\n".STORE_NAME,true,'Feedback Reminder Konfigurationsfehler');
	exit;
}
define('MAX_EBAY_PAGE_RESULTS',12);

$sellers = xtc_get_ebay_users();
$accept_date = date('Y-m-d H:i:s',time()-(60*60*24*FEEDBACK_REMINDER_DAYS_AFTER_SHIPPING));
for($si=0;$si<sizeOf($sellers);$si++){
    printf("\nItemsAwaiting Feedback Seller %s\n",
        $sellers[$si]['id']
    );
    if(ebayApi::oauth2_refreshtoken_exists($sellers[$si]['id'])){
        if(!ebayApi::oauth2_usertoken_exists($sellers[$si]['id']) or ebayApi::get_oauth2_usertoken_lifetime($sellers[$si]['id']) < 1){
            try{
                ebayApi::refresh_oauth2_usertoken($sellers[$si]['id']);
            }catch(Exception $e){
                $api_error = 'refresh_oauth2_usertoken() for seller '.$sellers[$si]['id'].'  '.$e->getMessage();
            }
        }
    }
    getQueryResults(1,[
        'seller'=>$sellers[$si]['id'],
        'site_id'=>$EBAYAPI->get_site_id_from_name(constant('EBAY_SITE'))
    ],$transactions);
    $items = $transactions;

    if(!is_countable($items)){
        continue;
    }
    foreach($items as $k=>$item){
        if(!is_object( $item->Buyer) ) {
            continue;
        }
        $buyer = $item->Buyer;
        $user_id = $buyer->UserID;
        $auction = $item->Item;
        $item_id = $auction->ItemID;
        $transaction_id = $item->TransactionID;
        $feedback_query_sql = sprintf("SELECT et.orders_id,fr.feedback_reminder_id FROM ebay_transactions et LEFT JOIN feedback_reminder fr USING(orders_id) WHERE et.ebayid='%s' and et.transactionid='%s' and fr.feedback_reminder_id IS NULL",$item_id,$transaction_id);
        $feedback_query = xtc_db_query($feedback_query_sql);
        if(!xtc_db_num_rows($feedback_query)){
            continue;
        }
        $feedback_data = xtc_db_fetch_array($feedback_query);
        // ZUSATZCHECK
        // ES DARF K E I N FEEDBACKROLE SELLER EINTRAG IN EBAY_FEEDBACK SEIN!!
        $feedback_exists_query_raw = sprintf("SELECT id FROM ebay_feedback WHERE ItemNumber='%s' and CommentingUser='%s' AND FeedbackRole='Seller'",$item_id,$user_id);
        $feedback_exists_query = xtc_db_query($feedback_exists_query_raw);
        $feedback_exists = xtc_db_num_rows($feedback_exists_query);

        $feedback_order_query_sql = sprintf("SELECT o.orders_status,o.combined_orders_id,o.orders_id,o.date_shipping,o.ebayfeedback_block_status FROM orders o WHERE o.orders_id='%s'",$feedback_data['orders_id']);
        $feedback_order_query = xtc_db_query($feedback_order_query_sql);
        $feedback_order = xtc_db_fetch_array($feedback_order_query);

        // Wir haben eine kombinierte
        // NUN NOCHMAL PRUEFEN OB DIESE SCHON GESPEICHERT IST
        $combined_saved = false;
        if($feedback_order['combined_orders_id'] > 0){
            $feedback_order_query_sql = sprintf("SELECT o.orders_status,o.orders_id,o.date_shipping,o.ebayfeedback_block_status FROM orders o WHERE o.orders_id='%s'",$feedback_order['combined_orders_id']);
            $feedback_order_query = xtc_db_query($feedback_order_query_sql);
            $feedback_order = xtc_db_fetch_array($feedback_order_query);

            // CHECKEN OB DIE KOMBINIERTE BEREITS IM REMINDER GESPEICHERT WURDE
            $combined_feedback_query_sql = sprintf("SELECT fr.feedback_reminder_id FROM feedback_reminder fr WHERE fr.orders_id='%s' and fr.ebay_id='%s'",$feedback_order['orders_id'],$item_id);
            $combined_feedback_query = xtc_db_query($combined_feedback_query_sql);
            // WENN ES KEINE ERGEBNISSE GIBT BLEIBT DIE VARIABLE FALSE
            // DAS HEISST WIR SPEICHERN NICHT NOCHMAL
            $combined_saved = xtc_db_num_rows($combined_feedback_query);
        }

        if(!$feedback_exists and !$combined_saved and ( $feedback_order['orders_status'] == ORDERS_STATUS_VERSENDET or $feedback_order['orders_status'] == ORDERS_STATUS_ABGESCHLOSSEN) ){
            if($feedback_order['date_shipping'] < $accept_date and $feedback_order['ebayfeedback_block_status']==0 ){
                $reminder_array = array(
                    'orders_id'=>$feedback_order['orders_id'],
                    'ebay_id'=>$item_id,
                    'ebay_user_id'=>$user_id,
                );
                xtc_db_perform('feedback_reminder',$reminder_array);
            }

        }
    }
}
die('Done');