<?php
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized call');
}
set_time_limit(0);
ini_set('memory_limit','512M');
include('includes/cron_application_top.php');
if(!defined('STOCK_CHECK') or STOCK_CHECK != 'true'){
    die('STOCK_CHECK ist deaktiviert.');
}
require_once(DIR_FS_INC.'yes_products_calc_in_auction_quantity.inc.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
require_once(DIR_WS_CLASSES.'class.ebay.php');
require_once(DIR_FS_INC.'yes_write_notice.inc.php');
require_once(DIR_FS_CATALOG.'lang/german/admin/german.php');
if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') && MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
    require('includes/classes/yes_hitmeister.php');
    $hitmeister = new yes_hitmeister(true); // true = activate client
    $hitmeister_client = $hitmeister->client;
}
if(defined('MODULE_OTHER_AMAZON_STATUS') and MODULE_OTHER_AMAZON_STATUS == 'True'){
    require_once('includes/classes/amazon_sp.php');
}
require(DIR_FS_ADMIN.'includes/classes/class.storagequantity.php');
require(DIR_FS_INC.'xtc_get_serial_number.inc.php');

$query = yes_db_query("SELECT * FROM cancel_auctions");
if(!yes_db_num_rows($query)){
	die("Nothing to do\r\n");
}
include('includes/classes/simple_lock.php');
$lock = new simple_lock(\main::get_exportdata_path().basename($argv[0]).'.LOCK');
$lock->lock();

define('AMAZON_REPORTLIST_MAX_COUNT',80);
define('AMAZON_ADDRESS_FORMAT_ID',5);
//define('MARKETPLACE_ID',MODULE_OTHER_AMAZON_MARKETPLACE_ID);
//define('MERCHANT_ID',MODULE_OTHER_AMAZON_MERCHANT_ID);

/**
 * Benoetigte include Dateien
 */
require (DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require (DIR_FS_INC . 'xtc_get_customer_status_value.inc.php');
include('includes/config.amazonmws.inc.php');
include('includes/classes/amz_Helper.php');
include('includes/classes/amz_ReportList.php');
include('includes/classes/amz_Service.php');
include('includes/classes/amz_Feedhandler.php');
include('includes/classes/amz_SubmitFeed.php');
include('includes/classes/amz_Sync.php');
require_once('includes/classes/product.php');
include('includes/classes/order.php');


$basics = new basics;
if(defined('MODULE_AMAZON_STATUS') and MODULE_AMAZON_STATUS == 'True'){
    $A = new amazon_helper;
    $AS = new amazon_service();
}
error_reporting(E_ERROR);

$notice_users = main::get_notice_recipients('ebayapi_cart');
$notice_sender = 0;
$EBAYAPI = new ebayAPI;
$sites = array(); // zum zwischenspeichern

// SAMMEL ARRAY AMAZON FEEDS
$json_array = ['feeds'=>[]];

foreach($query as $row){
	printf("Verarbeite pID %s\r\n",$row['products_id']);
		// WENN ZWISCHENZEITLICH EIN ARTIKEL VOM CANCEL AUCTION HANDLING
		// DEAKTIVIERT WURDE, WIRD DER VORHANDENE EINTRAG GELOESCHT
	$products_cron_cancel_auctions_max_quantity_query = xtc_db_query(sprintf(
			"SELECT cron_cancel_auctions_max_quantity FROM %s WHERE products_id='%d' AND cron_cancel_auctions_exclude=0",
			TABLE_PRODUCTS, $row['products_id']
	));
	if(!xtc_db_num_rows($products_cron_cancel_auctions_max_quantity_query)){
		xtc_db_query(sprintf(
				"DELETE FROM cancel_auctions WHERE products_id='%d'",
				$row['products_id']
		));
		printf("pID %d wurde vom cron_cancel_auction Handling ausgeschlossen.",
				$row['products_id']
		);
		continue;
	}
	$products_cron_cancel_auctions_max_quantity_res = xtc_db_fetch_array($products_cron_cancel_auctions_max_quantity_query);
	$products_cron_cancel_auctions_max_quantity = (int)$products_cron_cancel_auctions_max_quantity_res['cron_cancel_auctions_max_quantity'];
	$collies = xtc_get_product_collies($row['products_id']);
	$SQ = new products_quantity($row['products_id']);
	$qty_available1 = $SQ->get_available1_qty();
	$amz_qty = $SQ->get_amazon_qty();
	$in_auction_qty = $SQ->get_auction_qty();
	printf("[%s] amz qty %s, in_auction %s, av1 %s\n",
		$row['products_id'],$amz_qty,$in_auction_qty,$qty_available1
	);
	
	if(defined('MODULE_OTHER_YES_HITMEISTER_API_STATUS') && MODULE_OTHER_YES_HITMEISTER_API_STATUS == 'True'){
		$in_hitmeister = $SQ->get_hitmeister_quantity();
	}else{
		$in_hitmeister = 0;
	}
        
	$process_ebay = true;       
        
        //
        // in_auction_qty repraesentiert wie oft der Artikel als Auktion oder
        // Variante in Auktion vorkommt
        // 
        
        
	// V1 >= @ebay und AMazon --> Script-Abbruch
	if($in_auction_qty <= $qty_available1 and $amz_qty <= $qty_available1 and $in_hitmeister <= $qty_available1){
		printf("  Artikel (in Auktion %d, bei Amazon %d, Kaufland %d) < Verf. Bestand: %s (nichts zu tun). Loesche Eintraege pID %s\r\n",
			$in_auction_qty,
			$amz_qty,
			$in_hitmeister,
			$qty_available1,
			$row['products_id']
		);
		xtc_db_query(sprintf(
			"DELETE FROM cancel_auctions WHERE products_id='%s'",
			$row['products_id']
		));
		continue;
	}
	if($in_auction_qty <= $qty_available1){
		printf("  Artikel in Auktion %s < Verf. Bestand: %s (nichts zu tun) (pID %s)\r\n",$in_auction_qty,$qty_available1,$row['products_id']);
		$process_ebay = false;
	}


	if($process_ebay){
		// AV1 ist kleiner als der Wert Artikel in laufende Auktionen und Amazon
		// also gehen wir nun die Auktionen durch und revisen oder beenden
		
		$records = array();
		$runnings_items = \YES4Trade\Model\ebay_auctions::get_runnings_by_products_id(intval($row['products_id']),
			[
				'id','ebay_id','site','user','type','quantity','end_time','products_id','sku'
			],[
				'quantity DESC','end_time DESC'
			]
		);
		if(sizeOf($runnings_items)){
			foreach($runnings_items as $ri){
				$records[] = $ri->toArray();
			}
		}
		// IN VARIANTEN SUCHEN
		// WIR SCHLIESSEN STAFFELPREIS-VARIANTEN AUS AN DIESER STELLE
		// EIGENES NACHGELAGERTES HANDLING
		$auctions_variations_query = xtc_db_query(sprintf(
			"SELECT eav.ebay_auctions_id AS id, ea.ebay_id, ea.site, ea.user, ea.type, eav.quantity, ea.end_time, eav.products_id,eav.sku FROM ebay_auctions_variations eav LEFT JOIN ebay_auctions ea ON ea.id = eav.ebay_auctions_id WHERE eav.products_id = '%s' AND ea.status =0 ORDER BY eav.quantity DESC , ea.end_time DESC",
			$row['products_id']
		));
		if(xtc_db_num_rows($auctions_variations_query)){
			while($r = xtc_db_fetch_array($auctions_variations_query)){
				$r['variation'] = true;
				$records[] = $r;
			}
		}
		
		// NUR NOCHMAL ZUR SICHERHEIT. DENN EIGENTLICH WIRD JA SCHON OBEN
		// GEPRUEFT OB in_auction_qty < av1
		if(!sizeOf($records) and $amz_qty < 1 and $in_hitmeister < 1){
			printf("  Keine Auktionen, nichts bei Amazon und kaufland. Loesche Eintraege pID %s\r\n",$row['products_id']);
			xtc_db_query(sprintf(
				"DELETE FROM cancel_auctions WHERE products_id=%s",
				$row['products_id']
			));
			continue;
		}


		$removed = 0;
		// BOF - AUCTIONS
		// DURCHLAUFE ALLE AUKTIONEN UND VARIANTENAUKTIONSEINTRAEGE DER PID
		foreach($records as $r){

			if(ebayApi::oauth2_refreshtoken_exists($r['user'])){
					if(!ebayApi::oauth2_usertoken_exists($r['user']) or ebayApi::get_oauth2_usertoken_lifetime($r['user']) < 1){
						try{
							ebayApi::refresh_oauth2_usertoken($r['user']);
						}catch(Exception $e){
							$api_error = 'refresh_oauth2_usertoken() for seller '.$r['user'].'  '.$e->getMessage();
						}
					}
			}


			echo "\r\n\r\n---------------------------------------\r\n\r\n";
			if($r['variation'] === true){
				printf("Variante %s ",$r['sku']);
				if(strpos($r['sku'],'-STFLPRS_') !== false){
					echo " STAFFELPREIS VARIANTE - WIRD SPAETER VERARBEITET";
					continue;
				}
			}
			printf("Auktion %s\r\n",$r['ebay_id']);
			if(!isset($sites[ $r['site'] ])){
				$sites[ $r['site'] ] = $EBAYAPI->get_site_id_from_name($r['site']);
			}
			printf("@eBay %d / qty_available1 %d\r\n",
				$r['quantity'],$qty_available1
			);

			// alle auktionen wo der artikel enthalten ist, duerfen den AV1
			// Wert nicht uebersteigen
		    $revise_qty = $qty_available1; // 18.07.25
		    $current_ebay_auction_db_quantity = $r['quantity'];
			$ea = new ebay_auction($r['id']);
			$pruefwert = $current_ebay_auction_db_quantity - ($qty_available1 );
			if($current_ebay_auction_db_quantity <= $pruefwert){
				$revise_qty = 0;
				// new_qty wird spaeter verwendet um in_auction
				// bestand zu verringern (in_auction-=new_quantity)
				$new_qty = $current_ebay_auction_db_quantity; 
			}
			if($revise_qty < 0) {
				printf("\r\n\tRevise QTY < 0: Setze revise_qty auf 0");
				$revise_qty = 0;
			}
			// new_qty wird spaeter verwendet um in_auction
			// bestand zu aktualisieren (in_auction-=new_quantity)
			$new_qty = $current_ebay_auction_db_quantity - $revise_qty;

			if( $revise_qty == $current_ebay_auction_db_quantity){
				printf("revise_qty %d == current_item_db_quantity %d\r\n",
					$revise_qty,
					$current_ebay_auction_db_quantity
				);
				continue;
			}
                        
			// WENN revise_qty GROESSER IST ALS 
			// product.cron_cancel_auctions_max_quantity
			// DANN revise_qty VERRINGERN
			$new_qty_diff = 0;
			if($products_cron_cancel_auctions_max_quantity > 0){
				if($products_cron_cancel_auctions_max_quantity < $revise_qty){
					$new_qty_diff = $revise_qty - $products_cron_cancel_auctions_max_quantity;
					$revise_qty = $products_cron_cancel_auctions_max_quantity;
				}
			}
			$new_qty = $new_qty - $new_qty_diff;

			if($new_qty <= 0){
				echo "... nichts zu tun - naechster Datensatz\r\n";
				continue;
			}
                        

			printf("\r\n\tcurrent_item_db_quantity: %d\r\n\trevise_qty: %d\r\n\tqty_available1: %d\r\n\tnew_qty: %d (wird spaeter vom in_auction Wert abgezogen))\r\n\tin_auction_qty: %d\r\n\r\n",
				$current_ebay_auction_db_quantity,$revise_qty,$qty_available1,$new_qty,$in_auction_qty
			);
			if( $revise_qty < 0 or ($revise_qty == 0 and $qty_available1 <= 0) or ($new_qty - $in_auction_qty == 0) or ($revise_qty == 0 and $current_ebay_auction_db_quantity == 1) or ($new_qty == $current_ebay_auction_db_quantity) ){
		            if(isset($r['variation'])){
						$variation_sum = \YES4Trade\Model\ebay_auctions_variations::calc_quantity_by_ebay_auctions_id_excluding_sku(
							intval($r['id']),$r['sku']
						);
						printf("\r\n\tVariante der Auktion - %s Varianten anderer pID vorhanden",$variation_sum);
		                if($variation_sum < 1){
		                    $do_end_auction = true;
		                }
		            }else{
		                 $do_end_auction = true;
		            }
			}else{
		            // REVISE
		            $do_end_auction = false;
			}
			if($do_end_auction){
				//printf("\r\nid: %d, revise_qty: %d, qty_available1: %d, new_qty=%d,in_auction_qty: %d\r\n",$r['id'],$revise_qty,$qty_available1,$new_qty,$in_auction_qty);
			    if(defined('EBAY_FEATURE_OUTOFSTOCK') and EBAY_FEATURE_OUTOFSTOCK == 'True' and in_array($r['type'],array('FixedPriceItem','StoreFixedPrice'))){
					printf("  EBAY_FEATURE_OUTOFSTOCK FixedPriceItem %s - nicht beendet, auf Null gesetzt\r\n",$r['ebay_id']);
					if(isset($r['variation'])){
						$oos_status = $EBAYAPI->set_outofstock($r['id'], $r['sku']);
					}else{
						$oos_status = $EBAYAPI->set_outofstock($r['id']);
					}
					if($oos_status['status'] == 'success'){
						$removed += $current_ebay_auction_db_quantity;
                        if(isset($r['variation'])){
							\YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
								'quantity'=>0,
								'ebay_auctions_id'=>intval($r['id']),
								'sku'=>$r['sku']
							]);
							ebay_auction::add_history($r['id'], 0, '[cron_cancel_auction] Kein Bestand mehr fuer Variante '.$r['sku'].', deaktivieren');
							yes_update_products_in_auction_quantity(intval($r['products_id']),
								yes_products_calc_in_auction_quantity(intval($r['products_id'])),
                                sprintf('[cron_cancel_auctions:variation] Revise Variante SKU %s in Auktion %s auf 0',
                                    $r['sku'],
                                    $ebay_id
								),
								true // overwrite!
							);
                        }else{
							\YES4Trade\Model\ebay_auctions::update_ebay_auction(['quantity'=>0,'id'=>intval($r['id'])]);
							ebay_auction::add_history($r['id'], 0, '[cron_cancel_auction] Kein Bestand mehr, deaktivieren');
							yes_update_products_in_auction_quantity($r['products_id'],
								yes_products_calc_in_auction_quantity(intval($r['products_id'])),
								sprintf('[cron_cancel_auctions] Revise Auktion %s auf 0',
                                	$ebay_id
								),
								true // OVERWRITE!!!!
							);
						}
					}else{
						yes_write_notice(
							sprintf('Autom. OutOfStock Auktion %s nach Shopkauf',$r['ebay_id']),
							$oos_status['text'], $notice_sender, $notice_users
						);
						printf(" eBay Fehler OutOfStock: %s\r\n",$oos_status['text']);
					}
			    }else{
					printf("\tBEENDE AUKTION %s\r\n",$r['ebay_id']);
					$end_status = $EBAYAPI->ebay_end_auction( $r['id'] );
					if($end_status['status'] != 'success'){
						yes_write_notice(
							sprintf('Autom. Beenden Auktion %s nach Shopkauf',$r['ebay_id']),
							$end_status['text'], $notice_sender, $notice_users
						);
					}else{
		            	$removed += $current_ebay_auction_db_quantity;
					}
			    }
			}else{
				// ------
				// REVISE
				//-------
				$site_id = $sites[ $r['site'] ];
				$ebay_id = $r['ebay_id'];
				$item = new \stdClass();
				if(isset($r['variation'])){
					$Variations = new \stdClass();
					$Variation = new \stdClass();
				}
				$item->ItemID = $ebay_id;
				if(isset($r['variation'])){
					$Variation->SKU = $r['sku'];
					$Variation->Quantity = $revise_qty;
					$Variations->Variation[] = $Variation;
					$item->Variations = $Variations;
				}else{
					$item->Quantity = $revise_qty;
				}
                $res = $EBAYAPI->revise_auction($r['id'], $item);

				if($res != ''){
					yes_write_notice(
						sprintf('Autom. Revise Auktion %s nach Shopkauf',$r['ebay_id']),
						sprintf('EBAYID %s: pID %s Revise auf %s (new_qty: %s)<br /><b>Fehlermeldung:</b><br />%s',
							$ebay_id,
							$r['products_id'],
							$revise_qty,
							$new_qty,
							$res
						),
						$notice_sender, $notice_users
					);
				}else{
					if(isset($r['variation'])){
						// wofuer der revise counter ist weiss ich nicht, muss aber scheinbar beruecksichtigt werden
						$revise_counter = 0;
						$eav = \YES4Trade\Model\ebay_auctions_variations::get_by_ebay_auctions_id_and_sku(
							intval($r['id']), $r['sku'],
							['revise_counter']
						);
						if($eav !== null){
							$revise_counter = $eav->revise_counter;
						}
						\YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
							'quantity'=>intval($revise_qty),
							'revise_counter'=>intval($revise_counter)+$revise_qty,
							'ebay_auctions_id'=>intval($r['id']),
							'sku'=>$r['sku']
						]);
						$qcomm = sprintf("[%s] Variante SKU %s Revise %d",
							basename(__FILE__),
							$r['sku'], $revise_qty
						);
						ebay_auction::add_history($r['id'], $revise_qty, $qcomm);
						yes_update_products_in_auction_quantity($r['products_id'],
							yes_products_calc_in_auction_quantity(intval($r['products_id'])),
							sprintf('[cron_cancel_auctions] Revise Auktion %s Variante SKU %s auf %d',
								$ebay_id,$r['sku'],$revise_qty
							),true // true heisst overwrite!!
						);
					}else{
						\YES4Trade\Model\ebay_auctions::update_ebay_auction([
							'quantity'=>intval($revise_qty),
							'revise_counter'=>intval($ea->getReviseCounter())-intval($new_qty),
							'id'=>intval($r['id'])
						]);
						$qcomm = sprintf("[%s] Revise",
								basename(__FILE__)
						);
						ebay_auction::add_history(intval($r['id']), intval($revise_qty),$qcomm);
						yes_update_products_in_auction_quantity(intval($r['products_id']),
							yes_products_calc_in_auction_quantity(intval($r['products_id'])),
							sprintf('[cron_cancel_auctions] Revise Auktion %s auf %d',
								$ebay_id,$revise_qty
							),true // true heisst overwrite!!
						);
					}
					$removed += $new_qty;
					/** DAS IST DOPPELT!!!
					// HANDLING STKLISTEN
					if(isset($r['set']) and $r['set'] === True){
						// DA STKLISTEN KEINE VARIANTEN MEHR
						// HABEN DUERFEN, KEINE AENDERUNG
						// VORGENOMMEN - 05/2020
					    $collies = xtc_get_product_collies($r['set_products_id']);
					    foreach($collies as $colli){
							$com = ($colli['collie_products_id'] == $r['products_id']) ? '[cron cancel auctions] SET '.$r['set_products_id'].' ebay variation revise to '.$revise_qty : '[cron cancel auctions] SET '.$r['set_products_id'].'/Colli '.$r['products_id'].' ebay variation revise to '.$revise_qty;
							$insert_sql_array = array(
						    	'products_id'=>$colli['collie_products_id'],
						    	'editor_id'=>0,
						    	'date_saved'=>'now()',
						    	'comments'=>$com
							);
							xtc_db_perform('products_history',$insert_sql_array);
					    }
					}else{
						printf("\r\nRevise Auktion %s: %d Stk. (akt. in_auction: %d)\r\n",
							$ebay_id,-$new_qty,$current_ebay_auction_db_quantity-$new_qty
						);
						yes_update_products_in_auction_quantity($r['products_id'],
							-$new_qty,
							sprintf('Revise Auktion %s: %s Stk. (akt. DB auction quantity: %d)',
								$ebay_id,-$new_qty,$current_ebay_auction_db_quantity-$new_qty
						));
					}*/
				} // ende revise erfolgreich
			} // ende revise der auktion
		} // ende foreach auktionen mit artikel

		// -------------
		// STAFFELPREISE
		// -------------
	    if(defined('MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS') and MODULE_OTHER_STAFFELPREISE_ALS_VARIANTEN_STATUS == 'True'){
			$staffelpreis_query = yes_query(
				"SELECT DISTINCT ea.id FROM ebay_auctions ea 
					JOIN ebay_auctions_variations eav ON eav.ebay_auctions_id = ea.id
					WHERE ea.status = 0
					AND eav.products_id =:id
					AND eav.sku LIKE '%-STFLPRS_%'",
				['id'=>intval($row['products_id'])]
			);
			foreach($staffelpreis_query as $staffel_auction){
				$ea = new ebay_auction(intval($staffel_auction['id']));
				printf("\nStaffelpreis Auktion %s\n",
					$ea->getEbayId()
				);
				$SQ = new products_quantity($row['products_id']);
				$qty_available1 = $SQ->get_available1_qty();
				$in_auction_qty = $SQ->get_auction_qty();
				$total_staffelpreis_qty = 0;
				foreach($ea->getVariations() as $variation){
					$parts = explode('-STFLPRS_',$variation->getSku());
					$sku = $parts[0];
					$staffelpreis_menge_multiplier = intval($parts[1]);
					$staffelpreis_variante_menge = $staffelpreis_menge_multiplier*$variation->getQuantity();
					$total_staffelpreis_qty += $staffelpreis_variante_menge;
					if($qty_available1 < $staffelpreis_variante_menge){
						printf("\tVariante SKU %s mit %s Stk in der Auktion muss auf %d (v1) aktualisiert werden.\n",
							$variation->getSku(),
							$staffelpreis_variante_menge,
							$qty_available1
						);
						// wieder abziehen
						$total_staffelpreis_qty -= ($staffelpreis_variante_menge-$qty_available1);
					}
				}
				if($total_staffelpreis_qty > $qty_available1){
					$qty_to_remove = $total_staffelpreis_qty - $qty_available1;
					printf("\n\tinsgesamt %d Stk der sku %s - Auktion muss um %d Stk verringert werden auf v1 %d.",
						$total_staffelpreis_qty,
						$sku,
						$qty_to_remove,
						$qty_available1
					);
					$ea = new ebay_auction(intval($staffel_auction['id']));
					$SQ = new products_quantity($row['products_id']);
					$qty_available1 = $SQ->get_available1_qty();
					$in_auction_qty = $SQ->get_auction_qty();
					// wir wollen von den groessten Staffelungen
					// als erstes abziehen
					$variation_remove_array = [];
					foreach($ea->getVariations() as $variation){
						$parts = explode('-STFLPRS_',$variation->getSku());
						$sku = $parts[0];
						$staffelpreis_menge_multiplier = intval($parts[1]);
						$staffelpreis_variante_menge = $staffelpreis_menge_multiplier*$variation->getQuantity();
						$variation_remove_array[] = [
							'variation_quantity'=>$variation->getQuantity(),
							'quantity'=>$staffelpreis_variante_menge,
							'staffel_quantity'=>$staffelpreis_menge_multiplier,
							'sku'=>$variation->getSku(),
							'revise_counter'=>$variation->getReviseCounter(),
							'products_id'=>$variation->getProductsId(),
						];
					}
					usort($variation_remove_array, function($a, $b) {
    					return $b['quantity'] <=> $a['staffel_quantity'];
					});
					$total_removed = 0;
					foreach($variation_remove_array as $remove_entry){
						$rest_to_remove_qty = $qty_to_remove - $total_removed;
						if($rest_to_remove_qty < 1){
							echo "\n\tNichts mehr zu tun\n";
							break;
						}
						$item = new \stdClass();
						$Variations = new \stdClass();
						$Variation = new \stdClass();
						$item->ItemID = $ea->getEbayId();
						$Variation->SKU = $remove_entry['sku'];
						if($rest_to_remove_qty > $remove_entry['quantity']){
							// komplett auf 0 revisen
							printf("\n\tVariante %s hat %d Stk, auf 0 setzen (%d muessen insgesamt beendet werden, %d wurden schon beendet)",
								$remove_entry['sku'],
								$remove_entry['quantity'],
								$qty_to_remove,
								$total_removed
							);
							$Variation->Quantity = 0;
							$abzug = $remove_entry['quantity'];
						}else{

							$gesamtmenge_variante = $remove_entry['staffel_quantity']*$remove_entry['quantity'];
							$abgezogen = 0;
							$staffelung_counter = 0;
							while($abgezogen < $rest_to_remove_qty){
								$abgezogen += $remove_entry['staffel_quantity'];
								$staffelung_counter++;
							}
							printf("\n\tEs muessen $staffelung_counter Stk der Staffelung ".$remove_entry['staffel_quantity']." abgezogen werden um auf $rest_to_remove_qty zu kommen\n");

        					$rest_to_remove_qty -= ($staffelung_counter * $remove_entry['staffel_quantity']);

							printf("\n\tVariante %s hat %d Stk, auf %d setzen (%d muessen insgesamt beendet werden, %d wurden schon beendet)",
								$remove_entry['sku'],
								$remove_entry['quantity'],
								$remove_entry['quantity']-$staffelung_counter,
								$qty_to_remove,
								$total_removed
							);
							$Variation->Quantity = $remove_entry['variation_quantity']-$staffelung_counter;
							$abzug = $staffelung_counter*$remove_entry['staffel_quantity'];
						}
						$Variations->Variation[] = $Variation;
						$item->Variations = $Variations;
						$res = $EBAYAPI->revise_variation_auction($staffel_auction['id'],$item);
						if(empty($res)){
							$total_removed += $abzug;
							\YES4Trade\Model\ebay_auctions_variations::update_ebay_auctions_variations_by_ebay_auctions_id_and_sku([
								'quantity'=>intval($Variation->Quantity),
								'revise_counter'=>intval($remove_entry['revise_counter'])+$abzug,
								'ebay_auctions_id'=>intval($ea->getId()),
								'sku'=>$Variation->SKU
							]);
							$qcomm = sprintf("[%s] Variante SKU %s Revise %d",
								basename(__FILE__),
								$Variation->SKU, $Variation->Quantity
							);
							ebay_auction::add_history(
								intval($ea->getId()), 
								intval($Variation->Quantity), 
								$qcomm
							);
							yes_update_products_in_auction_quantity(intval($remove_entry['products_id']),
								yes_products_calc_in_auction_quantity(intval($remove_entry['products_id'])),
								sprintf('[cron_cancel_auctions] Revise Auktion %s Staffelpreis Variante SKU %s auf %d',
									$item->ItemID,$Variation->SKU,$Variation->Quantity
								),true // true heisst overwrite!!
							);
						}else{
							$errcom = sprintf('SKU %s Revise auf %d hat nicht geklappt.<br /><b>Fehlermeldung:</b><br />%s',
								$Variation->SKU,
								$Variation->Quantity,
								$res
							);
							yes_write_notice(
								sprintf('Revise Staffelpreis Auction %s failed',$item->ItemID),
								$errcom,
								$notice_sender, $notice_users
							);
							echo "\n\t".$errcom;
						}
					}
				}
			}
		}
	} // end if process_ebay
	$removed = 0;
	if($amz_qty > 0){
		$SQ = new products_quantity($row['products_id']);
		$qty_available1 = $SQ->get_available1_qty();
		
		$A = new amazon_helper();
		$sku_query = xtc_db_query(sprintf(
			"SELECT sku,quantity,selling_partner_id FROM amazon_products WHERE products_id='%s' ORDER BY quantity",
			$row['products_id']
		));

		if($amz_qty > $qty_available1){
			$amz_removed = 0;
                        while($sku = xtc_db_fetch_array($sku_query)){
			
				if( ($amz_qty - $amz_removed) > $qty_available1){
					if((($amz_qty - $amz_removed) - $sku['quantity']) >= $qty_available1){
						$update_qty = 0;
						$amz_removed += $sku['quantity'];
					}else{
						$update_qty = $qty_available1;
						$amz_removed += ($amz_qty - $amz_removed)-$qty_available1;
					}
					printf('<li>[amazon Seller %s] AV1: %s, amz_qty: %s, update_qty: %s',$sku['selling_partner_id'], $qty_available1,$amz_qty,$update_qty);
				}else{
					continue;
				}
                                
				$fl = yes_get_products_amazon_fulfillmentlatency($row['products_id']);
                                if(!isset($json_array['feeds'][$sku['selling_partner_id']])){
                                    $json_array['feeds'][$sku['selling_partner_id']] = [];
                                }
                                
                                $json_array['feeds'][$sku['selling_partner_id']][] = [
                                    'sku'=>$sku['sku'],
                                    'update_qty'=>$update_qty,
                                    'fl'=>$fl,
                                    'type'=>'update_qty',
                                ];
			}
		} // end if amz_qty > qty_available1
	}
        
        if($in_hitmeister > 0){
            $process_hitmeister = true;
            // true = local qty
            $local_qty = $hitmeister->get_quantity( $row['products_id'], true );
            
            $part = 'amount';
            $id_unit = yes_hitmeister::get_id_unit_from_products_id($row['products_id']);
            $res = json_decode($hitmeister->get_unit($id_unit));
            $unit = $res->data;
            //$unit = $hitmeister_client->units()->get($id_unit);
            $id_item = $unit->id_item;
            if($unit === false){
                printf("Kaufland pID %d / id_unit %s: Cant get unit from API",
                        $row['products_id'], $id_unit
                );
                $process_hitmeister = false;

            }
            if($process_hitmeister){
                $old_unit_amount = $unit->amount;
                $target_qty = $qty_available1;
                $deactivate_unit = false;
                if($qty_available1 < 1){
                    $deactivate_unit = true;
                }
		$unit_data = array(
                    //'condition'=>$unit->condition,
                    'listing_price'=>$unit->price,
                    "amount"=> $target_qty
		);
                if($unit->status == 'ONHOLD' and $qty_available1 > 0){
                    $unit_data['status'] = 'AVAILABLE';
                }
                
		try{
                    if($deactivate_unit){
                        $unit_data = [
                            'status' => 'ONHOLD',
                        ];
                        $res = json_decode( $hitmeister->units_update( $id_unit, $unit_data ));
                        yes_hitmeister::update_local_quantity(
                            $row['products_id'],
                            0
                        );
                        $com = "Kaufland - Status set to ONHOLD because no items left";
                        yes_add_products_history($row['products_id'], '[cron auction end] '.$com);
                        printf("pID %d %s\r\n",$row['products_id'],$com);
                    }else{
                        $res = json_decode($hitmeister->units_update($id_unit, $unit_data));
                        $update = $res->data;
			//$update = $hitmeister_client->units()->update($id_unit, $unit_data);
			$msg = ($update->amount === $target_qty) ? '' : 'Update fehlgeschlagen';
                        if($update->amount === $target_qty){
                            yes_hitmeister::update_local_quantity(
                                $row['products_id'],
                                $update->amount
                            );
                            $com = sprintf(
                                "Kaufland - update amount from %d to %d",
                                $old_unit_amount,$update->amount
                            );
                            yes_add_products_history($row['products_id'], '[cron auction end] '.$com);
                            printf("pID %d %s\r\n",$row['products_id'],$com);
                        }
                        if($msg != ''){
                            echo $msg."\r\n";
                        }
                    }
		}catch(Exception $e){
			printf('Kaufland pID %d / id_unit "%s" amount update to %d failed. Reason: %s'."\r\n",
                            $row['products_id'],$id_unit, $unit_data['amount'],
                            $e->getMessage()
                        );
		}
            } // end if process hitmeister
            
        }
	xtc_db_query(sprintf(
		"DELETE FROM cancel_auctions WHERE products_id='%s'",
		$row['products_id']
	));
}
if(sizeOf($json_array['feeds'])){
    $ASP = new amazon_sp(null,false);
    foreach($json_array['feeds'] as $selling_partner_id => $items){
        foreach($items as $it){
            $afc = new \YES4Trade\Model\amazon_feed_collector([
                'selling_partner_id'=>$selling_partner_id,
                'sku'=>"".$it['sku'],
                'feed_type'=>'JSON_LISTINGS_FEED.quantity',
                'feed_value'=>"".$it['update_qty'], // verlangt string
                'fulfillment_latency'=>(int)$it['fl'],
                'from_cron'=>1
            ]);
            $afc->create();
        }
        // ES WIRD IN secure_files/AMAZON-SP-FEEDS_TO_CREATE/
        // EINE DATEI ANGELEGT, zb "1698133499.xml"
        // DIESE WIRD DANN VON cron_amazon_sp_feeds.php
        // VERARBEITET
        //$ASP->createFeedFile($json);
    }
}
$lock->destroy();
die('Fertig.');
