<?php
include('includes/cron_application_top.php');
include('includes/config.amazonmws.inc.php');
include('includes/classes/amz_ReportList.php');
include('includes/classes/amz_Service.php');
include('includes/classes/amz_Helper.php');
include('includes/classes/amz_SubmitFeed.php');
include('includes/classes/amz_Feedhandler.php');
include('includes/classes/amz_Sync.php');
require_once('includes/classes/product.php');
require_once('includes/classes/class.basics.php');
require_once(DIR_WS_CLASSES.'amazon_fba_order.php');
ini_set('memory_limit','1200M');
$exportdata_path = \main::get_exportdata_path();
define('AMAZON_SAVE_PATH',$exportdata_path.'amazon/');
define('AMAZON_REPORTLIST_MAX_COUNT',80);
define('AMAZON_ADDRESS_FORMAT_ID',5);
define('MARKETPLACE_ID',MODULE_OTHER_AMAZON_MARKETPLACE_ID);
define('MERCHANT_ID',MODULE_OTHER_AMAZON_MERCHANT_ID);

function amazon_get_request_error_msg($ex){
	return sprintf("Caught Exception: %s<br />Response Status Code: %s<br />Error Code: %s<br />Error Type: %s<br />Request ID: %s<br /><pre>%s</pre>",
			$ex->getMessage(),
			$ex->getStatusCode(),
			$ex->getErrorCode(),
			$ex->getErrorType(),
			$ex->getRequestId(),
			htmlentities($ex->getXML())
	);
}

$A = new amazon_helper;
$AS = new amazon_service();
$basics = new basics;
$dayspan = '-1 Day';

// BOF - BEI JEDEM CRON AUFRUF EINEN ANDEREN USER
$auth_user_array = $A->get_auth_user_array();
if(sizeOf($auth_user_array) > 1){
	$toggle_merchant_file = \main::get_exportdata_path().'CRON_AMAZON_GET_AMAZON_FULFILLED_SHIPMENTS_DATA.TOGGLE';
	if(!is_file($toggle_merchant_file)){
		file_put_contents($toggle_merchant_file,'0');
	}
	$merchant_nr = (int)file_get_contents($toggle_merchant_file);
	$mercID = $auth_user_array[$merchant_nr];
	$new_merchant_nr = (($merchant_nr+1) >= sizeOf($auth_user_array)) ? 0 : $merchant_nr+1;
	file_put_contents($toggle_merchant_file,$new_merchant_nr);
}else{
	$mercID = $auth_user_array[0];
}
// EOF - BEI JEDEM CRON AUFRUF EINEN ANDEREN USER
$auth_params = $A->get_auth_data_array($mercID);

$to = new DateTime('Now');
$from = new DateTime($dayspan);

$call = '_GET_AMAZON_FULFILLED_SHIPMENTS_DATA_';

$parameters = array (
	'Marketplace' => $auth_params['marketplace_id'],
	'Merchant' => $auth_params['merchant_id'],
	'AvailableToDate' => $to,
	'AvailableFromDate' => $from,
	'ReportTypeList'=>array ('Type' => array ($call)),
	'MaxCount' => AMAZON_REPORTLIST_MAX_COUNT,
//	'Acknowledged' => false
);
if(!empty($auth_params['mwsauthtoken'])){
	$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
}
$service = $AS->get_service();
$RL = new ReportList;

$request = new MarketplaceWebService_Model_GetReportListRequest($parameters);
$ReportListArray = $RL->invokeGetReportList($service, $request);
if(!sizeOf($ReportListArray)){
	die('Keine '.$call.' Reporte verfuegbar.');
}
foreach($ReportListArray as $nr=>$Report){
	printf("%s/%s [%s] %s vom %s (%s)\r\n\r\n",($nr+1),sizeOf($ReportListArray),$Report['ID'],$Report['NAME'],xtc_date_short($Report['DATE_AVAILABLE']),($Report['ACKNOWLEDGED'] === true)?'ACK':'NO ACK');
	$parameters = array (
		'Marketplace' => $auth_params['marketplace_id'],
		'Merchant' => $auth_params['merchant_id'],
		'Report' => @fopen('php://memory', 'rw+'),
		'ReportId' => $Report['ID']
	);
	if(!empty($auth_params['mwsauthtoken'])){
		$parameters['MWSAuthToken'] = $auth_params['mwsauthtoken'];
	}
	ob_start();
	$service = $AS->get_service();
	$R = new Report;
	$R->setReportType($Report['NAME']);
	$request = new MarketplaceWebService_Model_GetReportRequest($parameters);
	$ff_shipments = @$R->invokeGetReport($service, $request);
	ob_end_clean();
	if(!sizeOf($ff_shipments)){
		die('Keine Fulfilled Shipments Daten zum Verarbeiten');
	}
        foreach($ff_shipments as $ff_shipment ){
            if(empty($ff_shipment['amazon-order-id'])){
                continue;
            }
            printf("\r\ncheck amazon order #%s\r\n\r\n",
                    $ff_shipment['amazon-order-id']
            );
            
            // ZWEITER PARAMETER IST TESTMODUS - true/false
            $fba_ord = new amazon_fba_order($mercID, true);
            $fba_ord->set_from_amazon_response($ff_shipment);
            if($fba_ord->check_create_amazon_order_fba()){
                    $fba_ord->create_amazon_order_fba_entry();
                    printf("\tAmazon Order FBA #%s imported as oID %s\r\n",
                            $fba_ord->getAmazon_orders_fba_id(),
                            $fba_ord->getOrders_id()
                    );
            }else{
                    echo "\r\n".implode("\r\n",$fba_ord->get_errors());
            }
            die("\r\nHIER ABBRECHEN\r\n");
        }
}

die("\r\nAufruf ".basename(__FILE__)." abgeschlossen\r\n");