<?php
if(php_sapi_name() !== 'cli' and php_sapi_name() !== 'cgi' and php_sapi_name() !== 'cgi-fcgi'){
	die('unauthorized http call');
}
include('includes/cron_application_top.php');
require_once (DIR_FS_INC . 'yes_write_notice.inc.php');
require_once (DIR_FS_INC . 'yes_end_auction_add.inc.php');
// fuer order-recalc() aus yes_end_auction heraus
require_once (DIR_FS_INC . 'xtc_oe_customer_infos.inc.php');
require_once('includes/classes/product.php');
require_once('includes/classes/order.php');
require_once('includes/classes/class.basics.php');
require_once('includes/classes/simple_lock.php');
if(!defined('MODULE_OTHER_AMAZON_STATUS') or MODULE_OTHER_AMAZON_STATUS != 'True'){
	die('Amazon is not enabled');
}
$log_filename = 'importdata/'.basename(__FILE__).'.log';
$basics = new basics;
$send_notification_mail = false;
$lock_minutes = 20;
$lock_file = new simple_lock('exportdata/'.basename(__FILE__).'.locked',$send_notification_mail,'1',$lock_minutes);
$lock_file->lock();
$items = array();
$query = xtc_db_query(sprintf(
	"SELECT op.* FROM %s op LEFT JOIN %s o USING(orders_id) WHERE o.source='amazon' AND o.orders_status='%s' and op.products_id=-1 and op.amazon_sku != ''",
	TABLE_ORDERS_PRODUCTS,TABLE_ORDERS,ORDERS_STATUS_BEZAHLT
));
while($record = xtc_db_fetch_array($query)){
	$items[] = $record;
}
$messages = array();
foreach($items as $item){
	$query = xtc_db_query(sprintf(
		"SELECT products_id,products_tax_class_id,products_model FROM %s WHERE products_ean='%s'",
		TABLE_PRODUCTS,$item['amazon_sku']
	));
	$matches_num = xtc_db_num_rows($query);
	if($matches_num == 1){
		$product_record = xtc_db_fetch_array($query);
		$pID = $product_record['products_id'];
		$products_model = $product_record['products_model'];
		$tax_class_id = $product_record['products_tax_class_id'];
		$tax_rate = xtc_get_tax_rate($tax_class_id);
		
		$update_sql_array = array(
			'products_id'=>$pID,
			'products_model'=>$products_model,
			'products_tax'=>$tax_rate
		);
		if(defined('MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON') and MODULE_OTHER_AMAZON_PRODUCTS_NAME_FROM_AMAZON != 'True'){
			$update_sql_array['products_name'] = xtc_get_products_name($pID);
		}
		xtc_db_perform('orders_products',$update_sql_array,"update",'orders_products_id='.$item['orders_products_id']);
		yes_end_auction_add($pID, $item['products_quantity']);
		$order = new order($item['orders_id']);
		// BOF - Neuberechnung MWST Versand - Ticket 1620
		if(number_format($tax_rate,2,'.','') != number_format($item['products_tax'],2,'.','')){
		    // EIGENTLICH UNNUETZ, DA DAS BEIM RECALC ERMITTELT UND AKTUALISIERT WIRD
		    $update_sql_array = array(
			'tax_rate_percent'=>$tax_rate
		    );
		    xtc_db_perform(TABLE_ORDERS_TOTAL,$update_sql_array,'update',"orders_id='".$item['orders_id']."' AND class='ot_shipping'");
		    $order = new order($item['orders_id']);
		    $order->recalc();
		}
		// EOF - Neuberechnung MWST Versand - Ticket 1620
		$order->add_history($order->info['orders_status'], 0, sprintf('[Autom. EAN/SKU Zuweisung] Der unbekannte Amazon Artikel %s (pID %s) wurde zugewiesen.',
				$item['products_name'],$pID
		));
		printf("ORDER %s / sku %s allocated with pID %s\r\n",$item['orders_id'],$item['amazon_sku'],$record['products_id']);
	}elseif($matches_num > 1){
		$products_id_array = array();
		while($record = xtc_db_fetch_array($query)){
			$products_id_array[] = $record['products_id'];
		}
		$messages[] = sprintf("ORDER %s / sku %s exists multiple as pID %s\r\n",$item['orders_id'],$item['amazon_sku'],implode(',',$products_id_array));
	}else{
		$messages[] = sprintf("ORDER %s / sku %s not exists\r\n",$item['orders_id'],$item['amazon_sku']);
	}
}
if(sizeOf($messages)){
	$log_content = basename(__FILE__).' - '.date('Y-m-d H:i:s')."\r\n";
	$log_content .= implode("\r\n",$messages);
	$basics->create_file($log_filename,$log_content);
	chmod($log_filename,0700);
	echo "\r\nEs wurde ".$log_filename." mit ".sizeOf($messages)." Eintraegen erstellt. \r\n";
}
echo "\r\nDone. Es wurden ".sizeOf($items)." unzugewiesene Amazonartikel durchlaufen\r\n";
$lock_file->destroy();

