<?php
/**
 * wird included in stats_kasse.php
 */
require_once(DIR_WS_CLASSES.'counter_history.php');
require_once(DIR_WS_CLASSES.'class.basics.php');
$branches_id = (int)xtc_db_input($_GET['branches_id']??0);

$day = $_GET['day'] ?? date('Y-m-d');
if($branches_id > 0){
    $CH = new counter_history($branches_id);
    $save_date = new DateTime($day.' '.date('H:i:s'));
    $counter_activities = $CH->get_counter_activities($save_date,$branches_id);
    if(isset($_GET['dl'])){
        $basics = new basics;
        $basics->download_file($CH->getSave_path().$CH->SUMMARY_DIR.DIRECTORY_SEPARATOR.$day.DIRECTORY_SEPARATOR.sprintf($CH->DAILY_ZIP_FILENAME,$branches_id));
    }
}
$branches = array(array(
    'id'=>'','text'=>TEXT_SELECT
));
if(defined('YES_BRANCHES_COUNT') and YES_BRANCHES_COUNT > 0){
    $branches_query = xtc_db_query("select * from branches ORDER by title");
    while($branch = xtc_db_fetch_array($branches_query)){
        $branches[] = array(
            'id'=>$branch['branches_id'],
            'text'=>xtc_db_prepare_input($branch['title'])
        );
    }
}else{
    $branches[] = array(
        'id'=>'0',
        'text'=>TEXT_MAIN_STORAGE
    );
}
if(!isset($_GET['day'])){
?>
<script>
    $(function(){
       $('input#counter_history_start').on('click',function(){
        if( $('form[name="branch_select"] select[name="branches_id"]').val() == ''){
            console.log('no branch');
            return false;
        }
        if( $('input[name="day"]').val() == ''){
            console.log('no date');
            return false;
        }
        if (!Date.parse( $('input[name="day"]').val() )) {
            console.log('invalid date');
            return false;
        }
        $('#counter_history_result').load('stats_kasse.php?action=tagesabschluss&branches_id='+
            $('form[name="branch_select"] select[name="branches_id"]').val()+'&day='+
            $('input[name="day"]').val()
        );
       });
    });
</script>
<div class="main">
<?php
    echo xtc_draw_form('branch_select', 'stats_kasse.php','','GET','onsubmit="return false;"');
    printf('%s:<br />%s<br />',
        TEXT_BRANCHCOUNTER,
        xtc_draw_pull_down_menu('branches_id',$branches, $branches_id)
    );
    printf('<br />%s<br />%s',
        TEXT_COUNTER_HISTORY_DATE,
        xtc_draw_input_field('day',$day,'',false,'date')
    );
    echo '<input class="ui-corner-all ui-button" type="button" id="counter_history_start" value="Start" /></form><hr noshade="noshade" /><div id="counter_history_result"></div>';
}
if(isset($counter_activities)){
	$has_data = false;
	foreach($counter_activities as $ac_class => $ac_array){
		switch($ac_class){
			case 'counter':
				$ac_class = 'Kasse';
				break;
			case 'reimbursements':
				$ac_class = 'R&uuml;ckerstattung';
				break;
		}
		if(sizeOf($ac_array)){
			$has_data = true;
		}
	}
	if($has_data){
		$ds = $CH->daily_summary($save_date);
		if($ds === false){
		    echo TEXT_TAGESABSCHLUSS_NO_DATA;
		}
		printf('<p><a href="%s" style="background-color: #CCC;border: 1px solid #000; padding: 5px;color: #000; text-decoration: none">Download</a></p>',
			xtc_href_link('stats_kasse.php',xtc_get_all_get_params(array('dl')).'dl=1')
		);
		//echo '<br /><i>'.$ds.' created</i>';
	}else{
            echo TEXT_TAGESABSCHLUSS_NO_DATA;
        }
}
die('</div>');
