<?php
/* --------------------------------------------------------------
   $Id: combined_orders.php,v 1.0

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2004 Mario Aspeleiter <dazze@gmx.de>
   --------------------------------------------------------------
   based on:
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(orders.php,v 1.109 2003/05/28); www.oscommerce.com
   (c) 2003	 nextcommerce (orders.php,v 1.19 2003/08/24); www.nextcommerce.org

   Released under the GNU General Public License
   --------------------------------------------------------------
   Third Party contribution:
   OSC German Banktransfer v0.85a       	Autor:	Dominik Guder <osc@guder.org>
   Customers Status v3.x  (c) 2002-2003 Copyright Elari elari@free.fr | www.unlockgsm.com/dload-osc/ | CVS : http://cvs.sourceforge.net/cgi-bin/viewcvs.cgi/elari/?sortby=date#dirlist

   credit card encryption functions for the catalog module
   BMC 2003 for the CC CVV Module

   Released under the GNU General Public License
   --------------------------------------------------------------*/

require('includes/application_top.php');
require(DIR_FS_CATALOG.DIR_WS_CLASSES . 'xtcPrice.php');
require_once(DIR_FS_CATALOG.DIR_WS_CLASSES.'class.phpmailer.php');
require_once(DIR_WS_CLASSES.'customer.php');
require_once(DIR_FS_INC . 'xtc_php_mail.inc.php');
require_once(DIR_FS_INC . 'xtc_add_tax.inc.php');
require_once(DIR_FS_INC . 'changedataout.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_tax_rate.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_o_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_customers_status.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_price_i_tax.inc.php');
require_once(DIR_FS_INC . 'xtc_oe_get_allow_tax.inc.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_subtotal_no_tax.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_discount.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_coupon.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_payment_fee.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_cod_fee.php');
require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_loworderfee.php');
//require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_klarna_fee.php');

// initiate template engine for mail
$smarty = new yesSmarty;
$smarty->assign('language_path',DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf');

require(DIR_WS_CLASSES . 'currencies.php');
$currencies = new currencies();
$orders_statuses = xtc_get_orders_status();
require(DIR_WS_CLASSES . 'order.php');
foreach($orders_statuses as $orders_status) {
    $orders_status_array[$orders_status['id']] = $orders_status['text'];
}

if (isset($_REQUEST['action']) and $_REQUEST['action'] == 'save'){
    if(!is_countable($_REQUEST['collect_orders_id']) or sizeOf($_REQUEST['collect_orders_id']) < 2) {
	if(!isset($_REQUEST['ajax_processing'])){
            $messageStack->add_session(MSG_ERROR_MINIMUM_TWO_ORDERS,'error');
            xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','collect_orders_id'))));
	}else{
            die('error: '.MSG_ERROR_MINIMUM_TWO_ORDERS);
        }
    }
    $products_data = array();
    $total_data = array();
    $customers_status = false;
    $currency = false;
    $payment_method = false;
    $currency_value = false;
    $lang = false;
    $cc_type = false;
    $cc_owner = false;
    $cc_number = false;
    $cc_expires = false;

    $shipping_method = 'Versandkosten';
    $shipping_class = 'flat_flat';
    $ebay_plus = false;

    $cID = false;
    for($a=0;$a<count($_REQUEST['collect_orders_id']);$a++){
        $oID = (int)xtc_db_prepare_input($_REQUEST['collect_orders_id'][$a]);
        $orders_query = xtc_db_query(sprintf(
            "SELECT orders_id FROM %s WHERE orders_id = '%d'",
            TABLE_ORDERS,$oID
        ));
        $order_exists = true;
        if( !xtc_db_num_rows($orders_query) ) {
            $order_exists = false;
            if(!isset($_REQUEST['ajax_processing'])){
                $messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID), 'error');
                xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','collect_orders_id'))));
            }else{
                die('error: '.sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID));
            }
        }
        $order = new order($oID);
        if(in_array($order->info['orders_status'],array(ORDERS_STATUS_STORNIERT))){
            $messageStack->add(sprintf(ERROR_ORDER_IS_STORNO, $oID), 'error');
            xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','collect_orders_id'))));
        }

        if($_REQUEST['adressdata'] == $oID){
            $selected_customerdata = $order->customer;
            $selected_deliverydata = $order->delivery;
            $selected_billingdata = $order->billing;
            $payment_method = $order->info['payment_method'];
            $cc_type = $order->info['cc_type'];
            $cc_owner = $order->info['cc_owner'];
            $cc_number = $order->info['cc_number'];
            $cc_expires = $order->info['cc_expires'];
            $selected_source = $order->info['source'];
            $selected_source_editor_id = $order->info['source_editor_id'];
        }

        // PRODUCTS SAMMELN
        for($i=0;$i<sizeOf($order->products);$i++){
            $order->products[$i]['orig_orders_id'] = $oID;
            $products_data[] = $order->products[$i];
        }
        // TOTALS SAMMELN
        for($i=0;$i<sizeOf($order->totals);$i++){
            // DIE VERSANDKOSTEN NUR BEI DEN AUSGESUCHTEN UEBERNEHMEN
            if($order->totals[$i]['class'] != 'ot_shipping'){
                $total_data[] = $order->totals[$i];
            }

            if(isset($_REQUEST['shippingcosts']) and sizeOf($_REQUEST['shippingcosts'])>0){
                if( in_array($order->totals[$i]['otid'].'_'.$oID,$_REQUEST['shippingcosts']) ){
                    $shipping_method = $order->info['shipping_method'];
                    $shipping_class = $order->info['shipping_class'];
                    $total_data[] = $order->totals[$i];
                }
            }
        }

        // den customers_status ermitteln
        if(!$customers_status){
                $customers_status = $order->info['status'];
        }

        // die waehrung ermitteln
        if(!$currency){
            $currency = $order->info['currency'];
            $currency_value = ($currency_value > 0) ? $currency_value : 1;
        }

        // cID setzen
        if(!isset($cID) or $cID === false){
            $cID = (int)$order->customer['ID'];
        }

        if(!isset($lang)){
                $lang = $order->info['language'];
        }
        if($order->info['ebay_plus'] == 1){
            $ebay_plus = true;
        }
    }
    // GENERATE NEW INVOICE
    $customers1_query = xtc_db_query(sprintf(
        "SELECT * FROM %s where customers_id = '%d'",
        TABLE_CUSTOMERS,$cID
    ));
    $customers1 = xtc_db_fetch_array($customers1_query);
    $stat = main::get_customers_status($customers_status, $_SESSION['languages_id']);

    $sql_data_array = array(
        'customers_id' => $cID,
        'customers_cid' => xtc_db_prepare_input($customers1['customers_cid']),
        'customers_vat_id' => xtc_db_prepare_input($customers1['customers_vat_id']),
        'customers_status' => xtc_db_prepare_input($customers1['customers_status']),
        'customers_status_name' => xtc_db_prepare_input($stat['customers_status_name']),
        'customers_status_image' => xtc_db_prepare_input($stat['customers_status_image']),
        'customers_status_discount' => xtc_db_prepare_input($stat['customers_status_discount']),
        'customers_name' => xtc_db_prepare_input($selected_customerdata['name']),
        'customers_company' => xtc_db_prepare_input($selected_customerdata['company']),
        'customers_street_address' => xtc_db_prepare_input($selected_customerdata['street_address']),
        'customers_suburb' => xtc_db_prepare_input($selected_customerdata['suburb']),
        'customers_city' => xtc_db_prepare_input($selected_customerdata['city']),
        'customers_postcode' => xtc_db_prepare_input($selected_customerdata['postcode']),
        'customers_state' => xtc_db_prepare_input($selected_customerdata['state']),
        'customers_country' => xtc_db_prepare_input($selected_customerdata['country']),
        'customers_telephone' => xtc_db_prepare_input($selected_customerdata['telephone']),
        'customers_email_address' => xtc_db_prepare_input($selected_customerdata['email_address']),
        'customers_mobile' => xtc_db_prepare_input($selected_customerdata['mobile']),
        'customers_address_format_id' => $selected_customerdata['format_id'],
        'customers_ip' => '0',
        'delivery_name' => xtc_db_prepare_input($selected_deliverydata['name']),
        'delivery_company' => xtc_db_prepare_input($selected_deliverydata['company']),
        'delivery_street_address' => xtc_db_prepare_input($selected_deliverydata['street_address']),
        'delivery_suburb' => $selected_deliverydata['suburb'],
        'delivery_city' => xtc_db_prepare_input($selected_deliverydata['city']),
        'delivery_postcode' => xtc_db_prepare_input($selected_deliverydata['postcode']),
        'delivery_state' => xtc_db_prepare_input($selected_deliverydata['state']),
        'delivery_country' => xtc_db_prepare_input($selected_deliverydata['country']),
        'delivery_address_format_id' => $selected_deliverydata['format_id'],
        'billing_name' => xtc_db_prepare_input($selected_billingdata['name']),
        'billing_company' => xtc_db_prepare_input($selected_billingdata['company']),
        'billing_street_address' => xtc_db_prepare_input($selected_billingdata['street_address']),
        'billing_suburb' => xtc_db_prepare_input($selected_billingdata['suburb']),
        'billing_city' => xtc_db_prepare_input($selected_billingdata['city']),
        'billing_postcode' => xtc_db_prepare_input($selected_billingdata['postcode']),
        'billing_state' => xtc_db_prepare_input($selected_billingdata['state']),
        'billing_country' => xtc_db_prepare_input($selected_billingdata['country']),
        'billing_address_format_id' => $selected_billingdata['format_id'],
        'payment_method' => $payment_method,
        'cc_type' => $cc_type,
        'cc_owner' => $cc_owner,
        'cc_number' => $cc_number,
        'cc_expires' => $cc_expires,
        'cc_start' => '',
        'cc_issue' => '',
        'cc_cvv' => '',
        'comments' => '',
        'last_modified' => 'now()',
        'date_purchased' => 'now()',
        'orders_status' => (int)xtc_db_input($_REQUEST['orders_status']),
        'orders_date_finished' => '',
        'currency' => $currency,
        'currency_value' => $currency_value,
        'account_type' => $customers1['account_type'],
        'payment_class' => $payment_method,
        'shipping_method' => $shipping_method,
        'shipping_class' => $shipping_class,
        'customers_ip' => '',
        'language' => $lang,
        'source'=>$selected_source,
        'source_editor_id'=>$selected_source_editor_id,
        'ebay_plus'=>$ebay_plus
    );

    if(isset($_REQUEST['block_shipping_comment'])){
        $sql_data_array['block_shipping'] = 1;
    }
    xtc_db_perform(TABLE_ORDERS, $sql_data_array);
    $orders_id = xtc_db_insert_id();

    $ot_shipping_title = '';
    $ot_cod_fee = 0;
    $ot_coupon = 0;
    $ot_discount = 0;
    $ot_gv = 0;
    $ot_loworderfee = 0;
    $ot_subtotal = 0;
    $ot_subtotal_no_tax = 0;
    $ot_payment_fee = 0;

    for ($i = 0, $n = sizeof($total_data); $i < $n; $i++) {
        switch($total_data[$i]['class']) {
            // wird von recalc() berechnet
            case 'ot_total':
                    break;
            case 'ot_subtotal_no_tax':
                    $ot_subtotal_no_tax += $total_data[$i]['value'];
                    break;
            case 'ot_subtotal':
                    $ot_subtotal += $total_data[$i]['value'];
                    break;
            case 'ot_shipping':
                    if(!isset($ot_shipping_value))
                            $ot_shipping_value = 0;
                    $ot_shipping_value += $total_data[$i]['value'];
                    $ot_shipping_title = $total_data[$i]['title'];
                    break;						
            case 'ot_cod_fee':
                    $ot_cod_fee += $total_data[$i]['value'];
                    break;
            case 'ot_coupon':
                    $ot_coupon += $total_data[$i]['value'];
                    break;
            case 'ot_discount':
                    $ot_discount += $total_data[$i]['value'];
                    break;
            case 'ot_gv':
                    $ot_gv += $total_data[$i]['value'];
                    break;
            case 'ot_loworderfee':
                    $ot_loworderfee += $total_data[$i]['value'];
                    break;
            case 'ot_payment_fee':
                    $ot_payment_fee += $total_data[$i]['value'];
                    break;
        }
    }

    // DUMMY ANLEGEN
    $sql_data_array = array(
        'orders_id' => $orders_id,
        'title' => '<b>Summe</b>:',
        'text' => '0',
        'value' => '0',
        'class' => 'ot_total'
    );
    $insert_sql_data = array('sort_order' => MODULE_ORDER_TOTAL_TOTAL_SORT_ORDER);
    $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);

    xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

    $allow_tax = $stat['customers_status_add_tax_ot'];
    if($ot_subtotal > 0){
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => MODULE_ORDER_TOTAL_SUBTOTAL_TITLE.':',
            'text' => format_price( ($ot_subtotal+$ot_subtotal_no_tax) ,1,$currency,0,0),
            'value' => ($ot_subtotal+$ot_subtotal_no_tax),
            'class' => 'ot_subtotal',
            'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_SORT_ORDER
        );
    }else{
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_TITLE.':',
            'text' => format_price(($ot_subtotal+$ot_subtotal_no_tax),1,$currency,0,0),
            'value' => ($ot_subtotal+$ot_subtotal_no_tax),
            'class' => 'ot_subtotal_no_tax',
            'sort_order'=>MODULE_ORDER_TOTAL_SUBTOTAL_NO_TAX_SORT_ORDER
        );
    }

    xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);

    // DIE ZUSAETZLICHEN OT_MODULE EINFUEGEN
    if(isset($ot_shipping_value)){
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => $ot_shipping_title,
            'text' => format_price($ot_shipping_value,1,$currency,0,0),
            'value' => $ot_shipping_value,
            'class' => 'ot_shipping'
        );
        $insert_sql_data = array('sort_order' => MODULE_ORDER_TOTAL_SHIPPING_SORT_ORDER);
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
    }
    if($ot_cod_fee > 0){
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => 'Nachnahme',
            'text' => format_price($ot_cod_fee,1,$currency,0,0),
            'value' => $ot_cod_fee,
            'class' => 'ot_cod_fee'
        );

        $insert_sql_data = array('sort_order' => MODULE_ORDER_TOTAL_COD_SORT_ORDER);
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
    }
    if($ot_coupon > 0){
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => MODULE_ORDER_TOTAL_COUPON_TITLE,
            'text' => format_price($ot_coupon,1,$currency,0,0),
            'value' => $ot_coupon,
            'class' => 'ot_coupon'
        );

        $insert_sql_data = array('sort_order' => MODULE_ORDER_TOTAL_COD_SORT_ORDER);
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
    }
    if($ot_discount <> 0){
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => MODULE_ORDER_TOTAL_DISCOUNT_TITLE,
            'text' => format_price($ot_discount,1,$currency,0,0),
            'value' => $ot_discount,
            'class' => 'ot_discount'
        );

        $insert_sql_data = array('sort_order' => MODULE_ORDER_TOTAL_DISCOUNT_SORT_ORDER);
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
    }
    if($ot_gv > 0){
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => MODULE_ORDER_TOTAL_GV_TITLE,
            'text' => format_price($ot_gv,1,$currency,0,0),
            'value' => $ot_gv,
            'class' => 'ot_gv'
        );

        $insert_sql_data = array('sort_order' => MODULE_ORDER_TOTAL_GV_SORT_ORDER);
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
    }
    if($ot_loworderfee > 0){
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => MODULE_ORDER_TOTAL_LOWORDERFEE_TITLE,
            'text' => format_price($ot_loworderfee,1,$currency,0,0),
            'value' => $ot_loworderfee,
            'class' => 'ot_loworderfee'
        );

        $insert_sql_data = array('sort_order' => MODULE_ORDER_TOTAL_LOWORDERFEE_SORT_ORDER);
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
    }

    if($ot_payment_fee > 0){
        if(!defined('MODULE_ORDER_TOTAL_PAYMENT_TITLE')){
            require_once(DIR_FS_CATALOG.'lang/'.$_SESSION['language'].'/modules/order_total/ot_payment_fee.php');
        }
        $sql_data_array = array(
            'orders_id' => $orders_id,
            'title' => MODULE_ORDER_TOTAL_PAYMENT_TITLE,
            'text' => format_price($ot_payment_fee,1,$currency,0,0),
            'value' => $ot_payment_fee,
            'class' => 'ot_payment_fee'
        );

        $insert_sql_data = array('sort_order' => MODULE_ORDER_TOTAL_PAYMENT_SORT_ORDER);
        $sql_data_array = xtc_array_merge($sql_data_array, $insert_sql_data);
        xtc_db_perform(TABLE_ORDERS_TOTAL, $sql_data_array);
    }

    // PRODUCTS ADDEN
    for ($i = 0, $n = sizeof($products_data); $i < $n; $i++) {
        $insert_sql_array = array(
          'orders_id'=>$orders_id,
          'products_id'=>$products_data[$i]['id'],
          'products_model'=>$products_data[$i]['model'],
          'products_name'=>$products_data[$i]['name'],
          'products_price'=>$products_data[$i]['price'],
          'products_discount_made'=>$products_data[$i]['discount'],
          'final_price'=>$products_data[$i]['final_price'],
          'products_tax'=>$products_data[$i]['tax'],
          'products_quantity'=>$products_data[$i]['qty'],
          'allow_tax'=>$products_data[$i]['allow_tax'],
          'date_added'=>'now()'
        );
        xtc_db_perform('orders_products',$insert_sql_array);
        $newopID = xtc_db_insert_id();

        // FALLS SERIENNUMMERN AUS ORIG-RECHNUNG DIESE AUF DIE NEUE UPDATEN
        yes_add_products_history($products_data[$i]['id'], sprintf(
            TEXT_STORNO_COMBINED_TO,
            $products_data[$i]['orig_orders_id'],$orders_id
        ));
    }
    // ORIG-RECHN AUF STORNO
    $combined_string = '';
    for($a=0;$a<count($_REQUEST['collect_orders_id']);$a++){
        $oID = (int)xtc_db_input($_REQUEST['collect_orders_id'][$a]);
        // die kombinierten mit der erzeugten combined_orders_id versehen
        xtc_db_query("UPDATE orders SET combined_orders_id='".$orders_id."' WHERE orders_id='".$oID."'");

        $order = new order($oID);
        $order->update_orders_status(ORDERS_STATUS_STORNIERT);
        if(!isset($_REQUEST['ajax_processing'])){
            $history = sprintf(TEXT_HISTORY_COMBINED_TO,$orders_id);
        }else{
            $history = sprintf('[Amazon] '.TEXT_HISTORY_COMBINED_TO,$orders_id);
        }
        $order->add_history(ORDERS_STATUS_STORNIERT,$notified=0,$history);
        $combined_string .= $oID.', ';

        // BUGFIX - auch die Zahlungszuweisungen speichern
        xtc_db_query("UPDATE payment_orders SET orders_id='".$orders_id."' WHERE orders_id='".$oID."'");
    }
    $combined_string = substr($combined_string,0,(strlen($combined_string)-2));

    // NEUE RECHNUNG KOMMENTAR
    $order = new order($orders_id);
    $order->recalc();
    if(!isset($_REQUEST['ajax_processing'])){
        $history = sprintf(TEXT_HISTORY_COMBINED,$combined_string);
    }else{
        $history = sprintf('[Amazon] '.TEXT_HISTORY_COMBINED,$combined_string);
    }
    $order->add_history($order->info['orders_status'],$notified=0,$history);

    if(isset($_REQUEST['block_shipping_comment'])){
        $history_query = xtc_db_query(sprintf(
                "SELECT comments FROM %s WHERE orders_id='%s' AND comments LIKE 'Vom Versand ausgeschlossen:%%' ORDER BY date_added DESC",
                TABLE_ORDERS_STATUS_HISTORY,(int)xtc_db_input($_REQUEST['block_shipping_comment'])
        ));
        $history_record = xtc_db_fetch_array($history_query);
        $order->add_history($order->info['orders_status'],$notified=0,xtc_db_prepare_input($history_record['comments']));
    }
		
		
		
    $customer = new customer($cID);
    $customer->update_current_account_value();
    if(!isset($_REQUEST['ajax_processing'])){
        $messageStack->add_session(MSG_SUCCESS_COMBINED,'success');
        xtc_redirect(xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','oID')).'action=edit&oID='.$orders_id));
    }else{
        if(isset($_REQUEST['orig_amazon_orders_id'])){
            xtc_db_query(sprintf(
                "UPDATE amazon_orders SET orders_id='%s' WHERE orig_amazon_orders_id='%s' AND orders_id IN(%s)",
                $orders_id,xtc_db_input($_REQUEST['orig_amazon_orders_id']),implode(',',$_REQUEST['collect_orders_id'])
            ));
        }
        die(''.$orders_id);
    }
}


if ( isset($_REQUEST['action']) and $_REQUEST['action'] == 'edit' ) {
    $distinct_orders_statuses = array(); // alle auftraege muessen selben status haben
    $o_array = (isset($_POST['collect_orders_id']) and xtc_not_null($_POST['collect_orders_id'])) ? $_POST['collect_orders_id'] : $_GET['collect_orders_id'];
    $order_fibu_error = array();
    $order_status_error = [];
    for($i=0;$i<count($o_array);$i++){
	$oID = $o_array[$i];
	$orders_query = xtc_db_query("select orders_id from " . TABLE_ORDERS . " where orders_id = '" . xtc_db_input($oID) . "'");
	$order_exists = true;
	if (!xtc_db_num_rows($orders_query)) {
            $order_exists = false;
            $messageStack->add(sprintf(ERROR_ORDER_DOES_NOT_EXIST, $oID), 'error');
	}else{
            // nicht wenn auswahlset nicht abgeschlossen
            // mahnwesen+mahnstatus egal
            $o = new order($oID);
            $distinct_orders_statuses[ $o->info['orders_status'] ] = true;
            if( defined('MODULE_OTHER_FIBUNUMBERS_STATUS') and MODULE_OTHER_FIBUNUMBERS_STATUS == 'True'){
		if(ALLOW_COMBINE_ORDERS_WITH_FIBU_NUMBER != 'True'){
                    $number = $o->get_fibunumber();
                    if(!empty($number) or $number!=''){
                            $order_fibu_error[] = $o;
                    }
		}
            }
            if( $o->info['select_set'] == 0 or ($o->info['select_set'] == 1 and $o->info['select_set_status'] == 1)){
                if($o->info['orders_status'] != ORDERS_STATUS_STORNIERT){
                    $order[$o->is_netto()][] = $o;
                }else{
                    $order_status_error[] = $o;
                }
            }else{
                $order_not_selected[] = $o;
            }
        }
    }
    if(isset($order_not_selected) and sizeOf($order_not_selected) > 0){
        $orders_string = '';
        foreach($order_not_selected as $k=>$v){
                $orders_string .= $v->info['id'].', ';
        }
        $orders_string = substr($orders_string,0,(strlen($orders_string)-2));
        $messageStack->add_session(sprintf(MSG_ERROR_EBAY_SELECTSET,$orders_string),'error');
        xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','collect_orders_id'))));
    }
    if(sizeOf($order_fibu_error) > 0){
        $orders_string = '';
        foreach($order_fibu_error as $k=>$v){
                $orders_string .= $v->info['id'].', ';
        }
        $orders_string = substr($orders_string,0,(strlen($orders_string)-2));
        $messageStack->add_session(sprintf(MSG_ERROR_FIBU_NUMBER_EXISTS,$orders_string),'error');
        xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','collect_orders_id'))));
    }
    if(isset($order_status_error) and sizeOf($order_status_error) > 0){
        $orders_string = '';
        foreach($order_status_error as $k=>$v){
                $orders_string .= $v->info['id'].', ';
        }
        $orders_string = substr($orders_string,0,(strlen($orders_string)-2));
        $messageStack->add_session(sprintf(MSG_ERROR_FORBIDDEN_STATUS,$orders_string),'error');
        xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','collect_orders_id'))));
    }
    if(sizeOf($order) > 1){
        $messageStack->add_session(MSG_ERROR_DIFFERENT_TAXES,'error');
        xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','collect_orders_id'))));
    }
    if(isset($order[1]) and sizeOf($order[1])>0){
        $order[0] = $order[1];
        $order[1] = false;
    }
    if(sizeOf($distinct_orders_statuses) > 1){
        $messageStack->add_session(MSG_ERROR_DIFFERENT_STATUSES,'error');
        xtc_redirect(xtc_href_link('orders.php',xtc_get_all_get_params(array('action','collect_orders_id'))));
    }
        
}
yes_draw_pre_header();
yes_draw_header(TITLE);
$smarty->assign('ENTRY_CID',ENTRY_CID);
$smarty->assign('ENTRY_CUSTOMER',ENTRY_CUSTOMER);
$smarty->assign('ENTRY_TELEPHONE',ENTRY_TELEPHONE);
$smarty->assign('ENTRY_EMAIL_ADDRESS',ENTRY_EMAIL_ADDRESS);
$smarty->assign('EXT_POPUP_WIDTH',EXT_POPUP_WIDTH);
$smarty->assign('EXT_POPUP_HEIGHT',EXT_POPUP_HEIGHT);
$smarty->assign('ENTRY_PAYMENT_METHOD',ENTRY_PAYMENT_METHOD);
$smarty->assign('ENTRY_SHIPPING_ADDRESS',ENTRY_SHIPPING_ADDRESS);
$smarty->assign('ENTRY_BILLING_ADDRESS',ENTRY_BILLING_ADDRESS);
$smarty->assign('ENTRY_CREDIT_CARD_TYPE',ENTRY_CREDIT_CARD_TYPE);
$smarty->assign('ENTRY_CREDIT_CARD_OWNER',ENTRY_CREDIT_CARD_OWNER);
$smarty->assign('ENTRY_CREDIT_CARD_NUMBER',ENTRY_CREDIT_CARD_NUMBER);
$smarty->assign('ENTRY_CREDIT_CARD_EXPIRES',ENTRY_CREDIT_CARD_EXPIRES);
$smarty->assign('TEXT_BANK_NAME',TEXT_BANK_NAME);
$smarty->assign('TEXT_BANK_BLZ',TEXT_BANK_BLZ);
$smarty->assign('TEXT_BANK_NUMBER',TEXT_BANK_NUMBER);
$smarty->assign('TEXT_BANK_OWNER',TEXT_BANK_OWNER);
$smarty->assign('TEXT_BANK_STATUS',TEXT_BANK_STATUS);
$smarty->assign('TEXT_BANK_ERRORCODE',TEXT_BANK_ERRORCODE);
$smarty->assign('TEXT_BANK_PRZ',TEXT_BANK_PRZ);
$smarty->assign('TEXT_BANK_FAX',TEXT_BANK_FAX);
$smarty->assign('TABLE_HEADING_PRODUCTS',TABLE_HEADING_PRODUCTS);
$smarty->assign('TABLE_HEADING_PRODUCTS_MODEL',TABLE_HEADING_PRODUCTS_MODEL);
$smarty->assign('TABLE_HEADING_PRICE_EXCLUDING_TAX',TABLE_HEADING_PRICE_EXCLUDING_TAX);
$smarty->assign('TABLE_HEADING_TAX',TABLE_HEADING_TAX);
$smarty->assign('TABLE_HEADING_PRICE_INCLUDING_TAX',TABLE_HEADING_PRICE_INCLUDING_TAX);
$smarty->assign('TABLE_HEADING_TOTAL_INCLUDING_TAX',TABLE_HEADING_TOTAL_INCLUDING_TAX);

if (isset($_REQUEST['action']) and $_REQUEST['action'] == 'edit') {
	$smarty->assign('ADD_FORM',xtc_draw_form('combinedorders', FILENAME_COMBINED_ORDERS, xtc_get_all_get_params(array('collect_orders_id','action')), 'post'));
	$orderdata_array = array();
	$block_shippings = array();
	$errors = array();
	$default_orders_status = '';
	$bc_checked = true;
	for($orders_count=0;$orders_count<count($order[0]);$orders_count++){
	    if($default_orders_status == ''){
		$default_orders_status = $order[0][$orders_count]->info['orders_status'];
	    }
		$oId = $order[0][$orders_count]->info['id'];
		$orderdata = array();
		if($order[0][$orders_count]->has_unallocated_amazon_items()){
			$errors[] = sprintf(TEXT_ERROR_UNALLOCATED_AMAZON_ITEM_IN_ORDER,$oId);
		}
		/**if($order[0][$orders_count]->has_unallocated_ebay_items( )){
			$errors[] = sprintf(TEXT_ERROR_UNALLOCATED_EBAY_ITEM_IN_ORDER,$oId);
		}*/
		if($order[0][$orders_count]->info['block_shipping'] == 1){
			$history_query = xtc_db_query(sprintf(
				"SELECT comments FROM %s WHERE orders_id='%s' AND comments LIKE 'Vom Versand ausgeschlossen:%%' ORDER BY date_added DESC",
				TABLE_ORDERS_STATUS_HISTORY,$oId
			));
			$history_record = xtc_db_fetch_array($history_query);
			if(isset($_REQUEST['block_shipping_comment']) and $_REQUEST['block_shipping_comment'] == $oId){
				$bc_checked = true;
			}
			$block_shippings[] = xtc_draw_radio_field('block_shipping_comment',$oId,$bc_checked).' Kommentar: &raquo;'.xtc_db_prepare_input(str_replace('Vom Versand ausgeschlossen:','',$history_record['comments']).'&laquo;');
			$bc_checked = false;
		}
		$payment_methods[ $order[0][$orders_count]->info['payment_method'] ] = true;
		$orderdata['info'] = $order[0][$orders_count]->info;
		$orderdata['customer'] = $order[0][$orders_count]->customer;
		$orderdata['customer_address'] = xtc_address_format($order[0][$orders_count]->customer['format_id'], $order[0][$orders_count]->customer, true, '', '<br>');
		$orderdata['billing_address'] = xtc_address_format($order[0][$orders_count]->billing['format_id'], $order[0][$orders_count]->billing, true, '', '<br>');
		$orderdata['delivery_address'] = xtc_address_format($order[0][$orders_count]->delivery['format_id'], $order[0][$orders_count]->delivery, true, '', '<br>');
		$orderdata['products'] = $order[0][$orders_count]->products;
		$orderdata['products_num'] = sizeOf($orderdata['products']);
		$orderdata['totals'] = $order[0][$orders_count]->totals;
		$orderdata['customers_address'] = xtc_address_format($order[0][$orders_count]->customer['format_id'], $order[0][$orders_count]->customer, 1, '', '<br>');
		$orderdata['shipping_address'] = xtc_address_format($order[0][$orders_count]->delivery['format_id'], $order[0][$orders_count]->delivery, 1, '', '<br>');
		$orderdata['billing_address'] = xtc_address_format($order[0][$orders_count]->billing['format_id'], $order[0][$orders_count]->billing, 1, '', '<br>');
		$orderdata['trclass'] = (is_int($orders_count/2)) ? 'dataTableRowSelected' : 'dataTableRow';
		$orderdata['email_link'] = xtc_href_link('ebay_mail_frame.php','email='.$order[0][$orders_count]->customer['email_address']);
		if ( (($order[0][$orders_count]->info['cc_type']) || ($order[0][$orders_count]->info['cc_owner']) || ($order[0][$orders_count]->info['cc_number'])) ) {
			$orderdata['cc'] = 1;
			// BMC CC Mod Start
			if ($order[0][$orders_count]->info['cc_number'] != '0000000000000000') {
				if ( strtolower(CC_ENC) == 'true' ) {
					$key = changeme;
					$cipher_data = $order[0][$orders_count]->info['cc_number'];
					$order[0][$orders_count]->info['cc_number'] = changedataout($cipher_data,$key);
				}
			}
		}
		$orderdata['collect_orders_id'] = xtc_draw_hidden_field('collect_orders_id[]', $oId);

		for ($i = 0, $n = sizeof($orderdata['products']); $i < $n; $i++) {
			$orderdata['products'][$i]['price_excl_tax'] = format_price($orderdata['products'][$i]['final_price']/$orderdata['products'][$i]['qty'], 1, $order[0][$orders_count]->info['currency'], $orderdata['products'][$i]['allow_tax'], $orderdata['products'][$i]['tax']);
			if ($orderdata['products'][$i]['allow_tax'] == 1) {
				$orderdata['products'][$i]['tax_value'] = xtc_display_tax_value($orderdata['products'][$i]['tax']).'%';
				$orderdata['products'][$i]['price_incl_tax'] = format_price($orderdata['products'][$i]['final_price']/$orderdata['products'][$i]['qty'], 1, $order[0][$orders_count]->info['currency'], 0, 0);
			}
			$orderdata['products'][$i]['price_total'] = format_price(($orderdata['products'][$i]['final_price']),1,$order[0][$orders_count]->info['currency'],0,0);
		}
		$orderdata_array[] = $orderdata;
	}
	if(sizeOf($errors)){
		$smarty->assign('errors',$errors);
	}
	
	// payment_method select
	$payment_method_array = array();
	if(is_array($payment_methods)){
		foreach($payment_methods as $k=>$v){
			$payment_method_array[] = array('id'=>$k,'text'=>$k);
		}
	}
	$smarty->assign('payment_method_select',xtc_draw_pull_down_menu('payment_method',$payment_method_array));
        $access = main::get_admin_access('f_orders_update_status');
        if($access){
            $orders_status_select_array = array();
            for($i=0;$i<sizeOf($orders_statuses);$i++){
                    if($orders_statuses[$i]['id'] != ORDERS_STATUS_STORNIERT){
                            $orders_status_select_array[] = array('id'=>$orders_statuses[$i]['id'],'text'=>$orders_statuses[$i]['text']);
                    }
            }
            $smarty->assign('orders_status_select',xtc_draw_pull_down_menu('orders_status',$orders_status_select_array,$default_orders_status));
        }else{
            $smarty->assign('orders_status_input',xtc_draw_hidden_field('orders_status',key($orders_status_array)));
        }
	$menus = array();
	$menus[] = array(
	    'text'=>IMAGE_BACK,
	    'link'=>xtc_href_link(FILENAME_ORDERS,xtc_get_all_get_params(array('action','collect_orders_id'))),
	    'lbOn'=>false,
	    'auth'=>true
	);
	$smarty->assign(array(
		'block_shippings'=>$block_shippings,
		'TEXT_ERROR_NO_COMBINE'=>TEXT_ERROR_NO_COMBINE,
		'HEADING_TITLE'=>HEADING_TITLE,
		'ADDITIONAL_TITLE'=>sprintf(ADDITIONAL_PAGE_HEADING,implode(', ',$_REQUEST['collect_orders_id'])),
		'PAGE_HEADING_MENU_BUTTONS'=>$menus,
	    'TEXT_SELECT_ADDRESS_SOURCE'=>TEXT_SELECT_ADDRESS_SOURCE,
	    'INTRO_COMBINE_ORDERS'=>INTRO_COMBINE_ORDERS,
	    'TEXT_OT_SHIPPING_SOURCE'=>TEXT_OT_SHIPPING_SOURCE,
	    'BUTTON_COMBINE'=>BUTTON_COMBINE
	));
	
	$smarty->assign('orders',$orderdata_array);
	$html=$smarty->fetch('combined_orders.html');
	echo $html;
}
require(DIR_WS_INCLUDES . 'footer.php');
require(DIR_WS_INCLUDES . 'application_bottom.php');
