<?php
$smarty = new yesSmarty;
$allocation_mode = false;
$allocation_product_mode = false;
if(isset($_GET['products_id']) and is_countable($_GET['products_id'])){
    if(isset($_GET['allocate']) and intval($_GET['allocate']) == 1){
        foreach($_GET['products_id'] as $pID){
            $exists = \YES4Trade\Model\product_un_classification::get_by_products_id(intval($pID));
            if($exists !== null){
                \YES4Trade\Model\product_un_classification::delete($exists->product_un_classification_id);
            }
            $un_classifications_id = intval($_POST['un_classifications_id']??0);
            if($un_classifications_id > 0){
                $unc = \YES4Trade\Model\un_classifications::get_by_un_classifications_id($un_classifications_id);
                $un_title = $unc->un_title;
                $new = new \YES4Trade\Model\product_un_classification([
                    'products_id'=>intval($pID),
                    'un_classifications_id'=>$un_classifications_id,
                    'ADR_Class'=>$_POST['ADR_Class']??'ADR_Class_1',
                    'Packaging_Group'=>$_POST['Packaging_Group']??'Packaging_Group_I',
                    'Bk'=>$_POST['Bk']??'Bk_1',
                    'TUNNEL_CATEGORY'=>$_POST['TUNNEL_CATEGORY']??'TUNNEL_CATEGORY_A',
                ]);
                $new->create();
            }else{
                $un_title = 'deleted';
            }
            \product::add_history_static(intval($pID),'UN Classification: '.$un_title);
        }
        $messageStack->add_session('UN Classification updated','success');
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['products_id','action','allocate'])));
    }
    $allocation_mode = true;
    $uns = \YES4Trade\Model\un_classifications::get_all();
    if($uns === null){
        $input = sprintf('<i>%s</i>',constant('UN_CLASSIFICATIONS_NO_ENTRYS'));
    }else{
        $options = [[
            'id'=>'',
            'text'=>TEXT_SELECT
        ]];
        foreach($uns as $uns_item){
            $options[] = [
                'id'=>$uns_item->un_classifications_id,
                'text'=>$uns_item->un_title,
                'title'=>str_replace('"','',$uns_item->un_description)
            ];
        }
        $input = xtc_draw_pull_down_menu('un_classifications_id',$options,'','',true);
    }

    $default_adr = '';
    $default_pg = '';
    $default_bk = '';
    $default_tunnel = '';

    $ADR_classes_options = [];
    foreach (\YES4Trade\Enums\ADR_Class::cases() as $case) {
        $ADR_classes_options[] = [
            'id'=>$case->name,
            'text'=>$case->value,
            'title'=>$case->label()
        ];
    }
    $Packaging_Group_options = [];
    foreach (\YES4Trade\Enums\Packaging_Group::cases() as $case){
        $Packaging_Group_options[] = [
            'id'=>$case->name,
            'text'=>$case->value,
            'title'=>$case->label()
        ];
    }
    $Bk_options = [];
    foreach (\YES4Trade\Enums\Bk::cases() as $case){
        $Bk_options[] = [
            'id'=>$case->name,
            'text'=>$case->value,
            'title'=>$case->label()
        ];
    }

    $TC_options = [];
    foreach(\YES4Trade\Enums\TUNNEL_CATEGORY::cases() as $case){
        $TC_options[] = [
            'id'=>$case->name,
            'text'=>$case->value,
            'title'=>$case->title()
        ];
    }

    $smarty->assign([
        'ALLOCATION_MODE'=>1,
        'FORM'=>xtc_draw_form('un_allocation',FILENAME_CATEGORIES,
            xtc_get_all_get_params(['allocate']).'allocate=1'
            ,'POST'
        ),
        'INPUT_UN_CLASSIFICATIONS'=>$input,
        'INPUT_ALLOCATE'=>yes_draw_href_button(IMAGE_SAVE,'','','submit','ui-button ui-corner-all ui-state-default allocate'),
        'BUTTON_UN_CLASSIFICATIONS'=>yes_draw_href_button(
            UN_CLASSIFACTIONS,
            xtc_href_link(FILENAME_CATEGORIES,'action=un_classifications'),
            '',
            'button',
            'ui-button ui-corner-all ui-state-highlight'
        ),
        'INPUT_ADR_Class'=>xtc_draw_pull_down_menu('ADR_Class',$ADR_classes_options,$default_adr),
        'INPUT_Packaging_Group'=>xtc_draw_pull_down_menu('Packaging_Group',$Packaging_Group_options,$default_pg),
        'INPUT_Bk'=>xtc_draw_pull_down_menu('Bk',$Bk_options,$default_bk),
        'INPUT_TUNNEL_CATEGORY'=>xtc_draw_pull_down_menu('TUNNEL_CATEGORY',$TC_options,$default_tunnel,'id="TUNNEL_CATEGORY"'),
    ]);
}
if(isset($_GET['delete']) and intval($_GET['delete'])>0){
    $id = intval($_GET['delete']);
    \YES4Trade\Model\un_classifications::delete($id);
    $allocations = \YES4Trade\Model\product_un_classification::get_by_un_classifications_id($id);
    foreach($allocations as $puc){
        \YES4Trade\Model\product_un_classification::delete($puc->product_un_classifications_id);
    }
    $messageStack->add_session('UN Classification and all product allocations deleted','success');
    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,'action=un_classifications'));
}
if(isset($_POST['un_title'])){
    if(empty($_POST['un_title'])){
        $messageStack->add_session(
            'UN Classification not saved - no title submitted','error'
        );
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,'action=un_classifications'));
    }
    $un_item = new \YES4Trade\Model\un_classifications([
        'un_title'=>$_POST['un_title'],
        'un_description'=>$_POST['un_description'],
        'un_image'=>''
    ]);
    if(!isset($_POST['un_classifications_id'])){
        $un_item->create();
    }else{
        $un_item->un_classifications_id = intval($_POST['un_classifications_id']);
        $un_item->update();
    }
    $messageStack->add_session(sprintf(
        'UN Classification %s saved',
        $_POST['un_title']
    ),'success');
    xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,'action=un_classifications'));
}
if(!isset($_GET['products_id']) and isset($_GET['pID']) and intval($_GET['pID'])>0){
    if(isset($_GET['allocate_product']) and intval($_GET['allocate_product']) == 1){
        $pID = intval($_GET['pID']);
        $exists = \YES4Trade\Model\product_un_classification::get_by_products_id(intval($pID));
        if($exists !== null){
            \YES4Trade\Model\product_un_classification::delete($exists->product_un_classification_id);
        }
        $un_classifications_id = intval($_POST['un_classifications_id']??0);
        if($un_classifications_id > 0){
            $unc = \YES4Trade\Model\un_classifications::get_by_un_classifications_id($un_classifications_id);
            $un_title = $unc->un_title;
            $new = new \YES4Trade\Model\product_un_classification([
                'products_id'=>intval($pID),
                'un_classifications_id'=>$un_classifications_id,
                'ADR_Class'=>$_POST['ADR_Class']??'ADR_Class_1',
                'Packaging_Group'=>$_POST['Packaging_Group']??'Packaging_Group_I',
                'Bk'=>$_POST['Bk']??'Bk_1',
                'TUNNEL_CATEGORY'=>$_POST['TUNNEL_CATEGORY']??'TUNNEL_CATEGORY_A',
            ]);
            $new->create();
        }else{
            $un_title = 'deleted';
        }
        \product::add_history_static(intval($pID),'UN Classification: '.$un_title);
        $messageStack->add_session('UN Classification updated','success');
        xtc_redirect(xtc_href_link(FILENAME_CATEGORIES,xtc_get_all_get_params(['products_id','action','allocate_product'])));
    }

    $allocation_product_mode = true;
    $uns = \YES4Trade\Model\un_classifications::get_all();
    $puc = \YES4Trade\Model\product_un_classification::get_by_products_id(intval($_GET['pID']));
    if($puc === null){
        $default = '';
        $default_adr = '';
        $default_pg = '';
        $default_bk = '';
        $default_tunnel = '';
    }else{
        $default = $puc->un_classifications_id;
        $default_adr = $puc->ADR_Class;
        $default_pg = $puc->Packaging_Group;
        $default_bk = $puc->Bk;
        $default_tunnel = $puc->TUNNEL_CATEGORY;
    }
    if($uns === null){
        $input = sprintf('<i>%s</i>',constant('UN_CLASSIFICATIONS_NO_ENTRYS'));
    }else{
        $options = [[
            'id'=>'',
            'text'=>TEXT_SELECT
        ]];
        foreach($uns as $uns_item){
            $options[] = [
                'id'=>$uns_item->un_classifications_id,
                'text'=>$uns_item->un_title,
                'title'=>str_replace('"','',$uns_item->un_description)
            ];
        }
        $input = xtc_draw_pull_down_menu('un_classifications_id',$options,$default,'',true);
    }

    $ADR_classes_options = [];
    foreach (\YES4Trade\Enums\ADR_Class::cases() as $case) {
        $ADR_classes_options[] = [
            'id'=>$case->name,
            'text'=>$case->value,
            'title'=>$case->label()
        ];
    }
    $Packaging_Group_options = [];
    foreach (\YES4Trade\Enums\Packaging_Group::cases() as $case){
        $Packaging_Group_options[] = [
            'id'=>$case->name,
            'text'=>$case->value,
            'title'=>$case->label()
        ];
    }
    $Bk_options = [];
    foreach (\YES4Trade\Enums\Bk::cases() as $case){
        $Bk_options[] = [
            'id'=>$case->name,
            'text'=>$case->value,
            'title'=>$case->label()
        ];
    }
    $TC_options = [];
    foreach(\YES4Trade\Enums\TUNNEL_CATEGORY::cases() as $case){
        $TC_options[] = [
            'id'=>$case->name,
            'text'=>$case->value,
            'title'=>$case->title()
        ];
    }

    $smarty->assign([
        'ALLOCATION_PRODUCT_MODE'=>1,
        'FORM'=>xtc_draw_form('un_allocation_product',FILENAME_CATEGORIES,
            xtc_get_all_get_params(['allocate_product']).'allocate_product=1'
            ,'POST'
        ),
        'INPUT_UN_CLASSIFICATIONS'=>$input,
        'INPUT_ALLOCATE'=>yes_draw_href_button(IMAGE_SAVE,'','','submit','ui-button ui-corner-all ui-state-default allocate'),
        'BUTTON_UN_CLASSIFICATIONS'=>yes_draw_href_button(
            UN_CLASSIFACTIONS,
            xtc_href_link(FILENAME_CATEGORIES,'action=un_classifications'),
            '',
            'button',
            'ui-button ui-corner-all ui-state-highlight'
        ),
        'INPUT_ADR_Class'=>xtc_draw_pull_down_menu('ADR_Class',$ADR_classes_options,$default_adr),
        'INPUT_Packaging_Group'=>xtc_draw_pull_down_menu('Packaging_Group',$Packaging_Group_options,$default_pg),
        'INPUT_Bk'=>xtc_draw_pull_down_menu('Bk',$Bk_options,$default_bk),
        'INPUT_TUNNEL_CATEGORY'=>xtc_draw_pull_down_menu('TUNNEL_CATEGORY',$TC_options,$default_tunnel,'id="TUNNEL_CATEGORY"'),
    ]);
}
$table = new tableBlock();
$table->table_parameters = 'class="yesListTable_minimal un_items" style="width: auto;"';
$contents = [[
    ['text'=>'ID','th'=>true],
    ['text'=>UN_CLASSIFACTIONS_TITLE,'th'=>true],
    ['text'=>'Action','th'=>true],
]];
$un_array = \YES4Trade\Model\un_classifications::get_all();
foreach ($un_array as $un_item) {
    $un_title = sprintf('<a data-uncid="%d" href="javascript:un_edit(%d)" title="%s">%s</a>',
        intval($un_item->un_classifications_id),
        intval($un_item->un_classifications_id),
        ITEM_EDIT,
        $un_item->un_title
    );
    if(!empty($un_item->un_description)){
        $un_title .= sprintf('<div data-uncid="%d" class="un_desc">%s</div>',
            $un_item->un_classifications_id,
            $un_item->un_description
        );
    }
    $all = \YES4Trade\Model\product_un_classification::get_by_un_classifications_id(intval($un_item->un_classifications_id));
    $size_all = sizeOf($all);
    $contents[] = [
        ['text'=>$un_item->un_classifications_id],
        ['text'=>$un_title],
        ['text'=>
            yes_draw_href_button(UN_CLASSIFICATION_ALLOCATED_PRODUCTS .' ('.$size_all.')','javascript:un_allocateds('.intval($un_item->un_classifications_id).')','','button','ui-button ui-corner-all ui-state-default')
            . '<br />'
            . yes_draw_href_button(IMAGE_DELETE,'javascript:un_delete('.intval($un_item->un_classifications_id).')','','button','ui-button ui-corner-all ui-state-error')
        ]
    ];
}

yes_draw_pre_header();
if(!$allocation_mode and !$allocation_product_mode){
    yes_draw_header('UN Classifications');
}
$buttons = [
    [
        'text'=>ITEM_ADD,
        'link' => 'javascript:un_add()',
        'lbOn'=>false,
        'auth'=>true,
    ]
];

$smarty->assign([
	'language_path'=>DIR_FS_LANGUAGES.$_SESSION['language'].'/admin/'.$_SESSION['language'].'.conf',
    'HEADING_TITLE'=>'UN Classifications',
    'BASELINK'=>xtc_href_link(FILENAME_CATEGORIES,'action=un_classifications'),    
    'TABLE'=>$table->tableBlock_draw($contents),
    'PAGE_HEADING_MENU_BUTTONS'=>$buttons
]);
$smarty->display('un_classifications.html');
if(!$allocation_mode and !$allocation_product_mode){
    require(DIR_WS_INCLUDES . 'footer.php');
}
require(DIR_WS_INCLUDES . 'application_bottom.php');
exit;
