<?php
/* -----------------------------------------------------------------------------------------
   $Id: account_password.php,v 1.4 2016/05/12 09:16:15 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(account_password.php,v 1.1 2003/05/19); www.oscommerce.com 
   (c) 2003	 nextcommerce (account_password.php,v 1.14 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
// create smarty elements
require_once(DIR_WS_CLASSES.'yes_input_field.php');
$smarty = new yesSmarty;
// include boxes
$YesBoxes->load( $smarty, basename(__FILE__) );
// include needed functions
require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_password_field.inc.php');
require_once(DIR_FS_INC . 'xtc_validate_password.inc.php');
require_once(DIR_FS_INC . 'xtc_encrypt_password.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');

if (!isset($_SESSION['customer_id'])) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}

if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
    $password_current = xtc_db_prepare_input($_POST['password_current']);
    $password_new = xtc_db_prepare_input($_POST['password_new']);
    $password_confirmation = xtc_db_prepare_input($_POST['password_confirmation']);

    $error = false;

    if (strlen($password_current) < ENTRY_PASSWORD_MIN_LENGTH) {
      $error = true;
      $messageStack->add('account_password', ENTRY_PASSWORD_CURRENT_ERROR);
    } elseif (strlen($password_new) < ENTRY_PASSWORD_MIN_LENGTH) {
      $error = true;
      $messageStack->add('account_password', ENTRY_PASSWORD_NEW_ERROR);
    } elseif ($password_new != $password_confirmation) {
      $error = true;
      $messageStack->add('account_password', ENTRY_PASSWORD_NEW_ERROR_NOT_MATCHING);
    }

    if ($error == false) {
        $customer = \YES4Trade\Model\customers::get_by_customers_id((int)$_SESSION['customer_id']);
        if (xtc_validate_password($password_current, $customer->customers_password)) {
            $upd = new \YES4Trade\Model\customers([
                'customers_password' => xtc_encrypt_password($password_new),
                'customers_id' => (int)$_SESSION['customer_id'],
            ]);
            $upd->update();
            
            $upd = new \YES4Trade\Model\customers_info([
                'customers_info_date_account_last_modified' => date('Y-m-d H:i:s'),
                'customers_info_id'=>(int)$_SESSION['customer_id']
            ]);
            $upd->update();
            $messageStack->add_session('account', SUCCESS_PASSWORD_UPDATED, 'success');

            xtc_redirect(xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
        } else {
            $error = true;
            $messageStack->add('account_password', ERROR_CURRENT_PASSWORD_NOT_MATCHING);
        }
    }
}

$breadcrumb->add(NAVBAR_TITLE_1_ACCOUNT_PASSWORD, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2_ACCOUNT_PASSWORD, xtc_href_link(FILENAME_ACCOUNT_PASSWORD, '', 'SSL'));
require(DIR_WS_INCLUDES . 'header.php');
if ($messageStack->size('account_password') > 0) {
    $smarty->assign('error',$messageStack->output('account_password'));

}
$smarty->assign(array(
    'FORM_ACTION'=>xtc_draw_form('account_password', xtc_href_link(FILENAME_ACCOUNT_PASSWORD, '', 'SSL'), 'post', 'onSubmit="return check_form(account_password);"') . xtc_draw_hidden_field('action', 'process'),
    'INPUT_ACTUAL'=>xtc_draw_password_field('password_current') . '&nbsp;' . (xtc_not_null(ENTRY_PASSWORD_CURRENT_TEXT) ? '<span class="inputRequirement">' . ENTRY_PASSWORD_CURRENT_TEXT . '</span>': ''),
    'INPUT_ACTUAL_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'password_current',
	'label'=>ENTRY_PASSWORD_CURRENT,
	'type'=>'password',
	'required'=>true,
	'minlength'=>3,
	'maxlength'=>64,
	'required_text'=>ENTRY_PASSWORD_CURRENT_TEXT,
    )),
    'INPUT_NEW'=>xtc_draw_password_field('password_new') . '&nbsp;' . (xtc_not_null(ENTRY_PASSWORD_NEW_TEXT) ? '<span class="inputRequirement">' . ENTRY_PASSWORD_NEW_TEXT . '</span>': ''),
    'INPUT_NEW_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'password_new',
	'label'=>ENTRY_PASSWORD_NEW,
	'type'=>'password',
	'required'=>true,
	'minlength'=>3,
	'maxlength'=>64,
	'required_text'=>ENTRY_PASSWORD_NEW_TEXT,
    )),
    'INPUT_CONFIRM'=>xtc_draw_password_field('password_confirmation') . '&nbsp;' . (xtc_not_null(ENTRY_PASSWORD_CONFIRMATION_TEXT) ? '<span class="inputRequirement">' . ENTRY_PASSWORD_CONFIRMATION_TEXT . '</span>': ''),
    'INPUT_CONFIRM_ARRAY'=>yes_input_field::get_html(array(
	'name'=>'password_confirmation',
	'label'=>ENTRY_PASSWORD_CONFIRMATION,
	'type'=>'password',
	'required'=>true,
	'minlength'=>3,
	'maxlength'=>64,
	'required_text'=>ENTRY_PASSWORD_CONFIRMATION_TEXT,
    )),
    'BUTTON_BACK'=>'<a href="' . xtc_href_link(FILENAME_ACCOUNT, '', 'SSL') . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>',
    'BUTTON_SUBMIT'=>xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE),
    'language'=> $_SESSION['language']
));
$smarty->caching = 0;
$main_content= $smarty->fetch(CURRENT_TEMPLATE.'/module/account_password.html');

$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include('includes/application_bottom.php');  