<?php
/* -----------------------------------------------------------------------------------------
   $Id: account_notifications.php,v 1.3 2012/09/06 16:58:03 cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(account_notifications.php,v 1.2 2003/05/22); www.oscommerce.com
   (c) 2003	 nextcommerce (account_notifications.php,v 1.13 2003/08/17); www.nextcommerce.org 

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');
$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

require_once(DIR_FS_INC . 'xtc_draw_hidden_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_checkbox_field.inc.php');
require_once(DIR_FS_INC . 'xtc_draw_selection_field.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');

if (!isset($_SESSION['customer_id'])) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}

$global = \YES4Trade\Model\customers_info::get_by_customers_info_id(intval($_SESSION['customer_id']),[
    'global_product_notifications'
]);

if (isset($_POST['action']) && ($_POST['action'] == 'process')) {
    if (isset($_POST['product_global']) && is_numeric($_POST['product_global'])) {
        $product_global = $_POST['product_global'];
    } else {
        $product_global = '0';
    }

    $products = $_POST['products']??[];
    if (intval($product_global) != intval($global->global_product_notifications)) {
        $product_global = ((intval($global->global_product_notifications) == 1) ? '0' : '1');
        $upd = new \YES4Trade\Model\customers_info([
            'global_product_notifications' => (int)$product_global,
            'customers_info_id' => (int)$_SESSION['customer_id']
        ]);
        $upd->update();
    } elseif (sizeof($products) > 0) {
        $products_parsed = array();
        for ($i=0, $n=sizeof($products); $i<$n; $i++) {
            if (is_numeric($products[$i])) {
                $products_parsed[] = intval($products[$i]);
            }
        }

        if (sizeof($products_parsed) > 0) {
            $parameters = [];
            $check_query_raw = sprintf(
                "select count(*) as total from %s where customers_id = '%d' and products_id not in (%s)",
                TABLE_PRODUCTS_NOTIFICATIONS,
                (int)$_SESSION['customer_id'],
                implode(',', $products_parsed)
            );
            $check = yes_query($check_query_raw, $parameters,true);
            if ($check['total'] > 0) {
                $delete_query_raw = sprintf(
                    "delete from %s where customers_id = '%d' and products_id not in (%s)",
                    TABLE_PRODUCTS_NOTIFICATIONS, (int)$_SESSION['customer_id'],
                    implode(',', $products_parsed)
                );
                yes_query($delete_query_raw);
            }
        }
    } else {
        $check_query = xtc_db_query(sprintf(
            "select count(*) as total from %s where customers_id = '%d'",
            TABLE_PRODUCTS_NOTIFICATIONS,(int)$_SESSION['customer_id']
        ));
        $check = xtc_db_fetch_array($check_query);

        if ($check['total'] > 0) {
            $delete_query_raw = sprintf(
                "delete from %s where customers_id = '%d'",
                TABLE_PRODUCTS_NOTIFICATIONS,(int)$_SESSION['customer_id']
            );
            xtc_db_query($delete_query_raw);
        }
    }
    $messageStack->add_session('account', SUCCESS_NOTIFICATIONS_UPDATED, 'success');
    xtc_redirect(xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
}

$breadcrumb->add(NAVBAR_TITLE_1_ACCOUNT_NOTIFICATIONS, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2_ACCOUNT_NOTIFICATIONS, xtc_href_link(FILENAME_ACCOUNT_NOTIFICATIONS, '', 'SSL'));

require(DIR_WS_INCLUDES . 'header.php');

$smarty->assign('CHECKBOX_GLOBAL',xtc_draw_checkbox_field('product_global', '1', ((intval($global->global_product_notifications) == 1) ? true : false), 'onclick="checkBox(\'product_global\')"'));
if (intval($global->global_product_notifications) != 1) {
    $smarty->assign('GLOBAL_NOTIFICATION','0');
} else {
    $smarty->assign('GLOBAL_NOTIFICATION','1');
}
if (intval($global->global_product_notifications) != 1) {
    $products_check_query = xtc_db_query(sprintf(
        "select count(*) as total from %s where customers_id = '%d'",
        TABLE_PRODUCTS_NOTIFICATIONS,
        (int)$_SESSION['customer_id']
    ));
    $products_check = xtc_db_fetch_array($products_check_query);
    if ($products_check['total'] > 0) {
        $counter = 0;
        $notifications_products='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
        $products_query = xtc_db_query(sprintf(
            "select pd.products_id, pd.products_name from %s pd, %s pn where pn.customers_id = '%d' and pn.products_id = pd.products_id and pd.language_id = '%d' order by pd.products_name",
            TABLE_PRODUCTS_DESCRIPTION,TABLE_PRODUCTS_NOTIFICATIONS,
            (int)$_SESSION['customer_id'], (int)$_SESSION['languages_id']
        ));
        while ($products = xtc_db_fetch_array($products_query)) {
              $notifications_products.= '

                      <tr class="moduleRow" onmouseover="rowOverEffect(this)" onmouseout="rowOutEffect(this)" onclick="checkBox(\'products['.$counter.']\')">
                        <td class="main" width="30">'.xtc_draw_checkbox_field('products[' . $counter . ']', $products['products_id'], true, 'onclick="checkBox(\'products[' . $counter . ']\')"').'</td>
                        <td class="main"><b>'.$products['products_name'].'</b></td>
                      </tr> ';

                $counter++;
          }
          $notifications_products.= '</table>';
          $smarty->assign('PRODUCTS_NOTIFICATION',$notifications_products);
    }
}

$smarty->assign('FORM_ACTION',xtc_draw_form('account_notifications', xtc_href_link(FILENAME_ACCOUNT_NOTIFICATIONS, '', 'SSL')) . xtc_draw_hidden_field('action', 'process'));
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('BUTTON_BACK','<a href="' . xtc_href_link(FILENAME_ACCOUNT, '', 'SSL') . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>');
$smarty->assign('BUTTON_CONTINUE',xtc_image_submit('button_continue.gif', IMAGE_BUTTON_CONTINUE));
$smarty->caching = 0;
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/account_notifications.html');

$smarty->assign('language', $_SESSION['language']);
$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include('includes/application_bottom.php');
