<?php
/* -----------------------------------------------------------------------------------------
   $Id: account_history.php,v 1.27 2020/08/03 08:21:29 ssh-511548-cvs Exp $   

   XT-Commerce - community made shopping
   http://www.xt-commerce.com

   Copyright (c) 2003 XT-Commerce
   -----------------------------------------------------------------------------------------
   based on: 
   (c) 2000-2001 The Exchange Project  (earlier name of osCommerce)
   (c) 2002-2003 osCommerce(account_history.php,v 1.60 2003/05/27); www.oscommerce.com 
   (c) 2003	 nextcommerce (account_history.php,v 1.13 2003/08/17); www.nextcommerce.org

   Released under the GNU General Public License 
   ---------------------------------------------------------------------------------------*/

include( 'includes/application_top.php');

$smarty = new yesSmarty;
$YesBoxes->load( $smarty, basename(__FILE__) );

// include needed functions
require_once(DIR_FS_INC . 'xtc_date_long.inc.php');
require_once(DIR_FS_INC . 'xtc_image_button.inc.php');
require_once(DIR_FS_INC . 'xtc_get_all_get_params.inc.php');
if (!isset($_SESSION['customer_id'])) {
    xtc_redirect(xtc_href_link(FILENAME_LOGIN, '', 'SSL'));
}


$breadcrumb->add(NAVBAR_TITLE_1_ACCOUNT_HISTORY, xtc_href_link(FILENAME_ACCOUNT, '', 'SSL'));
$breadcrumb->add(NAVBAR_TITLE_2_ACCOUNT_HISTORY, xtc_href_link(FILENAME_ACCOUNT_HISTORY, '', 'SSL'));

require(DIR_WS_INCLUDES . 'header.php');
$customers_id = intval($_SESSION['customer_id']);
$orders_total_count = \YES4Trade\Model\customers::count_orders($customers_id);
$module_content=array();

$all = \YES4Trade\Model\customers::get_orders_sum($customers_id,
    array(1,2,ORDERS_STATUS_UPSELLING,ORDERS_STATUS_VERSENDET)
);

$all_abgeschlossen = \YES4Trade\Model\customers::get_orders_sum($customers_id,
    array(ORDERS_STATUS_ABGESCHLOSSEN)
);

$all_bezahlt = \YES4Trade\Model\customers::get_orders_sum($customers_id,
    array(ORDERS_STATUS_BEZAHLT)
);

if ($orders_total_count > 0) {
    $history_query_raw = sprintf(
        "select o.orders_id, o.date_purchased, o.delivery_name, o.delivery_company,o.delivery_street_address,o.delivery_suburb,o.delivery_city,o.delivery_postcode,o.delivery_country, o.orders_status,o.billing_name, o.shipping_method,o.payment_method, ot.text as order_total, ot.value, o.date_shipping from %s o LEFT JOIN %s ot USING(orders_id) where o.customers_id = '%d' and ot.class = 'ot_total' order by orders_id DESC",
        TABLE_ORDERS,
        TABLE_ORDERS_TOTAL,
        $customers_id,
    );
    $page = max(0,intval($_GET['page'] ?? 0));
    $history_split = new splitPageResults($history_query_raw, $page, MAX_DISPLAY_ORDER_HISTORY);
    $history_query = xtc_db_query($history_split->sql_query);
    $hc = 0;
    
    $_tmp = [];
    while ($history = xtc_db_fetch_array($history_query)) {
        $_tmp[] = $history;
    }
    foreach($_tmp as $history){
        $products_query = xtc_db_query(sprintf(
            "select count(orders_products_id) as count from %s where orders_id = '%d'",
            TABLE_ORDERS_PRODUCTS,
            intval($history['orders_id'])
        ));
        $products = xtc_db_fetch_array($products_query);

        $tracking_nr = array();
        $query = xtc_db_query(sprintf(
	    "SELECT id,tracking_id FROM shippings WHERE orders_id='%d'",
	        intval($history['orders_id'])
        ));
        $in_shippings = array();
        while($record = xtc_db_fetch_array($query)){
            if(!empty($record['tracking_id'])){
                $tracking_nr[] = $record['tracking_id'];
            }
            $in_shippings[] = $record['id'];
        }
        foreach($in_shippings as $sid){
            $query = xtc_db_query(sprintf(
                "SELECT tracking_number FROM shippings_tracking_numbers WHERE shippings_id='%d'",
                intval($sid)
            ));
            while($record = xtc_db_fetch_array($query)){
                $tracking_nr[] = $record['tracking_number'];
            }
        }
        $module_content[$hc]=array(
            'ORDER_ID'=>$history['orders_id'],
            'ORDER_STATUS'=>main::get_orders_status_name($history['orders_status'], $_SESSION['languages_id']),
            'ORDER_DATE'=>xtc_date_long($history['date_purchased']),
            'ORDER_DATE_SHIPPING'=>xtc_date_long($history['date_shipping']),
            'ORDER_PRODUCTS'=>$products['count'],
            'ORDER_TOTAL'=>strip_tags($history['order_total']),
            'ORDER_BUTTON'=>sprintf('<a href="%s">%s</a>',
                xtc_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 
                    'page=' . $page . '&order_id=' . $history['orders_id'], 'SSL'
                ),
                xtc_image_button('small_view.gif', SMALL_IMAGE_BUTTON_VIEW)
            ),
            'PRINT_LINK'=>xtc_href_link(FILENAME_PRINT_ORDER, 'order_id=' . $history['orders_id'], 'SSL'),
            'ORDER_LINK'=>xtc_href_link(FILENAME_ACCOUNT_HISTORY_INFO, 
                'page=' . $page . '&order_id=' . $history['orders_id'], 'SSL'
            ),
            'TRACKING_NUMBERS'=>$tracking_nr,
            'delivery_name' => $history['delivery_name'],
            'delivery_company' => $history['delivery_company'],
            'delivery_street_address' => $history['delivery_street_address'],
            'delivery_suburb' => $history['delivery_suburb'],
            'delivery_city' => $history['delivery_city'],
            'delivery_postcode' => $history['delivery_postcode'],
            'delivery_country'=>xtc_db_prepare_input($history['delivery_country']),
            'shipping_method' => $history['shipping_method'],
            'payment_method'=>$history['payment_method']
        );
        if(!isset($_SESSION['rma'][$history['orders_id']]) and in_array($history['orders_status'],array(ORDERS_STATUS_ABGESCHLOSSEN,ORDERS_STATUS_VERSENDET))){
            $module_content[$hc]['RMA_LINK'] = xtc_href_link('rma.php', 'page=' . ($_GET['page']??'') . '&orders_id=' . $history['orders_id'], 'SSL');
        }
        $hc++;
    }
}

if ($orders_total_count > 0) {
    $smarty->assign('SPLIT_BAR','
          <tr>
            <td class="smallText" valign="top">'. $history_split->display_count(TEXT_DISPLAY_NUMBER_OF_ORDERS).'</td>
            <td class="smallText" align="right">'. TEXT_RESULT_PAGE . ' ' . $history_split->display_links(MAX_DISPLAY_PAGE_LINKS, xtc_get_all_get_params(array('page', 'info', 'x', 'y'))).'</td>
          </tr>'
    );

}
if($all > 0) {
	$addon  = '<table width="100%" bgcolor="black" cellspacing="0" cellpadding="1">';
	$addon .= '<tr><td>';
	$addon .= '<table width="100%" bgcolor="white" cellspacing="0" cellpadding="1">';
	$addon .= '<tr><td class="smallText"><b>'.ACCOUNT_HISTORY_SUM_ORDERS_TOTAL.':</b> '.number_format($all,2,',','.').' '.$_SESSION['currency'].'</td></tr>';
	$addon .= '</table>';
	$addon .= '</td></tr>';
	$addon .= '</table>';
}else{
  	$addon = '';
}
  
if(isset($_SESSION['show_bankdata']) and $_SESSION['show_bankdata'] == '1'){
    $smarty->assign('SHOW_BANK','1');
    $bank_query = xtc_db_query("SELECT user,bank_wrap,store_name FROM ebay_auth WHERE environment='".((EBAY_TESTMODE == 1)?'sandbox':'production')."'");
    $bankdata = array();
    while($bank = xtc_db_fetch_array($bank_query)){
          $bank = xtc_db_prepare_input($bank);
          $bankdata[] = array('powerseller'=>$bank['user'],
                  'bank_wrap'=>$bank['bank_wrap'],
                  'store_name'=>$bank['store_name']
          );
    }
    $smarty->assign('bankdata',$bankdata);
}
if($messageStack->size('error') > 0){
      $smarty->assign('MESSAGESTACK_ERROR',$messageStack->output('error'));
}
if($messageStack->size('success') > 0){
      $smarty->assign('MESSAGESTACK_SUCCESS',$messageStack->output('success'));
}
if(isset($_GET['orders_id_processed']) and $_GET['orders_id_processed'] > 0){
    $oid_proc = yes_getIntFromRequest('orders_id_processed');
    if($oid_proc > 0){ // nur wenn gueltige oid
        $parameters = [
            'orders_id'=>$oid_proc,
            'customers_id'=>$customers_id
        ];
        $query_raw = "SELECT orders_id FROM orders WHERE orders_id=:orders_id AND customers_id=:customers_id";
        $query = yes_query($query_raw, $parameters);
        if(sizeOf($query)>0){
            $smarty->assign('PRINT_ORDERS_ID',$_GET['orders_id_processed']);
        }
    }
}
$smarty->caching = 0;
$smarty->assign('order_content',$module_content);
$smarty->assign('order_content',$module_content);
$smarty->assign('language', $_SESSION['language']);
$smarty->assign('BUTTON_BACK','<a href="' . xtc_href_link(FILENAME_ACCOUNT, '', 'SSL') . '">' . xtc_image_button('button_back.gif', IMAGE_BUTTON_BACK) . '</a>');
$smarty->assign('CUSTOMER_TOTAL_ORDERS',$addon);
$smarty->assign('CUSTOMER_TOTAL_ORDERS_ABGESCHLOSSEN',$all_abgeschlossen);
$smarty->assign('CUSTOMER_TOTAL_ORDERS_ABGESCHLOSSEN_FORMATTED',number_format($all_abgeschlossen,2,',','.'));
$smarty->assign('CUSTOMER_TOTAL_ORDERS_BEZAHLT',$all_bezahlt);
$bezahlt_formatted = ($all_bezahlt !== null)?number_format($all_bezahlt,2,',','.'):0;
$smarty->assign('CUSTOMER_TOTAL_ORDERS_BEZAHLT_FORMATTED',$bezahlt_formatted);
$main_content=$smarty->fetch(CURRENT_TEMPLATE . '/module/account_history.html');


$smarty->assign('main_content',$main_content);
$smarty->caching = 0;
if (!defined('RM')) {
    $smarty->load_filter('output', 'note');
}
$smarty->display(CURRENT_TEMPLATE . '/index.html');
include( 'includes/application_bottom.php');
