<?php
require_once 'EbatNs_ComplexType.php';
require_once 'TicketListingDetailsType.php';

/**
 * Details about Variation Specifics validation rules. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/VariationDetailsType.html
 *
 */
class VariationProductListingDetailsType extends EbatNs_ComplexType
{
	/**
	 * @var string
	 */
	protected $ISBN;
	/**
	 * @var string
	 */
	protected $UPC;
	/**
	 * @var string
	 */
	protected $EAN;
	/**
	 * @return 
	 */
	/**
	 * @return string
	 */
	function getISBN()
	{
		return $this->ISBN;
	}
	/**
	 * @return void
	 * @param string $value 
	 */
	function setISBN($value)
	{
		$this->ISBN = $value;
	}
	/**
	 * @return string
	 */
	function getUPC()
	{
		return $this->UPC;
	}
	/**
	 * @return void
	 * @param string $value 
	 */
	function setUPC($value)
	{
		$this->UPC = $value;
	}
	/**
	 * @return string
	 */
	function getEAN()
	{
		return $this->EAN;
	}
	/**
	 * @return void
	 * @param string $value 
	 */
	function setEAN($value)
	{
		$this->EAN = $value;
	}
	function __construct()
	{
		parent::__construct('VariationProductListingDetailsType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
				array(
					'ISBN' =>
					array(
						'required' => false,
						'type' => 'string',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					),
					'UPC' =>
					array(
						'required' => false,
						'type' => 'string',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					),
					'EAN' =>
					array(
						'required' => false,
						'type' => 'string',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					),
				));
	}
}
?>
