<?php
require_once 'EbatNs_ComplexType.php';
require_once 'SupportedSellerProfilesType.php';

/**
 * Defines the values that make up the seller's preferences. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/SellerPaymentPreferencesType.html
 *
 */
class SupportedSellerProfilesType extends EbatNs_ComplexType
{
	/**
	 * @var SupportedSellerProfile
	 */
	protected $SupportedSellerProfile;

	/**
	 * @return SupportedSellerProfileType
	 */
	function getSupportedSellerProfile($index = null)
	{
		if ($index !== null) {
			return $this->SupportedSellerProfile[$index];
		} else {
			return $this->SupportedSellerProfile;
		}
	}
	/**
	 * @param SupportedSellerProfileType $value 
	 */
	function setSupportedSellerProfile($value, $index = null)
	{
		if ($index !== null) {
			$this->SupportedSellerProfile[$index] = $value;
		} else {
			$this->SupportedSellerProfile = $value;
		}
	}


	/**
	 * @return 
	 */
	function __construct()
	{
		parent::__construct('SupportedSellerProfilesType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
				array(
					'SupportedSellerProfile' =>
					array(
						'required' => false,
						'type' => 'SupportedSellerProfileType',
						'nsURI' => 'urn:ebay:apis:eBLBaseComponents',
						'array' => true,
						'cardinality' => '0..*'
					)
				));
	}
}

