<?php
require_once 'EbatNs_ComplexType.php';

/**
 * Defines the values that make up the seller's preferences. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/SellerPaymentPreferencesType.html
 *
 */
class SupportedSellerProfileType extends EbatNs_ComplexType
{
	/**
	 * @var CategoryGroupType
	 */
	protected $CategoryGroup;
	/**
	 * @var int
	 */
	protected $ProfileID;
	/**
	 * @var String
	*/
	protected $ProfileName;
	/**
	 * @var String
	*/
	protected $ProfileType;
	/**
	 * @var String
	*/
	protected $ShortSummary;


	/**
	 * @return CategoryGroupType
	 */
	function getCategoryGroup()
	{
		return $this->CategoryGroup;
	}
	/**
	 * @return CategoryGroupType
	 * @param CategoryGroupType $value 
	 */
	function setCategoryGroup($value)
	{
		$this->CategoryGroup = $value;
	}

	/**
	 * @return int
	 */
	function getProfileID()
	{
		return $this->ProfileID;
	}
	/**
	 * @param int $value 
	 */
	function setProfileID($value)
	{
		$this->ProfileID = $value;
	}

	/**
	 * @return string
	 */
	function getProfileName()
	{
		return $this->ProfileName;
	}
	/**
	 * @param string $value 
	 */
	function setProfileName($value)
	{
		$this->ProfileName = $value;
	}

	/**
	 * @return string
	 */
	function getProfileType()
	{
		return $this->ProfileType;
	}
	/**
	 * @param string $value 
	 */
	function setProfileType($value)
	{
		$this->ProfileType = $value;
	}

	/**
	 * @return string
	 */
	function getShortSummary()
	{
		return $this->ShortSummary;
	}
	/**
	 * @param string $value 
	 */
	function setShortSummary($value)
	{
		$this->ShortSummary = $value;
	}

	/**
	 * @return 
	 */
	function __construct()
	{
		parent::__construct('SupportedSellerProfileType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
				array(
					'CategoryGroup' =>
					array(
						'required' => false,
						'type' => 'CategoryGroupType',
						'nsURI' => 'urn:ebay:apis:eBLBaseComponents',
						'array' => false,
						'cardinality' => '0..1'
					),
					'ProfileID' =>
					array(
						'required' => false,
						'type' => 'int',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					),
					'ProfileName' =>
					array(
						'required' => false,
						'type' => 'string',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					),
					'ProfileType' =>
					array(
						'required' => false,
						'type' => 'string',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					),
					'ShortSummary' =>
					array(
						'required' => false,
						'type' => 'string',
						'nsURI' => 'http://www.w3.org/2001/XMLSchema',
						'array' => false,
						'cardinality' => '0..1'
					),
				));
	}
}

