<?php
require_once 'EbatNs_ComplexType.php';

/**
 * Defines the values that make up the seller's preferences. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/SellerPaymentPreferencesType.html
 *
 */
class SellerReturnProfileType extends EbatNs_ComplexType
{
	/**
	 * @var long
	 */
	protected $ReturnProfileID;
	/**
	 * @var string
	 */
	protected $ReturnProfileName;

	/**
	 * @return long
	 */
	function getReturnProfileID()
	{
		return $this->ReturnProfileID;
	}
	/**
	 * @param long
	 */
	function setReturnProfileID($value)
	{
		$this->ReturnProfileID = $value;
	}

	/**
	 * @return string
	 */
	function getReturnProfileName()
	{
		return $this->ReturnProfileName;
	}
	/**
	 * @param long
	 */
	function setReturnProfileName($value)
	{
		$this->ReturnProfileName = $value;
	}



	/**
	 * @return 
	 */
	function __construct()
	{
		parent::__construct('SellerReturnProfileType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
					array(
						'ReturnProfileID' =>
						array(
							'required' => false,
							'type' => 'long',
							'nsURI' => 'http://www.w3.org/2001/XMLSchema',
							'array' => false,
							'cardinality' => '0..1'
						),
					),array(
						'ReturnProfileName' =>
						array(
							'required' => false,
							'type' => 'string',
							'nsURI' => 'http://www.w3.org/2001/XMLSchema',
							'array' => false,
							'cardinality' => '0..1'
						)
					)
				);
		
	}
}

