<?php
require_once 'EbatNs_ComplexType.php';
require_once 'SellerPaymentProfileType.php';
require_once 'SellerShippingProfileType.php';
require_once 'SellerReturnProfileType.php';

/**
 * Defines the values that make up the seller's preferences. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/SellerPaymentPreferencesType.html
 *
 */
class SellerProfilesType extends EbatNs_ComplexType
{
	/**
	 * @var SellerPaymentProfileType
	 */
	protected $SellerPaymentProfile;
	/**
	 * @var SellerReturnProfileType
	 */
	protected $SellerReturnProfile;
	/**
	 * @var SellerShippingProfileType
	 */
	protected $SellerShippingProfile;

	/**
	 * @return SellerPaymentProfileType
	 */
	function getSellerPaymentProfile()
	{
		return $this->SellerPaymentProfile;
	}
	/**
	 * @param SellerPaymentProfileType
	 */
	function setSellerPaymentProfile($value)
	{
		$this->SellerPaymentProfile = $value;
	}

	/**
	 * @return SellerReturnProfile
	 */
	function getSellerReturnProfile()
	{
		return $this->SellerReturnProfile;
	}
	/**
	 * @param SellerReturnProfileType
	 */
	function setSellerReturnProfile($value)
	{
		$this->SellerReturnProfile = $value;
	}

	/**
	 * @return SellerShippingProfile
	 */
	function getSellerShippingProfile()
	{
		return $this->SellerShippingProfile;
	}
	/**
	 * @param SellerShippingProfileType
	 */
	function setSellerShippingProfile($value)
	{
		$this->SellerShippingProfile = $value;
	}


	/**
	 * @return 
	 */
	function __construct()
	{
		parent::__construct('SellerProfilesType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
				array(
					'SellerShippingProfile' =>
					array(
						'required' => false,
						'type' => 'SellerShippingProfileType',
						'nsURI' => 'urn:ebay:apis:eBLBaseComponents',
						'array' => false,
						'cardinality' => '0..1'
					)
				),
				array(
					'SellerPaymentProfile' =>
					array(
						'required' => false,
						'type' => 'SellerPaymentProfileType',
						'nsURI' => 'urn:ebay:apis:eBLBaseComponents',
						'array' => false,
						'cardinality' => '0..1'
					)
				),
				array(
					'SellerReturnProfile' =>
					array(
						'required' => false,
						'type' => 'SellerReturnProfileType',
						'nsURI' => 'urn:ebay:apis:eBLBaseComponents',
						'array' => false,
						'cardinality' => '0..1'
					)
				));
	}
}

