<?php
require_once 'EbatNs_ComplexType.php';

/**
 * Defines the values that make up the seller's preferences. 
 *
 * @link http://developer.ebay.com/DevZone/XML/docs/Reference/eBay/types/SellerPaymentPreferencesType.html
 *
 */
class SellerPaymentProfileType extends EbatNs_ComplexType
{
	/**
	 * @var long
	 */
	protected $PaymentProfileID;
	/**
	 * @var string
	 */
	protected $PaymentProfileName;

	/**
	 * @return long
	 */
	function getPaymentProfileID()
	{
		return $this->PaymentProfileID;
	}
	/**
	 * @param long
	 */
	function setPaymentProfileID($value)
	{
		$this->PaymentProfileID = $value;
	}

	/**
	 * @return string
	 */
	function getPaymentProfileName()
	{
		return $this->PaymentProfileName;
	}
	/**
	 * @param long
	 */
	function setPaymentProfileName($value)
	{
		$this->PaymentProfileName = $value;
	}



	/**
	 * @return 
	 */
	function __construct()
	{
		parent::__construct('SellerPaymentProfileType', 'urn:ebay:apis:eBLBaseComponents');
		if (!isset(self::$_elements[__CLASS__]))
				self::$_elements[__CLASS__] = array_merge(self::$_elements[get_parent_class()],
					array(
						'PaymentProfileID' =>
						array(
							'required' => false,
							'type' => 'long',
							'nsURI' => 'http://www.w3.org/2001/XMLSchema',
							'array' => false,
							'cardinality' => '0..1'
						)
					),array(
						'PaymentProfileName' =>
						array(
							'required' => false,
							'type' => 'string',
							'nsURI' => 'http://www.w3.org/2001/XMLSchema',
							'array' => false,
							'cardinality' => '0..1'
						)
					));
		
	}
}

